{$IFDEF WINDOWS}
{$N-,V-,W-,G+}
{$ELSE}
{$E-,N-,V-}
{$ENDIF}

unit bibtmplt;

interface

Uses
{$IFDEF WINDOWS}
  bibfile, wObjects, wbibabv1,strings,
{$ELSE}
  Objects,DOS,
{$ENDIF}
  bibvars, bibstrg, bibutil, bib8bit, lfnunit;

const
  WordFormat     =1;  AuthorFormat=2;  YearFormat    =3;  ShortYearFormat=4;
  VerbatimFormat =5;  NumberFormat=6;  DefaultFormat =7;  TelephoneFormat=8;
  IfFormat       =9;  NotFormat   =10; LastNameFormat=11; FullNameFormat =12;
  MultiNameFormat=13;

procedure EncapsulateTemplate(var S: string);
procedure StripTemplate(var S: string);
procedure PrepareTemplate(var S: string);
procedure DecompTemplate(var Result: string; Template: string);
procedure FillTemplate(Entry: EntryRecPtr; var Result: string; Template: string;
                       DefFormat: byte; FullName,ExpAbbrevs: boolean);
procedure AutoLabel(Entry: EntryRecPtr; var Template,result: string);


implementation

const
  NormalCaseFormat=0; UpperCaseFormat=1; CapitalizeFormat=2; LowerCaseFormat=3;

  UnknownField    =251; NullField      =252; FilenameField=254;
  EntryNumberField=255; EntryTypeField =253; EtypeShift   =MaxField+10;

  FieldPrefixChar=#1; CommaChar=#2; LbrChar=#3; RbrChar=#4; BslashChar=#5;


procedure EncapsulateTemplate(var S: string);
var
  nbr,ind: integer;
  comma: boolean;
begin
  nbr:=0; ind:=1; comma:=false;
  while (not comma) and (ind<=length(s)) do
  begin
    if s[ind]=lbrace then inc(nbr)
    else if s[ind]=rbrace then dec(nbr)
    else if (s[ind]=',') and (nbr=0) then comma:=true;
    inc(ind);
  end;
  if comma then S:=lbrace+S+rbrace;
end;                                          { EncapsulateTemplate }

procedure StripTemplate(var S: string);
var
  nbr,ind: integer;
  zero: boolean;
begin
  zero:=false;
  while (not zero) and (S<>'') and (S[1]=lbrace) and (S[length(S)]=rbrace) do
  begin
    ind:=2; nbr:=1;
    while (not zero) and (ind<length(S)) do
    begin
      if s[ind]=lbrace then inc(nbr)
      else if s[ind]=rbrace then dec(nbr);
      if nbr<=0 then zero:=true;
      inc(ind);
    end;
    if not zero then
    begin
      Delete(S,1,1); Delete(S,length(S),1);
    end;
  end;
end;                                           { StripTemplate }

procedure PrepareTemplate(var S: string);
var
  nbr,fld,CaseFormat,l: integer;

procedure PrepareGroup(var s: string; CurrentForm: byte);
var
  Form: byte;
  i,ind,LastComma: integer;
  tmp: string;
  FoundGroup,bare: boolean;

procedure EncodeField(var S: string);
begin
  CaseFormat:=NormalCaseFormat;
  l:=1; if (s<>'') and (s[1]='_') then l:=2;
  if length(s)>=l then
  begin
    if s[l]=UpCase(s[l]) then
    begin
      if (length(s)>l) and (s[l+1]<>UpCase(s[l+1])) then
           CaseFormat:=CapitalizeFormat
      else CaseFormat:=UpperCaseFormat;
    end else if (length(s)>l) and (s[l+1]=UpCase(s[l+1])) then
           CaseFormat:=LowerCaseFormat;
  end;
  StrLwr(s);
  fld:=0;
  if Pos('_file',s)=1 then fld:=FilenameField
  else if Pos('_num',s)=1 then fld:=EntryNumberField
  else if Pos('_type',s)=1 then fld:=EntryTypeField
  else if Pos('_n',s)=1 then fld:=NullField
  else if Pos('t`',S)=1 then fld:=FindInETypeList(Copy(s,3,255))+ETypeShift
  else fld:=FindInFieldList(s);
  if (fld=0) or (fld=ETypeShift) then fld:=UnknownField;
  s:=FieldPrefixChar+Chr(fld)+Chr(CaseFormat);
end;                                 { EncodeField }

begin
  StripTemplate(s);
  if s='' then s:='_none';

  ind:=1; ChrDelR(s,'\'); FoundGroup:=false; LastComma:=0;
  while (ind<=length(s)+1) do
  begin
    if (ind>length(s)) or (s[ind]=',') then              { end of sub-template }
    begin
      if FoundGroup then
      begin
        LastComma:=ind; inc(ind);
      end else              { Bare field? End of recursion }
      begin
        i:=LastComma+1; bare:=true;
        while bare and (i<ind) do
        begin
          if s[i] in NameForbid-['`'] then bare:=false;
          inc(i);
        end;
        if bare then
        begin
          tmp:=Copy(s,LastComma+1,ind-LastComma-1);
          EncodeField(tmp);
          s:=Copy(s,1,LastComma)+tmp+Copy(s,ind,255);
          ind:=LastComma+length(tmp)+2;
        end else inc(ind);
        LastComma:=ind-1;
      end;
      FoundGroup:=False;
    end else if (s[ind]=lbrace) or (s[ind]='\') then    { New group }
    begin
      Form:=CurrentForm;
      if s[ind]='\' then       { Explicit format specifier }
      begin
        if ind>=length(s)-1 then   { error }
        begin
          s:=''; Exit;
        end;
        i:=ind+1; s[i]:=UpCase(s[i]);
        if s[i]='W'      then Form:=WordFormat
        else if s[i]='N' then Form:=NumberFormat
        else if s[i]='A' then Form:=AuthorFormat
        else if s[i]='L' then Form:=LastNameFormat
        else if s[i]='F' then Form:=FullNameFormat
        else if s[i]='M' then Form:=MultiNameFormat
        else if s[i]='Y' then Form:=YearFormat
        else if s[i]='S' then Form:=ShortYearFormat
        else if s[i]='V' then Form:=VerbatimFormat
        else if s[i]='D' then Form:=DefaultFormat
        else if s[i]='T' then Form:=TelephoneFormat
        else if s[i]='I' then Form:=IfFormat
        else if s[i]='^' then Form:=NotFormat;
        while (i<=length(s)) and (s[i]<>lbrace) do inc(i);
        Delete(S,ind,i-ind);
        if (s='') or (s[ind]<>lbrace) then  { error }
        begin
          s:=''; Exit;
        end;
      end;
      i:=ind+1; nbr:=1;
      while (i<=length(s)) and ((nbr>1) or (s[i]<>rbrace)) do
      begin
        if s[i]=lbrace then inc(nbr)
        else if s[i]=rbrace then dec(nbr);
        inc(i);
      end;
      if i>length(s) then { error }
      begin
        s:=''; Exit;
      end;
      tmp:=Copy(s,ind+1,i-ind-1);
      PrepareGroup(tmp,Form);                     { Recursive call }
      if tmp<>'' then tmp:=Chr(form)+tmp;
      s:=Copy(s,1,ind)+tmp+Copy(s,i,255);
      ind:=ind+length(tmp)+2;
      FoundGroup:=true;
    end else inc(ind);
  end;
end;                                   { PrepareGroup }

begin
  StrRepl(s,'\\',BslashChar,1,255,255);
  StrRepl(s,'\,',CommaChar,1,255,255);
  StrRepl(s,'\'+lbrace,LbrChar,1,255,255);
  StrRepl(s,'\'+rbrace,RbrChar,1,255,255);
  PrepareGroup(s,DefaultFormat);
end;                                   { PrepareTemplate }

procedure DecompTemplate(var Result: string; Template: string);
var
  fld,nbr: integer;
  CaseForm: byte;
  LongFormatSpec: boolean;
  tmp: string;
  
procedure DecompGroup(fst,lst: integer; CurrentForm: byte);
var
  i,ind: integer;
  Form: byte;
  UseCase: boolean;
begin
  ind:=fst;
  while (ind<=lst) do
  begin
    if (ind<=lst-2) and (Template[ind]=FieldPrefixChar) then    { A field }
    begin
      fld:=ord(Template[ind+1]); CaseForm:=Ord(Template[ind+2]);
      tmp:='_none'; UseCase:=false;
      if fld=UnknownField then tmp:='_unknown'
      else if fld=NullField then tmp:='_none'
      else if fld=EntryNumberField then tmp:='_num'
      else if fld=EntryTypeField then
      begin
        tmp:='_type'; UseCase:=true;
      end else if fld=FilenameField then
      begin
        tmp:='_filename'; UseCase:=true;
      end else if (fld>ETypeShift) and (fld<=ETypeShift+NumberOfTypes) then
      begin
        tmp:='t`'+TypeEntry^[fld-ETypeShift];
        UseCase:=false;
      end else
      begin
        tmp:=TypeField^[fld]; UseCase:=true;
      end;
      StrLwr(tmp);
      if UseCase then
      begin
        if CaseForm=UpperCaseFormat then StrUpr(tmp)
        else if (CaseForm=CapitalizeFormat) and (length(tmp)>1) then
        begin
          if tmp[1]='_' then tmp[2]:=UpCase(tmp[2])
          else tmp[1]:=UpCase(tmp[1]);
        end else if (CaseForm=LowerCaseFormat) and (length(tmp)>1) then
        begin
          if tmp[1]='_' then
          begin
            if length(tmp)>2 then tmp[3]:=UpCase(tmp[3]);
          end else tmp[2]:=UpCase(tmp[2]);
        end;
      end;
      Result:=Result+tmp;
      ind:=ind+3;
    end else if (ind<=lst-2) and (Template[ind]=lbrace) then     { begin group }
    begin
      Form:=Ord(Template[ind+1]);
      i:=ind+2; nbr:=1;
      while (i<=lst) and ((nbr>1) or (Template[i]<>rbrace)) do
      begin
        if Template[i]=lbrace then inc(nbr)
        else if Template[i]=rbrace then dec(nbr);
        inc(i);
      end;
      tmp:=lbrace;
      if Form<>CurrentForm then
      begin
        if LongFormatSpec then
          case Form of
            NumberFormat:    tmp:='\num'+tmp;
            AuthorFormat:    tmp:='\auth'+tmp;
            LastNameFormat:  tmp:='\last'+tmp;
            FullNameFormat:  tmp:='\full'+tmp;
            MultiNameFormat: tmp:='\mauth'+tmp;
            WordFormat:      tmp:='\word'+tmp;
            VerbatimFormat:  tmp:='\verb'+tmp;
            YearFormat:      tmp:='\year'+tmp;
            ShortYearFormat: tmp:='\syear'+tmp;
            DefaultFormat:   tmp:='\def'+tmp;
            TelephoneFormat: tmp:='\tel'+tmp;
            IfFormat:        tmp:='\if'+tmp;
            NotFormat:       tmp:='\^'+tmp;
          end
        else
          case Form of
            NumberFormat:    tmp:='\n'+tmp;
            AuthorFormat:    tmp:='\a'+tmp;
            LastNameFormat:  tmp:='\l'+tmp;
            FullNameFormat:  tmp:='\f'+tmp;
            MultiNameFormat: tmp:='\m'+tmp;
            WordFormat:      tmp:='\w'+tmp;
            VerbatimFormat:  tmp:='\v'+tmp;
            YearFormat:      tmp:='\y'+tmp;
            ShortYearFormat: tmp:='\s'+tmp;
            DefaultFormat:   tmp:='\d'+tmp;
            TelephoneFormat: tmp:='\t'+tmp;
            IfFormat:        tmp:='\if'+tmp;
            NotFormat:       tmp:='\^'+tmp;
          end
      end;
      Result:=Result+tmp;
      DecompGroup(ind+2,i-1,Form);                   { Recursive call }
      Result:=Result+rbrace;
      ind:=i+1;
    end else
    begin
      if Template[ind]=CommaChar then Result:=Result+'\,'
      else if Template[ind]=LbrChar then Result:=Result+'\'+lbrace
      else if Template[ind]=RbrChar then Result:=Result+'\'+rbrace
      else if Template[ind]=BslashChar then Result:=Result+'\\'
      else Result:=Result+Template[ind];
      inc(ind);
    end;
  end;
end;                                  { DecompGroup }

begin
  LongFormatSpec:=true; Result:='';
  DecompGroup(1,length(Template),DefaultFormat);
  if length(Result)>=255 then
  begin
    Result:='';; LongFormatSpec:=false;
    DecompGroup(1,length(template),DefaultFormat);
  end;
  StrRepl(Result,lbrace+'_none'+rbrace,lbrace+rbrace,1,255,255);
end;                                  { DecompTemplate }

procedure FillTemplate(Entry: EntryRecPtr; var Result: string; Template: string;
                       DefFormat: byte; FullName,ExpAbbrevs: boolean);
var
  FD,FileName,FE: PString;
  fld,nbr: integer;
  CaseForm: byte;
  ok: boolean;
  tmp: string;
  
procedure FormatString(var s: string; form,CaseForm: byte);
var
  tmp,tmp1,tmp2: string;
  ind,ind2,i,j,LastLen: word;
  ind3: byte;
  Comma,Multi,Finished: boolean;
begin
  if form<>VerbatimFormat then DeSpecial(s);
  if form=WordFormat then   { First word, without articles }
  begin
    ind:=1; tmp:=''; tmp1:='';
    TexWordGet(tmp,s[1],length(s),ind);
    while tmp1='' do
    begin
      i:=1;
      while (i<=length(tmp)) and (Pos(tmp[i],' ,.;-?!()[]'+lbrace+rbrace)>0) do inc(i);
      if i>1 then Delete(tmp,1,i-1);
      i:=length(tmp);
      while (i>0) and (Pos(tmp[i],' ,.;-?!()[]'+lbrace+rbrace)>0) do dec(i);
      if i<length(tmp) then tmp[0]:=Chr(i);
      tmp1:=tmp; StrLwr(tmp1);
      i:=0;
      while (i<Narticles) and (tmp<>'') do
      begin
        inc(i);
        if tmp1=Articles[i]^ then tmp1:='';
      end;
      if tmp1='' then
      begin
        if ind=0 then
        begin
          tmp1:='finish'; tmp:='';
        end else TexWordGet(tmp,s[1],length(s),ind);
      end;
    end;
    s:=tmp;
  end else if form in [AuthorFormat,LastNameFormat,FullNameFormat,MultiNameFormat] then
  begin                { authorlike, full or last name of first author }
    Multi:=(form=MultiNameFormat); if Multi then form:=AuthorFormat;
    tmp2:='';

    Finished:=(not Multi);
    ind:=1;
    repeat
      tmp:='';
                       { First, extract first name }                   
      tmp1:='';
      TexWordGet(tmp1,s[1],length(s),ind);
      if tmp1='' then Finished:=true;
      nbr:=0;
      LastLen:=0; Comma:=false;
      while (tmp1<>'') and ((nbr>0) or (tmp1<>'and')) do
      begin
        if nbr=0 then LastLen:=length(tmp);
        if tmp='' then tmp:=tmp1
        else tmp:=tmp+' '+tmp1;
        nbr:=nbr+ChrQty(tmp1,lbrace)-ChrQty(tmp1,rbrace);
        if (nbr=0) and (tmp1[length(tmp1)]=',') then Comma:=true;
        TexWordGet(tmp1,s[1],length(s),ind);
      end;
                                       { Surname begins at LastLen+1 }
      if not comma then
      begin
        tmp1:=Copy(tmp,LastLen+1,255); ChrDelR(tmp1,' '); ChrDelL(tmp1,' ');
        tmp:=Copy(tmp,1,LastLen);      ChrDelR(tmp,' ');  ChrDelL(tmp,' ');
        if tmp='' then tmp:=tmp1
        else if tmp1<>'' then tmp:=tmp1+', '+tmp;
      end;
      if (form<>FullNameFormat) and ((form=LastNameFormat) or (not FullName)) then
      begin
        ChrDel(tmp,lbrace); ChrDel(tmp,rbrace);
        ChrDelR(tmp,' ');  ChrDelL(tmp,' ');
        i:=Pos(',',tmp);
        if i>0 then
        begin
          tmp[0]:=Chr(i-1); ChrDelR(tmp,' ');
        end;
        i:=length(tmp);
        while (i>0) and (tmp[i]<>' ') do dec(i);
        if i>0 then Delete(tmp,1,i);
        tmp2:=tmp2+tmp;
      end else if tmp<>'' then
      begin
        if tmp2='' then tmp2:=tmp
        else tmp2:=tmp2+' & '+tmp;
      end;
    until Finished;
    s:=tmp2;
  end else if form in [YearFormat,ShortYearFormat,NumberFormat] then { Years and numbers }
  begin
    ind:=1; ind2:=0; tmp:='';
    repeat
      while (ind<=length(S)) and not (s[ind] in ['1'..'9']) do inc(ind);
      ind2:=ind+1;
      while (ind2<=length(S)) and (s[ind2] in ['0'..'9']) do inc(ind2);
      if (ind2>ind) and ((form=NumberFormat) or (ind2-ind=4)) then
        tmp:=Copy(s,ind,ind2-ind);
      ind:=ind2+1;
    until (ind>length(S)) or (tmp<>'');
    S:=tmp;
    if (form=ShortYearFormat) and (length(S)>=4) then Delete(S,1,2);
  end else if form=TelephoneFormat then                        { Phone numbers }
  begin
    ind:=1; ind2:=0; tmp:='';
    repeat
      while (ind<=length(S)) and not (s[ind] in ['0'..'9','+','(']) do inc(ind);
      ind2:=ind+1;
      while (ind2<=length(S)) and (s[ind2] in ['0'..'9','-','(',')',' ']) do inc(ind2);
      if ind2>ind+2 then
      begin
        while (ind2>ind+1) and not (s[ind2-1] in ['0'..'9']) do dec(ind2);
        tmp:=Copy(s,ind,ind2-ind);
      end;
      ind:=ind2+1;
    until (ind>length(S)) or (tmp<>'');
    S:=tmp;
  end;
  if s<>'' then
  begin
    if form<>VerbatimFormat then
    begin
      j:=1;
      while j<=length(s) do
        if Pos(s[j],'''`"~\:^'+lbrace+rbrace)>0 then Delete(s,j,1)
        else inc(j);
    end;
    if CaseForm=UpperCaseFormat then StrUpr(s)
    else if CaseForm=LowerCaseFormat then StrLwr(s)
    else if CaseForm=CapitalizeFormat then
    begin
      StrLwr(s);
      s[1]:=UpCase(s[1]);
      for j:=2 to length(s) do
        if s[j-1] in [' ','-'] then s[j]:=UpCase(s[j]);
    end;
  end;
end;                          { FormatString }

procedure InsertFieldValue(fld: integer; Form,CaseForm: byte; var ok: boolean);
{$IFDEF WINDOWS}
var
  NewS: PChar;
  SLen,SSize: word;
{$ENDIF}
begin
  if Form=DefaultFormat then             { Resolve defaults}
  begin
    Form:=DefFormat;
    if (fld>0) and (fld<=DefFieldLast) then   { field }
    begin
      if FieldParams^[fld].numeric then Form:=NumberFormat
      else if FieldParams^[fld].Authorlike then Form:=AuthorFormat;
    end;
  end;
  tmp:='';
  with Entry^ do
  if (fld>0) and (fld<=DefFieldLast) and (index[fld]>0) then  { Field }
  begin
    tmp:=content[index[fld]];
    if (tmp<>'') and (tmp[1]='@') then
    begin
{$IFDEF WINDOWS}
      if ExpAbbrevs and ExpandMacros then    { Macro }
      begin
        NewS:=Nil;
        if BigIndex[fld]=0 then
          DecodeAbbrevs(tmp[2],length(tmp)-1,NewS,SLen,SSize)
        else
          DecodeAbbrevs(Big[BigIndex[fld]]^[2],Blen[BigIndex[fld]]-1,NewS,SLen,SSize);
        if NewS<>Nil then
        begin
          if SLen>255 then NewS[255]:=#0 else NewS[SLen]:=#0;
          tmp:=StrPas(NewS);
          FreeMem(NewS,SSize);
        end else Delete(tmp,1,1);
      end else
{$ENDIF}
      Delete(tmp,1,1);
    end;
    FormatString(tmp,Form,CaseForm);
  end else if (fld>ETypeShift) and (fld<=ETypeShift+NumberOfTypes) then
  begin   { Type match }
    tmp:=EntryType; StrLwr(tmp);
    if tmp=TypeEntry^[fld-ETypeShift] then tmp:=#0
    else tmp:='';
  end else if fld=NullField then tmp:=#0
  else if fld=FilenameField then      { Filename }
  begin
    tmp:=FileName^;
    FormatString(tmp,VerbatimFormat,CaseForm);
  end else if fld=EntryNumberField then   { Entry number }
    tmp:=num2str(EntryNum)
  else if fld=EntryTypeField then     { Entry type }
  begin
    tmp:=EntryType; StrLwr(tmp);
    FormatString(tmp,VerbatimFormat,CaseForm);
  end;
  if tmp='' then ok:=false
  else begin
    if tmp=#0 then tmp:='';
    Result:=Result+tmp; ok:=true;
  end;
end;                                   { InsertFieldValue }

procedure GotoNextSegment(var ind: integer; lst: integer; var ok: boolean);
var
  nbr: integer;
begin
  nbr:=0;
  while (ind<=lst) and ((nbr>0) or (Template[ind]<>',')) do
  begin
    if Template[ind]=lbrace then inc(nbr)
    else if Template[ind]=rbrace then dec(nbr);
    inc(ind);
  end;
  if (ind<=lst) and (nbr=0) and (Template[ind]=',') then
  begin
    ok:=true; inc(ind);
  end else ok:=false;
end;                              { GotoNextSegment }

procedure FillGroup(fst,lst: integer; CurrentFormat: byte; var ok: boolean);
var
  ind,i: integer;
  ResultLength,RL2: char;
  Form: byte;
begin
  ind:=fst;
  ResultLength:=Result[0];
  while (ind<=lst) do
  begin
    ok:=true;
    if (ind<=lst-2) and (Template[ind]=FieldPrefixChar) then   { A field name }
    begin
      InsertFieldValue(Ord(Template[ind+1]),CurrentFormat,Ord(Template[ind+2]),ok);
      ind:=ind+3;
      if not ok then GotoNextSegment(ind,lst,ok);
    end else if (ind<=lst-2) and (Template[ind]=lbrace) then      { A group }
    begin
      i:=ind+2; nbr:=1;
      while (i<=lst) and ((nbr>1) or (Template[i]<>rbrace)) do
      begin
        if Template[i]=lbrace then inc(nbr)
        else if Template[i]=rbrace then dec(nbr);
        inc(i);
      end;
      RL2:=Result[0];
      Form:=Ord(Template[ind+1]);
      if Form in [IfFormat,NotFormat] then Form:=CurrentFormat;
      FillGroup(ind+2,i-1,Form,ok);         { Recursive call }
      if ok then
      begin
        if Ord(Template[ind+1])=IfFormat then Result[0]:=RL2
        else if Ord(Template[ind+1])=NotFormat then ok:=false;
      end else if Ord(Template[ind+1])=NotFormat then ok:=true;
      ind:=i+1;
      if not ok then
      begin
        Result[0]:=ResultLength;
        GotoNextSegment(ind,lst,ok);
      end;
    end else if Template[ind]=',' then    { Successful end of group }
    begin
      ok:=true; ind:=lst+1;
    end else
    begin
      if Template[ind]=CommaChar then Result:=Result+','
      else if Template[ind]=LbrChar then Result:=Result+lbrace
      else if Template[ind]=RbrChar then Result:=Result+rbrace
      else if Template[ind]=BslashChar then Result:=Result+'\'
      else Result:=Result+Template[ind];
      inc(ind);
    end;
  end;
  if not ok then Result[0]:=ResultLength;
end;                                   { FillGroup }

begin                                   { FillTemplate }
  AllocStrings(true,@FD,@FileName,@FE,Nil);
  LFNFsplit(bibname^,FD,FileName,FE);
  Result:='';
  FillGroup(1,length(Template),DefaultFormat,ok);
  if not ok then Result:='';
  AllocStrings(false,@FD,@FileName,@FE,Nil);
end;                                    { FillTemplate }

procedure AutoLabel(Entry: EntryRecPtr; var Template, result: string);
var
  i: word;
begin
  if result<>'' then Exit;
  FillTemplate(Entry,result,Template,WordFormat,false,true);
  StrRepl(result,' ','_',1,255,255);
  i:=1;
  while i<=length(result) do
  begin
    if result[i] in NameForbid then Delete(result,i,1)
    else inc(i);
  end;
end;

end.

