$INCLUDE:'C:\SRC\MTEXT\FML3.FOR'

      SUBROUTINE PRMATX(LFOR,NCS,NID,NAR,NF,IERR,ILIN)
C    THIS IS THE TOP-LEVEL EZMATH/TEX TRANSLATION ROUTINE AS USED IN
C THE TRANSLATION PROGRAM 'MTTR'. INPUT STRING (IN EZMATH
C LANGUAGE) IS IN 'LFOR'. 'NCS','NID','NAR'(INPUTS) POINT TO LAST CHAR.
C OF FORMULA, FORMULA ID, ARGUMENT, RESPECTIVELY.
C 'NF' (INPUT)  : CURRENT.NO.OF FORMULA. A NEGATIVE VALUE FLAGS
C                 IN-TEXT MATH
C 'IERR' IS SET TO 1 IF AN ERROR IS DETECTED IN THE FORMULA PROCESSING,
C OTHERWISE IT REMAINS UNAFFECTED.
C INPUT 'ILIN' IS LINE NO. IN INPUT FILE (USED FOR ERROR MESSAGE).
C-----------------------------------------------------------------------
C  MEANING OF FLAGS 'JSYE', 'JDEL(IDS)':
C
C    BIT    JSYE                        JDEL(IDS)
C
C     0     ENTER } AFTER NEXT SYMB.    EXTRA } REQUIRED
C     1     COLUMN ENTRY                COLUMN ENTRY
C     2     SCRIPTED VERT.BAR           SUB/SUPERSCRIPT
C     3     ARRAY ENTRY                 ARRAY ENTRY
C     4     XTRA BLNK.AFTER TEX CMD.    ACTIVE FRAME
C     5     N.A.                        ELIM.CLOSE DEL.FOR DEL.MATRIX
C     6     TEXTSTYLE REQ'D             HALF-SIZE OPERATOR
C     7     IN-TEXT MATH                REMOVE INV.DELS.AROUND t?
C     8     "FLALIGN" ACTIVE            TEXT OPERATOR T? 1ST IN LINE
C     9     4 BLANKS BEFORE t?          UPPER INDEX STRING FOR TENSOR
C    10     ABOVE ACTIVE IN \flalign    TENSOR ACTIVE
C    11     N.A.                        STANDARD DELIMITER SIZE
C    12     N.A.                        GROUP ACTIVE
C
      CHARACTER*1 LFOR(1),CH
      INTEGER*2 IREL(20)
$INCLUDE:'C:\SRC\MTEXT\FMLC.INC'
$INCLUDE:'FMLT.INC'
$INCLUDE:'C:\SRC\MTEXT\LNWC.INC'
      DATA IREL/30,48,31,32,81,24,47,49,79,80,68,70,83,82,38,77,78,84,
     &          73,74/
C***********************************************************************
C STORE PARAM.VALUES IN COMMON
      CRLF=CHAR(13)//CHAR(10)
      MACA=MALS(2)
      MASP=4
      DO J=1,20
        RESY(J:J)=CHAR(IREL(J))
      ENDDO
      ILN=ILIN
      NFOR=NF
C COPY INPUT STRING INTO 'LTXT', FLAG NON-ASCII CHARS.
      LTXT(1)=' ' ! START WITH BLANK TO ELIM.LOCAL ALPH.PREFIX PROBLEM
      J=1
      K1=0
      DO 11 K=1,NCS
      CH=LFOR(K)
      IF(CH.EQ.CHAR(250)) CH=' ' ! HARD BLANK  IN INPUT OK
      J=J+1
      LTXT(J)=CH
      NCH=ICHAR(CH)
      IF(NCH.GE.32 .AND. NCH.LE.126) GO TO 11
      K1=1
      LTXT(J)=CHAR(176)
   11 CONTINUE
      IF(K1.LE.0) GO TO 13
      WRITE(6,'(/,3X,''*** ERROR , LINE '',I3,'': NON-ASCII ''
     & ''CHARACTER FOUND IN EZMATH INPUT!'',/,(72A1))') ILIN,
     & (LTXT(K),K=1,NCS+1)
      GO TO 999
   13 CONTINUE
      J=J+1
      LTXT(J)=' ' ! END WITH BLANK TO ELIM.LOCAL ALPH.PREFIX PROBLEM
      NCH=J
C ATTACH FORMULA ID (IF ANY):
      K=NCS
      KTG=0
      IF(NID.LE.NCS) GO TO 17
   15 CONTINUE
      K=K+1
      J=J+1
      LTXT(J)=LFOR(K)
      IF(K.LT.NID) GO TO 15
      KTG=J ! FORMULA ID IS NOW IN LTX(NCH+1:KTG) (LTX EQUIV.TO LTXT)
   17 CONTINUE
      KAR=0
      IF(NAR.LE.NCS) GO TO 21
   19 CONTINUE
      K=K+1
      J=J+1
      LTXT(J)=LFOR(K)
      IF(K.LT.NAR) GO TO 19
      KAR=J ! ARG.IS NOW IN LTX(KTG+1:KAR) OR LTX(NCH+1:KAR)
   21 CONTINUE
C PREPARE EZMATH PARSING
C INITIALIZE PARAMETERS
      MLAP=0
      MBLK=0
      MCAP=0
      KBGC=0
      JBRK=0
      JGRP=0
      JCOL=0
      JTBC=0
      KTX1=0
      KTX2=0
      JSPL=0
      KDEL=0
      MDEL=0
      JCAS=0
      JDEL=0
      JSYE=0
      KTEX=0
      KTEX1=0
      KXTG(1)=0
      KTNS=0
      KT=1
      IDS=0
      KBEG=0 ! CAUSES 'ENTER' TO SAVE INDEX
      IF(NF.LT.0) THEN
        JSYE=IBSET(JSYE,7) ! FLAG IN-TEXT MATH
        IF(LTXT(2).NE.'!') JSYE=IBSET(JSYE,6) ! TEXTSTYLE REQ'D
      ENDIF
C SAVE LOC.AND PREPARE 1ST CH./SYMB.
C NOTE: FETCH LOOKS AHEAD ONE CH./SYMB.
      KTL=KT
      LCH=1000
      CALL FETCH(*999)
C MCD SERVES AS START FLAG
      MCD=1000
C START OF PARSING LOOP
  101 CONTINUE
C SAVE DEV.CODE,CHK.FOR END OF STRING,SAVE LOC.,GET NXT.CH./SYMB.
      MCDP=MCD
      IF(MEOS.NE.0) GO TO 201 ! PARSING DONE
C  CHECK FOR LOCAL ALPH.PREFIX (: OR ;)
      IF(JLAP.GT.0 .AND. JLAP.LT.256) THEN ! COLON
        IF(MLAP.EQ.0) MLAP=1
      ELSEIF(JLAP.GT.512 .AND. MCC.EQ.1) THEN ! SEMICOLON
        IF(MLAP.EQ.0) MLAP=-1
      ENDIF
      KTL=KT
      CALL FETCH(*999)
C  LOOK FOR TEX (BACKSLASH) CMDS.
C  \ PRECEDED BY BLANK AND FOLLOWED BY LETTER
      IF(LTXT(KTL).EQ.'\' .AND. KTL.GT.1 .AND. LTXT(KTL-1).EQ.' '
     &  .AND. KTL.LT.NCH .AND. ILTR(LTXT(KT)).NE.0) THEN
        IF(MBLK.GT.0) THEN ! ENTER IF MORE THAN 1 BLANK BEFORE
          JSYE=IBSET(JSYE,4)
          CALL STAND(*999)
        ENDIF
        K=0 ! DELIM.LEVEL
        K1=KTL ! SAVE START
        DO I=K1,NCH
          CH=LTX(I:I)
          IF(K.EQ.0 .AND. CH.EQ.' ') EXIT ! BLANK ON LEVEL 0 TERMINATES
          J=INDEX('{[',CH)-INDEX('}]',CH)
          IF(J.GT.0) THEN
            K=K+1
          ELSEIF(J.LT.0) THEN
            K=K-1
          ENDIF
          KTL=KT
          CALL FETCH(*999)
        ENDDO
        CALL ENTER(LTX(K1:I),I-K1+1)
        CH=LTXT(I+1)
        IF(CH.EQ.' ') THEN
          JSYE=IBSET(JSYE,4) ! FLAG XTRA BLNK AFTER TEX CMD.
        ELSEIF(CH.NE.'\') THEN
          KTL=KT
          CALL FETCH(*999)
        ENDIF
        GOTO 101
      ENDIF
C TRANSLATE ACCORDING TO CLASS CODE 'MCC':
      IF(MCC.EQ.1) THEN   ! DELIMITERS
        CALL DELIM(*999)
      ELSEIF(MCC.EQ.2) THEN ! POSITIONERS
        CALL POSIT(*999)
      ELSEIF(MCC.EQ.3) THEN ! MODIFIERS
        CALL MODIF(*999)
      ELSEIF(MCC.EQ.4) THEN ! ARRAY
        IF(MCCP.NE.1 .OR. MOD(MCMP,2).NE.1) THEN
          CALL ERRM('OPEN DELIMITER MUST PRECEDE $',-29,0,*999)
        ENDIF
        CALL ARRAY(*999)
      ELSEIF(MCC.GE.5 .AND. MCC.LE.7) THEN ! STANDARD ASCII CHARS.
        CALL STAND(*999)
      ELSEIF(MCC.EQ.8) THEN ! SPECIAL SYMBOLS
        CALL SPECI(*999)
      ELSEIF(MCC.EQ.9) THEN ! COLUMN TAB
        CALL COLTB(*999)
      ELSEIF(MCC.EQ.10) THEN ! BREAK POINT
        CALL BREAK
      ELSEIF(MCC.EQ.11) THEN ! TEXT OPERATOR
        CALL TXTOP(*999)
      ELSE
        CALL ERRM('FETCH RETURNED ILLEGAL MCC',-26,0,*999)
      ENDIF
      GO TO 101
C  END OF PARSING LOOP --
  201 CONTINUE
      IF(NF.GE.0) THEN
        IF(JBRK.NE.0) THEN
          IF(KTG.GT.0) THEN
            CALL ENTER(CRLF//'\end{multline}',16)
          ELSE
            CALL ENTER(CRLF//'\end{multline*}',17)
          ENDIF
        ELSEIF(JSPL.NE.-1) THEN
          IF(KTG.GT.0) THEN
            CALL INSERT('\begin{equation} \label{'//LTX(NCH+1:KTG)//'}'
     &       //CRLF,27+KTG-NCH,1)
            CALL ENTER(CRLF//'\end{equation}',16)
          ELSE
            CALL INSERT('\begin{equation*}'//CRLF,19,1)
            CALL ENTER(CRLF//'\end{equation*}',17)
          ENDIF
        ENDIF
      ELSE
        IF(.NOT.BTEST(JSYE,6)) THEN ! LEADING ! CALLS FOR DISPLAY STYLE
          TEX(1:1)=' '
          CALL INSERT('$\displaystyle',14,1)
        ELSE
          CALL INSERT('$',1,1)
        ENDIF
        CALL ENTER('$',1)
      ENDIF
C  FORMULA HAS NOW BEEN PARSED, MUST BE AT LEVEL 0
      IF(IDS.NE.0) THEN
        CALL ERRM('DELIMITER IMBALANCE, MISSING "CLOSE"-DELIMITER(S)',
     &  -49,0,*999)
      ENDIF
C  SEND ARRAY 'TEX' TO OUTPUT IF FORMULA
      if(nid.lt.0) WRITE(*,*) TEX(1:KTEX) ! TEST ONLY
      CALL WRTEX(NF)
      RETURN
  999 CONTINUE
C  ERROR RETURN:
      IERR=1
      RETURN
      END

      SUBROUTINE ENTER(STR,L)
C  ENTERS STRING 'STR' OF LENGTH 'L' INTO 'TEX' STARTING AT 'KTEX+1'
C  IF THE STRING STARTS WITH \ AND THE LAST CHAR.IN TEX IS NOT BLANK,
C  THEN A BLANK IS INSERTED BEFORE ENTERING THE STRING.
C  'KTEX1'(IN COMMON) SAVES (KTEX+1) PRIOR TO THE NEW ENTRY. IF A BLANK
C  WAS INSERTED 'KTEX1' IS GIVEN A NEGATIVE SIGN.
C-----------------------------------------------------------------------
      CHARACTER*(*) STR
$INCLUDE:'FMLT.INC'
C***********************************************************************
      IF(KBEG.LE.0) KBEG=KTEX+1 ! SAVE BEG.OF FORMULA ENTRIES
      IF(STR(1:1).EQ.'_' .AND. TEX(KTEX:KTEX).EQ.' ') KTEX=KTEX-1
      IF(STR(1:1).EQ.'^' .AND. TEX(KTEX:KTEX).EQ.' ') KTEX=KTEX-1
      IF(STR(1:1).EQ.'''' .AND. TEX(KTEX:KTEX).EQ.' ') KTEX=KTEX-1
      KTEX1=KTEX+1
      IF(STR(1:1).EQ.'\') THEN
        IF(TEX(KTEX:KTEX).NE.' ' .AND. KTEX.GT.0) THEN
          KTEX=KTEX+1
          TEX(KTEX:KTEX)=' '
          KTEX1=-(KTEX+1)
        ENDIF
      ENDIF
      J=KTEX+1
      KTEX=KTEX+L
      TEX(J:KTEX)=STR(1:L)
      RETURN
      END

      SUBROUTINE DSTK(KD,*)
C  DELIMITER STACK CONTROL
C-----------------------------------------------------------------------
$INCLUDE:'C:\SRC\MTEXT\FMLC.INC'
$INCLUDE:'FMLT.INC'
C***********************************************************************
      IF(MOD(MCM,2).EQ.1) THEN
        IDS=IDS+1 ! RAISE STACK LEVEL
        KDEL(IDS)=KD
        IF(BTEST(JDEL(IDS),6)) THEN ! REDUCE SIZE (HF.-SZ.OPERATOR)
          CALL ENTER('\textstyle ',11)
        ENDIF
        IF(MCC.EQ.1) THEN ! IF TENSOR, SET FLAG, MARK START OF IND.STR.
          IF(KTNS(3).EQ.-1) THEN
            KTNS(3)=KTEX+1
            JDEL(IDS)=IBSET(JDEL(IDS),9)
          ELSEIF(KTNS(5).EQ.-1) THEN
            KTNS(5)=KTEX+1
            JDEL(IDS)=IBSET(JDEL(IDS),10)
          ENDIF
        ENDIF

      ELSE
        IF(BTEST(JDEL(IDS),7)) THEN ! REMOVE INV.DELS.AROUND t?
          JDEL(IDS)=IBCLR(JDEL(IDS),7)
          TEX(KDEL(IDS):KDEL(IDS))=' '
          TEX(KTEX:KTEX)=' '
        ENDIF
        IF(BTEST(JDEL(IDS),0)) THEN ! EXTRA INVIS.DELIMITER IS REQD.
          JDEL(IDS)=IBCLR(JDEL(IDS),0)
          CALL ENTER('}',1)
        ENDIF
        IF(BTEST(JDEL(IDS),2)) THEN ! SUB/SUPER
          JDEL(IDS)=IBCLR(JDEL(IDS),2) ! CLEAR SUB/SUPER FLAG
          IF(JGRP.GT.0 .AND. .NOT.BTEST(JDEL(IDS-1),2)) THEN
            CALL ENTGRP
            IF(MCCN.NE.2 .OR. MCMN.GT.2) JGRP=0
          ENDIF
        ENDIF
        IF(BTEST(JDEL(IDS),12)) THEN ! ACTIVE GROUP
          JDEL(IDS)=IBCLR(JDEL(IDS),12)
          IF(MCCN.EQ.2 .AND. MCMN.LE.2) THEN
            JGRP=IABS(JGRP)
          ELSE
            JGRP=0
          ENDIF
        ENDIF
        JDEL(IDS)=IBCLR(JDEL(IDS),4) ! CLEAR FRAME FLAG
        JDEL(IDS)=IBCLR(JDEL(IDS),6) ! CLEAR HALF-SIZE FLAG
        IF(BTEST(JDEL(IDS),9)) THEN ! CHECK FOR TENSOR INDEX STRINGS
          KTNS(4)=KTEX-1
          JDEL(IDS)=IBCLR(JDEL(IDS),9)
          IF(MCCN.NE.2 .OR. MCMN.NE.2) KTNS=0 ! SUB MUST FOLLOW SUPER
        ELSEIF(BTEST(JDEL(IDS),10)) THEN
          KTNS(6)=KTEX-1
          JDEL(IDS)=IBCLR(JDEL(IDS),10)
          CALL TENSOR
        ENDIF
        IDS=IDS-1 ! LOWER STACK LEVEL
        IF(IDS.EQ.0 .OR. .NOT.BTEST(JDEL(IDS),2)) JSYE=IBCLR(JSYE,2)
        IF(JCAS.EQ.-1) THEN ! BLANK OUT DEL.FOR 'CASES'
          TEX(KTEX:KTEX)=' '
          JCAS=0
        ENDIF
        IF(MLAP.EQ.4096) THEN ! BLANK OUT DEL.FOR ; OPERATOR
          TEX(KTEX:KTEX)=' '
          MLAP=0
        ENDIF
        IF(BTEST(JDEL(IDS+1),1)) THEN ! CHECK FOR END OF COLUMN
          IF(MCCN.NE.2 .OR. MCMN.NE.4) CALL ENDCOL(*999)
        ENDIF
        IF(BTEST(JDEL(IDS+1),3)) THEN ! CHECK FOR ARRAY ENTRY
          CALL FILLAR
        ENDIF
      ENDIF
      RETURN
  999 RETURN 1
      END

      SUBROUTINE INSERT(STR,L,KINS)
C  INSERTS STRING 'STR' (LENGTH 'L') INTO 'TEX' BEFORE LOCATION 'KINS'.
C  AS A RESULT CONTENTS OF LOCATIONS 'KINS'-'KTEX' MOVE TO HIGHER LOC.
C  AND LOCATION 'KINS' NOW CONTAINS THE 1ST CHAR.OF 'STR'.
C-----------------------------------------------------------------------
      CHARACTER*(*) STR
$INCLUDE:'FMLT.INC'
C***********************************************************************
      INS=KINS ! SAVE VAL.OF 'KINS' AT ENTRY (MAY CHANGE)
C MAKE ROOM FOR 'STR'
      J=KTEX
      KTEX=KTEX+L
      I=KTEX
      DO WHILE(J.GE.INS)
        TEX(I:I)=TEX(J:J)
        I=I-1
        J=J-1
      ENDDO
C  INSERT STRING
      TEX(INS:I)=STR(1:L)
C  CORRECT DELIMITER LOCATIONS AND LOCATION MARKERS
      DO J=1,16
        I=KDEL(J)
        IF(I.GE.INS) KDEL(J)=I+L
      ENDDO
      IF(KBEG.GE.INS) KBEG=KBEG+L
      IF(KTX1.GE.INS) KTX1=KTX1+L
      IF(KTX2.GE.INS) KTX2=KTX2+L
      IF(IABS(KTEX1).GE.INS) KTEX1=ISIGN(IABS(KTEX1)+L,KTEX1)
      IF(IABS(JSPL).GE.INS) JSPL=ISIGN(IABS(JSPL)+L,JSPL)
      IF(KBGC.GE.INS) KBGC=KBGC+L
      IF(KBL1.GE.INS) THEN
        KBL1=KBL1+L
        KBL2=KBL2+L
      ENDIF
      J=1
      DO WHILE(KXTG(J).GT.0)
        IF(KXTG(J).GE.INS) KXTG(J)=KXTG(J)+L
        J=J+1
      ENDDO
      IF(KTNS(1).GT.0) THEN
        DO J=1,6
          IF(KTNS(J).GE.INS) KTNS(J)=KTNS(J)+L
        ENDDO
      ENDIF
      RETURN
      END

      SUBROUTINE DELIM(*)
C  TRANSLATES DELIMITERS
C-----------------------------------------------------------------------
$INCLUDE:'C:\SRC\MTEXT\FMLC.INC'
$INCLUDE:'FMLT.INC'
C***********************************************************************
      K=KTEX+1 ! SAVE START LOC.OF DEL.
C  PROPAGATE SUB/SUPER,FRAME FLAGS TO NEW LEVEL IF OPEN DEL.
      IF(MOD(MCM,2).EQ.1) THEN
        IF(BTEST(JDEL(IDS),2)) THEN
          JDEL(IDS+1)=IBSET(JDEL(IDS+1),2)
        ENDIF
        IF(BTEST(JDEL(IDS),4)) THEN
          JDEL(IDS+1)=IBSET(JDEL(IDS+1),4)
        ENDIF
      ENDIF
C  MOVE ( [ { TO LEFT IF PRECEDED BY LETTER, EXCEPT IF IN-TEXT
C  MATH OR IF PRECEDED BY SUB/SUPER (TO TAKE OUT GAP IN f(x) ETC.)
      IF(MCM.GT.2 .AND. MCM.LT.9 .AND. MOD(MCM,2).EQ.1
     &.AND. .NOT. (BTEST(JDEL(IDS+1),2) .OR. BTEST(JSYE,7))) THEN
        IF(MCCP.EQ.5) CALL ENTER('\!',2)
      ENDIF
      JS=1 ! SCALED DELIM.FLAG
      IF(BTEST(JSYE,7)) JS=0 ! UNSCALED DEL.FOR IN-TEXT MATH
      IF(BTEST(JDEL(IDS),11)) THEN ! UNSCALED, IF FLAG
        JS=0
        JDEL(IDS)=IBCLR(JDEL(IDS),11)
      ENDIF
      IF(MCM.GT.2 .AND. MOD(MCM,2).EQ.1 .AND. MCCN.EQ.8 .AND.
     &MCMN.EQ.14) THEN ! UNSCALED, IF DEL.FOLLOWED BY GROUP g?
        JS=0
        JDEL(IDS+1)=IBSET(JDEL(IDS+1),11)
      ENDIF
      IF(JS.GT.0) THEN ! ENTER SCALED DELIM.
        IF(MCM.EQ.1) THEN
          IF(TEX(KTEX:KTEX).EQ.' ') THEN ! ELIM.BLANK BEFORE {
            KTEX=KTEX-1
            K=K-1
          ENDIF
          CALL ENTER('{',1)
          IF(MCCN.EQ.11) THEN ! FLAG PRESENCE OF T? AS 1ST ENTRY
            JDEL(IDS+1)=IBSET(JDEL(IDS+1),8)
          ELSE
            JDEL(IDS+1)=IBCLR(JDEL(IDS+1),8)
          ENDIF
        ELSEIF(MCM.EQ. 2) THEN
          CALL ENTER('}',1)
        ELSEIF(MCM.EQ. 3) THEN
          CALL ENTER('\left(',6)
        ELSEIF(MCM.EQ. 4) THEN
          CALL ENTER('\right)',7)
        ELSEIF(MCM.EQ. 5) THEN
          CALL ENTER('\left[',6)
        ELSEIF(MCM.EQ. 6) THEN
          CALL ENTER('\right]',7)
        ELSEIF(MCM.EQ. 7) THEN
          CALL ENTER('\left\{',7)
        ELSEIF(MCM.EQ. 8) THEN
          CALL ENTER('\right\}',8)
        ELSEIF(MCM.EQ. 9) THEN
          CALL ENTER('\left\lvert ',12)
        ELSEIF(MCM.EQ.10) THEN
          CALL ENTER('\right\rvert ',13)
        ELSEIF(MCM.EQ.11) THEN
          CALL ENTER('\left\langle ',13)
        ELSEIF(MCM.EQ.12) THEN
          CALL ENTER('\right\rangle ',14)
        ELSEIF(MCM.EQ.13) THEN
          CALL ENTER('\left\lVert ',12)
        ELSEIF(MCM.EQ.14) THEN
          CALL ENTER('\right\rVert ',13)
        ENDIF
      ELSE  ! ENTER UNSCALED DELIM.
        IF(MCM.EQ.1) THEN
          IF(TEX(KTEX:KTEX).EQ.' ') THEN ! ELIM.BLANK BEFORE {
            KTEX=KTEX-1
            K=K-1
          ENDIF
          CALL ENTER('{',1)
          IF(MCCN.EQ.11) THEN ! FLAG PRESENCE OF T? AS 1ST ENTRY
            JDEL(IDS+1)=IBSET(JDEL(IDS+1),8)
          ELSE
            JDEL(IDS+1)=IBCLR(JDEL(IDS+1),8)
          ENDIF
        ELSEIF(MCM.EQ. 2) THEN
          CALL ENTER('}',1)
        ELSEIF(MCM.EQ. 3) THEN
          CALL ENTER('(',1)
        ELSEIF(MCM.EQ. 4) THEN
          CALL ENTER(')',1)
        ELSEIF(MCM.EQ. 5) THEN
          CALL ENTER('[',1)
        ELSEIF(MCM.EQ. 6) THEN
          CALL ENTER(']',1)
        ELSEIF(MCM.EQ. 7) THEN
          CALL ENTER('\{',2)
        ELSEIF(MCM.EQ. 8) THEN
          CALL ENTER('\}',2)
        ELSEIF(MCM.EQ. 9) THEN
          CALL ENTER('\lvert ',7)
        ELSEIF(MCM.EQ.10) THEN
          CALL ENTER('\rvert ',7)
        ELSEIF(MCM.EQ.11) THEN
          CALL ENTER('\langle ',8)
        ELSEIF(MCM.EQ.12) THEN
          CALL ENTER('\rangle ',8)
        ELSEIF(MCM.EQ.13) THEN
          CALL ENTER('\lVert ',7)
        ELSEIF(MCM.EQ.14) THEN
          CALL ENTER('\rVert ',7)
        ENDIF
      ENDIF
      KTEX1=K ! \! (IF PRESENT) IS PART OF DELIM.
      IF(BTEST(JDEL(IDS),5)) THEN ! REMOVE CLOSE DEL.FOR DELIMITED ARRAY
        JDEL(IDS)=IBCLR(JDEL(IDS),5)
        KTEX=K-1
        KTEX1=KTEX
      ENDIF
      CALL DSTK(K,*999)
      IF(MCD.GT.0) THEN ! DIACRITIC ATTACHED TO DEL.
        CALL DIACR(K)
      ENDIF
      RETURN
  999 RETURN 1
      END

      SUBROUTINE POSIT(*)
C  TRANSLATES POSITIONERS
C
C                   TRANSLATION TREE FOR MATHTEXT "COLUMN".
C                   
C
C                                     
C                                Ŀ
C                      N Tabs ?  YĿ
C                                        
C                                                   
C                                                   
C                 Ŀ                   Ŀ
C            NExpander?YĿ              t?=   or 
C                           Y  item   NĿ
C                            \cases           separator       
C                                                    
C                                                               
C       Ŀ                 Ŀ              Ŀ
C    NSub/SuperYĿ           NExpander?YĿ        NExpander?YĿ
C                                   
C \array{c}      \subarray                    \cases  \array{ll}      \cases
C [if 2 lines                    
C and ():\binom]            Ŀ
C                       N Tag ?   YĿ
C                                   
C                                              
C                  Ŀ             Ŀ
C               YT? 1st ? NĿ       NT? 1st ? YĿ
C                              
C           \flalign*        \align*                \flalign
C         (arg.to position         Ŀ     (tag only if = ;
C            2nd item)          Y Tag* ?  NĿ extra tags A,B,.. ;
C                                      arg.to pos.2nd item)
C                          \subequation           
C                          \align            Ŀ
C                                         Nt? 1st   YĿ
C                                           or <t?>    
C                                             
C                                      \align           \split
C                                (if more than 1 tab:
C                               item sep.min.5 blanks;
C                               extra tags A,B,... ;
C                               if T? only: \intertext;
C                               1 line only: blank after %)
C  Explanations:
C  a) Expander: {? preceding column
C  b) t?= : Tab precedes relational symbol (= > <  etc.)
C  c) Sub/Super: Column is in a subscript or superscript
C  d) Tag: A formula ID is given
C  e) T? 1st: A text-entry cmd.is first item on line
C  f) Tag* : Last char.of formula ID is *
C  g) t? 1st : Tab follows opening < of line (nothing to the left of it)
C  h) <t?> : Enclosing t? in <> has same effect as g)
C  i) arg. : Argument (e.g. 2.5in) enclosed in "  " given after ==
C  j) extra tags: Only 1 formula ID can be given in MATHTEXT. In cases
C     where TEX tags more than 1 line of a column (\align) the extra
C     tags are formed by appending A,B.. to the given ID.
C  k) tag only if = : A tag is attached only if a relational symbol is
C     found on the line.
C-----------------------------------------------------------------------
$INCLUDE:'FMLT.INC'
$INCLUDE:'C:\SRC\MTEXT\FMLC.INC'
C***********************************************************************
      IF(MCM.LE.2 .AND. MCCN.EQ.1) THEN ! FLAG SUB/SUPER BEFORE DELIM.
        JDEL(IDS+1)=IBSET(JDEL(IDS+1),2)
        IF(MCCP.EQ.8 .AND. MCMP.EQ.1) JSYE=IBSET(JSYE,2) ! SCRIPTED |
      ENDIF
      IF(MCM.EQ.1) THEN  ! SUPERSCRIPT
        IF(MCD.EQ.111 .AND. MCCP.EQ.5 .AND. (MCCN.EQ.5 .OR.
     &  (MCCN.EQ.1 .AND. MCMN.EQ.1))) THEN ! " FLAGS TENSOR
          KTNS(1)=IABS(KTEX1) ! START OF TENSOR NAME
          KTNS(2)=KTEX        ! END OF TENSOR NAME
          IF(TEX(KTEX:KTEX).EQ.' ') KTNS(2)=KTEX-1
          KTNS(3)=-1 ! FLAGS UPPER INDEX STRING
        ENDIF
        CALL ENTER('^',1)
        IF(MCCN.EQ.1) THEN ! {} ARE REQ'D
          IF(MCMN.NE.1) THEN
            CALL ENTER('{',1)
            JDEL(IDS+1)=IBSET(JDEL(IDS+1),0)
          ENDIF
        ELSE
          IF(JGRP.GT.0) THEN ! SINGLE SYMBOL NEEDS {} ONLY IF GROUP
            CALL ENTER('{',1)
            JSYE=IBSET(JSYE,0)
          ENDIF
        ENDIF

      ELSEIF(MCM.EQ.2) THEN ! SUBSCRIPT
        IF(KTNS(1).GT.0) THEN ! TENSOR
          KTNS(5)=-1 ! FLAGS LOWER INDEX STRING
        ENDIF
        CALL ENTER('_',1)
        IF(MCCN.EQ.1) THEN ! {} ARE REQ'D
          IF(MCMN.NE.1) THEN
            CALL ENTER('{',1)
            JDEL(IDS+1)=IBSET(JDEL(IDS+1),0)
          ENDIF
        ELSE
          IF(JGRP.GT.0) THEN ! SINGLE SYMBOL NEEDS {} ONLY IF GROUP
            CALL ENTER('{',1)
            JSYE=IBSET(JSYE,0)
          ENDIF
        ENDIF

      ELSEIF(MCM.EQ.3) THEN ! FRACTION
        IF(MCCP.EQ.1) THEN
          IF(MCMP.LE.2) THEN
            IF(BTEST(JSYE,6) .OR. BTEST(JDEL(IDS),6)) THEN
              CALL INSERT('\tfrac',6,KDEL(IDS+1))
            ELSE
              CALL INSERT('\dfrac',6,KDEL(IDS+1))
            ENDIF
          ELSE   ! EXTRA { IF NUM.DEL.NOT INVISIBLE
            IF(BTEST(JSYE,6) .OR. BTEST(JDEL(IDS),6)) THEN
              CALL INSERT('\tfrac{',7,KDEL(IDS+1))
            ELSE
              CALL INSERT('\dfrac{',7,KDEL(IDS+1))
            ENDIF
            CALL ENTER('}',1)
          ENDIF
        ELSE
          IF(BTEST(JSYE,6) .OR. BTEST(JDEL(IDS),6)) THEN
            CALL INSERT('\tfrac{',7,IABS(KTEX1))
          ELSE
            CALL INSERT('\dfrac{',7,IABS(KTEX1))
          ENDIF
          CALL ENTER('}',1)
        ENDIF
        IF(MCCN.EQ.1) THEN
          IF(MCMN.GT.2) THEN
            CALL ENTER('{',1)
            JDEL(IDS+1)=IBSET(JDEL(IDS+1),0) ! FLAG INV.DEL.AFTER DENOM.
          ENDIF
        ELSE
          CALL ENTER('{',1)
          JSYE=IBSET(JSYE,0) ! FLAG EXTRA INVISIBLE DEL.AFTER NEXT SYMB.
        ENDIF

      ELSEIF(MCM.EQ.4) THEN  ! COLUMN
        IF(JTBC.NE.0 .AND. (MCCP.EQ.1 .AND. MCMP.GT.2)) THEN
          CALL ERRM('ILLEGAL TAB IN COLUMN ENTRY',-27,0,*999)
        ENDIF
        IF(MCCP.EQ.1 .AND. MCMP.LE.2) THEN ! REM.INV.DELS.AROUND ENTRY
          TEX(KTEX:KTEX)=' '
          TEX(KDEL(IDS+1):KDEL(IDS+1))=' '
        ENDIF
        IF(JCOL.EQ.0) THEN ! FIRST ROW  *******************
          JCOL=1
C  'CASES' (JCAS=1) HAS AN EXTRA INV.DEL.:REPLACE BY BLANK
          IF(JCAS.EQ.1) TEX(KDEL(IDS):KDEL(IDS))=' '
          IF(MCCP.EQ.1) THEN ! SAVE BEG.OF COL.
            KBGC=KDEL(IDS+1)
          ELSE
            KBGC=IABS(KTEX1)
          ENDIF
          IF(JTBC.EQ.0) THEN
            IF(JCAS.NE.1) THEN
              IF(BTEST(JDEL(IDS),2)) THEN ! COL.IS IN SUB/SUPERSCRIPT
                IF(BTEST(JSYE,2)) THEN ! SCRIPTED | , LEFT JUSTIFY
                  CALL INSERT('\begin{subarray}{l} ',20,KBGC)
                ELSE
                  CALL INSERT('\begin{subarray}{c} ',20,KBGC)
                ENDIF
              ELSE
                CALL INSERT('\begin{array}{c} ',17,KBGC)
              ENDIF
            ELSE
              CALL INSERT('\begin{cases} ',14,KBGC)
            ENDIF
          ELSE
            IF(JTBC.GT.0 .AND. KBL2.LE.0) THEN
              JCOL=JCOL+256 ! BIT 8 : TAB FOUND (NOT PRECEDING = < ETC.)
                            ! OR AT LEAST 2 ITEM SEP.FOUND
              IF(JCAS.NE.1) THEN
                CALL INSERT('\begin{array}{ll}',17,KDEL(IDS+1))
              ELSE
                CALL INSERT('\begin{cases}',13,KDEL(IDS+1))
              ENDIF
            ELSE
              IF(BTEST(JDEL(IDS+1),8)) JSYE=IBSET(JSYE,8) ! FLAG FLALIGN
              JCOL=JCOL+512 ! BIT 9 : TAB PRECEDING RELATIONAL SYMB.
              IF(JCAS.EQ.0) THEN
                J=KDEL(IDS+1)
                IF(KTG.GT.0) THEN
                  IF(BTEST(JSYE,8)) THEN ! ROW STARTS WITH T?
                    CALL INSERT('& ',2,J)
                    CALL INSERT('\begin{flalign} \label{'//
     &              LTX(NCH+1:KTG)//'}'//CRLF,26+KTG-NCH,J)
                    KXTG(1)=J ! FLAG EXTRA LABEL ENTRY
                    IF(KTX2.GT.KTX1) TEX(KTX1:KTX2)=' ' ! REM.SPC.AFT.T?
C  FIX QUIRK IN \flalign ALIGNMENT:
                    IF(BTEST(JSYE,9)) JSYE=IBSET(JSYE,10)
                    IF(BTEST(JSYE,10)) THEN
                      CALL INSERT(' & & ',5,KTX1)
                    ELSE
                      CALL INSERT(' & & & ',7,KTX1)
                    ENDIF
                    IF(KAR.GT.0) THEN
                      I=KAR-KTG
                      SYM(1:I)=LTX(KTG+1:KAR)
                    ELSE
                      SYM(1:5)='1.0in'
                      I=5
                    ENDIF
                    CALL ENTER('\h{'//SYM(1:I)//'}',4+I)
                    IF(SCAN(TEX(J:KTEX),'=').LE.0) THEN ! NO TAG IF NO =
                      CALL ENTER('\notag ',7)
                      J=J+16
                      TEX(J:J+KTG-NCH+7)=' ' ! BLANK OUT LABEL CMD.
                    ENDIF
                  ELSE
                    IF(LTX(KTG:KTG).EQ.'*') THEN
                      CALL INSERT('\begin{align}'//CRLF,15,J)
                      CALL INSERT('\begin{subequations} \label{'//
     &                LTX(NCH+1:KTG-1)//'}'//CRLF,30+KTG-NCH,J)
                    ELSE
                      CALL INSERT('\begin{align} \label{'//
     &                LTX(NCH+1:KTG)//'}'//CRLF,24+KTG-NCH,J)
                      KXTG(1)=J ! FLAG EXTRA LABEL ENTRY
                    ENDIF
                  ENDIF
                ELSE
                  IF(BTEST(JSYE,8)) THEN
                    CALL INSERT('& ',2,J)
                    CALL INSERT('\begin{flalign*}'//CRLF,18,J)
                    IF(KTX2.GT.KTX1) TEX(KTX1:KTX2)=' ' ! REM.SPC.AFT.T?
C  FIX QUIRK IN \flalign ALIGNMENT:
                    IF(BTEST(JSYE,9)) JSYE=IBSET(JSYE,10)
                    IF(BTEST(JSYE,10)) THEN
                      CALL INSERT(' & & ',5,KTX1)
                    ELSE
                      CALL INSERT(' & & & ',7,KTX1)
                    ENDIF
                    IF(KAR.GT.0) THEN
                      I=KAR-NCH
                      SYM(1:I)=LTX(NCH+1:KAR)
                    ELSE
                      SYM(1:5)='1.0in'
                      I=5
                    ENDIF
                    CALL ENTER('\h{'//SYM(1:I)//'}',4+I)
                  ELSE
                    CALL INSERT('\begin{align*}'//CRLF,16,J)
                  ENDIF
                ENDIF
                IF(BTEST(JDEL(IDS),4)) THEN
                  JSPL=J  ! INSIDE FRAME "SPLIT" MUST BE USED
                ELSE
                  JSPL=-J ! SAVE LOCATION IN CASE "SPLIT" IS USED
                ENDIF
              ELSE
                CALL INSERT('\begin{cases}',13,KDEL(IDS+1))
              ENDIF
            ENDIF
          ENDIF
          IF(MCCN.EQ.1) THEN ! FLAG ACTIVE COLUMN
            JDEL(IDS+1)=IBSET(JDEL(IDS+1),1)
          ELSEIF(MCCN.EQ.7 .AND. MCMN.EQ.0) THEN ! % FOLLOWED BY BLANK
            GOTO 200 ! SINGLE ROW COLUMN, TERMINATE
          ELSE
            JSYE=IBSET(JSYE,1)
          ENDIF
          CALL ENTER('\\ ',3)
          IF(KXTG(1).GT.0) THEN ! LABEL NEXT ROW, IF REQD.
            J=MOD(JCOL,128)+1
            KXTG(J)=KTEX+1 ! SAVE EXTRA LABEL LOCATION
            KXTG(J+1)=0
            J=63+J ! ASCII CODE FOR A,B,C ETC.
            CALL ENTER('\label{'//LTX(NCH+1:KTG)//CHAR(J)//'}',
     &      9+KTG-NCH)
          ENDIF
        ELSE ! NEXT ROW  **********************************
          IF((JTBC.EQ.0 .AND. JCOL.GT.256) .OR.
     &       (JTBC.NE.0 .AND. JCOL.LT.256)) THEN
            CALL ERRM('TABS MUST BE PRESENT IN NONE OR ALL COL.ENTRIES!'
     &      ,-48,0,*999)
          ENDIF
          JCOL=JCOL+1
          IF(JTBC.EQ.-2) GOTO 100 ! \intertext CMD.
          IF(BTEST(JSYE,8)) THEN ! FLALIGN
            IF(KTX1.LE.0) THEN
              CALL ERRM('LINE MUST START WITH T? IN FLUSH-ALIGN ENV.!'
     &        ,-44,0,*999)
            ENDIF
            J=KDEL(IDS+1)
            CALL INSERT('& ',2,J)
            IF(KTX2.GT.KTX1) TEX(KTX1:KTX2)=' ' ! REM.SPC.AFT.T?
            IF(BTEST(JSYE,10)) THEN
              CALL INSERT(' & & ',5,KTX1)
            ELSE
              CALL INSERT(' & & & ',7,KTX1)
            ENDIF
            IF(KAR.GT.0) THEN
              J=NCH
              IF(KTG.GT.0) J=KTG
              I=KAR-J
              SYM(1:I)=LTX(J+1:KAR)
            ELSE
              SYM(1:5)='1.0in'
              I=5
            ENDIF
            CALL ENTER('\h{'//SYM(1:I)//'}',4+I)
            IF(KTG.GT.0) THEN
              IF(SCAN(TEX(J:KTEX),'=').LE.0) THEN ! NO TAG IF NO =
                CALL ENTER('\notag ',7)
                J=KXTG(MOD(JCOL,128))
                TEX(J:J+KTG-NCH+8)=' ' ! BLANK OUT LABEL CMD.
              ENDIF
            ENDIF
          ENDIF
          CALL ENTER('\\ ',3)
          IF(KXTG(1).GT.0) THEN ! LABEL NEXT ROW, IF REQD.
            J=MOD(JCOL,128)+1
            KXTG(J)=KTEX+1 ! SAVE EXTRA LABEL LOCATION
            KXTG(J+1)=0
            J=63+J ! ASCII CODE FOR A,B,C ETC.
            CALL ENTER('\label{'//LTX(NCH+1:KTG)//CHAR(J)//'}',
     &      9+KTG-NCH)
          ENDIF
  100     CONTINUE
          JDEL(IDS+1)=IBCLR(JDEL(IDS+1),1)
          JSYE=IBCLR(JSYE,1)
          IF(MCCN.EQ.1) THEN ! FLAG ACTIVE COLUMN
            JDEL(IDS+1)=IBSET(JDEL(IDS+1),1)
          ELSE
            JSYE=IBSET(JSYE,1)
          ENDIF
        ENDIF
        JTBC=0
        KTX1=0
        KTX2=0
      ENDIF
      RETURN

      ENTRY ENDCOL(*) ! LAST ROW  ****************************
      IF((JTBC.EQ.0 .AND. JCOL.GT.256) .OR.
     &   (JTBC.NE.0 .AND. JCOL.LT.256)) THEN
        CALL ERRM('TABS MUST BE PRESENT IN NONE OR ALL COL.ENTRIES!'
     &  ,-48,0,*999)
      ENDIF
      JCOL=JCOL+1
      IF(MCC.EQ.1 .AND. MCM.LE.2) THEN ! REM.INV.DELS.AROUND ENTRY
        TEX(KTEX:KTEX)=' '
        TEX(KDEL(IDS+1):KDEL(IDS+1))=' '
      ENDIF
      IF(BTEST(JSYE,8)) THEN ! FLALIGN
        IF(KTX1.LE.0) THEN
          CALL ERRM('LINE MUST START WITH T? IN FLUSH-ALIGN ENV.!'
     &    ,-44,0,*999)
        ENDIF
        J=KDEL(IDS+1)
        CALL INSERT('& ',2,J)
        IF(KTX2.GT.KTX1) TEX(KTX1:KTX2)=' ' ! REM.SPC.AFT.T?
        IF(BTEST(JSYE,10)) THEN
          CALL INSERT(' & & ',5,KTX1)
        ELSE
          CALL INSERT(' & & & ',7,KTX1)
        ENDIF
        JSYE=IBCLR(JSYE,10)
        IF(KAR.GT.0) THEN
          J=NCH
          IF(KTG.GT.0) J=KTG
          I=KAR-J
          SYM(1:I)=LTX(J+1:KAR)
        ELSE
          SYM(1:5)='1.0in'
          I=5
        ENDIF
        CALL ENTER('\h{'//SYM(1:I)//'}',4+I)
        IF(KTG.GT.0) THEN
          IF(SCAN(TEX(J:KTEX),'=').LE.0) THEN ! NO TAG IF NO =
            CALL ENTER('\notag ',7)
            J=KXTG(MOD(JCOL,128))
            TEX(J:J+KTG-NCH+8)=' ' ! BLANK OUT LABEL CMD.
          ENDIF
        ENDIF
      ENDIF
      IF(MCCN.EQ.1 .AND. MCMN.EQ.4 .AND. JCOL.EQ.2) THEN ! BINOMIAL COEFF.
        K=KTEX
        J=INDEX(TEX(KBGC:KTEX),'\\')+KBGC-2
        KTEX=KDEL(IDS)-1
        IF(BTEST(JSYE,6)) THEN
          CALL ENTER('\tbinom{'//TEX(KBGC:J)//'}',J-KBGC+10)
        ELSE
          CALL ENTER('\binom{'//TEX(KBGC:J)//'}',J-KBGC+9)
        ENDIF
        KBGC=J+3
        CALL ENTER('{'//TEX(KBGC:K)//'}',K-KBGC+3)
        KBGC=0
        JDEL(IDS)=IBSET(JDEL(IDS),5) ! FLAG TO EL.FOLLOW.CLOSE DEL.
        JDEL(IDS+1)=IBCLR(JDEL(IDS+1),1)
        JSYE=IBCLR(JSYE,1)
        JSYE=IBCLR(JSYE,8) ! FLALIGN FLAG
        JCOL=0
        JTBC=0
        RETURN
      ENDIF
      IF(JCAS.EQ.1) THEN
        CALL ENTER('\end{cases}',11)
        JCAS=-1 ! FLAG TO BLANK OUT FOLLOWING DEL.
        JDEL(IDS+1)=IBCLR(JDEL(IDS+1),1)
        JSYE=IBCLR(JSYE,1)
        JSYE=IBCLR(JSYE,8) ! FLALIGN FLAG
        JCOL=0
        JTBC=0
        KBGC=0
        RETURN
      ENDIF
  200 CONTINUE
      IF(JCOL.LT.256) THEN
        IF(BTEST(JDEL(IDS),2)) THEN
          CALL ENTER('\end{subarray}',14)
        ELSE
          CALL ENTER('\end{array}',11)
        ENDIF
      ELSE
        IF(JCOL.LT.512) THEN
          CALL ENTER('\end{array}',11)
        ELSE
          IF(JSPL.GT.0) THEN
            TEX(JSPL:KBGC-1)='\begin{split}'//CRLF
            CALL ENTER(CRLF//'\end{split}',13)
            I=2
            DO WHILE(KXTG(I).GT.0) ! REMOVE EXTRA LABELS
              JSPL=KXTG(I)
              J=INDEX(TEX(JSPL:KTEX),'}')+JSPL-1
              TEX(JSPL:J)=' '
              I=I+1
            ENDDO
            JSPL=0
          ELSE
            IF(KTG.GT.0) THEN
              IF(BTEST(JSYE,8)) THEN
                CALL ENTER(CRLF//'\end{flalign}',15)
              ELSE
                CALL ENTER(CRLF//'\end{align}',13)
                IF(LTX(KTG:KTG).EQ.'*') THEN
                  CALL ENTER(CRLF//'\end{subequations}',20)
                ENDIF
              ENDIF
            ELSE
              IF(BTEST(JSYE,8)) THEN
                CALL ENTER(CRLF//'\end{flalign*}',16)
              ELSE
                CALL ENTER(CRLF//'\end{align*}',14)
              ENDIF
            ENDIF
            JSPL=-1 ! TO SUPPRESS begin/end{equation}
          ENDIF
        ENDIF
      ENDIF
      JDEL(IDS+1)=IBCLR(JDEL(IDS+1),1)
      JSYE=IBCLR(JSYE,1)
      JSYE=IBCLR(JSYE,8) ! FLALIGN FLAG
      KXTG(1)=0
      JCOL=0
      JTBC=0
      KTX1=0
      KTX2=0
      KBGC=0
      RETURN
  999 CONTINUE
      RETURN 1
      END

      SUBROUTINE MODIF(*)
C  TRANSLATES MODIFIERSRS
C-----------------------------------------------------------------------
$INCLUDE:'FMLT.INC'
C***********************************************************************
      CALL ERRM('FETCH RETURNED MCC=3',-20,0,*999)
      RETURN
  999 RETURN 1
      END



      SUBROUTINE ARRAY(*)
C  TRANSLATES ARRAYS
C-----------------------------------------------------------------------
      CHARACTER COLA*12
$INCLUDE:'C:\SRC\MTEXT\FMLC.INC'
$INCLUDE:'FMLT.INC'
C***********************************************************************
      MADL=MCMP/2+1 ! TYPE OF MATRIX DELIMITER
      IF(MADL.EQ.4 .OR. MADL.EQ.6) MADL=-MADL
      IF(MADL.GT.0) KTEX=IABS(KTEX1)-1 ! ELIM.DEL.FOR DELIMITED ARRAY
C FETCH ARRAY DIM.AND SAVE IN IDIM
      DO J=1,2
        IF(MEOS.NE.0) THEN
          CALL ERRM('IMPROPER END OF STRING',-22,0,*999)
        ENDIF
        KTL=KT
        CALL FETCH(*999)
        IF(MCC.NE.6) THEN
          CALL ERRM(' 2 NUMERALS REQUIRED AFTER ARRAY FLAG',
     &    -37,0,*999)
        ENDIF
        IF(MCM.EQ.0) THEN
          CALL ERRM('ZERO DIMENSIONS NOT ALLOWED',-27,0,*999)
        ENDIF
        IF(J.EQ.1) THEN
          NROW=MCM
        ELSE
          NCOL=MCM
        ENDIF
      ENDDO
      IF(MADL.EQ.2) THEN
        CALL ENTER('\begin{pmatrix}',15)
      ELSEIF(MADL.EQ.3) THEN
        CALL ENTER('\begin{bmatrix}',15)
      ELSEIF(MADL.EQ.5) THEN
        CALL ENTER('\begin{vmatrix}',15)
      ELSEIF(MADL.EQ.7) THEN
        CALL ENTER('\begin{Vmatrix}',15)
      ELSE
        COLA='{cccccccccc}'
        J=NCOL+2
        COLA(J:J)='}'
        CALL ENTER('\begin{array}',13)
        CALL ENTER(COLA(1:J)//' ',J+1)
      ENDIF
      KARR(10,10)=KTEX ! SAVE CURRENT 'TEX' INDEX
      KTEX=8192 ! ARRAY ELEMENTS ARE ENTERED IN HIGH 'TEX'
      IROW=1
      ICOL=1
      KARR(1,1)=KTEX+1 ! START LOCATION OF ELEMENT (1,1)
      JDEL(IDS+1)=IBCLR(JDEL(IDS+1),3)
      JSYE=IBCLR(JSYE,3)
      IF(MCCN.EQ.1) THEN ! FLAG ACTIVE ARRAY
        JDEL(IDS+1)=IBSET(JDEL(IDS+1),3)
      ELSE
        JSYE=IBSET(JSYE,3)
      ENDIF
      RETURN

      ENTRY FILLAR
      JDEL(IDS+1)=IBCLR(JDEL(IDS+1),3) ! CLEAR ARRAY FLAG
      JSYE=IBCLR(JSYE,3)
      IF(MCC.EQ.1 .AND. MCM.LE.2) THEN ! REM.INV.DELS.AROUND ENTRY
        TEX(KTEX:KTEX)=' '
        TEX(KDEL(IDS+1):KDEL(IDS+1))=' '
      ENDIF
      IROW=IROW+1
      IF(IROW.GT.NROW) THEN
        ICOL=ICOL+1
        IROW=1
      ENDIF
      KARR(IROW,ICOL)=KTEX+1 ! START LOC.OF NEXT ELEMENT
      IF(ICOL.GT.NCOL) THEN ! ALL ELEMENTS ARE ENTERED, ARRAY DONE
        KTEX=KARR(10,10) ! RESTORE INITIAL TEX INDEX
        DO IROW=1,NROW ! ENTER ARRAY ELEMENTS ROW-WISE
          DO ICOL=1,NCOL
            I=IROW+1
            J=ICOL
            IF(I.GT.NROW) THEN
              I=1
              J=ICOL+1
            ENDIF
            K1=KARR(IROW,ICOL)
            K2=KARR(I,J)-1
            CALL ENTER(TEX(K1:K2),K2-K1+1)
            IF(ICOL.LT.NCOL) THEN
              CALL ENTER(' & ',3)
            ELSE
              IF(IROW.LT.NROW) CALL ENTER('\\ ',3)
            ENDIF
          ENDDO
        ENDDO
        IF(MADL.EQ.2) THEN
          CALL ENTER('\end{pmatrix}',13)
        ELSEIF(MADL.EQ.3) THEN
          CALL ENTER('\end{bmatrix}',13)
        ELSEIF(MADL.EQ.5) THEN
          CALL ENTER('\end{vmatrix}',13)
        ELSEIF(MADL.EQ.7) THEN
          CALL ENTER('\end{Vmatrix}',13)
        ELSE
          CALL ENTER('\end{array}',11)
        ENDIF
        IF(MADL.GT.0) JDEL(IDS)=IBSET(JDEL(IDS),5) ! FLAG TO ELIM.DEL.
        MADL=0
        NROW=0
        NCOL=0
        IROW=0
        ICOL=0
        RETURN
      ENDIF
C  MORE ELEMENTS TO COME
      IF(MCCN.EQ.1) THEN ! SET FLAG FOR NEXT ELEMENT
        JDEL(IDS+1)=IBSET(JDEL(IDS+1),3)
      ELSE
        JSYE=IBSET(JSYE,3)
      ENDIF
      RETURN
  999 RETURN 1
      END

      SUBROUTINE STAND(*)
C  PROCESSES STANDARD CHARACTERS (LETTERS, NUMERALS, SYMBOLS)
C-----------------------------------------------------------------------
      CHARACTER GRK*302,FCT*8(32),CHR*1
      INTEGER*2 IGRK( 68),ILIM(7)
$INCLUDE:'FMLT.INC'
$INCLUDE:'C:\SRC\MTEXT\FMLC.INC'
$INCLUDE:'C:\SRC\MTEXT\LNWC.INC'
      DATA GRK/                                                        '
     &\0=\1=\2=\3=\4=\5=\6=\7=\8=\9=\A=\B=\H=\Delta\E=\Phi\Gamma\X=\I=\v
     &arkappa\K=\Lambda\varpi\N=\varsigma\Pi\Theta\varrho\Sigma\vartheta
     &\Upsilon\V=\Omega\Xi\Psi\Z=\\\\\\\alpha\beta\eta\delta\varepsilon\
     &varphi\gamma\chi\iota\epsilon\kappa\lambda\mu\nu\o=\pi\theta\rho\s
     &igma\tau\upsilon\phi\omega\xi\psi\zeta'/
      DATA IGRK/
     &    1,    4,    7,   10,   13,   16,   19,   22,   25,   28,
     &   31,   34,   37,   40,   46,   49,   53,   59,   62,   65,
     &   74,   77,   84,   90,   93,  102,  105,  111,  118,  124,
     &  133,  141,  144,  150,  153,  157,  160,  161,  162,  163,
     &  164,  165,  166,  172,  177,  181,  187,  198,  205,  211,
     &  215,  220,  228,  234,  241,  244,  247,  250,  253,  259,
     &  263,  269,  273,  281,  285,  291,  294,  298/
      DATA FCT/'arccos  ','arcsin  ','arctan  ','arg     ','cos     ',
     &         'cosh    ','coth    ','csc     ','deg     ','det     ',
     &         'dim     ','exp     ','gcd     ','hom     ','inf     ',
     &         'ker     ','ln      ','lim     ','liminf  ','limsup  ',
     &         'ln      ','log     ','max     ','min     ','Pr      ',
     &         'sec     ','sin     ','sinh    ','sup     ','tan     ',
     &         'tanh    ','lg      '/
      DATA ILIM/15,18,19,20,23,24,29/, NLIM/7/ ! SUBSCR.UNDER FCT.
C***********************************************************************
      IF(MLAP.NE.0) THEN ! LOCAL ALPHABET PREFIX, COLLECT CHARS.
        IF(MLAP.GT.0) THEN ! COLON
          SYM(MLAP:MLAP)=CMTIN(LCH)
          MLAP=MLAP+1
          IF(JLAP.NE.0) RETURN
          MLAP=MLAP-1
          DO J=1,32
            IF(SYM(1:MLAP).EQ.FCT(J)) THEN
              CALL ENTER('\'//SYM(1:MLAP),MLAP+1)
              IF(MCCN.EQ.7 .AND. MCMN.EQ.0) THEN ! BLANK AFTER FCT.
                CALL ENTER(' ',1)                ! NOT SPACE!
                KTL=KT
                CALL FETCH(*999)
              ENDIF
              MLAP=0
              RETURN
            ENDIF
          ENDDO
          IF(MCCN.EQ.1 .AND. MOD(MCMN,2).EQ.1) THEN
            CALL ENTER('\operatorname{'//SYM(1:MLAP)//'}',MLAP+15)
          ELSE
            CALL ENTER('\text{'//SYM(1:MLAP)//'}',MLAP+7)
          ENDIF
          MLAP=0
          RETURN
        ELSE ! SEMICOLON
          I=IABS(MLAP)
          SYM(I:I)=CMTIN(LCH)
          MLAP=MLAP-1
          IF(JLAP.NE.0) RETURN
          DO J=1,NLIM+1 ! TEX CMDS.FOR LIM,SUP,MAX EXIST
            IF(SYM(1:I).EQ.FCT(ILIM(J))) EXIT
            IF(J.GT.NLIM) EXIT
          ENDDO
          IF(J.LE.NLIM) THEN
            CALL ENTER('\'//SYM(1:I),I+1)
          ELSE
            CALL ENTER('\operatornamewithlimits{'//SYM(1:I)//'}',I+25)
            IF(MCCN.EQ.7 .AND. MCMN.EQ.0) THEN ! BLANK AFTER FCT.
              CALL ENTER(' ',1)                ! NOT SPACE!
              KTL=KT
              CALL FETCH(*999)
            ENDIF
          ENDIF
          TEX(KDEL(IDS):KDEL(IDS))=' '
          MLAP=4096 ! FLAG TO BLANK OUT FOLLOWING DEL.
          RETURN
        ENDIF
      ENDIF
      IF(MCC.EQ.7 .AND. MCM.EQ.0) THEN ! BLANKS BECOME SPACES
        IF(KBEG.LE.0) RETURN ! IGNORE BLANK AT START OF INPUT STRING
C       IGNORE SINGLE BLANK AFTER VISIBLE CLOSE DELIMITER:
        IF(MCCP.EQ.1 .AND. MCMP.GT.2 .AND. MOD(MCMP,2).EQ.0 .AND.
     &    .NOT.(MCCN.EQ.7 .AND. MCMN.EQ.0)) RETURN
C       IGNORE SINGLE BLANK BEFORE ( [ {    (ITS FUNCTION IS TO NEGATE
C       GAP REMOVAL IN SUBROUT."DELIM")
        IF(MCCN.EQ.1 .AND. MCMN.GT.2 .AND. MCMN.LT.9 .AND.
     &  MOD(MCMN,2).EQ.1 .AND. MBLK.LE.0) RETURN
        MBLK=MBLK+1
        IF(MCCN.EQ.7 .AND. MCMN.EQ.0) THEN
          RETURN
        ELSE
          IF(BTEST(JSYE,4)) THEN
            JSYE=IBCLR(JSYE,4)
            MBLK=MBLK-1
          ENDIF
          IF(JTBC.NE.0 .AND. MBLK.GT.4) KBL1=KTEX+1
          I=MBLK/8
          MBLK=MBLK-8*I
          DO J=1,I
            CALL ENTER('\qquad',6)
          ENDDO
          I=MBLK/4
          MBLK=MBLK-4*I
          DO J=1,I
            CALL ENTER('\quad',5)
          ENDDO
          DO J=1,MBLK
            CALL ENTER('\,',2)
          ENDDO
          CALL ENTER(' ',1)
          IF(KBL1.GT.0) KBL2=KTEX
          IF(KTX1.GT.0 .AND. KTX2.EQ.-1) KTX2=KTEX
          MBLK=0
          GOTO 50
        ENDIF
      ENDIF
      IF(MCC.EQ.7 .AND. MCM.EQ.1) THEN ! PERIOD, LOOK FOR SPECIALS
        IF(MCCP.EQ.8 .AND. MCMP.EQ.5 .AND.
     &  MCCN.EQ.8 .AND. MCMN.EQ.5) THEN ! MULT.INTERGRAL WITH DOTS
          KTEX=IABS(KTEX1)-1
          CALL ENTER('\idotsint ',10)
          KTL=KT
          CALL FETCH(*999)
          RETURN
        ELSEIF(MCCN.EQ.7 .AND. MCMN.EQ.1) THEN ! ELLIPSES
          IF(MCCP.EQ.7 .AND. (MCMP.LE.4 .OR. MCMP.GT.7)) THEN
            CALL ENTER('\dotsc ',7)
            KTL=KT
            CALL FETCH(*999)
            RETURN
          ELSE
            CALL ENTER('\dotsb ',7)
            KTL=KT
            CALL FETCH(*999)
            RETURN
          ENDIF
        ENDIF
      ENDIF
      IF(MCA.EQ.MALS(3) .OR. MCA.EQ.MALB(3)) THEN ! GREEK LETTERS
        I=IGRK(LCH)
        SYM=GRK(I:I+31)
        IF(SYM(3:3).EQ.'=') THEN
          N=1
          SYM(1:1)=SYM(2:2)
        ELSE
          N=INDEX(SYM(2:32),'\')+1
          IF(N.LE.2) RETURN ! INVALID CHAR.
          SYM(N:N)=' '
        ENDIF
      ELSE ! LETTER,NUMERAL OR PUNCTUATION
        IF(LCH.EQ.75) LCH=9 ! DASH/MINUS
        IF(IABS(MCA).EQ.4) LCH=LCH+74
        N=1
        SYM(1:1)=CMTIN(LCH)
      ENDIF
C  ENTER SYMBOL
      IF(MCA.EQ.MCAP .AND. MCC.EQ.MCCP .AND. TEX(KTEX:KTEX).EQ.'}'
     &   .AND. ILTR(TEX(KTEX-1:KTEX-1)).NE.0) THEN ! @R STRING
        CALL INSERT(SYM(1:N),N,KTEX)
        GOTO 50
      ELSE
        CALL ENTER(SYM(1:N),N)
      ENDIF
      MCAP=0
      I=0 ! MOD.FLAG
      KE=IABS(KTEX1) ! MARK BEG.OF SYMBOL
      IF(MCA.EQ.MALS(1) .AND. MCC.NE.6) THEN ! FONT
        SYM='\mathrm{'
        I=8
        MCAP=MCA ! CANDIDATE FOR @R STRING
      ELSEIF(MCA.EQ.MALS(4)) THEN
        SYM='\mathsf{'
        I=8
        MCAP=MCA ! CANDIDATE FOR @R STRING
      ELSEIF(MCA.EQ.MALS(5)) THEN
        IF(LCH.GT.42) THEN
          CALL ERRM('\mathcal FONT DEFINED FOR U.C. ONLY',
     &    -35,0,*999)
        ENDIF
        SYM='\mathcal{'
        I=9
        MCAP=MCA ! CANDIDATE FOR @R STRING
      ELSEIF(MCA.EQ.MALS(7)) THEN
        SYM='\Bbb{'
        I=5
        MCAP=MCA ! CANDIDATE FOR @R STRING
      ELSEIF(MCA.EQ.MALS(8) .AND. MCC.EQ.5) THEN
        SYM='\mathbf{'
        I=8
      ELSEIF(MCA.EQ.MALS(9)) THEN
        SYM='\frak{'
        I=6
      ELSEIF(MCA.EQ.MALS(10)) THEN
        SYM='\mathtt{'
        I=8
        MCAP=MCA ! CANDIDATE FOR @R STRING
      ELSEIF(MCA.LT.0) THEN ! GENERAL BOLD FACE (# SIGN)
        IF(MCA.EQ.MALB(3) .OR. MCC.EQ.6 .OR. MCC.EQ.7) THEN
          SYM='\boldsymbol{'
          I=12
        ELSE
          SYM='\pmb{'
          I=5
        ENDIF
      ENDIF
      IF(I.GT.0) THEN ! ENTER FONT
        CALL INSERT(SYM,I,KE)
        CALL ENTER('}',1)
      ENDIF
      IF(MCD.GT.0) THEN ! DIACRITICS
        I=I+1
        CALL DIACR(KE)
        MCAP=0 ! NOT A CANDIDATE FOR @R STRING
      ENDIF
      IF(I.GT.0) CALL INSERT(' ',1,KE)
   50 CONTINUE
      IF(BTEST(JSYE,0)) THEN ! CHECK FOR EXTRA INV.DEL.
        JSYE=IBCLR(JSYE,0)
        CALL ENTER('}',1)
        IF(JGRP.LT.0) THEN
          IF(MCCN.EQ.2 .AND. MCMN.LE.2) THEN
            JGRP=-JGRP
          ELSE
            JGRP=0
          ENDIF
        ELSEIF(JGRP.GT.0) THEN
          CALL ENTGRP
          IF(MCCN.NE.2 .OR. MCMN.GT.2) JGRP=0
        ENDIF
      ENDIF
      IF(KTNS(3).EQ.-1) THEN ! CHECK FOR TENSOR INDEX
        KTNS(3)=IABS(KTEX1)
        KTNS(4)=KTEX
        IF(TEX(KTEX:KTEX).EQ.' ') KTNS(4)=KTEX-1
        IF(MCCN.NE.2 .OR. MCMN.NE.2) KTNS=0
      ELSEIF(KTNS(5).EQ.-1) THEN
        KTNS(5)=IABS(KTEX1)
        KTNS(6)=KTEX
        IF(TEX(KTEX:KTEX).EQ.' ') KTNS(6)=KTEX-1
        CALL TENSOR
      ENDIF
      IF(BTEST(JSYE,1)) THEN ! CHECK FOR END OF COLUMN
        IF(MCCN.NE.2 .OR. MCMN.NE.4) CALL ENDCOL(*999)
      ENDIF
      IF(BTEST(JSYE,3)) THEN ! CHECK FOR ARRAY ENTRY
        CALL FILLAR
      ENDIF
      RETURN
  999 RETURN 1
      END

      SUBROUTINE SPECI(*)
C  PROCESSES SPECIAL MATH SYMBOLS
C-----------------------------------------------------------------------
      CHARACTER SSY*700
      INTEGER*2 ISSY(132)
$INCLUDE:'FMLT.INC'
$INCLUDE:'C:\SRC\MTEXT\FMLC.INC'
$INCLUDE:'C:\SRC\MTEXT\LNWC.INC'
      DATA SSY/                                                        '
     &\ast\circ\dagger\ddagger\S\equiv\therefore\langle\rangle\vcross\pm
     &\angle\mp\div\leqq\neq\geqq\bot\cap\cup\subset\supset\in\exists\op
     &lus\int\oint\int\parallel\prod\varpropto\infty\partial\nabla\sum\r
     &ightarrow\uparrow\leftarrow\downarrow\sqrt\leq\geq\\\ll\gg\Rightar
     &row\Leftarrow\thickapprox\simeq\cong\Leftrightarrow\odot\top\mid\v
     &dot\vdot\mid\bullet\oint\\\\\bigoplus\bigotimes\bigotimes\hslash\\
     &neg\Box\\vdot\smallsmile\heartsuit\diamondsuit\clubsuit\\\smallsmi
     &le\\\\\\\\\\\\\\\\\\\\wedge\\mid\aleph\\wp\digamma\forall\ell\mho\
     &circ\bigcirc\circeq\Re\Im\emptyset\ominus\otimes\oslash\doteq\Join
     &\Diamond\supseteq\subseteq\doteqdot\ni\triangle\triangledown\bigtr
     &iangleup\bigtriangledown\lhd\rhd\eth\\\\'/
      DATA ISSY/
     &    1,    5,   10,   17,   25,   27,   33,   43,   50,   57,
     &   64,   67,   73,   76,   80,   85,   89,   94,   98,  102,
     &  106,  113,  120,  123,  130,  136,  140,  145,  149,  158,
     &  163,  173,  179,  187,  193,  197,  208,  216,  226,  236,
     &  241,  245,  249,  250,  251,  254,  257,  268,  278,  290,
     &  296,  301,  316,  321,  325,  329,  334,  339,  343,  350,
     &  355,  356,  357,  358,  359,  368,  378,  388,  395,  396,
     &  400,  404,  405,  410,  421,  431,  443,  452,  453,  454,
     &  465,  466,  467,  468,  469,  470,  471,  472,  473,  474,
     &  475,  476,  477,  478,  479,  480,  481,  482,  483,  484,
     &  490,  491,  495,  501,  502,  505,  513,  520,  524,  528,
     &  533,  541,  548,  551,  554,  563,  570,  577,  584,  590,
     &  595,  603,  612,  621,  630,  633,  642,  655,  669,  685,
     &  689,  693/
C
C  NOTE: vcross, vdot ARE DEFINED IN PREAMBLE
C  NOTE: THESE DATA STATMENTS ARE GENERATED BY PROGRAM SSY.FOR
C***********************************************************************
      IF(MCM.EQ.1) THEN ! CHECK FOR | AND ~
        IF(MCCN.EQ.2 .AND. MCMN.EQ.2 .AND.
     &     MCCP.EQ.1 .AND. MCMP.EQ.2) THEN ! SUBSCRIPTED VERTICAL BAR
          CALL INSERT('\left.',6,KDEL(IDS+1))
          CALL ENTER('\right\rvert',12)
        ELSE
          IF(MCCP.EQ.1 .AND. MCMP.EQ.4) CALL ENTER('\!',2) ! CLOSE GAP
          CALL ENTER('|',1) !                           BETWEEN ) AND |
        ENDIF
        GOTO 50
      ELSEIF(MCM.EQ.2) THEN
        CALL ENTER('~',1)
        GOTO 50
      ENDIF
      J=KTEX
C  CHECK FOR GRAPHIC OPERATORS:
      IF(MCM.EQ.11 .OR. MCM.EQ.12) THEN ! OVERLINE,UNDERLINE
        IF(MCM.EQ.11) THEN
          CALL ENTER('\overline',9)
        ELSE
          CALL ENTER('\underline',10)
        ENDIF
        IF(MCCN.NE.1 .OR. MCMN.NE.1) THEN ! NOT FOLLOWED BY <
          CALL ENTER('{',1)
          IF(MCCN.EQ.1) THEN
            JDEL(IDS+1)=IBSET(JDEL(IDS+1),0)
          ELSE
            JSYE=IBSET(JSYE,0)
          ENDIF
        ENDIF
        RETURN
      ELSEIF(MCM.EQ.13) THEN ! HALF SIZE
        JDEL(IDS+1)=IBSET(JDEL(IDS+1),6) ! REDUCE SIZE AFTER DEL.
        RETURN
      ELSEIF(MCM.EQ.14) THEN ! GROUP
        IF(JLAP.NE.0) RETURN ! LOCAL ALPH.PREFIX IS HANDLED ELSEWHERE
        JGRP=-(KTEX+1) ! MARK START OF GROUP
        IF(MCCN.EQ.1) THEN
          IF(MCMN.NE.1) THEN
            CALL ERRM('GROUP OPER. g? MUST BE FOLLOWED BY SYMBOL OR <',
     &      -46,0,*999)
          ENDIF
          JDEL(IDS+1)=IBSET(JDEL(IDS+1),12) ! SET GROUP FLAG
        ELSE
          CALL ENTER('{',1)
          JSYE=IBSET(JSYE,0) ! SET GROUP FLAG
        ENDIF
        RETURN
      ELSEIF(MCM.EQ.15) THEN ! FRAME
        CALL ENTER('\boxed',6)
        JDEL(IDS+1)=IBSET(JDEL(IDS+1),4) ! FRAME FLAG
      ELSEIF(MCM.EQ.39) THEN ! EXPANDER
        IF(MCCN.NE.1 .OR. MCMN.NE.1) THEN
          CALL ERRM('EXPANDER {? MUST BE FOLLOWED BY <',-33,0,*999)
        ENDIF
        JCAS=1
        RETURN
      ELSEIF(MCM.EQ.40) THEN ! COMPANDER
        IF(MCCP.NE.1 .OR. MCMP.NE.2) THEN
          CALL ERRM('COMPANDER MUST BE PRECEDED BY >',-31,0,*999)
        ENDIF
        J=INDEX(TEX(KDEL(IDS+1):KTEX),'&')
        IF(J.GT.0) THEN
          CALL ERRM('NO COL.TABS t? ALLOWED WITH COMPANDER }?',
     &    -40,0,*999)
        ENDIF
        J=INDEX(TEX(KDEL(IDS+1):KTEX),'{c}')
        IF(J.GT.0) THEN ! CHANGE ALIGNMENT TO {r}
          J=J+KDEL(IDS+1)
          TEX(J:J)='r'
        ENDIF
        CALL INSERT('\left. ',7,KDEL(IDS+1))
        CALL ENTER('\right\} ',9)
        RETURN
      ENDIF
      IF(KTEX.GT.J) GOTO 50 ! GRAPHIC OPERATOR FOUND
      J=LCH-32 ! SPEC.CHAR.INDEX IN MATHTEXT
      IF(J.EQ.40) THEN ! CHECK FOR SUPERSCRIPT ON RADICAL
        IF(MCCN.EQ.2 .AND. MCMN.EQ.1) THEN
          CALL FETCH(*999)
          CALL FETCH(*999)
          CALL ENTER('\sqrt['//CHAR(48+MCM)//']',8)
          RETURN
        ENDIF
      ENDIF
      IF(J.EQ.28) THEN ! CHECK FOR MULTIPLE INTEGRALS
        IF(MCCP.EQ.8 .AND. MCMP.EQ.5) THEN
          CALL INSERT('i',1,IABS(KTEX1)+1)
          RETURN
        ENDIF
      ENDIF
      IF(MCM.EQ.26) THEN ! \times FOLLOWED BY NUMERAL OR DEC.PT.
        IF(MCCN.EQ.6 .OR. (MCCN.EQ.7 .AND. MCMN.EQ.1)) THEN
          CALL ENTER('\!\times\! ',11)
          RETURN
        ENDIF
      ENDIF
      IF(MCM.EQ.19) THEN ! \nabla FOLLOWED BY \vcross
        IF(MCCN.EQ.8 .AND. MCMN.EQ.26) THEN
          CALL ENTER('\nabla\! ',9)
          RETURN
        ENDIF
      ENDIF
      I=ISSY(J)
      SYM=SSY(I:I+31)
      N=INDEX(SYM(2:32),'\')
      IF(N.LE.1) RETURN ! NO SYMBOL FOUND
      CALL ENTER(SYM(1:N)//' ',N+1)
      KE=IABS(KTEX1)
      IF(MCA.LT.0) THEN ! BOLD SYMBOL
        CALL INSERT('\boldsymbol{',12,KE)
        CALL ENTER('}',1)
      ENDIF
      IF(MCD.GT.0) THEN ! DIACRITICS
        CALL DIACR(KE)
        CALL ENTER(' ',1)
      ENDIF
   50 CONTINUE
      IF(BTEST(JSYE,0)) THEN ! CHECK FOR EXTRA INV.DEL.
        JSYE=IBCLR(JSYE,0)
        CALL ENTER('}',1)
        IF(JGRP.LT.0) THEN
          IF(MCCN.EQ.2 .AND. MCMN.LE.2) THEN
            JGRP=-JGRP
          ELSE
            JGRP=0
          ENDIF
        ELSEIF(JGRP.GT.0) THEN
          CALL ENTGRP
          IF(MCCN.NE.2 .OR. MCMN.GT.2) JGRP=0
        ENDIF
      ENDIF
      IF(BTEST(JSYE,1)) THEN ! CHECK FOR END OF COLUMN
        IF(MCCN.NE.2 .OR. MCMN.NE.4) CALL ENDCOL(*999)
      ENDIF
      IF(BTEST(JSYE,3)) THEN ! CHECK FOR ARRAY ENTRY
        CALL FILLAR
      ENDIF
      RETURN
  999 RETURN 1
      END

      SUBROUTINE COLTB(*)
C  PROCESS COLUMN TAB
C-----------------------------------------------------------------------
      CHARACTER BL*4
$INCLUDE:'C:\SRC\MTEXT\FMLC.INC'
$INCLUDE:'FMLT.INC'
C***********************************************************************
      IF(IDS.LE.0) THEN
        CALL ERRM('TABS "t?" ALLOWED IN COLUMN ENTRIES % ONLY',
     &  -42,0,*999)
      ENDIF
      IF(BTEST(JDEL(IDS),2)) RETURN ! IGNORE IF IN SUB/SUPER
C 4 BLANKS BEFORE TAB? (NEEDED TO FIX QUIRK IN \flalign)
      DO J=1,4
        BL(J:J)=LTXT(KT-3-J)
      ENDDO
      IF(BL.EQ.' ') THEN
        JSYE=IBSET(JSYE,9) ! 4 BLANKS PRECEDE COL.TAB
      ELSE
        JSYE=IBCLR(JSYE,9)
      ENDIF
      J=INDEX(RESY,CHAR(LCHN)) ! IS TAB FOLLOWED BY RELATIONAL SYMBOL?
      CALL ENTER(' & ',3) ! ENTER TEX TAB
      IF(JTBC.EQ.0) THEN
        JTBC=1 ! TAB FLAG
        IF(BTEST(JDEL(IDS),8) .OR. BTEST(JSYE,8)) GOTO 10 ! "FLALIGN"
        IF(MCAN.NE.4) RETURN
        IF(J.GT.0) GOTO 10 ! TAB FOLLOWED BY REL.SYMB.
        IF(MCCN.EQ.8 .AND. MCMN.EQ.2) GOTO 10 ! ~ IS RECOGNIZED BY MCC,MCM
        RETURN
   10   CONTINUE
        JTBC=-1 ! NEG.SIGN FLAGS "ALIGN","SPLIT","FLALIGN"
        IF(MCCP.EQ.1 .AND. MCMP.EQ.1) THEN ! NOTHING TO LEFT OF TAB:
          IF(JSPL.LT.0) JSPL=-JSPL         ! USE "SPLIT", NOT "ALIGN"
          IF(MCCN.EQ.1 .AND. MCMN.EQ.2) THEN ! FLAG t? ENCLOSED IN <>
            JDEL(IDS)=IBSET(JDEL(IDS),7)
          ENDIF
        ENDIF
      ELSE
        IF(KBL1.GT.0) THEN
          TEX(KBL1:KBL2)=' &'
          KBL1=0
        ELSE
          CALL ERRM('ITEM SEPARATION (5 BLANKS MIN.) REQD., IF MULTIPLE
     &TABS IN COLUMN ENTRY!',-72,0,*999)
        ENDIF
      ENDIF
      RETURN
  999 RETURN 1
      END

      SUBROUTINE BREAK
C  TRANSLATES BREAK CMD.
C-----------------------------------------------------------------------
$INCLUDE:'C:\SRC\MTEXT\FMLC.INC'
$INCLUDE:'FMLT.INC'
C***********************************************************************
      IF(JBRK.EQ.0) THEN
        JBRK=1
        IF(KTG.GT.0) THEN
          CALL INSERT('\begin{multline} \label{'//LTX(NCH+1:KTG)//'}'
     &     //CRLF,27+KTG-NCH,1)
        ELSE
          CALL INSERT('\begin{multline*}'//CRLF,19,1)
        ENDIF
      ENDIF
      CALL ENTER('\\ ',3)
      RETURN
      END

      SUBROUTINE WRTEX(NF)
C  WRITES A TEX EQUATION TO OUTPUT UNIT 11
C-----------------------------------------------------------------------
      CHARACTER BL*32,CHR*1
$INCLUDE:'FMLT.INC'
C***********************************************************************
      LL=72  ! LINE LENGTH
      LIND=2 ! INDENTATION
C  REMOVE UNNECESSARY BLANKS
      TEX(KTEX+1:KTEX+1)=' '
      KI=1
      DO K=1,KTEX ! REMOVE UNNECESSARY BLANKS
        IF(TEX(K:K).NE.' ') THEN
          TEX(KI:KI)=TEX(K:K)
          KI=KI+1
        ELSE
          IF(KI.LE.1) THEN
          ELSEIF(INDEX('\{}()[]|!@#$^&*_+-=<>/:;"''~`',TEX(K-1:K-1))+
     &    INDEX(' \{}()[]|!@#$^&*_+-=<>/:;"''~`',TEX(K+1:K+1)).GT.0)
     &    THEN
            I=INDEX(TEX(1:KI-1),'}',.TRUE.)
            J=INDEX(TEX(1:KI-1),'{',.TRUE.)
            IF(J.GT.5 .AND. J.GT.I) THEN
              IF(TEX(J-5:J-1).EQ.'\text') THEN ! NO BLANK REMOVAL
                TEX(KI:KI)=TEX(K:K)            ! INSIDE \text
                KI=KI+1
              ENDIF
            ENDIF
          ELSE
            TEX(KI:KI)=TEX(K:K)
            KI=KI+1
          ENDIF
        ENDIF
      ENDDO
C BLANKS HAVE BEEN REMOVED, NOW PRINT OUT IN PROPER FORMAT
      KTEX=KI-1
      IF(NF.LT.0) RETURN ! DONE IF IN-TEXT MATH
      BL=' '
      JIND=0
      K=0
   50 CONTINUE
      K=K+1
      I=INDEX(TEX(K:KTEX),CRLF)
      IF(I.LE.0) I=KTEX+2-K
      IF(I+JIND.LE.LL+1) THEN ! TEXT TO NEXT CRLF FITS ON LINE
        IF(KTEX-K+JIND.LT.LL) THEN ! DONE
          IF(KTEX.GE.K) WRITE(11,'(A)') BL(1:JIND)//TEX(K:KTEX)
          RETURN
        ELSE
          K2=K+I-2
          WRITE(11,'(A)') BL(1:JIND)//TEX(K:K2)
          K=K2+2
          JIND=0
          GOTO 50
        ENDIF
      ELSE ! NEXT CRLF TOO FAR, FIND PLACE TO BREAK LINE: })]\ ETC.
        KE=K+LL-JIND-1 ! LAST CHAR.TO FIT ON NEXT LINE (MUST NOT BE \)
        IF(TEX(KE:KE).EQ.'\') KE=VERIFY(TEX(1:KE),'\',.TRUE.)
   60   CONTINUE
        I=SCAN(TEX(K:KE),'})]',.TRUE.)
        J=SCAN(TEX(K:KE),'([\ ',.TRUE.)-1
        I=MAX(I,J)
        J=K+I-1
        IF(TEX(J:J+1).EQ.'\\') THEN ! HANDLE \\ AND \\\
          I=VERIFY(TEX(1:J),'\',.TRUE.)
          J=I+2
        ENDIF
        K2=J
        WRITE(11,'(A)') BL(1:JIND)//TEX(K:K2)
        JIND=LIND ! INDENT NEXT LINE
        K=J+1
        IF(TEX(K:K).NE.' ') K=J
        JBRK=1
        GOTO 50
      ENDIF
      END

      SUBROUTINE DIACR(KE)
C  ENTER DIACRITICS, IF ANY
C  'KE' POINTS TO BEGINNING IN 'TEX' OF SYMBOL TO BE MODIFIED
C-----------------------------------------------------------------------
$INCLUDE:'C:\SRC\MTEXT\FMLC.INC'
$INCLUDE:'FMLT.INC'
C***********************************************************************
      DO N=1,MCD ! REMOVE DOTS FROM i j IF ON-SYMBOL DIACRITICS
        IF(LCHM(N).GT.80) THEN
          IF(TEX(KE:KE).EQ.'i') THEN
            KTEX=KE-1
            CALL ENTER('\imath',6)
            EXIT
          ELSEIF(TEX(KE:KE).EQ.'j') THEN
            KTEX=KE-1
            CALL ENTER('\jmath',6)
            EXIT
          ENDIF
        ENDIF
      ENDDO
      DO N=1,MCD
        J=LCHM(N)/10
        M=MOD(LCHM(N),10)
        IF(J.EQ.1) THEN ! PRIME(S)
          IF(TEX(KTEX:KTEX).EQ.' ') KTEX=KTEX-1 ! ELIM.BLK.AFTER SYMBOL
          DO K=1,M
            CALL ENTER(CHAR(39),1)
          ENDDO
        ELSEIF(J.EQ.2) THEN ! STAR(S)
          IF(TEX(KTEX:KTEX).EQ.' ') KTEX=KTEX-1 ! ELIM.BLK.AFTER SYMBOL
          CALL ENTER('^',1)
          IF(M.GT.1) CALL ENTER('{',1)
          DO K=1,M
            CALL ENTER('*',1)
          ENDDO
          IF(M.GT.1) CALL ENTER('}',1)
        ELSEIF(J.EQ.3) THEN ! TRANSPOSE
          IF(TEX(KTEX:KTEX).EQ.' ') KTEX=KTEX-1 ! ELIM.BLK.AFTER SYMBOL
          CALL ENTER('^{\scriptscriptstyle{\mathsf{T}}}',33)
        ELSEIF(J.EQ.4) THEN ! DAGGER
          IF(TEX(KTEX:KTEX).EQ.' ') KTEX=KTEX-1 ! ELIM.BLK.AFTER SYMBOL
          CALL ENTER('^{\dagger}',10)
        ELSEIF(J.EQ.7) THEN ! DOT(S)
          CALL INSERT('\Dot{',5,KE)
          CALL ENTER('}',1)
          DO K=2,M
            CALL INSERT('d',1,KE+2)
          ENDDO
          IF(M.GT.2) TEX(KE+1:KE+1)='d'
        ELSEIF(J.EQ.8 .OR. J.EQ.9) THEN ! (DOUBLE) BAR
          DO K=8,J
            CALL INSERT('\Bar{',5,KE)
            CALL ENTER('}',1)
          ENDDO
        ELSEIF(J.EQ.10 .OR. J.EQ.11) THEN ! (DOUBLE) UNDERLINE
          DO K=10,J
            CALL INSERT('\underline{',11,KE)
            CALL ENTER('}',1)
          ENDDO
        ELSEIF(J.EQ.12) THEN ! HAT
          CALL INSERT('\Hat{',5,KE)
          CALL ENTER('}',1)
        ELSEIF(J.EQ.13) THEN ! TILDE
          CALL INSERT('\Tilde{',7,KE)
          CALL ENTER('}',1)
        ELSEIF(J.EQ.14) THEN ! ARROW
          CALL INSERT('\Vec{',5,KE)
          CALL ENTER('}',1)
        ENDIF
      ENDDO
      RETURN
      END

      SUBROUTINE TXTOP(*)
C  TRANSLATE TEXT OPERATOR T?
C-----------------------------------------------------------------------
$INCLUDE:'C:\SRC\MTEXT\FMLC.INC'
$INCLUDE:'FMLT.INC'
C***********************************************************************
      JF=0
      IF(MCCP.EQ.1 .AND. MCMP.EQ.1) JF=1 ! FLAG 1ST T?
      K=KT
      KTL=KT
      CALL FETCH(*999)
      IF(LTXT(K-1).EQ.'<') THEN
        J=0
   10 CONTINUE
        DO WHILE(LTXT(K).NE.'>')
          J=J+1
          IF(J.GT.80) GOTO 900
          BUF(J:J)=LTXT(K)
          K=K+1
        ENDDO
        IF(LTXT(K-1).EQ.'`' .AND. LTXT(K+1).EQ.'''') THEN
          BUF(J:J)='>'
          K=K+2
          GOTO 10
        ENDIF
   20 CONTINUE
        DO WHILE(LTXT(KTL-1).NE.'>')
          KTL=KT
          CALL FETCH(*999)
        ENDDO
        IF(LTXT(KTL-2).EQ.'`' .AND. LTXT(KTL).EQ.'''') THEN
          KTL=KT
          CALL FETCH(*999)
          GOTO 20
        ENDIF
        IF(JF.EQ.1 .AND. MCCN.EQ.1 .AND. MCMN.EQ.2 .AND. JCOL.GT.512)
     &  THEN ! \intertext CMD.IN "ALIGN"
          I=MOD(JCOL,128)+1
          IF(KXTG(I).GT.0) THEN
            CALL INSERT('\intertext{'//BUF(1:J)//'}',12+J,KXTG(I))
          ELSE
            CALL ENTER('\intertext{'//BUF(1:J)//'}',12+J)
          ENDIF
          JTBC=-2
        ELSE
          CALL ENTER('\text{'//BUF(1:J)//'}',7+J)
        ENDIF
      ELSE
        CALL ERRM('TEXT OPERATOR "T?" MUST BE FOLLOWED BY ARGUMENT ENCLO
     &SED IN < >',-63,0,*999)
      ENDIF
      IF(JF.EQ.1) THEN
        KTX1=KTEX+1 ! SAVE LOCATION AFTER \text CMD.
        IF(MCCN.EQ.7 .AND. MCMN.EQ.0) KTX2=-1 ! BLANK FOLLOWS T?
      ENDIF
      RETURN
  900 CONTINUE
      CALL ERRM('IMPROPER ARGUMENT OF TEXT OPERATOR "T?"',-39,0,*999)
      RETURN
  999 RETURN 1
      END

      SUBROUTINE TENSOR
C  ENTERS THE TEX TENSOR CMD. WITH INDEX STRINGS LOCATED BY "KTNS(*)"
C-----------------------------------------------------------------------
      CHARACTER*72 UIND,LIND
$INCLUDE:'FMLT.INC'
C***********************************************************************
      UIND=TEX(KTNS(3):KTNS(4))//' \, '
      LU=KTNS(4)-KTNS(3)+1
      LIND=TEX(KTNS(5):KTNS(6))//' \, '
      LL=KTNS(6)-KTNS(5)+1
      CALL INSERT('\tensor{',8,KTNS(1))
      KTEX=KTNS(2)
      CALL ENTER('}{',2)
      IU1=1
      IL1=1
      DO WHILE(IU1.LE.LU .OR. IL1.LE.LL)
        IF(IU1.LE.LU) THEN
          IU2=INDEX(UIND(IU1:32),' \, ')+IU1-2
          IF(IU2.GE.IU1) CALL ENTER('^{'//UIND(IU1:IU2)//'}',IU2-IU1+4)
          IU1=IU2+5
        ENDIF
        IF(IL1.LE.LL) THEN
          IL2=INDEX(LIND(IL1:32),' \, ')+IL1-2
          IF(IL2.GE.IL1) CALL ENTER('_{'//LIND(IL1:IL2)//'}',IL2-IL1+4)
          IL1=IL2+5
        ENDIF
      ENDDO
      CALL ENTER('}',1)
      KTNS=0
      RETURN
      END


      SUBROUTINE ENTGRP
C  ENTERS A GROUP WITH SUB- OR SUPERSCRIPTS. SUB- OR SUPERSCRIPTS ARE
C  FIRST PROCESSED NORMALLY, THEN THIS ROUTINE RE-ARRANGES THEM WITH
C  THE \underset OR \overset CMDS.
C-----------------------------------------------------------------------
$INCLUDE:'FMLT.INC'
C***********************************************************************
      J=SCAN(TEX(JGRP:KTEX),'^_')
      J=JGRP+J-1
      I=0
      IF(TEX(J:J).EQ.'^') I=1
      IF(TEX(JGRP:JGRP).EQ.'{') THEN
        CALL ENTER(TEX(JGRP:J-1),J-JGRP)
      ELSE
        CALL ENTER('{'//TEX(JGRP:J-1)//'}',J-JGRP+2)
      ENDIF
      TEX(JGRP:J)=' '
      IF(I.EQ.1) THEN
        CALL INSERT('\overset',8,J+1)
      ELSE
        CALL INSERT('\underset',9,J+1)
      ENDIF
      RETURN
      END
