/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor;

import java.util.ArrayList;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.editor.BracketInserter;
import net.sourceforge.texlipse.editor.TexCodeFolder;
import net.sourceforge.texlipse.editor.TexDocumentProvider;
import net.sourceforge.texlipse.editor.TexPairMatcher;
import net.sourceforge.texlipse.editor.TexSourceViewerConfiguration;
import net.sourceforge.texlipse.editor.TexlipseAnnotationUpdater;
import net.sourceforge.texlipse.model.TexDocumentModel;
import net.sourceforge.texlipse.outline.TexOutlinePage;
import net.sourceforge.texlipse.treeview.views.TexOutlineTreeView;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class TexEditor
extends TextEditor {
    public static final String TEX_PARTITIONING = "__tex_partitioning";
    private TexPairMatcher fBracketMatcher = new TexPairMatcher("()[]{}");
    private TexOutlinePage outlinePage;
    private TexOutlineTreeView fullOutline;
    private TexDocumentModel documentModel;
    private TexCodeFolder folder = new TexCodeFolder(this);
    private ProjectionSupport fProjectionSupport;
    private BracketInserter fBracketInserter;
    private TexlipseAnnotationUpdater fAnnotationUpdater;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.fProjectionSupport.install();
        if (TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("codeFolding")) {
            projectionViewer.doOperation(19);
        }
        this.fAnnotationUpdater = new TexlipseAnnotationUpdater((AbstractTextEditor)this);
        ((IPostSelectionProvider)this.getSelectionProvider()).addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TexEditor.this.documentModel.removeStatusLineErrorMessage();
            }
        });
        this.getDocumentProvider().getDocument((Object)this.getEditorInput()).addDocumentListener((IDocumentListener)this.documentModel);
        this.documentModel.initializeModel();
        this.documentModel.updateNow();
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            if (this.fBracketInserter == null) {
                this.fBracketInserter = new BracketInserter(this.getSourceViewer(), (IEditorPart)this);
            }
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId("net.sourceforge.texlipse.texEditorScope");
        this.documentModel = new TexDocumentModel(this);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new TexSourceViewerConfiguration(this));
        if (this.getDocumentProvider() == null) {
            this.setDocumentProvider((IDocumentProvider)new TexDocumentProvider());
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), true, styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        this.getPreferenceStore().setValue("matchingBrackets", TexlipsePlugin.getPreference("matchingBrackets"));
        this.getPreferenceStore().setValue("matchingBracketsColor", TexlipsePlugin.getPreference("matchingBracketsColor"));
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("matchingBrackets", "matchingBracketsColor");
        super.configureSourceViewerDecorationSupport(support);
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction a = new TextOperationAction(TexlipsePlugin.getDefault().getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    public Object getAdapter(Class required) {
        Object adapter;
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.outlinePage == null) {
                this.outlinePage = new TexOutlinePage(this);
                this.documentModel.updateOutline();
            }
            return this.outlinePage;
        }
        if (this.fProjectionSupport != null && (adapter = this.fProjectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return adapter;
        }
        return super.getAdapter(required);
    }

    public TexOutlinePage getOutlinePage() {
        return this.outlinePage;
    }

    public TexDocumentModel getDocumentModel() {
        return this.documentModel;
    }

    public IPreferenceStore getPreferences() {
        return this.getPreferenceStore();
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        this.documentModel.updateNow();
    }

    public void updateCodeFolder(ArrayList rootNodes, IProgressMonitor monitor) {
        this.folder.update(rootNodes);
    }

    public void updateModelNow() {
        this.documentModel.updateNow();
    }

    public boolean isModelDirty() {
        return this.documentModel.isDirty();
    }

    public void dispose() {
        super.dispose();
    }

    public TexOutlineTreeView getFullOutline() {
        return this.fullOutline;
    }

    public void registerFullOutline(TexOutlineTreeView view) {
        boolean projectChange = false;
        if (view == null || view.getEditor() == null) {
            projectChange = true;
        } else if (view.getEditor().getEditorInput() instanceof IFileEditorInput) {
            IFileEditorInput oldInput = (IFileEditorInput)view.getEditor().getEditorInput();
            IProject newProject = this.getProject();
            if (!oldInput.getFile().getProject().equals((Object)newProject)) {
                projectChange = true;
            }
        } else {
            projectChange = true;
        }
        this.fullOutline = view;
        this.fullOutline.setEditor(this);
        if (projectChange) {
            this.fullOutline.projectChanged();
            this.documentModel.updateNow();
        }
    }

    public void unregisterFullOutline(TexOutlineTreeView view) {
        this.fullOutline = null;
    }

    public IDocument getTexDocument() {
        return this.getDocumentProvider().getDocument((Object)this.getEditorInput());
    }

    public IProject getProject() {
        IResource res = (IResource)this.getEditorInput().getAdapter(IResource.class);
        if (res == null) {
            return null;
        }
        return res.getProject();
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.ui.textEditorScope", "net.sourceforge.texlipse.texEditorScope"});
    }
}

