/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.model;

import java.util.HashMap;
import java.util.List;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.model.DocumentReference;
import net.sourceforge.texlipse.model.ParseErrorMessage;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerHandler {
    private static MarkerHandler theInstance;

    private MarkerHandler() {
    }

    public static MarkerHandler getInstance() {
        if (theInstance == null) {
            theInstance = new MarkerHandler();
        }
        return theInstance;
    }

    public void createErrorMarkers(ITextEditor editor, List<ParseErrorMessage> errors) {
        this.createMarkers(editor, errors, "org.eclipse.core.resources.problemmarker");
    }

    public void createTaskMarkers(ITextEditor editor, List<ParseErrorMessage> tasks) {
        this.createMarkers(editor, tasks, "org.eclipse.core.resources.taskmarker");
    }

    private void createMarkers(ITextEditor editor, List<ParseErrorMessage> markers, String markerType) {
        IResource resource = (IResource)editor.getEditorInput().getAdapter(IResource.class);
        if (resource == null) {
            return;
        }
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        for (ParseErrorMessage msg : markers) {
            try {
                int beginOffset = document.getLineOffset(msg.getLine() - 1) + msg.getPos();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("lineNumber", msg.getLine());
                map.put("charStart", beginOffset);
                map.put("charEnd", beginOffset + msg.getLength());
                map.put("message", msg.getMsg());
                if ("org.eclipse.core.resources.problemmarker" == markerType) {
                    map.put("severity", msg.getSeverity());
                }
                if ("org.eclipse.core.resources.taskmarker" == markerType) {
                    map.put("priority", msg.getSeverity());
                }
                MarkerUtilities.createMarker((IResource)resource, map, (String)markerType);
            }
            catch (CoreException ce) {
                TexlipsePlugin.log("Creating marker", ce);
            }
            catch (BadLocationException ble) {
                TexlipsePlugin.log("Creating marker", ble);
            }
        }
    }

    public void createReferencingErrorMarkers(ITextEditor editor, List<DocumentReference> errors) {
        IResource resource = (IResource)editor.getEditorInput().getAdapter(IResource.class);
        if (resource == null) {
            return;
        }
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        for (DocumentReference msg : errors) {
            try {
                int beginOffset = document.getLineOffset(msg.getLine() - 1) + msg.getPos();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("lineNumber", msg.getLine());
                map.put("charStart", beginOffset);
                map.put("charEnd", beginOffset + msg.getLength());
                map.put("message", "Key " + msg.getKey() + " is undefined");
                map.put("severity", 1);
                MarkerUtilities.createMarker((IResource)resource, map, (String)"org.eclipse.core.resources.problemmarker");
            }
            catch (CoreException ce) {
                TexlipsePlugin.log("Creating marker", ce);
            }
            catch (BadLocationException ble) {
                TexlipsePlugin.log("Creating marker", ble);
            }
        }
    }

    public void addFatalError(ITextEditor editor, String error) {
        IResource resource = (IResource)editor.getEditorInput().getAdapter(IResource.class);
        if (resource == null) {
            return;
        }
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("message", error);
            map.put("severity", 2);
            MarkerUtilities.createMarker((IResource)resource, map, (String)"org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException ce) {
            TexlipsePlugin.log("Creating marker", ce);
        }
    }

    public void clearErrorMarkers(ITextEditor editor) {
        IResource resource = (IResource)editor.getEditorInput().getAdapter(IResource.class);
        if (resource == null) {
            return;
        }
        try {
            resource.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 2);
        }
        catch (CoreException e) {
            TexlipsePlugin.log("Deleting error markers", e);
        }
    }

    public void clearProblemMarkers(IResource resource) {
        try {
            resource.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 2);
        }
        catch (CoreException e) {
            TexlipsePlugin.log("Deleting error markers", e);
        }
    }

    public void clearTaskMarkers(ITextEditor editor) {
        IResource resource = (IResource)editor.getEditorInput().getAdapter(IResource.class);
        if (resource == null) {
            return;
        }
        try {
            resource.deleteMarkers("org.eclipse.core.resources.taskmarker", false, 2);
        }
        catch (CoreException e) {
            TexlipsePlugin.log("Deleting task markers", e);
        }
    }

    public void createErrorMarker(IResource resource, String message, int lineNumber) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("lineNumber", lineNumber);
            map.put("message", message);
            map.put("severity", 2);
            MarkerUtilities.createMarker((IResource)resource, map, (String)"org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException ce) {
            TexlipsePlugin.log("Creating marker", ce);
        }
    }
}

