#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "..\DPMI.H"
#include "..\DPMI10.H"

/*
   **  Test DPMI server
 */

#ifdef __EMX__
static int test_dpmi_server (void)
{
  return ((_emx_env & 0x80) | (_emx_env & 0x100));
}
#endif

#ifdef __GO32__
#include <go32.h>
extern Go32_Info_Block _go32_info_block;

static int test_dpmi_server (void)
{
  return _go32_info_block.run_mode & _GO32_RUN_MODE_DPMI;
}
#endif

void PrintDescriptor (DESCRIPTOR * d)
{
  BYTE flag;

  if ((d -> access & PRESENT_BIT) == 0)
    {
      printf ("Not Present\n");
      return;
    }

  if (d -> access & SEGMENT_BIT)       /* code or data selector */
    printf ("Base=%02X%02X%04X Limit=%01X%04X %s DPL=%u %s %s %s %s\n",
	    d -> base_hi, d -> base_mi, d -> base_lo,
	    d -> lim_hi & LIMIT_HI_MASK, d -> lim_lo,
	    (d -> lim_hi & GRANULAR_BIT) ? "Pages" : "Bytes",
	    (d -> access & DPL_MASK) >> 5,
	    (d -> lim_hi & DEFAULT_BIT) ? "32bit" : "16bit",
	    (d -> access & CODE_BIT) ?
	    (d -> access & CONFIRMING_BIT) ? "CONF" : "CODE" :
	    (d -> access & EXPAND_BIT) ? "EXPD" : "DATA",
	    (d -> access & WRITE_BIT) ?
	    (d -> access & CODE_BIT) ? "R" : "W" : "-",
	    (d -> access & ACCESS_BIT) ? "ACC" : " ");

  else
    {				       /* system selector */
      flag = d -> access & (BYTE) 7;
      switch (flag)
	{
	  case 0:
	    break;
	  case 1:printf ("TSS%s ", (d -> access & 8) ? "386" : "286");
	  break;
	  case 2:printf ("LDT ");
	  break;
	  case 3:printf ("BUSYTSS%s ", (d -> access & 8) ? "386" : "286");
	  break;
	  case 4:printf ("CALLGATE%s ", (d -> access & 8) ? "386" : "286");
	  break;
	  case 5:printf ("TASKGATE ");
	  break;
	  case 6:printf ("INT_GATE%s ", (d -> access & 8) ? "386" : "286");
	  break;
	  case 7:printf ("TRAPGATE%s ", (d -> access & 8) ? "386" : "286");
	  break;
	}


      if (flag <= 3)
	{
	  printf ("Base=%02X%02X%04X Limit=%01X%04X DPL=%u\n",
		  d -> base_hi, d -> base_mi, d -> base_lo,
		  d -> lim_hi & LIMIT_HI_MASK, d -> lim_lo,
		  (d -> access & DPL_MASK) >> 5);
	}

      else
	{
	  printf ("Sel=%04X Offset=%02X%02X%04X DPL=%u\n",
		  d -> base_lo,
		  d -> base_hi, d -> lim_hi, d -> lim_lo,
		  (d -> access & DPL_MASK) >> 5);
	}
    }				       /* else system descriptor */
}

int main (int argc, char **argv, char **env)
{
  DPMIVERSION dpmi_ver;
  DESCRIPTOR desc;
  int i;

  if (!test_dpmi_server ())
    {
      puts ("I need dpmi, run this program with a dpmiextender\n");
      puts ("EMX: run rsx ; DJGPP run go32 not with 'nodpmi'\n");
      return 1;
    }

  GetDPMIVersion (&dpmi_ver);
  printf ("\nDPMI version %d.%d\n", dpmi_ver.major, dpmi_ver.minor);
  printf ("32bit supported: %s\n", (dpmi_ver.flags & 1) ? "Yes": "No");
  printf ("CPU detected %d86\n", dpmi_ver.cpu);

  GetDescriptor (GetCS (), &desc);
  PrintDescriptor (& desc);
  GetDescriptor (GetDS (), &desc);
  PrintDescriptor (& desc);

  fflush (stdout);
  return 0;
}
