/*
 * LaTeD Version 1.1
 * (c) Gene Ressler 1993, 94, 97
 *   de8827@trotter.usma.edu
 *
 * LaTeD is a graphical editor for drawings in the LaTeX "picture" 
 * environment.  It runs under MSDOS or in a Windows DOS box.  The
 * distribution includes full sources, including LaTeX source for 
 * its documentation.
 *
 * No warranty of this software is expressed or implied by the author.
 *
 * Copy and use this program freely for any purpose except for sale
 * of the program (including the source code) itself.  That is, 
 * no one can copy this program for the purpose of providing it to 
 * another person in exchange for money or other compensation, even 
 * if this program is only part of the exchange.
 *
 * All copies of computer source code in this distribution, whether
 * copies in whole or in part, must have this notice attached.
 */

/* DTEXT.C --- Justified text for dialog boxes. */

#include <stdlib.h>
#include <assert.h>
#include <graphics.h>
#include <string.h>
#include "window.h"

enum {

text_x_margin = 0,
text_y_margin = 0,
text_border_width = 0,
text_border_color = cBLACK,
text_bg_color = NO_COLOR,
text_fg_color = cBLACK,
text_vsep     = 2,

};

static void handle_map(EVENT e)
{
  char **lp, **end;
  int x, y;
  TEXT t = (TEXT)e->map.window;

  switch (t->justify) {
    case LEFT_TEXT:   x = text_x_margin; break;
    case CENTER_TEXT: x = e->map.window->width/2; break;
    case RIGHT_TEXT:  x = e->map.window->width - text_x_margin - 1;
    default: assert(0);
  }
  push_graphics_state(&t->window, 0);
  setcolor(text_fg_color);
  settextjustify(t->justify, TOP_TEXT);
  protect_cursor(&t->window);

  for (y = text_y_margin, lp = t->lines, end = lp + t->n_lines;
       lp < end;
       y += textheight(*lp) + text_vsep, ++lp)
    outtextxy(x, y, *lp);

  unprotect_cursor();
  pop_graphics_state();
}

struct pointtype text_size(TEXT t)
{
  struct pointtype size;
  char **p, **end;

  for (size.x = size.y = 0, p = t->lines, end = p + t->n_lines; p < end; ++p) {
    size.x = max(size.x, textwidth(*p));
    if (size.y > 0)
      size.y += text_vsep;
    size.y += textheight(*p);
  }
  return size;
}

void open_text(TEXT t, int x, int y, WINDOW parent)
{
  struct pointtype size = text_size(t);

  open_window(&t->window, parent, x, y,
	      text_x_margin + size.x + text_x_margin,
	      text_y_margin + size.y + text_y_margin,
	      text_border_width, text_border_color, text_bg_color, bit(eMAP));
  t->window.handler = handle_map;
}
