/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.51 from the
 * contents of CairoSurface.xs. Do not edit this file, edit CairoSurface.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "CairoSurface.xs"
/*
 * Copyright (c) 2004-2006, 2012-2013 by the cairo perl team (see the file
 * README)
 *
 * Licensed under the LGPL, see LICENSE file for more information.
 *
 * $Id$
 */

#include <cairo-perl.h>
#include <cairo-perl-private.h>

#define NEED_sv_2pv_flags
#include "ppport.h"

#if CAIRO_VERSION < CAIRO_VERSION_ENCODE(1, 2, 0)

static HV *pointer_to_package = NULL;

/* A hex character represents four bits in the address of a pointer, so we'll
 * need BITS_PER_POINTER/4 characters.  That's sizeof (void*) * 2.  Add 2 for
 * the "0x" part.  Add 1 for the trailing \0.
 */
#define MAX_KEY_LENGTH ((sizeof(void*) * 2) + 2 + 1)

/* This stuff is also used in CairoPattern.xs, hence no static on the
 * functions.
 */

void
cairo_perl_package_table_insert (void *pointer, const char *package)
{
	char key[MAX_KEY_LENGTH];

	if (!pointer_to_package) {
		pointer_to_package = newHV ();
	}

	sprintf (key, "%p", pointer);
	hv_store (pointer_to_package, key, strlen (key), newSVpv (package, 0), 0);
}

const char *
cairo_perl_package_table_lookup (void *pointer)
{
	char key[MAX_KEY_LENGTH];
	SV **sv;

	if (!pointer_to_package) {
		return NULL;
	}

	sprintf (key, "%p", pointer);
	sv = hv_fetch (pointer_to_package, key, strlen (key), 0);
	if (sv && SvOK (*sv)) {
		return SvPV_nolen (*sv);
	}

	return NULL;
}

#endif /* !1.2.0 */

static const char *
get_package (cairo_surface_t *surface)
{
#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 2, 0)
	cairo_surface_type_t type;
	const char *package;

	type = cairo_surface_get_type (surface);
	switch (type) {
	    case CAIRO_SURFACE_TYPE_IMAGE:
		package = "Cairo::ImageSurface";
		break;

	    case CAIRO_SURFACE_TYPE_PDF:
		package = "Cairo::PdfSurface";
		break;

	    case CAIRO_SURFACE_TYPE_PS:
		package = "Cairo::PsSurface";
		break;

	    case CAIRO_SURFACE_TYPE_SVG:
		package = "Cairo::SvgSurface";
		break;

#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 10, 0)
	    case CAIRO_SURFACE_TYPE_RECORDING:
		package = "Cairo::RecordingSurface";
		break;
#endif

	    case CAIRO_SURFACE_TYPE_XLIB:
	    case CAIRO_SURFACE_TYPE_XCB:
	    case CAIRO_SURFACE_TYPE_GLITZ:
	    case CAIRO_SURFACE_TYPE_QUARTZ:
	    case CAIRO_SURFACE_TYPE_WIN32:
	    case CAIRO_SURFACE_TYPE_BEOS:
	    case CAIRO_SURFACE_TYPE_DIRECTFB:
#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 4, 0)
	    case CAIRO_SURFACE_TYPE_OS2:
#endif
#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 6, 0)
	    case CAIRO_SURFACE_TYPE_WIN32_PRINTING:
	    case CAIRO_SURFACE_TYPE_QUARTZ_IMAGE:
#endif
#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 10, 0)
	    case CAIRO_SURFACE_TYPE_SCRIPT:
	    case CAIRO_SURFACE_TYPE_QT:
	    case CAIRO_SURFACE_TYPE_VG:
	    case CAIRO_SURFACE_TYPE_GL:
	    case CAIRO_SURFACE_TYPE_DRM:
	    case CAIRO_SURFACE_TYPE_TEE:
	    case CAIRO_SURFACE_TYPE_XML:
	    case CAIRO_SURFACE_TYPE_SKIA:
	    case CAIRO_SURFACE_TYPE_SUBSURFACE:
#endif
		package = "Cairo::Surface";
		break;

	    default:
		warn ("unknown surface type %d encountered", type);
		package = "Cairo::Surface";
		break;
	}

	return package;
#else
	const char *package = cairo_perl_package_table_lookup (surface);
	return package ? package : "Cairo::Surface";
#endif
}

SV *
cairo_surface_to_sv (cairo_surface_t *surface)
{
	SV *sv = newSV (0);
	sv_setref_pv(sv, get_package (surface), surface);
	return sv;
}

/* -------------------------------------------------------------------------- */

typedef struct {
	SV *func;
	SV *data;
	void *context;
} CairoPerlCallback;

#ifdef PERL_IMPLICIT_CONTEXT
# define dCAIRO_PERL_CALLBACK_MARSHAL_SP		\
	SV ** sp;
# define CAIRO_PERL_CALLBACK_MARSHAL_INIT(callback)	\
	PERL_SET_CONTEXT (callback->context);		\
	SPAGAIN;
#else
# define dCAIRO_PERL_CALLBACK_MARSHAL_SP		\
	dSP;
# define CAIRO_PERL_CALLBACK_MARSHAL_INIT(callback)	\
	/* nothing to do */
#endif

static CairoPerlCallback *
cairo_perl_callback_new (SV *func, SV *data)
{
	CairoPerlCallback *callback;

	Newz (0, callback, 1, CairoPerlCallback);

	callback->func = newSVsv (func);
	if (data)
		callback->data = newSVsv (data);

#ifdef PERL_IMPLICIT_CONTEXT
	callback->context = aTHX;
#endif

	return callback;
}

static void
cairo_perl_callback_free (CairoPerlCallback *callback)
{
	SvREFCNT_dec (callback->func);
	if (callback->data)
		SvREFCNT_dec (callback->data);
	Safefree (callback);
}

/* -------------------------------------------------------------------------- */

/* Caller owns returned SV */
static SV *
strip_off_location (SV *error)
{
	SV *saved_defsv, *result;
	saved_defsv = newSVsv (DEFSV);
	ENTER;
	SAVETMPS;
	sv_setsv (DEFSV, error);
	eval_pv ("s/^([-_\\w]+) .+$/$1/s", FALSE);
	result = newSVsv (DEFSV);
	FREETMPS;
	LEAVE;
	sv_setsv (DEFSV, saved_defsv);
	SvREFCNT_dec (saved_defsv);
	return result;
}

static cairo_status_t
write_func_marshaller (void *closure,
                       const unsigned char *data,
                       unsigned int length)
{
	CairoPerlCallback *callback;
	cairo_status_t status = CAIRO_STATUS_SUCCESS;
	dCAIRO_PERL_CALLBACK_MARSHAL_SP;

	callback = (CairoPerlCallback *) closure;

	CAIRO_PERL_CALLBACK_MARSHAL_INIT (callback);

	ENTER;
	SAVETMPS;
	PUSHMARK (SP);

	EXTEND (SP, 2);
	PUSHs (callback->data ? callback->data : &PL_sv_undef);
	PUSHs (sv_2mortal (newSVpv ((const char *) data, length)));

	PUTBACK;
	call_sv (callback->func, G_DISCARD | G_EVAL);
	SPAGAIN;

	if (SvTRUE (ERRSV)) {
		SV *sv = strip_off_location (ERRSV);
		status = SvCairoStatus (sv);
		SvREFCNT_dec (sv);
	}

	PUTBACK;
	FREETMPS;
	LEAVE;

	return status;
}

/* -------------------------------------------------------------------------- */

static cairo_status_t
read_func_marshaller (void *closure,
                      unsigned char *data,
                      unsigned int length)
{
	CairoPerlCallback *callback;
	cairo_status_t status = CAIRO_STATUS_SUCCESS;
	dCAIRO_PERL_CALLBACK_MARSHAL_SP;

	callback = (CairoPerlCallback *) closure;

	CAIRO_PERL_CALLBACK_MARSHAL_INIT (callback);

	ENTER;
	SAVETMPS;
	PUSHMARK (SP);

	EXTEND (SP, 2);
	PUSHs (callback->data ? callback->data : &PL_sv_undef);
	PUSHs (sv_2mortal (newSVuv (length)));

	PUTBACK;
	call_sv (callback->func, G_SCALAR | G_EVAL);
	SPAGAIN;

	if (SvTRUE (ERRSV)) {
		SV *sv = strip_off_location (ERRSV);
		status = SvCairoStatus (sv);
		SvREFCNT_dec (sv);
	} else {
		SV *retval = POPs;
		STRLEN len = 0;
		const char *sv_data = SvPV (retval, len);
		/* should we assert that len == length? */
		memcpy (data, sv_data, len);
	}

	PUTBACK;
	FREETMPS;
	LEAVE;

	return status;
}

/* -------------------------------------------------------------------------- */

static void
data_destroy (void *data)
{
	SvREFCNT_dec ((SV *) data);
}

/* -------------------------------------------------------------------------- */

#line 316 "CairoSurface.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 460 "CairoSurface.c"

XS_EUPXS(XS_Cairo__Surface_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
#line 310 "CairoSurface.xs"
	cairo_surface_destroy (surface);
#line 473 "CairoSurface.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Surface_create_similar); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_create_similar)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
#line 315 "CairoSurface.xs"
	int offset = 0;
	cairo_surface_t * other = NULL;
	cairo_content_t content = 0;
	int width = 0;
	int height = 0;
#line 492 "CairoSurface.c"
	cairo_surface_t_noinc *	RETVAL;
#line 321 "CairoSurface.xs"
	if (items == 4) {
		offset = 0;
	} else if (items == 5) {
		offset = 1;
	} else {
		croak ("Usage: Cairo::Surface->create_similar ($other, $content, $width, $height)\n"
		       " -or-: $other->create_similar ($content, $width, $height)");
	}
	other = SvCairoSurface (ST (0 + offset));
	content = SvCairoContent (ST (1 + offset));
	width = SvIV (ST (2 + offset));
	height = SvIV (ST (3 + offset));
	RETVAL = cairo_surface_create_similar (other, content, width, height);
#if CAIRO_VERSION < CAIRO_VERSION_ENCODE(1, 2, 0)
	{
	const char *package = cairo_perl_package_table_lookup (other);
	cairo_perl_package_table_insert (RETVAL, package ? package : "Cairo::Surface");
	}
#endif
#line 514 "CairoSurface.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoSurface_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Surface_finish); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_finish)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;

	cairo_surface_finish(surface);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Surface_status); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_status)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	cairo_status_t	RETVAL;
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;

	RETVAL = cairo_surface_status(surface);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoStatus (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Surface_set_device_offset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_set_device_offset)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "surface, x_offset, y_offset");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	double	x_offset = (double)SvNV(ST(1))
;
	double	y_offset = (double)SvNV(ST(2))
;

	cairo_surface_set_device_offset(surface, x_offset, y_offset);
    }
    XSRETURN_EMPTY;
}

#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 2, 0)
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_Cairo__Surface_get_device_offset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_get_device_offset)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	double	x_offset;
	double	y_offset;

	cairo_surface_get_device_offset(surface, &x_offset, &y_offset);
	XSprePUSH;	EXTEND(SP,2);
	PUSHs(sv_newmortal());
	sv_setnv(ST(0), (double)x_offset);
	PUSHs(sv_newmortal());
	sv_setnv(ST(1), (double)y_offset);
    }
    XSRETURN(2);
}


XS_EUPXS(XS_Cairo__Surface_set_fallback_resolution); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_set_fallback_resolution)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "surface, x_pixels_per_inch, y_pixels_per_inch");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	double	x_pixels_per_inch = (double)SvNV(ST(1))
;
	double	y_pixels_per_inch = (double)SvNV(ST(2))
;

	cairo_surface_set_fallback_resolution(surface, x_pixels_per_inch, y_pixels_per_inch);
    }
    XSRETURN_EMPTY;
}

#endif
#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 8, 0)
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_Cairo__Surface_get_fallback_resolution); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_get_fallback_resolution)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	double	x_pixels_per_inch;
	double	y_pixels_per_inch;

	cairo_surface_get_fallback_resolution(surface, &x_pixels_per_inch, &y_pixels_per_inch);
	XSprePUSH;	EXTEND(SP,2);
	PUSHs(sv_newmortal());
	sv_setnv(ST(0), (double)x_pixels_per_inch);
	PUSHs(sv_newmortal());
	sv_setnv(ST(1), (double)y_pixels_per_inch);
    }
    XSRETURN(2);
}

#endif

XS_EUPXS(XS_Cairo__Surface_get_font_options); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_get_font_options)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	cairo_font_options_t *	RETVAL;
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
#line 366 "CairoSurface.xs"
	RETVAL = cairo_font_options_create ();
	cairo_surface_get_font_options (surface, RETVAL);
#line 672 "CairoSurface.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoFontOptions (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Surface_flush); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_flush)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;

	cairo_surface_flush(surface);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Surface_mark_dirty); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_mark_dirty)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;

	cairo_surface_mark_dirty(surface);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Surface_mark_dirty_rectangle); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_mark_dirty_rectangle)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "surface, x, y, width, height");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	int	x = (int)SvIV(ST(1))
;
	int	y = (int)SvIV(ST(2))
;
	int	width = (int)SvIV(ST(3))
;
	int	height = (int)SvIV(ST(4))
;

	cairo_surface_mark_dirty_rectangle(surface, x, y, width, height);
    }
    XSRETURN_EMPTY;
}

#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 2, 0)
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_Cairo__Surface_get_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_get_type)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	cairo_surface_type_t	RETVAL;
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;

	RETVAL = cairo_surface_get_type(surface);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoSurfaceType (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Surface_get_content); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_get_content)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	cairo_content_t	RETVAL;
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;

	RETVAL = cairo_surface_get_content(surface);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoContent (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif
#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 10, 0)
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_Cairo__Surface_set_mime_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_set_mime_data)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "surface, mime_type, data");
    {
#line 391 "CairoSurface.xs"
	const unsigned char *mime_data;
	unsigned long length;
#line 803 "CairoSurface.c"
	cairo_status_t	RETVAL;
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	const char *	mime_type = (const char *)SvPV_nolen(ST(1))
;
	SV *	data = ST(2)
;
#line 394 "CairoSurface.xs"
	SvREFCNT_inc (data);
	mime_data = (const unsigned char *) SvPV(data, length);
	RETVAL = cairo_surface_set_mime_data (surface, mime_type, mime_data, length, data_destroy, data);
#line 815 "CairoSurface.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoStatus (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Surface_get_mime_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_get_mime_data)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "surface, mime_type");
    {
#line 404 "CairoSurface.xs"
	const unsigned char *data;
	unsigned long length;
#line 837 "CairoSurface.c"
	SV *	RETVAL;
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	const char *	mime_type = (const char *)SvPV_nolen(ST(1))
;
#line 407 "CairoSurface.xs"
	cairo_surface_get_mime_data (surface, mime_type, &data, &length);
	RETVAL = newSVpvn ((const char *) data, length);
#line 846 "CairoSurface.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#endif
#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 12, 0)
#define XSubPPtmpAAAE 1


XS_EUPXS(XS_Cairo__Surface_supports_mime_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_supports_mime_type)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "surface, mime_type");
    {
	cairo_bool_t	RETVAL;
	dXSTARG;
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	const char *	mime_type = (const char *)SvPV_nolen(ST(1))
;

	RETVAL = cairo_surface_supports_mime_type(surface, mime_type);
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}

#endif
#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 14, 0)
#define XSubPPtmpAAAF 1

#endif
#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 16, 0)
#define XSubPPtmpAAAG 1

#endif
#ifdef CAIRO_HAS_PNG_FUNCTIONS
#define XSubPPtmpAAAH 1


XS_EUPXS(XS_Cairo__Surface_write_to_png); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_write_to_png)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "surface, filename");
    {
	cairo_status_t	RETVAL;
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	const char *	filename = (const char *)SvPV_nolen(ST(1))
;

	RETVAL = cairo_surface_write_to_png(surface, filename);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoStatus (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Surface_write_to_png_stream); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_write_to_png_stream)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "surface, func, data=NULL");
    {
#line 457 "CairoSurface.xs"
	CairoPerlCallback *callback;
#line 926 "CairoSurface.c"
	cairo_status_t	RETVAL;
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	SV *	func = ST(1)
;
	SV *	data;

	if (items < 3)
	    data = NULL;
	else {
	    data = ST(2)
;
	}
#line 459 "CairoSurface.xs"
	callback = cairo_perl_callback_new (func, data);
	RETVAL = cairo_surface_write_to_png_stream (surface,
	                                            write_func_marshaller,
	                                            callback);
	cairo_perl_callback_free (callback);
#line 946 "CairoSurface.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoStatus (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif
#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE (1, 6, 0)
#define XSubPPtmpAAAI 1


XS_EUPXS(XS_Cairo__Surface_copy_page); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_copy_page)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;

	cairo_surface_copy_page(surface);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Surface_show_page); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_show_page)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;

	cairo_surface_show_page(surface);
    }
    XSRETURN_EMPTY;
}

#endif
#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE (1, 8, 0)
#define XSubPPtmpAAAJ 1


XS_EUPXS(XS_Cairo__Surface_has_show_text_glyphs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_has_show_text_glyphs)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	cairo_bool_t	RETVAL;
	dXSTARG;
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;

	RETVAL = cairo_surface_has_show_text_glyphs(surface);
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}

#endif
#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE (1, 10, 0)
#define XSubPPtmpAAAK 1


XS_EUPXS(XS_Cairo__Surface_create_for_rectangle); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Surface_create_for_rectangle)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "class, target, x, y, width, height");
    {
	cairo_surface_t_noinc *	RETVAL;
	cairo_surface_t *	target = SvCairoSurface (ST(1))
;
	double	x = (double)SvNV(ST(2))
;
	double	y = (double)SvNV(ST(3))
;
	double	width = (double)SvNV(ST(4))
;
	double	height = (double)SvNV(ST(5))
;

	RETVAL = cairo_surface_create_for_rectangle(target, x, y, width, height);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoSurface_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Cairo__ImageSurface_create); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__ImageSurface_create)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "class, format, width, height");
    {
	cairo_surface_t_noinc *	RETVAL;
	cairo_format_t	format = SvCairoFormat (ST(1))
;
	int	width = (int)SvIV(ST(2))
;
	int	height = (int)SvIV(ST(3))
;

	RETVAL = cairo_image_surface_create(format, width, height);
#line 505 "CairoSurface.xs"
#if CAIRO_VERSION < CAIRO_VERSION_ENCODE(1, 2, 0)
	cairo_perl_package_table_insert (RETVAL, "Cairo::ImageSurface");
#endif
#line 1074 "CairoSurface.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoSurface_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__ImageSurface_create_for_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__ImageSurface_create_for_data)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "class, data, format, width, height, stride");
    {
	cairo_surface_t_noinc *	RETVAL;
	unsigned char *	data = (unsigned char *)SvPV_nolen(ST(1))
;
	cairo_format_t	format = SvCairoFormat (ST(2))
;
	int	width = (int)SvIV(ST(3))
;
	int	height = (int)SvIV(ST(4))
;
	int	stride = (int)SvIV(ST(5))
;

	RETVAL = cairo_image_surface_create_for_data(data, format, width, height, stride);
#line 514 "CairoSurface.xs"
#if CAIRO_VERSION < CAIRO_VERSION_ENCODE(1, 2, 0)
	cairo_perl_package_table_insert (RETVAL, "Cairo::ImageSurface");
#endif
#line 1110 "CairoSurface.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoSurface_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 2, 0)
#define XSubPPtmpAAAL 1


XS_EUPXS(XS_Cairo__ImageSurface_get_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__ImageSurface_get_data)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
#line 524 "CairoSurface.xs"
	unsigned char *data;
	int height, stride;
#line 1135 "CairoSurface.c"
	SV *	RETVAL;
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
#line 527 "CairoSurface.xs"
	data = cairo_image_surface_get_data (surface);
	height = cairo_image_surface_get_height (surface);
	stride = cairo_image_surface_get_stride (surface);
	RETVAL = data ? newSVpv ((char *) data, height * stride) : &PL_sv_undef;
#line 1144 "CairoSurface.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__ImageSurface_get_format); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__ImageSurface_get_format)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	cairo_format_t	RETVAL;
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;

	RETVAL = cairo_image_surface_get_format(surface);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoFormat (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Cairo__ImageSurface_get_width); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__ImageSurface_get_width)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	int	RETVAL;
	dXSTARG;
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;

	RETVAL = cairo_image_surface_get_width(surface);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__ImageSurface_get_height); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__ImageSurface_get_height)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	int	RETVAL;
	dXSTARG;
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;

	RETVAL = cairo_image_surface_get_height(surface);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 2, 0)
#define XSubPPtmpAAAM 1


XS_EUPXS(XS_Cairo__ImageSurface_get_stride); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__ImageSurface_get_stride)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	int	RETVAL;
	dXSTARG;
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;

	RETVAL = cairo_image_surface_get_stride(surface);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif
#ifdef CAIRO_HAS_PNG_FUNCTIONS
#define XSubPPtmpAAAN 1


XS_EUPXS(XS_Cairo__ImageSurface_create_from_png); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__ImageSurface_create_from_png)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, filename");
    {
	cairo_surface_t_noinc *	RETVAL;
	const char *	filename = (const char *)SvPV_nolen(ST(1))
;

	RETVAL = cairo_image_surface_create_from_png(filename);
#line 555 "CairoSurface.xs"
#if CAIRO_VERSION < CAIRO_VERSION_ENCODE(1, 2, 0)
	cairo_perl_package_table_insert (RETVAL, "Cairo::ImageSurface");
#endif
#line 1259 "CairoSurface.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoSurface_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__ImageSurface_create_from_png_stream); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__ImageSurface_create_from_png_stream)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "class, func, data=NULL");
    {
#line 563 "CairoSurface.xs"
	CairoPerlCallback *callback;
#line 1280 "CairoSurface.c"
	cairo_surface_t_noinc *	RETVAL;
	SV *	func = ST(1)
;
	SV *	data;

	if (items < 3)
	    data = NULL;
	else {
	    data = ST(2)
;
	}
#line 565 "CairoSurface.xs"
	callback = cairo_perl_callback_new (func, data);
	RETVAL = cairo_image_surface_create_from_png_stream (
			read_func_marshaller, callback);
	cairo_perl_callback_free (callback);
#if CAIRO_VERSION < CAIRO_VERSION_ENCODE(1, 2, 0)
	cairo_perl_package_table_insert (RETVAL, "Cairo::ImageSurface");
#endif
#line 1300 "CairoSurface.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoSurface_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif
#ifdef CAIRO_HAS_PDF_SURFACE
#define XSubPPtmpAAAO 1


XS_EUPXS(XS_Cairo__PdfSurface_create); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PdfSurface_create)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "class, filename, width_in_points, height_in_points");
    {
	cairo_surface_t_noinc *	RETVAL;
	const char *	filename = (const char *)SvPV_nolen(ST(1))
;
	double	width_in_points = (double)SvNV(ST(2))
;
	double	height_in_points = (double)SvNV(ST(3))
;

	RETVAL = cairo_pdf_surface_create(filename, width_in_points, height_in_points);
#line 591 "CairoSurface.xs"
#if CAIRO_VERSION < CAIRO_VERSION_ENCODE(1, 2, 0)
	cairo_perl_package_table_insert (RETVAL, "Cairo::PdfSurface");
#endif
#line 1336 "CairoSurface.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoSurface_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__PdfSurface_create_for_stream); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PdfSurface_create_for_stream)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "class, func, data, width_in_points, height_in_points");
    {
#line 599 "CairoSurface.xs"
	CairoPerlCallback *callback;
#line 1357 "CairoSurface.c"
	cairo_surface_t_noinc *	RETVAL;
	SV *	func = ST(1)
;
	SV *	data = ST(2)
;
	double	width_in_points = (double)SvNV(ST(3))
;
	double	height_in_points = (double)SvNV(ST(4))
;
#line 601 "CairoSurface.xs"
	callback = cairo_perl_callback_new (func, data);
	RETVAL = cairo_pdf_surface_create_for_stream (write_func_marshaller,
	                                              callback,
	                                              width_in_points,
	                                              height_in_points);
	cairo_surface_set_user_data (
		RETVAL, (const cairo_user_data_key_t *) &callback, callback,
		(cairo_destroy_func_t) cairo_perl_callback_free);
#if CAIRO_VERSION < CAIRO_VERSION_ENCODE(1, 2, 0)
	cairo_perl_package_table_insert (RETVAL, "Cairo::PdfSurface");
#endif
#line 1379 "CairoSurface.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoSurface_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 2, 0)
#define XSubPPtmpAAAP 1


XS_EUPXS(XS_Cairo__PdfSurface_set_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PdfSurface_set_size)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "surface, width_in_points, height_in_points");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	double	width_in_points = (double)SvNV(ST(1))
;
	double	height_in_points = (double)SvNV(ST(2))
;

	cairo_pdf_surface_set_size(surface, width_in_points, height_in_points);
    }
    XSRETURN_EMPTY;
}

#endif
#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 10, 0)
#define XSubPPtmpAAAQ 1


XS_EUPXS(XS_Cairo__PdfSurface_restrict_to_version); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PdfSurface_restrict_to_version)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "surface, version");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	cairo_pdf_version_t	version = SvCairoPdfVersion (ST(1))
;

	cairo_pdf_surface_restrict_to_version(surface, version);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__PdfSurface_get_versions); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PdfSurface_get_versions)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "class=NULL");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 629 "CairoSurface.xs"
	cairo_pdf_version_t const *versions = NULL;
	int num_versions = 0, i;
#line 1448 "CairoSurface.c"
#line 632 "CairoSurface.xs"
	PERL_UNUSED_VAR (ax);
	cairo_pdf_get_versions (&versions, &num_versions);
	EXTEND (sp, num_versions);
	for (i = 0; i < num_versions; i++)
		PUSHs (sv_2mortal (newSVCairoPdfVersion (versions[i])));
#line 1455 "CairoSurface.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Cairo__PdfSurface_version_to_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PdfSurface_version_to_string)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	const char *	RETVAL;
	dXSTARG;
#line 642 "CairoSurface.xs"
	if (items == 1) {
		RETVAL = cairo_pdf_version_to_string (SvCairoPdfVersion (ST (0)));
	} else if (items == 2) {
		RETVAL = cairo_pdf_version_to_string (SvCairoPdfVersion (ST (1)));
	} else {
		RETVAL = NULL;
		croak ("Usage: Cairo::PdfSurface::version_to_string (version) or Cairo::PdfSurface->version_to_string (version)");
	}
#line 1480 "CairoSurface.c"
	sv_setpv(TARG, RETVAL);
	XSprePUSH;
	PUSHTARG;
    }
    XSRETURN(1);
}

#endif
#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 16, 0)
#define XSubPPtmpAAAR 1


XS_EUPXS(XS_Cairo__PdfSurface_add_outline); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PdfSurface_add_outline)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "surface, parent_id, utf8, link_attribs, flags");
    {
	int	RETVAL;
	dXSTARG;
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	int	parent_id = (int)SvIV(ST(1))
;
	const char *	utf8 = (const char *)SvPV_nolen(ST(2))
;
	const char *	link_attribs = (const char *)SvPV_nolen(ST(3))
;
	cairo_pdf_outline_flags_t	flags = SvCairoPdfOutlineFlags (ST(4))
;

	RETVAL = cairo_pdf_surface_add_outline(surface, parent_id, utf8, link_attribs, flags);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__PdfSurface_set_metadata); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PdfSurface_set_metadata)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "surface, metadata, utf8");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	cairo_pdf_metadata_t	metadata = SvCairoPdfMetadata (ST(1))
;
	const char_utf8 *	utf8;

	sv_utf8_upgrade (ST(2));
	utf8 = (const char_utf8 *) SvPV_nolen (ST(2))
;

	cairo_pdf_surface_set_metadata(surface, metadata, utf8);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__PdfSurface_set_page_label); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PdfSurface_set_page_label)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "surface, utf8");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	const char *	utf8 = (const char *)SvPV_nolen(ST(1))
;

	cairo_pdf_surface_set_page_label(surface, utf8);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__PdfSurface_set_thumbnail_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PdfSurface_set_thumbnail_size)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "surface, width, height");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	int	width = (int)SvIV(ST(1))
;
	int	height = (int)SvIV(ST(2))
;

	cairo_pdf_surface_set_thumbnail_size(surface, width, height);
    }
    XSRETURN_EMPTY;
}

#endif
#endif
#ifdef CAIRO_HAS_PS_SURFACE
#define XSubPPtmpAAAS 1


XS_EUPXS(XS_Cairo__PsSurface_create); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PsSurface_create)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "class, filename, width_in_points, height_in_points");
    {
	cairo_surface_t_noinc *	RETVAL;
	const char *	filename = (const char *)SvPV_nolen(ST(1))
;
	double	width_in_points = (double)SvNV(ST(2))
;
	double	height_in_points = (double)SvNV(ST(3))
;

	RETVAL = cairo_ps_surface_create(filename, width_in_points, height_in_points);
#line 687 "CairoSurface.xs"
#if CAIRO_VERSION < CAIRO_VERSION_ENCODE(1, 2, 0)
	cairo_perl_package_table_insert (RETVAL, "Cairo::PsSurface");
#endif
#line 1607 "CairoSurface.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoSurface_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__PsSurface_create_for_stream); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PsSurface_create_for_stream)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "class, func, data, width_in_points, height_in_points");
    {
#line 695 "CairoSurface.xs"
	CairoPerlCallback *callback;
#line 1628 "CairoSurface.c"
	cairo_surface_t_noinc *	RETVAL;
	SV *	func = ST(1)
;
	SV *	data = ST(2)
;
	double	width_in_points = (double)SvNV(ST(3))
;
	double	height_in_points = (double)SvNV(ST(4))
;
#line 697 "CairoSurface.xs"
	callback = cairo_perl_callback_new (func, data);
	RETVAL = cairo_ps_surface_create_for_stream (write_func_marshaller,
	                                             callback,
	                                             width_in_points,
	                                             height_in_points);
	cairo_surface_set_user_data (
		RETVAL, (const cairo_user_data_key_t *) &callback, callback,
		(cairo_destroy_func_t) cairo_perl_callback_free);
#if CAIRO_VERSION < CAIRO_VERSION_ENCODE(1, 2, 0)
	cairo_perl_package_table_insert (RETVAL, "Cairo::PsSurface");
#endif
#line 1650 "CairoSurface.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoSurface_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 2, 0)
#define XSubPPtmpAAAT 1


XS_EUPXS(XS_Cairo__PsSurface_set_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PsSurface_set_size)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "surface, width_in_points, height_in_points");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	double	width_in_points = (double)SvNV(ST(1))
;
	double	height_in_points = (double)SvNV(ST(2))
;

	cairo_ps_surface_set_size(surface, width_in_points, height_in_points);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__PsSurface_dsc_comment); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PsSurface_dsc_comment)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "surface, comment");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	const char *	comment = (const char *)SvPV_nolen(ST(1))
;

	cairo_ps_surface_dsc_comment(surface, comment);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__PsSurface_dsc_begin_setup); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PsSurface_dsc_begin_setup)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;

	cairo_ps_surface_dsc_begin_setup(surface);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__PsSurface_dsc_begin_page_setup); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PsSurface_dsc_begin_page_setup)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;

	cairo_ps_surface_dsc_begin_page_setup(surface);
    }
    XSRETURN_EMPTY;
}

#endif
#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 6, 0)
#define XSubPPtmpAAAU 1


XS_EUPXS(XS_Cairo__PsSurface_restrict_to_level); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PsSurface_restrict_to_level)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "surface, level");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	cairo_ps_level_t	level = SvCairoPsLevel (ST(1))
;

	cairo_ps_surface_restrict_to_level(surface, level);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__PsSurface_get_levels); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PsSurface_get_levels)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "class=NULL");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 731 "CairoSurface.xs"
	cairo_ps_level_t const *levels = NULL;
	int num_levels = 0, i;
#line 1769 "CairoSurface.c"
#line 734 "CairoSurface.xs"
	PERL_UNUSED_VAR (ax);
	cairo_ps_get_levels (&levels, &num_levels);
	EXTEND (sp, num_levels);
	for (i = 0; i < num_levels; i++)
		PUSHs (sv_2mortal (newSVCairoPsLevel (levels[i])));
#line 1776 "CairoSurface.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Cairo__PsSurface_level_to_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PsSurface_level_to_string)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	const char *	RETVAL;
	dXSTARG;
#line 744 "CairoSurface.xs"
	if (items == 1) {
		RETVAL = cairo_ps_level_to_string (SvCairoPsLevel (ST (0)));
	} else if (items == 2) {
		RETVAL = cairo_ps_level_to_string (SvCairoPsLevel (ST (1)));
	} else {
		RETVAL = NULL;
		croak ("Usage: Cairo::PsSurface::level_to_string (level) or Cairo::PsSurface->level_to_string (level)");
	}
#line 1801 "CairoSurface.c"
	sv_setpv(TARG, RETVAL);
	XSprePUSH;
	PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__PsSurface_set_eps); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PsSurface_set_eps)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "surface, eps");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	cairo_bool_t	eps = (cairo_bool_t)SvUV(ST(1))
;

	cairo_ps_surface_set_eps(surface, eps);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__PsSurface_get_eps); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__PsSurface_get_eps)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	cairo_bool_t	RETVAL;
	dXSTARG;
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;

	RETVAL = cairo_ps_surface_get_eps(surface);
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}

#endif
#endif
#ifdef CAIRO_HAS_SVG_SURFACE
#define XSubPPtmpAAAV 1


XS_EUPXS(XS_Cairo__SvgSurface_create); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__SvgSurface_create)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "class, filename, width_in_points, height_in_points");
    {
	cairo_surface_t_noinc *	RETVAL;
	const char *	filename = (const char *)SvPV_nolen(ST(1))
;
	double	width_in_points = (double)SvNV(ST(2))
;
	double	height_in_points = (double)SvNV(ST(3))
;

	RETVAL = cairo_svg_surface_create(filename, width_in_points, height_in_points);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoSurface_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__SvgSurface_create_for_stream); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__SvgSurface_create_for_stream)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "class, func, data, width_in_points, height_in_points");
    {
#line 785 "CairoSurface.xs"
	CairoPerlCallback *callback;
#line 1889 "CairoSurface.c"
	cairo_surface_t_noinc *	RETVAL;
	SV *	func = ST(1)
;
	SV *	data = ST(2)
;
	double	width_in_points = (double)SvNV(ST(3))
;
	double	height_in_points = (double)SvNV(ST(4))
;
#line 787 "CairoSurface.xs"
	callback = cairo_perl_callback_new (func, data);
	RETVAL = cairo_svg_surface_create_for_stream (write_func_marshaller,
						      callback,
						      width_in_points,
						      height_in_points);
	cairo_surface_set_user_data (
		RETVAL, (const cairo_user_data_key_t *) &callback, callback,
		(cairo_destroy_func_t) cairo_perl_callback_free);
#line 1908 "CairoSurface.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoSurface_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__SvgSurface_restrict_to_version); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__SvgSurface_restrict_to_version)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "surface, version");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	cairo_svg_version_t	version = SvCairoSvgVersion (ST(1))
;

	cairo_svg_surface_restrict_to_version(surface, version);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__SvgSurface_get_versions); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__SvgSurface_get_versions)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "class=NULL");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 804 "CairoSurface.xs"
	cairo_svg_version_t const *versions = NULL;
	int num_versions = 0, i;
#line 1950 "CairoSurface.c"
#line 807 "CairoSurface.xs"
	PERL_UNUSED_VAR (ax);
	cairo_svg_get_versions (&versions, &num_versions);
	EXTEND (sp, num_versions);
	for (i = 0; i < num_versions; i++)
		PUSHs (sv_2mortal (newSVCairoSvgVersion (versions[i])));
#line 1957 "CairoSurface.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Cairo__SvgSurface_version_to_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__SvgSurface_version_to_string)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	const char *	RETVAL;
	dXSTARG;
#line 817 "CairoSurface.xs"
	if (items == 1) {
		RETVAL = cairo_svg_version_to_string (SvCairoSvgVersion (ST (0)));
	} else if (items == 2) {
		RETVAL = cairo_svg_version_to_string (SvCairoSvgVersion (ST (1)));
	} else {
		RETVAL = NULL;
		croak ("Usage: Cairo::SvgSurface::version_to_string (version) or Cairo::SvgSurface->version_to_string (version)");
	}
#line 1982 "CairoSurface.c"
	sv_setpv(TARG, RETVAL);
	XSprePUSH;
	PUSHTARG;
    }
    XSRETURN(1);
}

#endif
#ifdef CAIRO_HAS_RECORDING_SURFACE
#define XSubPPtmpAAAW 1


XS_EUPXS(XS_Cairo__RecordingSurface_create); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__RecordingSurface_create)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "class, content, extents");
    {
	cairo_surface_t_noinc *	RETVAL;
	cairo_content_t	content = SvCairoContent (ST(1))
;
	cairo_rectangle_t_ornull *	extents = SvCairoRectangle_ornull (ST(2))
;

	RETVAL = cairo_recording_surface_create(content, extents);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoSurface_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__RecordingSurface_ink_extents); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__RecordingSurface_ink_extents)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
	double	x0;
	double	y0;
	double	width;
	double	height;

	cairo_recording_surface_ink_extents(surface, &x0, &y0, &width, &height);
	XSprePUSH;	EXTEND(SP,4);
	PUSHs(sv_newmortal());
	sv_setnv(ST(0), (double)x0);
	PUSHs(sv_newmortal());
	sv_setnv(ST(1), (double)y0);
	PUSHs(sv_newmortal());
	sv_setnv(ST(2), (double)width);
	PUSHs(sv_newmortal());
	sv_setnv(ST(3), (double)height);
    }
    XSRETURN(4);
}

#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 12, 0)
#define XSubPPtmpAAAX 1


XS_EUPXS(XS_Cairo__RecordingSurface_get_extents); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__RecordingSurface_get_extents)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "surface");
    {
#line 856 "CairoSurface.xs"
	cairo_bool_t status;
	cairo_rectangle_t rect;
#line 2062 "CairoSurface.c"
	cairo_rectangle_t *	RETVAL;
	cairo_surface_t *	surface = SvCairoSurface (ST(0))
;
#line 859 "CairoSurface.xs"
	status = cairo_recording_surface_get_extents (surface, &rect);
	RETVAL = status ? &rect : NULL;
#line 2069 "CairoSurface.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVCairoRectangle (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif
#endif
#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 6, 0)
#define XSubPPtmpAAAY 1


XS_EUPXS(XS_Cairo__Format_stride_for_width); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Format_stride_for_width)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "format, width");
    {
	int	RETVAL;
	dXSTARG;
	cairo_format_t	format = SvCairoFormat (ST(0))
;
	int	width = (int)SvIV(ST(1))
;

	RETVAL = cairo_format_stride_for_width(format, width);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif
#ifdef __cplusplus
extern "C" {
#endif
XS_EXTERNAL(boot_Cairo__Surface); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Cairo__Surface)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("Cairo::Surface::DESTROY", XS_Cairo__Surface_DESTROY);
        newXS_deffile("Cairo::Surface::create_similar", XS_Cairo__Surface_create_similar);
        newXS_deffile("Cairo::Surface::finish", XS_Cairo__Surface_finish);
        newXS_deffile("Cairo::Surface::status", XS_Cairo__Surface_status);
        newXS_deffile("Cairo::Surface::set_device_offset", XS_Cairo__Surface_set_device_offset);
#if XSubPPtmpAAAA
        newXS_deffile("Cairo::Surface::get_device_offset", XS_Cairo__Surface_get_device_offset);
        newXS_deffile("Cairo::Surface::set_fallback_resolution", XS_Cairo__Surface_set_fallback_resolution);
#endif
#if XSubPPtmpAAAB
        newXS_deffile("Cairo::Surface::get_fallback_resolution", XS_Cairo__Surface_get_fallback_resolution);
#endif
        newXS_deffile("Cairo::Surface::get_font_options", XS_Cairo__Surface_get_font_options);
        newXS_deffile("Cairo::Surface::flush", XS_Cairo__Surface_flush);
        newXS_deffile("Cairo::Surface::mark_dirty", XS_Cairo__Surface_mark_dirty);
        newXS_deffile("Cairo::Surface::mark_dirty_rectangle", XS_Cairo__Surface_mark_dirty_rectangle);
#if XSubPPtmpAAAC
        newXS_deffile("Cairo::Surface::get_type", XS_Cairo__Surface_get_type);
        newXS_deffile("Cairo::Surface::get_content", XS_Cairo__Surface_get_content);
#endif
#if XSubPPtmpAAAD
        newXS_deffile("Cairo::Surface::set_mime_data", XS_Cairo__Surface_set_mime_data);
        newXS_deffile("Cairo::Surface::get_mime_data", XS_Cairo__Surface_get_mime_data);
#endif
#if XSubPPtmpAAAE
        newXS_deffile("Cairo::Surface::supports_mime_type", XS_Cairo__Surface_supports_mime_type);
#endif
#if XSubPPtmpAAAF
#endif
#if XSubPPtmpAAAG
#endif
#if XSubPPtmpAAAH
        newXS_deffile("Cairo::Surface::write_to_png", XS_Cairo__Surface_write_to_png);
        newXS_deffile("Cairo::Surface::write_to_png_stream", XS_Cairo__Surface_write_to_png_stream);
#endif
#if XSubPPtmpAAAI
        newXS_deffile("Cairo::Surface::copy_page", XS_Cairo__Surface_copy_page);
        newXS_deffile("Cairo::Surface::show_page", XS_Cairo__Surface_show_page);
#endif
#if XSubPPtmpAAAJ
        newXS_deffile("Cairo::Surface::has_show_text_glyphs", XS_Cairo__Surface_has_show_text_glyphs);
#endif
#if XSubPPtmpAAAK
        newXS_deffile("Cairo::Surface::create_for_rectangle", XS_Cairo__Surface_create_for_rectangle);
#endif
        newXS_deffile("Cairo::ImageSurface::create", XS_Cairo__ImageSurface_create);
        newXS_deffile("Cairo::ImageSurface::create_for_data", XS_Cairo__ImageSurface_create_for_data);
#if XSubPPtmpAAAL
        newXS_deffile("Cairo::ImageSurface::get_data", XS_Cairo__ImageSurface_get_data);
        newXS_deffile("Cairo::ImageSurface::get_format", XS_Cairo__ImageSurface_get_format);
#endif
        newXS_deffile("Cairo::ImageSurface::get_width", XS_Cairo__ImageSurface_get_width);
        newXS_deffile("Cairo::ImageSurface::get_height", XS_Cairo__ImageSurface_get_height);
#if XSubPPtmpAAAM
        newXS_deffile("Cairo::ImageSurface::get_stride", XS_Cairo__ImageSurface_get_stride);
#endif
#if XSubPPtmpAAAN
        newXS_deffile("Cairo::ImageSurface::create_from_png", XS_Cairo__ImageSurface_create_from_png);
        newXS_deffile("Cairo::ImageSurface::create_from_png_stream", XS_Cairo__ImageSurface_create_from_png_stream);
#endif
#if XSubPPtmpAAAO
        newXS_deffile("Cairo::PdfSurface::create", XS_Cairo__PdfSurface_create);
        newXS_deffile("Cairo::PdfSurface::create_for_stream", XS_Cairo__PdfSurface_create_for_stream);
#if XSubPPtmpAAAP
        newXS_deffile("Cairo::PdfSurface::set_size", XS_Cairo__PdfSurface_set_size);
#endif
#if XSubPPtmpAAAQ
        newXS_deffile("Cairo::PdfSurface::restrict_to_version", XS_Cairo__PdfSurface_restrict_to_version);
        newXS_deffile("Cairo::PdfSurface::get_versions", XS_Cairo__PdfSurface_get_versions);
        newXS_deffile("Cairo::PdfSurface::version_to_string", XS_Cairo__PdfSurface_version_to_string);
#endif
#if XSubPPtmpAAAR
        newXS_deffile("Cairo::PdfSurface::add_outline", XS_Cairo__PdfSurface_add_outline);
        newXS_deffile("Cairo::PdfSurface::set_metadata", XS_Cairo__PdfSurface_set_metadata);
        newXS_deffile("Cairo::PdfSurface::set_page_label", XS_Cairo__PdfSurface_set_page_label);
        newXS_deffile("Cairo::PdfSurface::set_thumbnail_size", XS_Cairo__PdfSurface_set_thumbnail_size);
#endif
#endif
#if XSubPPtmpAAAS
        newXS_deffile("Cairo::PsSurface::create", XS_Cairo__PsSurface_create);
        newXS_deffile("Cairo::PsSurface::create_for_stream", XS_Cairo__PsSurface_create_for_stream);
#if XSubPPtmpAAAT
        newXS_deffile("Cairo::PsSurface::set_size", XS_Cairo__PsSurface_set_size);
        newXS_deffile("Cairo::PsSurface::dsc_comment", XS_Cairo__PsSurface_dsc_comment);
        newXS_deffile("Cairo::PsSurface::dsc_begin_setup", XS_Cairo__PsSurface_dsc_begin_setup);
        newXS_deffile("Cairo::PsSurface::dsc_begin_page_setup", XS_Cairo__PsSurface_dsc_begin_page_setup);
#endif
#if XSubPPtmpAAAU
        newXS_deffile("Cairo::PsSurface::restrict_to_level", XS_Cairo__PsSurface_restrict_to_level);
        newXS_deffile("Cairo::PsSurface::get_levels", XS_Cairo__PsSurface_get_levels);
        newXS_deffile("Cairo::PsSurface::level_to_string", XS_Cairo__PsSurface_level_to_string);
        newXS_deffile("Cairo::PsSurface::set_eps", XS_Cairo__PsSurface_set_eps);
        newXS_deffile("Cairo::PsSurface::get_eps", XS_Cairo__PsSurface_get_eps);
#endif
#endif
#if XSubPPtmpAAAV
        newXS_deffile("Cairo::SvgSurface::create", XS_Cairo__SvgSurface_create);
        newXS_deffile("Cairo::SvgSurface::create_for_stream", XS_Cairo__SvgSurface_create_for_stream);
        newXS_deffile("Cairo::SvgSurface::restrict_to_version", XS_Cairo__SvgSurface_restrict_to_version);
        newXS_deffile("Cairo::SvgSurface::get_versions", XS_Cairo__SvgSurface_get_versions);
        newXS_deffile("Cairo::SvgSurface::version_to_string", XS_Cairo__SvgSurface_version_to_string);
#endif
#if XSubPPtmpAAAW
        newXS_deffile("Cairo::RecordingSurface::create", XS_Cairo__RecordingSurface_create);
        newXS_deffile("Cairo::RecordingSurface::ink_extents", XS_Cairo__RecordingSurface_ink_extents);
#if XSubPPtmpAAAX
        newXS_deffile("Cairo::RecordingSurface::get_extents", XS_Cairo__RecordingSurface_get_extents);
#endif
#endif
#if XSubPPtmpAAAY
        newXS_deffile("Cairo::Format::stride_for_width", XS_Cairo__Format_stride_for_width);
#endif

    /* Initialisation Section */

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#if XSubPPtmpAAAD
#line 413 "CairoSurface.xs"
    HV *stashsurface = gv_stashpv("Cairo::Surface", 0);
    newCONSTSUB (stashsurface, "MIME_TYPE_JP2",  newSVpv (CAIRO_MIME_TYPE_JP2,  0));
    newCONSTSUB (stashsurface, "MIME_TYPE_JPEG", newSVpv (CAIRO_MIME_TYPE_JPEG, 0));
    newCONSTSUB (stashsurface, "MIME_TYPE_PNG",  newSVpv (CAIRO_MIME_TYPE_PNG,  0));
    newCONSTSUB (stashsurface, "MIME_TYPE_URI",  newSVpv (CAIRO_MIME_TYPE_URI,  0));

#endif
#if XSubPPtmpAAAE
#line 426 "CairoSurface.xs"
    newCONSTSUB (stashsurface, "MIME_TYPE_UNIQUE_ID",  newSVpv (CAIRO_MIME_TYPE_UNIQUE_ID,  0));

#endif
#if XSubPPtmpAAAF
#line 433 "CairoSurface.xs"
    newCONSTSUB (stashsurface, "MIME_TYPE_JBIG2",            newSVpv (CAIRO_MIME_TYPE_JBIG2,            0));
    newCONSTSUB (stashsurface, "MIME_TYPE_JBIG2_GLOBAL",     newSVpv (CAIRO_MIME_TYPE_JBIG2_GLOBAL,     0));
    newCONSTSUB (stashsurface, "MIME_TYPE_JBIG2_GLOBAL_ID",  newSVpv (CAIRO_MIME_TYPE_JBIG2_GLOBAL_ID,  0));

#endif
#if XSubPPtmpAAAG
#line 442 "CairoSurface.xs"
    newCONSTSUB (stashsurface, "MIME_TYPE_CCITT_FAX",         newSVpv (CAIRO_MIME_TYPE_CCITT_FAX,          0));
    newCONSTSUB (stashsurface, "MIME_TYPE_CCITT_FAX_PARAMS",  newSVpv (CAIRO_MIME_TYPE_CCITT_FAX_PARAMS,   0));
    newCONSTSUB (stashsurface, "MIME_TYPE_EPS",               newSVpv (CAIRO_MIME_TYPE_EPS,                0));
    newCONSTSUB (stashsurface, "MIME_TYPE_EPS_PARAMS",        newSVpv (CAIRO_MIME_TYPE_EPS_PARAMS,         0));

#endif
#if XSubPPtmpAAAH
#endif
#if XSubPPtmpAAAI
#endif
#if XSubPPtmpAAAJ
#endif
#if XSubPPtmpAAAK
#endif
#line 498 "CairoSurface.xs"
	cairo_perl_set_isa ("Cairo::ImageSurface", "Cairo::Surface");

#if XSubPPtmpAAAL
#endif
#if XSubPPtmpAAAM
#endif
#if XSubPPtmpAAAN
#endif
#if XSubPPtmpAAAO
#line 584 "CairoSurface.xs"
	cairo_perl_set_isa ("Cairo::PdfSurface", "Cairo::Surface");

#if XSubPPtmpAAAP
#endif
#if XSubPPtmpAAAQ
#endif
#if XSubPPtmpAAAR
#line 660 "CairoSurface.xs"
    HV *stashpdfsurface = gv_stashpv("Cairo::PdfSurface", 0);
    newCONSTSUB(stashpdfsurface, "OUTLINE_ROOT", newSViv(CAIRO_PDF_OUTLINE_ROOT));

#endif
#endif
#if XSubPPtmpAAAS
#line 680 "CairoSurface.xs"
	cairo_perl_set_isa ("Cairo::PsSurface", "Cairo::Surface");

#if XSubPPtmpAAAT
#endif
#if XSubPPtmpAAAU
#endif
#endif
#if XSubPPtmpAAAV
#line 773 "CairoSurface.xs"
	cairo_perl_set_isa ("Cairo::SvgSurface", "Cairo::Surface");

#endif
#if XSubPPtmpAAAW
#line 840 "CairoSurface.xs"
	cairo_perl_set_isa ("Cairo::RecordingSurface", "Cairo::Surface");

#if XSubPPtmpAAAX
#endif
#endif
#if XSubPPtmpAAAY
#endif
#line 2341 "CairoSurface.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

#ifdef __cplusplus
}
#endif
