# frozen_string_literal: true

class DropWrongIndexOnVulnerabilityOccurrences < Gitlab::Database::Migration[2.1]
  disable_ddl_transaction!

  INDEX_NAME = 'tmp_idx_vulns_on_converted_uuid'

  def up
    # We do not want to drop this from Gitlab.com
    # because it was created correctly there
    return if Gitlab.com? && !Gitlab.dev_or_test_env?

    remove_concurrent_index_by_name(
      :vulnerability_occurrences,
      INDEX_NAME
    )
  end

  def down
    # no-op
  end
end
