---
stage: Secure
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# JSON injection

## Description

Check for JSON serialization/injection vulnerabilities.

## Remediation

JSON injection is an attack technique used to manipulate or compromise the logic of a JSON application or service. The injection of unintended JSON content and/or structures into an JSON message can alter the intend logic of the application. Further, JSON injection can cause the insertion of malicious content into the resulting message/document.

## Links

- [OWASP](https://owasp.org/Top10/A03_2021-Injection/)
- [CWE](CWE-929: OWASP Top Ten 2013 Category A1 - Injection)
