import Vue from 'vue';
import VueApollo from 'vue-apollo';
import { shallowMountExtended } from 'helpers/vue_test_utils_helper';
import createMockApollo from 'helpers/mock_apollo_helper';
import waitForPromises from 'helpers/wait_for_promises';
import App from '~/merge_request_dashboard/components/app.vue';
import MergeRequestsQuery from '~/merge_request_dashboard/components/merge_requests_query.vue';
import MergeRequest from '~/merge_request_dashboard/components/merge_request.vue';
import CollapsibleSection from '~/merge_request_dashboard/components/collapsible_section.vue';
import assigneeQuery from '~/merge_request_dashboard/queries/assignee.query.graphql';
import { createMockMergeRequest } from '../mock_data';

Vue.use(VueApollo);

describe('Merge requests app component', () => {
  let wrapper;
  let assigneeQueryMock;

  const findMergeRequests = () => wrapper.findAllComponents(MergeRequest);
  const findLoadMoreButton = () => wrapper.findByTestId('load-more');

  function createComponent(
    props = { query: 'reviewRequestedMergeRequests', variables: { state: 'opened' } },
  ) {
    assigneeQueryMock = jest.fn().mockResolvedValue({
      data: {
        currentUser: {
          id: 1,
          assignedMergeRequests: {
            count: 1,
            pageInfo: {
              hasNextPage: true,
              hasPreviousPage: false,
              startCursor: 'startCursor',
              endCursor: 'endCursor',
              __typename: 'PageInfo',
            },
            nodes: [createMockMergeRequest({ titleHtml: 'assignee' })],
          },
        },
      },
    });
    const apolloProvider = createMockApollo(
      [[assigneeQuery, assigneeQueryMock]],
      {},
      { typePolicies: { Query: { fields: { currentUser: { merge: false } } } } },
    );

    wrapper = shallowMountExtended(App, {
      apolloProvider,
      propsData: {
        lists: [
          {
            title: 'Assigned merge requests',
            query: 'assignedMergeRequests',
            variables: { state: 'opened' },
          },
        ],
        ...props,
      },
      stubs: {
        MergeRequestsQuery,
        CollapsibleSection,
      },
    });
  }

  it('renders list of merge requests', async () => {
    createComponent();

    await waitForPromises();

    expect(findMergeRequests()).toHaveLength(1);
  });

  it('renders load more button', async () => {
    createComponent();

    await waitForPromises();

    findLoadMoreButton().vm.$emit('click');

    await waitForPromises();

    expect(assigneeQueryMock).toHaveBeenCalledWith(
      expect.objectContaining({ afterCursor: 'endCursor' }),
    );
  });
});
