# OpenbaoClient::TotpCreateKeyRequest

## Properties

| Name | Type | Description | Notes |
| ---- | ---- | ----------- | ----- |
| **account_name** | **String** | The name of the account associated with the key. Required if generate is true. | [optional] |
| **algorithm** | **String** | The hashing algorithm used to generate the TOTP token. Options include SHA1, SHA256 and SHA512. | [optional][default to &#39;SHA1&#39;] |
| **digits** | **Integer** | The number of digits in the generated TOTP token. This value can either be 6 or 8. | [optional][default to 6] |
| **exported** | **Boolean** | Determines if a QR code and url are returned upon generating a key. Only used if generate is true. | [optional][default to true] |
| **generate** | **Boolean** | Determines if a key should be generated by OpenBao or if a key is being passed from another service. | [optional][default to false] |
| **issuer** | **String** | The name of the key&#39;s issuing organization. Required if generate is true. | [optional] |
| **key** | **String** | The shared master key used to generate a TOTP token. Only used if generate is false. | [optional] |
| **key_size** | **Integer** | Determines the size in bytes of the generated key. Only used if generate is true. | [optional][default to 20] |
| **period** | **Integer** | The length of time used to generate a counter for the TOTP token calculation. | [optional][default to 30] |
| **qr_size** | **Integer** | The pixel size of the generated square QR code. Only used if generate is true and exported is true. If this value is 0, a QR code will not be returned. | [optional][default to 200] |
| **skew** | **Integer** | The number of delay periods that are allowed when validating a TOTP token. This value can either be 0 or 1. Only used if generate is true. | [optional][default to 1] |
| **url** | **String** | A TOTP url string containing all of the parameters for key setup. Only used if generate is false. | [optional] |

## Example

```ruby
require 'openbao_client'

instance = OpenbaoClient::TotpCreateKeyRequest.new(
  account_name: null,
  algorithm: null,
  digits: null,
  exported: null,
  generate: null,
  issuer: null,
  key: null,
  key_size: null,
  period: null,
  qr_size: null,
  skew: null,
  url: null
)
```

