/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)__vTBL_sqrtf.c	1.3	06/01/31 SMI"

#pragma align 32 (__vlibm_TBL_sqrtf)

/*
 i = [0,255]
 TBL[2*i+0] = 1.0 / (*(double*)&(0x3ff0000000000000LL + (i << 44)));
 TBL[2*i+1] = sqrt(*(double*)&(0x3ff0000000000000LL + (i << 44)))/sqrt(2);
 TBL[512+2*i+0] = 1.0 / (*(double*)&(0x3ff0000000000000LL + (i << 44)));
 TBL[512+2*i+1] = sqrt(*(double*)&(0x3ff0000000000000LL + (i << 44)));
*/

const double __vlibm_TBL_sqrtf[] = {
 1.0000000000000000000, 0.7071067811865474617,
 0.9961089494163424263, 0.7084865030471646508,
 0.9922480620155038622, 0.7098635432250340882,
 0.9884169884169884401, 0.7112379172963151364,
 0.9846153846153846700, 0.7126096406869610878,
 0.9808429118773945854, 0.7139787286747413253,
 0.9770992366412213359, 0.7153451963912248468,
 0.9733840304182509451, 0.7167090588237321480,
 0.9696969696969697239, 0.7180703308172535770,
 0.9660377358490566113, 0.7194290270763336048,
 0.9624060150375939315, 0.7207851621669246756,
 0.9588014981273408344, 0.7221387505182088606,
 0.9552238805970149071, 0.7234898064243890925,
 0.9516728624535315539, 0.7248383440464502003,
 0.9481481481481481843, 0.7261843774138906360,
 0.9446494464944649172, 0.7275279204264260002,
 0.9411764705882352811, 0.7288689868556624818,
 0.9377289377289377281, 0.7302075903467450946,
 0.9343065693430656626, 0.7315437444199764938,
 0.9309090909090909083, 0.7328774624724109232,
 0.9275362318840579823, 0.7342087577794206288,
 0.9241877256317689859, 0.7355376434962387355,
 0.9208633093525180335, 0.7368641326594745911,
 0.9175627240143369168, 0.7381882381886073485,
 0.9142857142857142572, 0.7395099728874520162,
 0.9110320284697508431, 0.7408293494456060779,
 0.9078014184397162900, 0.7421463804398696906,
 0.9045936395759717197, 0.7434610783356448982,
 0.9014084507042253724, 0.7447734554883115310,
 0.8982456140350877360, 0.7460835241445826771,
 0.8951048951048951041, 0.7473912964438372830,
 0.8919860627177700341, 0.7486967844194336585,
 0.8888888888888888395, 0.7499999999999998890,
 0.8858131487889273625, 0.7513009550107067058,
 0.8827586206896551602, 0.7525996611745184861,
 0.8797250859106529042, 0.7538961301134260440,
 0.8767123287671232390, 0.7551903733496606597,
 0.8737201365187713398, 0.7564824023068876802,
 0.8707482993197278587, 0.7577722283113837998,
 0.8677966101694915002, 0.7590598625931948007,
 0.8648648648648649129, 0.7603453162872774174,
 0.8619528619528619151, 0.7616286004346212168,
 0.8590604026845637398, 0.7629097259833563793,
 0.8561872909698996503, 0.7641887037898427160,
 0.8533333333333333881, 0.7654655446197431434,
 0.8504983388704319136, 0.7667402591490810604,
 0.8476821192052980125, 0.7680128579652816256,
 0.8448844884488448947, 0.7692833515681981593,
 0.8421052631578946901, 0.7705517503711221128,
 0.8393442622950819665, 0.7718180647017791607,
 0.8366013071895425091, 0.7730823048033113043,
 0.8338762214983713728, 0.7743444808352416553,
 0.8311688311688312236, 0.7756046028744285614,
 0.8284789644012945375, 0.7768626809160033009,
 0.8258064516129032251, 0.7781187248742956752,
 0.8231511254019292512, 0.7793727445837452805,
 0.8205128205128204844, 0.7806247497997997886,
 0.8178913738019168989, 0.7818747501998001281,
 0.8152866242038216971, 0.7831227553838541189,
 0.8126984126984126977, 0.7843687748756957845,
 0.8101265822784810000, 0.7856128181235333408,
 0.8075709779179810477, 0.7868548945008857487,
 0.8050314465408805464, 0.7880950133074056119,
 0.8025078369905955800, 0.7893331837696929698,
 0.8000000000000000444, 0.7905694150420947697,
 0.7975077881619937470, 0.7918037162074953450,
 0.7950310559006210642, 0.7930360962780950151,
 0.7925696594427245056, 0.7942665641961771383,
 0.7901234567901234129, 0.7954951288348659499,
 0.7876923076923076916, 0.7967217989988725213,
 0.7852760736196319202, 0.7979465834252315037,
 0.7828746177370030646, 0.7991694907840263262,
 0.7804878048780488076, 0.8003905296791060664,
 0.7781155015197568359, 0.8016097086487912193,
 0.7757575757575757569, 0.8028270361665704735,
 0.7734138972809667667, 0.8040425206417879389,
 0.7710843373493976305, 0.8052561704203202719,
 0.7687687687687687621, 0.8064679937852462510,
 0.7664670658682635196, 0.8076779989575053609,
 0.7641791044776119479, 0.8088861940965489383,
 0.7619047619047618625, 0.8100925873009824363,
 0.7596439169139466152, 0.8112971866091980289,
 0.7573964497041419941, 0.8124999999999998890,
 0.7551622418879055942, 0.8137010353932209172,
 0.7529411764705882248, 0.8149003006503310331,
 0.7507331378299120228, 0.8160978035750371395,
 0.7485380116959063912, 0.8172935519138762039,
 0.7463556851311953233, 0.8184875533567996797,
 0.7441860465116278966, 0.8196798155377500450,
 0.7420289855072463858, 0.8208703460352310133,
 0.7398843930635837784, 0.8220591523728690841,
 0.7377521613832852543, 0.8232462420199680997,
 0.7356321839080459668, 0.8244316223920574727,
 0.7335243553008595763, 0.8256153008514316438,
 0.7314285714285714279, 0.8267972847076845433,
 0.7293447293447293811, 0.8279775812182355033,
 0.7272727272727272929, 0.8291561975888499525,
 0.7252124645892351618, 0.8303331409741513403,
 0.7231638418079096020, 0.8315084184781292853,
 0.7211267605633803202, 0.8326820371546392874,
 0.7191011235955055980, 0.8338540040078957771,
 0.7170868347338935633, 0.8350243259929617246,
 0.7150837988826815872, 0.8361930100162282553,
 0.7130919220055710328, 0.8373600629358912695,
 0.7111111111111111382, 0.8385254915624210659,
 0.7091412742382271484, 0.8396893026590250830,
 0.7071823204419889208, 0.8408515029421067544,
 0.7052341597796143446, 0.8420120990817173690,
 0.7032967032967033516, 0.8431710977020024922,
 0.7013698630136986356, 0.8443285053816433905,
 0.6994535519125683054, 0.8454843286542926828,
 0.6975476839237056970, 0.8466385740090041079,
 0.6956521739130434590, 0.8477912478906584060,
 0.6937669376693766932, 0.8489423567003827609,
 0.6918918918918919303, 0.8500919067959651354,
 0.6900269541778976112, 0.8512399044922647207,
 0.6881720430107527431, 0.8523863560616159463,
 0.6863270777479892892, 0.8535312677342289378,
 0.6844919786096256287, 0.8546746456985838680,
 0.6826666666666666439, 0.8558164961018219774,
 0.6808510638297872175, 0.8569568250501304885,
 0.6790450928381962514, 0.8580956386091237453,
 0.6772486772486772111, 0.8592329428042199124,
 0.6754617414248020868, 0.8603687436210126771,
 0.6736842105263157743, 0.8615030470056387335,
 0.6719160104986876547, 0.8626358588651412695,
 0.6701570680628272658, 0.8637671850678283469,
 0.6684073107049608442, 0.8648970314436278395,
 0.6666666666666666297, 0.8660254037844384856,
 0.6649350649350649345, 0.8671523078444753896,
 0.6632124352331606465, 0.8682777493406126368,
 0.6614987080103359451, 0.8694017339527221333,
 0.6597938144329896781, 0.8705242673240073392,
 0.6580976863753212891, 0.8716453550613345591,
 0.6564102564102564097, 0.8727650027355586815,
 0.6547314578005115626, 0.8738832158818476969,
 0.6530612244897958663, 0.8749999999999998890,
 0.6513994910941476313, 0.8761153605547615797,
 0.6497461928934009645, 0.8772293029761374372,
 0.6481012658227848222, 0.8783418326596996728,
 0.6464646464646465196, 0.8794529549668930191,
 0.6448362720403022497, 0.8805626752253356004,
 0.6432160804020100597, 0.8816709987291176942,
 0.6416040100250626210, 0.8827779307390958285,
 0.6400000000000000133, 0.8838834764831843271,
 0.6384039900249376398, 0.8849876411566435230,
 0.6368159203980099381, 0.8860904299223640868,
 0.6352357320099255578, 0.8871918479111493561,
 0.6336633663366336711, 0.8882919002219933358,
 0.6320987654320987525, 0.8893905919223566992,
 0.6305418719211822731, 0.8904879280484380155,
 0.6289926289926289771, 0.8915839136054440894,
 0.6274509803921568540, 0.8926785535678561923,
 0.6259168704156479190, 0.8937718528796931849,
 0.6243902439024390238, 0.8948638164547719764,
 0.6228710462287104788, 0.8959544491769656505,
 0.6213592233009708199, 0.8970437559004575956,
 0.6198547215496368334, 0.8981317414499945251,
 0.6183574879227052845, 0.8992184106211348338,
 0.6168674698795181266, 0.9003037681804957337,
 0.6153846153846154188, 0.9013878188659971702,
 0.6139088729016786150, 0.9024705673871031841,
 0.6124401913875597847, 0.9035520184250599440,
 0.6109785202863962095, 0.9046321766331330005,
 0.6095238095238095788, 0.9057110466368397672,
 0.6080760095011876754, 0.9067886330341817791,
 0.6066350710900474397, 0.9078649403958718445,
 0.6052009456264775267, 0.9089399732655616404,
 0.6037735849056603543, 0.9100137361600647568,
 0.6023529411764705355, 0.9110862335695781855,
 0.6009389671361502483, 0.9121574699579014789,
 0.5995316159250585475, 0.9132274497626535759,
 0.5981308411214952825, 0.9142961773954870752,
 0.5967365967365967361, 0.9153636572423006212,
 0.5953488372093023173, 0.9164298936634486248,
 0.5939675174013920866, 0.9174948909939498742,
 0.5925925925925925597, 0.9185586535436917055,
 0.5912240184757505679, 0.9196211855976350602,
 0.5898617511520737322, 0.9206824914160146589,
 0.5885057471264367734, 0.9217425752345390633,
 0.5871559633027523262, 0.9228014412645875186,
 0.5858123569794050356, 0.9238590936934051312,
 0.5844748858447488260, 0.9249155366842962689,
 0.5831435079726651205, 0.9259707743768158528,
 0.5818181818181817899, 0.9270248108869577619,
 0.5804988662131519428, 0.9280776503073435713,
 0.5791855203619910020, 0.9291292967074065157,
 0.5778781038374717349, 0.9301797541335758979,
 0.5765765765765765716, 0.9312290266094586100,
 0.5752808988764045450, 0.9322771181360186565,
 0.5739910313901345207, 0.9333240326917547902,
 0.5727069351230424932, 0.9343697742328782585,
 0.5714285714285713969, 0.9354143466934853324,
 0.5701559020044543180, 0.9364577539857310562,
 0.5688888888888888884, 0.9375000000000000000,
 0.5676274944567627490, 0.9385410886050753465,
 0.5663716814159291957, 0.9395810236483067568,
 0.5651214128035320083, 0.9406198089557756825,
 0.5638766519823789070, 0.9416574483324601230,
 0.5626373626373626369, 0.9426939455623971620,
 0.5614035087719297934, 0.9437293044088436167,
 0.5601750547045951656, 0.9447635286144357991,
 0.5589519650655021543, 0.9457966219013471676,
 0.5577342047930283764, 0.9468285879714447573,
 0.5565217391304347894, 0.9478594305064437231,
 0.5553145336225596695, 0.9488891531680609948,
 0.5541125541125541121, 0.9499177595981663780,
 0.5529157667386609409, 0.9509452534189335449,
 0.5517241379310344751, 0.9519716382329884707,
 0.5505376344086021501, 0.9529969176235565387,
 0.5493562231759656633, 0.9540210951546090890,
 0.5481798715203426431, 0.9550441743710077480,
 0.5470085470085470636, 0.9560661587986472032,
 0.5458422174840085184, 0.9570870519445969782,
 0.5446808510638297962, 0.9581068572972432085,
 0.5435244161358810944, 0.9591255783264254209,
 0.5423728813559322015, 0.9601432184835759776,
 0.5412262156448203188, 0.9611597812018561893,
 0.5400843881856539630, 0.9621752698962906525,
 0.5389473684210526194, 0.9631896879639025855,
 0.5378151260504201447, 0.9642030387838443906,
 0.5366876310272536976, 0.9652153257175312140,
 0.5355648535564853097, 0.9662265521087691766,
 0.5344467640918579843, 0.9672367212838850481,
 0.5333333333333333259, 0.9682458365518541443,
 0.5322245322245322541, 0.9692539012044263380,
 0.5311203319502074693, 0.9702609185162514027,
 0.5300207039337474502, 0.9712668917450032469,
 0.5289256198347107585, 0.9722718241315028154,
 0.5278350515463917647, 0.9732757188998396591,
 0.5267489711934156826, 0.9742785792574933934,
 0.5256673511293634693, 0.9752804083954520475,
 0.5245901639344262568, 0.9762812094883317471,
 0.5235173824130879838, 0.9772809856944930651,
 0.5224489795918367818, 0.9782797401561579287,
 0.5213849287169042279, 0.9792774759995248601,
 0.5203252032520325754, 0.9802741963348825527,
 0.5192697768762677413, 0.9812699042567237795,
 0.5182186234817813819, 0.9822646028438568599,
 0.5171717171717171713, 0.9832582951595170151,
 0.5161290322580645018, 0.9842509842514762797,
 0.5150905432595573874, 0.9852426731521528591,
 0.5140562248995983463, 0.9862333648787187101,
 0.5130260521042083743, 0.9872230624332070104,
 0.5120000000000000107, 0.9882117688026185176,
 0.5109780439121756057, 0.9891994869590258199,
 0.5099601593625497920, 0.9901862198596785847,
 0.5089463220675943811, 0.9911719704471065873,
 0.5079365079365079083, 0.9921567416492214075,
 0.5069306930693069368, 0.9931405363794189034,
 0.5059288537549406772, 0.9941233575366791309,
 0.5049309664694280331, 0.9951052080056659310,
 0.5039370078740157410, 0.9960860906568265172,
 0.5029469548133594925, 0.9970660083464885082,
 0.5019607843137254832, 0.9980449639169568510,
 0.5009784735812132794, 0.9990229601966111872,
 1.0000000000000000000, 1.0000000000000000000,
 0.9961089494163424263, 1.0019512213675874079,
 0.9922480620155038622, 1.0038986502630631303,
 0.9884169884169884401, 1.0058423087144425789,
 0.9846153846153846700, 1.0077822185373186414,
 0.9808429118773945854, 1.0097184013377193956,
 0.9770992366412213359, 1.0116508785149154193,
 0.9733840304182509451, 1.0135796712641784723,
 0.9696969696969697239, 1.0155048005794951038,
 0.9660377358490566113, 1.0174262872562316318,
 0.9624060150375939315, 1.0193441518937556012,
 0.9588014981273408344, 1.0212584148980119458,
 0.9552238805970149071, 1.0231690964840562952,
 0.9516728624535315539, 1.0250762166785454266,
 0.9481481481481481843, 1.0269797953221864173,
 0.9446494464944649172, 1.0288798520721456065,
 0.9411764705882352811, 1.0307764064044151464,
 0.9377289377289377281, 1.0326694776161440270,
 0.9343065693430656626, 1.0345590848279280216,
 0.9309090909090909083, 1.0364452469860625516,
 0.9275362318840579823, 1.0383279828647593579,
 0.9241877256317689859, 1.0402073110683274226,
 0.9208633093525180335, 1.0420832500333165882,
 0.9175627240143369168, 1.0439558180306292012,
 0.9142857142857142572, 1.0458250331675944533,
 0.9110320284697508431, 1.0476909133900131899,
 0.9078014184397162900, 1.0495534764841665254,
 0.9045936395759717197, 1.0514127400787951494,
 0.9014084507042253724, 1.0532687216470448810,
 0.8982456140350877360, 1.0551214385083833580,
 0.8951048951048951041, 1.0569709078304851957,
 0.8919860627177700341, 1.0588171466310885016,
 0.8888888888888888395, 1.0606601717798211926,
 0.8858131487889273625, 1.0625000000000000000,
 0.8827586206896551602, 1.0643366478704001654,
 0.8797250859106529042, 1.0661701318269987127,
 0.8767123287671232390, 1.0680004681646912967,
 0.8737201365187713398, 1.0698276730389806310,
 0.8707482993197278587, 1.0716517624676404896,
 0.8677966101694915002, 1.0734727523323541742,
 0.8648648648648649129, 1.0752906583803283347,
 0.8619528619528619151, 1.0771054962258803656,
 0.8590604026845637398, 1.0789172813520042649,
 0.8561872909698996503, 1.0807260291119114015,
 0.8533333333333333881, 1.0825317547305484123,
 0.8504983388704319136, 1.0843344733060920060,
 0.8476821192052980125, 1.0861341998114228957,
 0.8448844884488448947, 1.0879309490955757500,
 0.8421052631578946901, 1.0897247358851684940,
 0.8393442622950819665, 1.0915155747858111823,
 0.8366013071895425091, 1.0933034802834937782,
 0.8338762214983713728, 1.0950884667459519495,
 0.8311688311688312236, 1.0968705484240153236,
 0.8284789644012945375, 1.0986497394529342042,
 0.8258064516129032251, 1.1004260538536880798,
 0.8231511254019292512, 1.1021995055342748149,
 0.8205128205128204844, 1.1039701082909809671,
 0.8178913738019168989, 1.1057378758096332305,
 0.8152866242038216971, 1.1075028216668343362,
 0.8126984126984126977, 1.1092649593311780798,
 0.8101265822784810000, 1.1110243021644485850,
 0.8075709779179810477, 1.1127808634228035789,
 0.8050314465408805464, 1.1145346562579379057,
 0.8025078369905955800, 1.1162856937182343842,
 0.8000000000000000444, 1.1180339887498949025,
 0.7975077881619937470, 1.1197795541980573031,
 0.7950310559006210642, 1.1215224028078976115,
 0.7925696594427245056, 1.1232625472257142807,
 0.7901234567901234129, 1.1250000000000000000,
 0.7876923076923076916, 1.1267347735824966293,
 0.7852760736196319202, 1.1284668803292368100,
 0.7828746177370030646, 1.1301963325015702555,
 0.7804878048780488076, 1.1319231422671771625,
 0.7781155015197568359, 1.1336473217010658576,
 0.7757575757575757569, 1.1353688827865593414,
 0.7734138972809667667, 1.1370878374162658453,
 0.7710843373493976305, 1.1388041973930373985,
 0.7687687687687687621, 1.1405179744309161816,
 0.7664670658682635196, 1.1422291801560666702,
 0.7641791044776119479, 1.1439378261076953436,
 0.7619047619047618625, 1.1456439237389599572,
 0.7596439169139466152, 1.1473474844178637166,
 0.7573964497041419941, 1.1490485194281396808,
 0.7551622418879055942, 1.1507470399701229535,
 0.7529411764705882248, 1.1524430571616108843,
 0.7507331378299120228, 1.1541365820387117225,
 0.7485380116959063912, 1.1558276255566830582,
 0.7463556851311953233, 1.1575161985907584938,
 0.7441860465116278966, 1.1592023119369629924,
 0.7420289855072463858, 1.1608859763129193432,
 0.7398843930635837784, 1.1625672023586421933,
 0.7377521613832852543, 1.1642460006373223091,
 0.7356321839080459668, 1.1659223816361019566,
 0.7335243553008595763, 1.1675963557668378456,
 0.7314285714285714279, 1.1692679333668567487,
 0.7293447293447293811, 1.1709371246996995719,
 0.7272727272727272929, 1.1726039399558574328,
 0.7252124645892351618, 1.1742683892534959700,
 0.7231638418079096020, 1.1759304826391736576,
 0.7211267605633803202, 1.1775902300885483509,
 0.7191011235955055980, 1.1792476415070753948,
 0.7170868347338935633, 1.1809027267306990705,
 0.7150837988826815872, 1.1825554955265313861,
 0.7130919220055710328, 1.1842059575935259819,
 0.7111111111111111382, 1.1858541225631422655,
 0.7091412742382271484, 1.1875000000000000000,
 0.7071823204419889208, 1.1891435994025278955,
 0.7052341597796143446, 1.1907849302036030981,
 0.7032967032967033516, 1.1924240017711820183,
 0.7013698630136986356, 1.1940608234089249429,
 0.6994535519125683054, 1.1956954043568119861,
 0.6975476839237056970, 1.1973277537917510482,
 0.6956521739130434590, 1.1989578808281797784,
 0.6937669376693766932, 1.2005857945186590996,
 0.6918918918918919303, 1.2022115038544589627,
 0.6900269541778976112, 1.2038350177661389928,
 0.6881720430107527431, 1.2054563451241193661,
 0.6863270777479892892, 1.2070754947392479117,
 0.6844919786096256287, 1.2086924753633572216,
 0.6826666666666666439, 1.2103072956898177637,
 0.6808510638297872175, 1.2119199643540823352,
 0.6790450928381962514, 1.2135304899342249652,
 0.6772486772486772111, 1.2151388809514738210,
 0.6754617414248020868, 1.2167451458707365664,
 0.6736842105263157743, 1.2183492931011203897,
 0.6719160104986876547, 1.2199513309964460372,
 0.6701570680628272658, 1.2215512678557540749,
 0.6684073107049608442, 1.2231491119238078191,
 0.6666666666666666297, 1.2247448713915889407,
 0.6649350649350649345, 1.2263385543967864066,
 0.6632124352331606465, 1.2279301690242812040,
 0.6614987080103359451, 1.2295197233066250675,
 0.6597938144329896781, 1.2311072252245129910,
 0.6580976863753212891, 1.2326926827072512971,
 0.6564102564102564097, 1.2342761036332186020,
 0.6547314578005115626, 1.2358574958303243374,
 0.6530612244897958663, 1.2374368670764581690,
 0.6513994910941476313, 1.2390142250999380824,
 0.6497461928934009645, 1.2405895775799504754,
 0.6481012658227848222, 1.2421629321469869200,
 0.6464646464646465196, 1.2437342963832749287,
 0.6448362720403022497, 1.2453036778232047244,
 0.6432160804020100597, 1.2468710839537502366,
 0.6416040100250626210, 1.2484365222148861019,
 0.6400000000000000133, 1.2500000000000000000,
 0.6384039900249376398, 1.2515615246562992180,
 0.6368159203980099381, 1.2531211034852138830,
 0.6352357320099255578, 1.2546787437427957546,
 0.6336633663366336711, 1.2562344526401112432,
 0.6320987654320987525, 1.2577882373436317653,
 0.6305418719211822731, 1.2593401049756178800,
 0.6289926289926289771, 1.2608900626145009838,
 0.6274509803921568540, 1.2624381172952596764,
 0.6259168704156479190, 1.2639842760097927954,
 0.6243902439024390238, 1.2655285457072866784,
 0.6228710462287104788, 1.2670709332945808701,
 0.6213592233009708199, 1.2686114456365273906,
 0.6198547215496368334, 1.2701500895563484494,
 0.6183574879227052845, 1.2716868718359877199,
 0.6168674698795181266, 1.2732217992164600595,
 0.6153846153846154188, 1.2747548783981961229,
 0.6139088729016786150, 1.2762861160413836448,
 0.6124401913875597847, 1.2778155187663045034,
 0.6109785202863962095, 1.2793430931536700079,
 0.6095238095238095788, 1.2808688457449497466,
 0.6080760095011876754, 1.2823927830426995467,
 0.6066350710900474397, 1.2839149115108836607,
 0.6052009456264775267, 1.2854352375751958437,
 0.6037735849056603543, 1.2869537676233751000,
 0.6023529411764705355, 1.2884705080055189885,
 0.6009389671361502483, 1.2899854650343933749,
 0.5995316159250585475, 1.2914986449857390749,
 0.5981308411214952825, 1.2930100540985751678,
 0.5967365967365967361, 1.2945196985754987562,
 0.5953488372093023173, 1.2960275845829825059,
 0.5939675174013920866, 1.2975337182516684109,
 0.5925925925925925597, 1.2990381056766580059,
 0.5912240184757505679, 1.3005407529178008019,
 0.5898617511520737322, 1.3020416659999787257,
 0.5885057471264367734, 1.3035408509133881161,
 0.5871559633027523262, 1.3050383136138188345,
 0.5858123569794050356, 1.3065340600229295998,
 0.5844748858447488260, 1.3080280960285217695,
 0.5831435079726651205, 1.3095204274848102344,
 0.5818181818181817899, 1.3110110602126894275,
 0.5804988662131519428, 1.3125000000000000000,
 0.5791855203619910020, 1.3139872526017899457,
 0.5778781038374717349, 1.3154728237405741709,
 0.5765765765765765716, 1.3169567191065922884,
 0.5752808988764045450, 1.3184389443580617485,
 0.5739910313901345207, 1.3199195051214296370,
 0.5727069351230424932, 1.3213984069916233643,
 0.5714285714285713969, 1.3228756555322953581,
 0.5701559020044543180, 1.3243512562760682005,
 0.5688888888888888884, 1.3258252147247766572,
 0.5676274944567627490, 1.3272975363497063750,
 0.5663716814159291957, 1.3287682265918312474,
 0.5651214128035320083, 1.3302372908620476721,
 0.5638766519823789070, 1.3317047345414072534,
 0.5626373626373626369, 1.3331705629813463965,
 0.5614035087719297934, 1.3346347815039139029,
 0.5601750547045951656, 1.3360973954019967902,
 0.5589519650655021543, 1.3375584099395434468,
 0.5577342047930283764, 1.3390178303517843439,
 0.5565217391304347894, 1.3404756618454509720,
 0.5553145336225596695, 1.3419319095989930002,
 0.5541125541125541121, 1.3433865787627923272,
 0.5529157667386609409, 1.3448396744593758001,
 0.5517241379310344751, 1.3462912017836259349,
 0.5505376344086021501, 1.3477411658029889718,
 0.5493562231759656633, 1.3491895715576813775,
 0.5481798715203426431, 1.3506364240608943472,
 0.5470085470085470636, 1.3520817282989960884,
 0.5458422174840085184, 1.3535254892317321040,
 0.5446808510638297962, 1.3549677117924250336,
 0.5435244161358810944, 1.3564084008881691634,
 0.5423728813559322015, 1.3578475614000269367,
 0.5412262156448203188, 1.3592851981832216879,
 0.5400843881856539630, 1.3607213160673274910,
 0.5389473684210526194, 1.3621559198564605619,
 0.5378151260504201447, 1.3635890143294642218,
 0.5366876310272536976, 1.3650206042400971906,
 0.5355648535564853097, 1.3664506943172154418,
 0.5344467640918579843, 1.3678792892649556112,
 0.5333333333333333259, 1.3693063937629152971,
 0.5322245322245322541, 1.3707320124663318062,
 0.5311203319502074693, 1.3721561500062593453,
 0.5300207039337474502, 1.3735788109897444365,
 0.5289256198347107585, 1.3750000000000000000,
 0.5278350515463917647, 1.3764197215965774390,
 0.5267489711934156826, 1.3778379803155376138,
 0.5256673511293634693, 1.3792547806696193735,
 0.5245901639344262568, 1.3806701271484076443,
 0.5235173824130879838, 1.3820840242184988522,
 0.5224489795918367818, 1.3834964763236659024,
 0.5213849287169042279, 1.3849074878850211601,
 0.5203252032520325754, 1.3863170633011772104,
 0.5192697768762677413, 1.3877252069484073971,
 0.5182186234817813819, 1.3891319231808043622,
 0.5171717171717171713, 1.3905372163304368094,
 0.5161290322580645018, 1.3919410907075053796,
 0.5150905432595573874, 1.3933435506004971938,
 0.5140562248995983463, 1.3947446002763372874,
 0.5130260521042083743, 1.3961442439805422655,
 0.5120000000000000107, 1.3975424859373686282,
 0.5109780439121756057, 1.3989393303499619847,
 0.5099601593625497920, 1.4003347814005049354,
 0.5089463220675943811, 1.4017288432503627327,
 0.5079365079365079083, 1.4031215200402280541,
 0.5069306930693069368, 1.4045128158902644433,
 0.5059288537549406772, 1.4059027349002490848,
 0.5049309664694280331, 1.4072912811497126917,
 0.5039370078740157410, 1.4086784586980805045,
 0.5029469548133594925, 1.4100642715848097364,
 0.5019607843137254832, 1.4114487238295267968,
 0.5009784735812132794, 1.4128318194321642931,
};

