/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)mlib_ImageFilters.c	9.2	07/11/05"

/*
 * Tables mlib_filters_u8f_bc and mlib_filters_u8f_bc2
 *
 *  DESCRIPTION
 *  mlib_filters_u8f_bc[4*i+0] = (float)((-0.5*dx^3+    dx^2-0.5*dx)*PREC);
 *  mlib_filters_u8f_bc[4*i+1] = (float)(( 1.5*dx^3-2.5*dx^2+1.0   )*PREC);
 *  mlib_filters_u8f_bc[4*i+2] = (float)((-1.5*dx^3+2.0*dx^2+0.5*dx)*PREC);
 *  mlib_filters_u8f_bc[4*i+3] = (float)(( 0.5*dx^3-0.5*dx^2       )*PREC);
 *
 *  mlib_filters_u8f_bc2[4*i+0] = (float)((-dx^3+2.0*dx^2-dx )*PREC);
 *  mlib_filters_u8f_bc2[4*i+1] = (float)(( dx^3-2.0*dx^2+1.0)*PREC);
 *  mlib_filters_u8f_bc2[4*i+2] = (float)((-dx^3+    dx^2+dx )*PREC);
 *  mlib_filters_u8f_bc2[4*i+3] = (float)(( dx^3-    dx^2    )*PREC);
 *
 *  Where
 *    PREC = ((double)(1 << 12))
 *    dx = (double)i/256 + 1./512.; i = 0, 1, ..., 255;
 *
 *  Tables mlib_filters_s16f_bc and mlib_filters_s16f_bc2
 *
 *  DESCRIPTION
 *  mlib_filters_s16f_bc[4*i+0] = (float) ((-0.5*dx^3+    dx^2-0.5*dx)*PREC);
 *  mlib_filters_s16f_bc[4*i+1] = (float) (( 1.5*dx^3-2.5*dx^2+1.0   )*PREC);
 *  mlib_filters_s16f_bc[4*i+2] = (float) ((-1.5*dx^3+2.0*dx^2+0.5*dx)*PREC);
 *  mlib_filters_s16f_bc[4*i+3] = (float) (( 0.5*dx^3-0.5*dx^2       )*PREC);
 *
 *  mlib_filters_s16f_bc2[4*i+0] = (float) ((-dx^3+2.0*dx^2-dx )*PREC);
 *  mlib_filters_s16f_bc2[4*i+1] = (float) (( dx^3-2.0*dx^2+1.0)*PREC);
 *  mlib_filters_s16f_bc2[4*i+2] = (float) ((-dx^3+    dx^2+dx )*PREC);
 *  mlib_filters_s16f_bc2[4*i+3] = (float) (( dx^3-    dx^2    )*PREC);
 *
 *  Where
 *    PREC = ((double)(1 << 8))
 *    dx = (double)i/512 + 1./1024.; i = 0, 1, ..., 511;
 *
 *  Tables mlib_filters_u8_bc and mlib_filters_u8_bc2
 *
 *  DESCRIPTION
 *  mlib_filters_u8_bc[4*i+0] = (short) ((-0.5*dx^3+    dx^2-0.5*dx)*PREC-0.5);
 *  mlib_filters_u8_bc[4*i+1] = (short) (( 1.5*dx^3-2.5*dx^2+1.0   )*PREC+0.5);
 *  mlib_filters_u8_bc[4*i+2] = (short) ((-1.5*dx^3+2.0*dx^2+0.5*dx)*PREC+0.5);
 *  mlib_filters_u8_bc[4*i+3] = (short) (( 0.5*dx^3-0.5*dx^2       )*PREC-0.5);
 *
 *  mlib_filters_u8_bc2[4*i+0] = (short) ((-dx^3+2.0*dx^2-dx )*PREC-0.5);
 *  mlib_filters_u8_bc2[4*i+1] = (short) (( dx^3-2.0*dx^2+1.0)*PREC+0.5);
 *  mlib_filters_u8_bc2[4*i+2] = (short) ((-dx^3+    dx^2+dx )*PREC+0.5);
 *  mlib_filters_u8_bc2[4*i+3] = (short) (( dx^3-    dx^2    )*PREC-0.5);
 *
 *  Where
 *    PREC = ((double) (1 << 14));
 *    dx = (double)i/256 + 1./512.; i = 0, 1, ..., 255;
 *
 *  Tables mlib_filters_s16_bc and mlib_filters_s16_bc2
 *
 *  DESCRIPTION
 *  mlib_filters_s16_bc[4*i+0] = (short) ((-0.5*dx^3+    dx^2-0.5*dx)*PREC-0.5);
 *  mlib_filters_s16_bc[4*i+1] = (short) (( 1.5*dx^3-2.5*dx^2+1.0   )*PREC+0.5);
 *  mlib_filters_s16_bc[4*i+2] = (short) ((-1.5*dx^3+2.0*dx^2+0.5*dx)*PREC+0.5);
 *  mlib_filters_s16_bc[4*i+3] = (short) (( 0.5*dx^3-0.5*dx^2       )*PREC-0.5);
 *
 *  mlib_filters_s16_bc2[4*i+0] = (short) ((-dx^3+2.0*dx^2-dx )*PREC-0.5);
 *  mlib_filters_s16_bc2[4*i+1] = (short) (( dx^3-2.0*dx^2+1.0)*PREC+0.5);
 *  mlib_filters_s16_bc2[4*i+2] = (short) ((-dx^3+    dx^2+dx )*PREC+0.5);
 *  mlib_filters_s16_bc2[4*i+3] = (short) (( dx^3-    dx^2    )*PREC-0.5);
 *
 *  Where
 *    PREC = ((double) (1 << 15));
 *    dx = (double)i/512 + 1./1024.; i = 0, 1, ..., 511;
 *    All 32768 are replace to 32767
 *
 *  COMMENTS
 *    These tables are used by C and VIS versions of the following functions:
 *      mlib_ImageRotate(Index)
 *      mlib_ImageAffine(Index)
 *      mlib_ImageZoom(Index)
 *      mlib_ImageGridWarp
 *      mlib_ImagePolynomialWarp
 *
 */

#include <mlib_image.h>
#include <mlib_ImageFilters.h>

/* *********************************************************** */

const mlib_f32 mlib_filters_u8f_bc[] = {
	-3.9843902588f, 4095.9609832764f, 4.0312042236f, -0.0077972412f,
	-11.8597869873f, 4095.6496734619f, 12.2800140381f, -0.0699005127f,
	-19.6112823486f, 4095.0291595459f, 20.7755279541f, -0.1934051514f,
	-27.2396087646f, 4094.1016387939f, 29.5155487061f, -0.3775787354f,
	-34.7454986572f, 4092.8693084717f, 38.4978790283f, -0.6216888428f,
	-42.1296844482f, 4091.3343658447f, 47.7203216553f, -0.9250030518f,
	-49.3928985596f, 4089.4990081787f, 57.1806793213f, -1.2867889404f,
	-56.5358734131f, 4087.3654327393f, 66.8767547607f, -1.7063140869f,
	-63.5593414307f, 4084.9358367920f, 76.8063507080f, -2.1828460693f,
	-70.4640350342f, 4082.2124176025f, 86.9672698975f, -2.7156524658f,
	-77.2506866455f, 4079.1973724365f, 97.3573150635f, -3.3040008545f,
	-83.9200286865f, 4075.8928985596f, 107.9742889404f, -3.9471588135f,
	-90.4727935791f, 4072.3011932373f, 118.8159942627f, -4.6443939209f,
	-96.9097137451f, 4068.4244537354f, 129.8802337646f, -5.3949737549f,
	-103.2315216064f, 4064.2648773193f, 141.1648101807f, -6.1981658936f,
	-109.4389495850f, 4059.8246612549f, 152.6675262451f, -7.0532379150f,
	-115.5327301025f, 4055.1060028076f, 164.3861846924f, -7.9594573975f,
	-121.5135955811f, 4050.1110992432f, 176.3185882568f, -8.9160919189f,
	-127.3822784424f, 4044.8421478271f, 188.4625396729f, -9.9224090576f,
	-133.1395111084f, 4039.3013458252f, 200.8158416748f, -10.9776763916f,
	-138.7860260010f, 4033.4908905029f, 213.3762969971f, -12.0811614990f,
	-144.3225555420f, 4027.4129791260f, 226.1417083740f, -13.2321319580f,
	-149.7498321533f, 4021.0698089600f, 239.1098785400f, -14.4298553467f,
	-155.0685882568f, 4014.4635772705f, 252.2786102295f, -15.6735992432f,
	-160.2795562744f, 4007.5964813232f, 265.6457061768f, -16.9626312256f,
	-165.3834686279f, 4000.4707183838f, 279.2089691162f, -18.2962188721f,
	-170.3810577393f, 3993.0884857178f, 292.9662017822f, -19.6736297607f,
	-175.2730560303f, 3985.4519805908f, 306.9152069092f, -21.0941314697f,
	-180.0601959229f, 3977.5634002686f, 321.0537872314f, -22.5569915771f,
	-184.7432098389f, 3969.4249420166f, 335.3797454834f, -24.0614776611f,
	-189.3228302002f, 3961.0388031006f, 349.8908843994f, -25.6068572998f,
	-193.7997894287f, 3952.4071807861f, 364.5850067139f, -27.1923980713f,
	-198.1748199463f, 3943.5322723389f, 379.4599151611f, -28.8173675537f,
	-202.4486541748f, 3934.4162750244f, 394.5134124756f, -30.4810333252f,
	-206.6220245361f, 3925.0613861084f, 409.7433013916f, -32.1826629639f,
	-210.6956634521f, 3915.4698028564f, 425.1473846436f, -33.9215240479f,
	-214.6703033447f, 3905.6437225342f, 440.7234649658f, -35.6968841553f,
	-218.5466766357f, 3895.5853424072f, 456.4693450928f, -37.5080108643f,
	-222.3255157471f, 3885.2968597412f, 472.3828277588f, -39.3541717529f,
	-226.0075531006f, 3874.7804718018f, 488.4617156982f, -41.2346343994f,
	-229.5935211182f, 3864.0383758545f, 504.7038116455f, -43.1486663818f,
	-233.0841522217f, 3853.0727691650f, 521.1069183350f, -45.0955352783f,
	-236.4801788330f, 3841.8858489990f, 537.6688385010f, -47.0745086670f,
	-239.7823333740f, 3830.4798126221f, 554.3873748779f, -49.0848541260f,
	-242.9913482666f, 3818.8568572998f, 571.2603302002f, -51.1258392334f,
	-246.1079559326f, 3807.0191802979f, 588.2855072021f, -53.1967315674f,
	-249.1328887939f, 3794.9689788818f, 605.4607086182f, -55.2967987061f,
	-252.0668792725f, 3782.7084503174f, 622.7837371826f, -57.4253082275f,
	-254.9106597900f, 3770.2397918701f, 640.2523956299f, -59.5815277100f,
	-257.6649627686f, 3757.5652008057f, 657.8644866943f, -61.7647247314f,
	-260.3305206299f, 3744.6868743896f, 675.6178131104f, -63.9741668701f,
	-262.9080657959f, 3731.6070098877f, 693.5101776123f, -66.2091217041f,
	-265.3983306885f, 3718.3278045654f, 711.5393829346f, -68.4688568115f,
	-267.8020477295f, 3704.8514556885f, 729.7032318115f, -70.7526397705f,
	-270.1199493408f, 3691.1801605225f, 747.9995269775f, -73.0597381592f,
	-272.3527679443f, 3677.3161163330f, 766.4260711670f, -75.3894195557f,
	-274.5012359619f, 3663.2615203857f, 784.9806671143f, -77.7409515381f,
	-276.5660858154f, 3649.0185699463f, 803.6611175537f, -80.1136016846f,
	-278.5480499268f, 3634.5894622803f, 822.4652252197f, -82.5066375732f,
	-280.4478607178f, 3619.9763946533f, 841.3907928467f, -84.9193267822f,
	-282.2662506104f, 3605.1815643311f, 860.4356231689f, -87.3509368896f,
	-284.0039520264f, 3590.2071685791f, 879.5975189209f, -89.8007354736f,
	-285.6616973877f, 3575.0554046631f, 898.8742828369f, -92.2679901123f,
	-287.2402191162f, 3559.7284698486f, 918.2637176514f, -94.7519683838f,
	-288.7402496338f, 3544.2285614014f, 937.7636260986f, -97.2519378662f,
	-290.1625213623f, 3528.5578765869f, 957.3718109131f, -99.7671661377f,
	-291.5077667236f, 3512.7186126709f, 977.0860748291f, -102.2969207764f,
	-292.7767181396f, 3496.7129669189f, 996.9042205811f, -104.8404693604f,
	-293.9701080322f, 3480.5431365967f, 1016.8240509033f, -107.3970794678f,
	-295.0886688232f, 3464.2113189697f, 1036.8433685303f, -109.9660186768f,
	-296.1331329346f, 3447.7197113037f, 1056.9599761963f, -112.5465545654f,
	-297.1042327881f, 3431.0705108643f, 1077.1716766357f, -115.1379547119f,
	-298.0027008057f, 3414.2659149170f, 1097.4762725830f, -117.7394866943f,
	-298.8292694092f, 3397.3081207275f, 1117.8715667725f, -120.3504180908f,
	-299.5846710205f, 3380.1993255615f, 1138.3553619385f, -122.9700164795f,
	-300.2696380615f, 3362.9417266846f, 1158.9254608154f, -125.5975494385f,
	-300.8849029541f, 3345.5375213623f, 1179.5796661377f, -128.2322845459f,
	-301.4311981201f, 3327.9889068604f, 1200.3157806396f, -130.8734893799f,
	-301.9092559814f, 3310.2980804443f, 1221.1316070557f, -133.5204315186f,
	-302.3198089600f, 3292.4672393799f, 1242.0249481201f, -136.1723785400f,
	-302.6635894775f, 3274.4985809326f, 1262.9936065674f, -138.8285980225f,
	-302.9413299561f, 3256.3943023682f, 1284.0353851318f, -141.4883575439f,
	-303.1537628174f, 3238.1566009521f, 1305.1480865479f, -144.1509246826f,
	-303.3016204834f, 3219.7876739502f, 1326.3295135498f, -146.8155670166f,
	-303.3856353760f, 3201.2897186279f, 1347.5774688721f, -149.4815521240f,
	-303.4065399170f, 3182.6649322510f, 1368.8897552490f, -152.1481475830f,
	-303.3650665283f, 3163.9155120850f, 1390.2641754150f, -154.8146209717f,
	-303.2619476318f, 3145.0436553955f, 1411.6985321045f, -157.4802398682f,
	-303.0979156494f, 3126.0515594482f, 1433.1906280518f, -160.1442718506f,
	-302.8737030029f, 3106.9414215088f, 1454.7382659912f, -162.8059844971f,
	-302.5900421143f, 3087.7154388428f, 1476.3392486572f, -165.4646453857f,
	-302.2476654053f, 3068.3758087158f, 1497.9913787842f, -168.1195220947f,
	-301.8473052979f, 3048.9247283936f, 1519.6924591064f, -170.7698822021f,
	-301.3896942139f, 3029.3643951416f, 1541.4402923584f, -173.4149932861f,
	-300.8755645752f, 3009.6970062256f, 1563.2326812744f, -176.0541229248f,
	-300.3056488037f, 2989.9247589111f, 1585.0674285889f, -178.6865386963f,
	-299.6806793213f, 2970.0498504639f, 1606.9423370361f, -181.3115081787f,
	-299.0013885498f, 2950.0744781494f, 1628.8552093506f, -183.9282989502f,
	-298.2685089111f, 2930.0008392334f, 1650.8038482666f, -186.5361785889f,
	-297.4827728271f, 2909.8311309814f, 1672.7860565186f, -189.1344146729f,
	-296.6449127197f, 2889.5675506592f, 1694.7996368408f, -191.7222747803f,
	-295.7556610107f, 2869.2122955322f, 1716.8423919678f, -194.2990264893f,
	-294.8157501221f, 2848.7675628662f, 1738.9121246338f, -196.8639373779f,
	-293.8259124756f, 2828.2355499268f, 1761.0066375732f, -199.4162750244f,
	-292.7868804932f, 2807.6184539795f, 1783.1237335205f, -201.9553070068f,
	-291.6993865967f, 2786.9184722900f, 1805.2612152100f, -204.4803009033f,
	-290.5641632080f, 2766.1378021240f, 1827.4168853760f, -206.9905242920f,
	-289.3819427490f, 2745.2786407471f, 1849.5885467529f, -209.4852447510f,
	-288.1534576416f, 2724.3431854248f, 1871.7740020752f, -211.9637298584f,
	-286.8794403076f, 2703.3336334229f, 1893.9710540771f, -214.4252471924f,
	-285.5606231689f, 2682.2521820068f, 1916.1775054932f, -216.8690643311f,
	-284.1977386475f, 2661.1010284424f, 1938.3911590576f, -219.2944488525f,
	-282.7915191650f, 2639.8823699951f, 1960.6098175049f, -221.7006683350f,
	-281.3426971436f, 2618.5984039307f, 1982.8312835693f, -224.0869903564f,
	-279.8520050049f, 2597.2513275146f, 2005.0533599854f, -226.4526824951f,
	-278.3201751709f, 2575.8433380127f, 2027.2738494873f, -228.7970123291f,
	-276.7479400635f, 2554.3766326904f, 2049.4905548096f, -231.1192474365f,
	-275.1360321045f, 2532.8534088135f, 2071.7012786865f, -233.4186553955f,
	-273.4851837158f, 2511.2758636475f, 2093.9038238525f, -235.6945037842f,
	-271.7961273193f, 2489.6461944580f, 2116.0959930420f, -237.9460601807f,
	-270.0695953369f, 2467.9665985107f, 2138.2755889893f, -240.1725921631f,
	-268.3063201904f, 2446.2392730713f, 2160.4404144287f, -242.3733673096f,
	-266.5070343018f, 2424.4664154053f, 2182.5882720947f, -244.5476531982f,
	-264.6724700928f, 2402.6502227783f, 2204.7169647217f, -246.6947174072f,
	-262.8033599854f, 2380.7928924561f, 2226.8242950439f, -248.8138275146f,
	-260.9004364014f, 2358.8966217041f, 2248.9080657959f, -250.9042510986f,
	-258.9644317627f, 2336.9636077881f, 2270.9660797119f, -252.9652557373f,
	-256.9960784912f, 2314.9960479736f, 2292.9961395264f, -254.9961090088f,
	-254.9961090088f, 2292.9961395264f, 2314.9960479736f, -256.9960784912f,
	-252.9652557373f, 2270.9660797119f, 2336.9636077881f, -258.9644317627f,
	-250.9042510986f, 2248.9080657959f, 2358.8966217041f, -260.9004364014f,
	-248.8138275146f, 2226.8242950439f, 2380.7928924561f, -262.8033599854f,
	-246.6947174072f, 2204.7169647217f, 2402.6502227783f, -264.6724700928f,
	-244.5476531982f, 2182.5882720947f, 2424.4664154053f, -266.5070343018f,
	-242.3733673096f, 2160.4404144287f, 2446.2392730713f, -268.3063201904f,
	-240.1725921631f, 2138.2755889893f, 2467.9665985107f, -270.0695953369f,
	-237.9460601807f, 2116.0959930420f, 2489.6461944580f, -271.7961273193f,
	-235.6945037842f, 2093.9038238525f, 2511.2758636475f, -273.4851837158f,
	-233.4186553955f, 2071.7012786865f, 2532.8534088135f, -275.1360321045f,
	-231.1192474365f, 2049.4905548096f, 2554.3766326904f, -276.7479400635f,
	-228.7970123291f, 2027.2738494873f, 2575.8433380127f, -278.3201751709f,
	-226.4526824951f, 2005.0533599854f, 2597.2513275146f, -279.8520050049f,
	-224.0869903564f, 1982.8312835693f, 2618.5984039307f, -281.3426971436f,
	-221.7006683350f, 1960.6098175049f, 2639.8823699951f, -282.7915191650f,
	-219.2944488525f, 1938.3911590576f, 2661.1010284424f, -284.1977386475f,
	-216.8690643311f, 1916.1775054932f, 2682.2521820068f, -285.5606231689f,
	-214.4252471924f, 1893.9710540771f, 2703.3336334229f, -286.8794403076f,
	-211.9637298584f, 1871.7740020752f, 2724.3431854248f, -288.1534576416f,
	-209.4852447510f, 1849.5885467529f, 2745.2786407471f, -289.3819427490f,
	-206.9905242920f, 1827.4168853760f, 2766.1378021240f, -290.5641632080f,
	-204.4803009033f, 1805.2612152100f, 2786.9184722900f, -291.6993865967f,
	-201.9553070068f, 1783.1237335205f, 2807.6184539795f, -292.7868804932f,
	-199.4162750244f, 1761.0066375732f, 2828.2355499268f, -293.8259124756f,
	-196.8639373779f, 1738.9121246338f, 2848.7675628662f, -294.8157501221f,
	-194.2990264893f, 1716.8423919678f, 2869.2122955322f, -295.7556610107f,
	-191.7222747803f, 1694.7996368408f, 2889.5675506592f, -296.6449127197f,
	-189.1344146729f, 1672.7860565186f, 2909.8311309814f, -297.4827728271f,
	-186.5361785889f, 1650.8038482666f, 2930.0008392334f, -298.2685089111f,
	-183.9282989502f, 1628.8552093506f, 2950.0744781494f, -299.0013885498f,
	-181.3115081787f, 1606.9423370361f, 2970.0498504639f, -299.6806793213f,
	-178.6865386963f, 1585.0674285889f, 2989.9247589111f, -300.3056488037f,
	-176.0541229248f, 1563.2326812744f, 3009.6970062256f, -300.8755645752f,
	-173.4149932861f, 1541.4402923584f, 3029.3643951416f, -301.3896942139f,
	-170.7698822021f, 1519.6924591064f, 3048.9247283936f, -301.8473052979f,
	-168.1195220947f, 1497.9913787842f, 3068.3758087158f, -302.2476654053f,
	-165.4646453857f, 1476.3392486572f, 3087.7154388428f, -302.5900421143f,
	-162.8059844971f, 1454.7382659912f, 3106.9414215088f, -302.8737030029f,
	-160.1442718506f, 1433.1906280518f, 3126.0515594482f, -303.0979156494f,
	-157.4802398682f, 1411.6985321045f, 3145.0436553955f, -303.2619476318f,
	-154.8146209717f, 1390.2641754150f, 3163.9155120850f, -303.3650665283f,
	-152.1481475830f, 1368.8897552490f, 3182.6649322510f, -303.4065399170f,
	-149.4815521240f, 1347.5774688721f, 3201.2897186279f, -303.3856353760f,
	-146.8155670166f, 1326.3295135498f, 3219.7876739502f, -303.3016204834f,
	-144.1509246826f, 1305.1480865479f, 3238.1566009521f, -303.1537628174f,
	-141.4883575439f, 1284.0353851318f, 3256.3943023682f, -302.9413299561f,
	-138.8285980225f, 1262.9936065674f, 3274.4985809326f, -302.6635894775f,
	-136.1723785400f, 1242.0249481201f, 3292.4672393799f, -302.3198089600f,
	-133.5204315186f, 1221.1316070557f, 3310.2980804443f, -301.9092559814f,
	-130.8734893799f, 1200.3157806396f, 3327.9889068604f, -301.4311981201f,
	-128.2322845459f, 1179.5796661377f, 3345.5375213623f, -300.8849029541f,
	-125.5975494385f, 1158.9254608154f, 3362.9417266846f, -300.2696380615f,
	-122.9700164795f, 1138.3553619385f, 3380.1993255615f, -299.5846710205f,
	-120.3504180908f, 1117.8715667725f, 3397.3081207275f, -298.8292694092f,
	-117.7394866943f, 1097.4762725830f, 3414.2659149170f, -298.0027008057f,
	-115.1379547119f, 1077.1716766357f, 3431.0705108643f, -297.1042327881f,
	-112.5465545654f, 1056.9599761963f, 3447.7197113037f, -296.1331329346f,
	-109.9660186768f, 1036.8433685303f, 3464.2113189697f, -295.0886688232f,
	-107.3970794678f, 1016.8240509033f, 3480.5431365967f, -293.9701080322f,
	-104.8404693604f, 996.9042205811f, 3496.7129669189f, -292.7767181396f,
	-102.2969207764f, 977.0860748291f, 3512.7186126709f, -291.5077667236f,
	-99.7671661377f, 957.3718109131f, 3528.5578765869f, -290.1625213623f,
	-97.2519378662f, 937.7636260986f, 3544.2285614014f, -288.7402496338f,
	-94.7519683838f, 918.2637176514f, 3559.7284698486f, -287.2402191162f,
	-92.2679901123f, 898.8742828369f, 3575.0554046631f, -285.6616973877f,
	-89.8007354736f, 879.5975189209f, 3590.2071685791f, -284.0039520264f,
	-87.3509368896f, 860.4356231689f, 3605.1815643311f, -282.2662506104f,
	-84.9193267822f, 841.3907928467f, 3619.9763946533f, -280.4478607178f,
	-82.5066375732f, 822.4652252197f, 3634.5894622803f, -278.5480499268f,
	-80.1136016846f, 803.6611175537f, 3649.0185699463f, -276.5660858154f,
	-77.7409515381f, 784.9806671143f, 3663.2615203857f, -274.5012359619f,
	-75.3894195557f, 766.4260711670f, 3677.3161163330f, -272.3527679443f,
	-73.0597381592f, 747.9995269775f, 3691.1801605225f, -270.1199493408f,
	-70.7526397705f, 729.7032318115f, 3704.8514556885f, -267.8020477295f,
	-68.4688568115f, 711.5393829346f, 3718.3278045654f, -265.3983306885f,
	-66.2091217041f, 693.5101776123f, 3731.6070098877f, -262.9080657959f,
	-63.9741668701f, 675.6178131104f, 3744.6868743896f, -260.3305206299f,
	-61.7647247314f, 657.8644866943f, 3757.5652008057f, -257.6649627686f,
	-59.5815277100f, 640.2523956299f, 3770.2397918701f, -254.9106597900f,
	-57.4253082275f, 622.7837371826f, 3782.7084503174f, -252.0668792725f,
	-55.2967987061f, 605.4607086182f, 3794.9689788818f, -249.1328887939f,
	-53.1967315674f, 588.2855072021f, 3807.0191802979f, -246.1079559326f,
	-51.1258392334f, 571.2603302002f, 3818.8568572998f, -242.9913482666f,
	-49.0848541260f, 554.3873748779f, 3830.4798126221f, -239.7823333740f,
	-47.0745086670f, 537.6688385010f, 3841.8858489990f, -236.4801788330f,
	-45.0955352783f, 521.1069183350f, 3853.0727691650f, -233.0841522217f,
	-43.1486663818f, 504.7038116455f, 3864.0383758545f, -229.5935211182f,
	-41.2346343994f, 488.4617156982f, 3874.7804718018f, -226.0075531006f,
	-39.3541717529f, 472.3828277588f, 3885.2968597412f, -222.3255157471f,
	-37.5080108643f, 456.4693450928f, 3895.5853424072f, -218.5466766357f,
	-35.6968841553f, 440.7234649658f, 3905.6437225342f, -214.6703033447f,
	-33.9215240479f, 425.1473846436f, 3915.4698028564f, -210.6956634521f,
	-32.1826629639f, 409.7433013916f, 3925.0613861084f, -206.6220245361f,
	-30.4810333252f, 394.5134124756f, 3934.4162750244f, -202.4486541748f,
	-28.8173675537f, 379.4599151611f, 3943.5322723389f, -198.1748199463f,
	-27.1923980713f, 364.5850067139f, 3952.4071807861f, -193.7997894287f,
	-25.6068572998f, 349.8908843994f, 3961.0388031006f, -189.3228302002f,
	-24.0614776611f, 335.3797454834f, 3969.4249420166f, -184.7432098389f,
	-22.5569915771f, 321.0537872314f, 3977.5634002686f, -180.0601959229f,
	-21.0941314697f, 306.9152069092f, 3985.4519805908f, -175.2730560303f,
	-19.6736297607f, 292.9662017822f, 3993.0884857178f, -170.3810577393f,
	-18.2962188721f, 279.2089691162f, 4000.4707183838f, -165.3834686279f,
	-16.9626312256f, 265.6457061768f, 4007.5964813232f, -160.2795562744f,
	-15.6735992432f, 252.2786102295f, 4014.4635772705f, -155.0685882568f,
	-14.4298553467f, 239.1098785400f, 4021.0698089600f, -149.7498321533f,
	-13.2321319580f, 226.1417083740f, 4027.4129791260f, -144.3225555420f,
	-12.0811614990f, 213.3762969971f, 4033.4908905029f, -138.7860260010f,
	-10.9776763916f, 200.8158416748f, 4039.3013458252f, -133.1395111084f,
	-9.9224090576f, 188.4625396729f, 4044.8421478271f, -127.3822784424f,
	-8.9160919189f, 176.3185882568f, 4050.1110992432f, -121.5135955811f,
	-7.9594573975f, 164.3861846924f, 4055.1060028076f, -115.5327301025f,
	-7.0532379150f, 152.6675262451f, 4059.8246612549f, -109.4389495850f,
	-6.1981658936f, 141.1648101807f, 4064.2648773193f, -103.2315216064f,
	-5.3949737549f, 129.8802337646f, 4068.4244537354f, -96.9097137451f,
	-4.6443939209f, 118.8159942627f, 4072.3011932373f, -90.4727935791f,
	-3.9471588135f, 107.9742889404f, 4075.8928985596f, -83.9200286865f,
	-3.3040008545f, 97.3573150635f, 4079.1973724365f, -77.2506866455f,
	-2.7156524658f, 86.9672698975f, 4082.2124176025f, -70.4640350342f,
	-2.1828460693f, 76.8063507080f, 4084.9358367920f, -63.5593414307f,
	-1.7063140869f, 66.8767547607f, 4087.3654327393f, -56.5358734131f,
	-1.2867889404f, 57.1806793213f, 4089.4990081787f, -49.3928985596f,
	-0.9250030518f, 47.7203216553f, 4091.3343658447f, -42.1296844482f,
	-0.6216888428f, 38.4978790283f, 4092.8693084717f, -34.7454986572f,
	-0.3775787354f, 29.5155487061f, 4094.1016387939f, -27.2396087646f,
	-0.1934051514f, 20.7755279541f, 4095.0291595459f, -19.6112823486f,
	-0.0699005127f, 12.2800140381f, 4095.6496734619f, -11.8597869873f,
	-0.0077972412f, 4.0312042236f, 4095.9609832764f, -3.9843902588f
};

/* *********************************************************** */

const mlib_f32 mlib_filters_u8f_bc2[] = {
	-7.9687805176f, 4095.9687805176f, 8.0155944824f, -0.0155944824f,
	-23.7195739746f, 4095.7195739746f, 24.1398010254f, -0.1398010254f,
	-39.2225646973f, 4095.2225646973f, 40.3868103027f, -0.3868103027f,
	-54.4792175293f, 4094.4792175293f, 56.7551574707f, -0.7551574707f,
	-69.4909973145f, 4093.4909973145f, 73.2433776855f, -1.2433776855f,
	-84.2593688965f, 4092.2593688965f, 89.8500061035f, -1.8500061035f,
	-98.7857971191f, 4090.7857971191f, 106.5735778809f, -2.5735778809f,
	-113.0717468262f, 4089.0717468262f, 123.4126281738f, -3.4126281738f,
	-127.1186828613f, 4087.1186828613f, 140.3656921387f, -4.3656921387f,
	-140.9280700684f, 4084.9280700684f, 157.4313049316f, -5.4313049316f,
	-154.5013732910f, 4082.5013732910f, 174.6080017090f, -6.6080017090f,
	-167.8400573730f, 4079.8400573730f, 191.8943176270f, -7.8943176270f,
	-180.9455871582f, 4076.9455871582f, 209.2887878418f, -9.2887878418f,
	-193.8194274902f, 4073.8194274902f, 226.7899475098f, -10.7899475098f,
	-206.4630432129f, 4070.4630432129f, 244.3963317871f, -12.3963317871f,
	-218.8778991699f, 4066.8778991699f, 262.1064758301f, -14.1064758301f,
	-231.0654602051f, 4063.0654602051f, 279.9189147949f, -15.9189147949f,
	-243.0271911621f, 4059.0271911621f, 297.8321838379f, -17.8321838379f,
	-254.7645568848f, 4054.7645568848f, 315.8448181152f, -19.8448181152f,
	-266.2790222168f, 4050.2790222168f, 333.9553527832f, -21.9553527832f,
	-277.5720520020f, 4045.5720520020f, 352.1623229980f, -24.1623229980f,
	-288.6451110840f, 4040.6451110840f, 370.4642639160f, -26.4642639160f,
	-299.4996643066f, 4035.4996643066f, 388.8597106934f, -28.8597106934f,
	-310.1371765137f, 4030.1371765137f, 407.3471984863f, -31.3471984863f,
	-320.5591125488f, 4024.5591125488f, 425.9252624512f, -33.9252624512f,
	-330.7669372559f, 4018.7669372559f, 444.5924377441f, -36.5924377441f,
	-340.7621154785f, 4012.7621154785f, 463.3472595215f, -39.3472595215f,
	-350.5461120605f, 4006.5461120605f, 482.1882629395f, -42.1882629395f,
	-360.1203918457f, 4000.1203918457f, 501.1139831543f, -45.1139831543f,
	-369.4864196777f, 3993.4864196777f, 520.1229553223f, -48.1229553223f,
	-378.6456604004f, 3986.6456604004f, 539.2137145996f, -51.2137145996f,
	-387.5995788574f, 3979.5995788574f, 558.3847961426f, -54.3847961426f,
	-396.3496398926f, 3972.3496398926f, 577.6347351074f, -57.6347351074f,
	-404.8973083496f, 3964.8973083496f, 596.9620666504f, -60.9620666504f,
	-413.2440490723f, 3957.2440490723f, 616.3653259277f, -64.3653259277f,
	-421.3913269043f, 3949.3913269043f, 635.8430480957f, -67.8430480957f,
	-429.3406066895f, 3941.3406066895f, 655.3937683105f, -71.3937683105f,
	-437.0933532715f, 3933.0933532715f, 675.0160217285f, -75.0160217285f,
	-444.6510314941f, 3924.6510314941f, 694.7083435059f, -78.7083435059f,
	-452.0151062012f, 3916.0151062012f, 714.4692687988f, -82.4692687988f,
	-459.1870422363f, 3907.1870422363f, 734.2973327637f, -86.2973327637f,
	-466.1683044434f, 3898.1683044434f, 754.1910705566f, -90.1910705566f,
	-472.9603576660f, 3888.9603576660f, 774.1490173340f, -94.1490173340f,
	-479.5646667480f, 3879.5646667480f, 794.1697082520f, -98.1697082520f,
	-485.9826965332f, 3869.9826965332f, 814.2516784668f, -102.2516784668f,
	-492.2159118652f, 3860.2159118652f, 834.3934631348f, -106.3934631348f,
	-498.2657775879f, 3850.2657775879f, 854.5935974121f, -110.5935974121f,
	-504.1337585449f, 3840.1337585449f, 874.8506164551f, -114.8506164551f,
	-509.8213195801f, 3829.8213195801f, 895.1630554199f, -119.1630554199f,
	-515.3299255371f, 3819.3299255371f, 915.5294494629f, -123.5294494629f,
	-520.6610412598f, 3808.6610412598f, 935.9483337402f, -127.9483337402f,
	-525.8161315918f, 3797.8161315918f, 956.4182434082f, -132.4182434082f,
	-530.7966613770f, 3786.7966613770f, 976.9377136230f, -136.9377136230f,
	-535.6040954590f, 3775.6040954590f, 997.5052795410f, -141.5052795410f,
	-540.2398986816f, 3764.2398986816f, 1018.1194763184f, -146.1194763184f,
	-544.7055358887f, 3752.7055358887f, 1038.7788391113f, -150.7788391113f,
	-549.0024719238f, 3741.0024719238f, 1059.4819030762f, -155.4819030762f,
	-553.1321716309f, 3729.1321716309f, 1080.2272033691f, -160.2272033691f,
	-557.0960998535f, 3717.0960998535f, 1101.0132751465f, -165.0132751465f,
	-560.8957214355f, 3704.8957214355f, 1121.8386535645f, -169.8386535645f,
	-564.5325012207f, 3692.5325012207f, 1142.7018737793f, -174.7018737793f,
	-568.0079040527f, 3680.0079040527f, 1163.6014709473f, -179.6014709473f,
	-571.3233947754f, 3667.3233947754f, 1184.5359802246f, -184.5359802246f,
	-574.4804382324f, 3654.4804382324f, 1205.5039367676f, -189.5039367676f,
	-577.4804992676f, 3641.4804992676f, 1226.5038757324f, -194.5038757324f,
	-580.3250427246f, 3628.3250427246f, 1247.5343322754f, -199.5343322754f,
	-583.0155334473f, 3615.0155334473f, 1268.5938415527f, -204.5938415527f,
	-585.5534362793f, 3601.5534362793f, 1289.6809387207f, -209.6809387207f,
	-587.9402160645f, 3587.9402160645f, 1310.7941589355f, -214.7941589355f,
	-590.1773376465f, 3574.1773376465f, 1331.9320373535f, -219.9320373535f,
	-592.2662658691f, 3560.2662658691f, 1353.0931091309f, -225.0931091309f,
	-594.2084655762f, 3546.2084655762f, 1374.2759094238f, -230.2759094238f,
	-596.0054016113f, 3532.0054016113f, 1395.4789733887f, -235.4789733887f,
	-597.6585388184f, 3517.6585388184f, 1416.7008361816f, -240.7008361816f,
	-599.1693420410f, 3503.1693420410f, 1437.9400329590f, -245.9400329590f,
	-600.5392761230f, 3488.5392761230f, 1459.1950988770f, -251.1950988770f,
	-601.7698059082f, 3473.7698059082f, 1480.4645690918f, -256.4645690918f,
	-602.8623962402f, 3458.8623962402f, 1501.7469787598f, -261.7469787598f,
	-603.8185119629f, 3443.8185119629f, 1523.0408630371f, -267.0408630371f,
	-604.6396179199f, 3428.6396179199f, 1544.3447570801f, -272.3447570801f,
	-605.3271789551f, 3413.3271789551f, 1565.6571960449f, -277.6571960449f,
	-605.8826599121f, 3397.8826599121f, 1586.9767150879f, -282.9767150879f,
	-606.3075256348f, 3382.3075256348f, 1608.3018493652f, -288.3018493652f,
	-606.6032409668f, 3366.6032409668f, 1629.6311340332f, -293.6311340332f,
	-606.7712707520f, 3350.7712707520f, 1650.9631042480f, -298.9631042480f,
	-606.8130798340f, 3334.8130798340f, 1672.2962951660f, -304.2962951660f,
	-606.7301330566f, 3318.7301330566f, 1693.6292419434f, -309.6292419434f,
	-606.5238952637f, 3302.5238952637f, 1714.9604797363f, -314.9604797363f,
	-606.1958312988f, 3286.1958312988f, 1736.2885437012f, -320.2885437012f,
	-605.7474060059f, 3269.7474060059f, 1757.6119689941f, -325.6119689941f,
	-605.1800842285f, 3253.1800842285f, 1778.9292907715f, -330.9292907715f,
	-604.4953308105f, 3236.4953308105f, 1800.2390441895f, -336.2390441895f,
	-603.6946105957f, 3219.6946105957f, 1821.5397644043f, -341.5397644043f,
	-602.7793884277f, 3202.7793884277f, 1842.8299865723f, -346.8299865723f,
	-601.7511291504f, 3185.7511291504f, 1864.1082458496f, -352.1082458496f,
	-600.6112976074f, 3168.6112976074f, 1885.3730773926f, -357.3730773926f,
	-599.3613586426f, 3151.3613586426f, 1906.6230163574f, -362.6230163574f,
	-598.0027770996f, 3134.0027770996f, 1927.8565979004f, -367.8565979004f,
	-596.5370178223f, 3116.5370178223f, 1949.0723571777f, -373.0723571777f,
	-594.9655456543f, 3098.9655456543f, 1970.2688293457f, -378.2688293457f,
	-593.2898254395f, 3081.2898254395f, 1991.4445495605f, -383.4445495605f,
	-591.5113220215f, 3063.5113220215f, 2012.5980529785f, -388.5980529785f,
	-589.6315002441f, 3045.6315002441f, 2033.7278747559f, -393.7278747559f,
	-587.6518249512f, 3027.6518249512f, 2054.8325500488f, -398.8325500488f,
	-585.5737609863f, 3009.5737609863f, 2075.9106140137f, -403.9106140137f,
	-583.3987731934f, 2991.3987731934f, 2096.9606018066f, -408.9606018066f,
	-581.1283264160f, 2973.1283264160f, 2117.9810485840f, -413.9810485840f,
	-578.7638854980f, 2954.7638854980f, 2138.9704895020f, -418.9704895020f,
	-576.3069152832f, 2936.3069152832f, 2159.9274597168f, -423.9274597168f,
	-573.7588806152f, 2917.7588806152f, 2180.8504943848f, -428.8504943848f,
	-571.1212463379f, 2899.1212463379f, 2201.7381286621f, -433.7381286621f,
	-568.3954772949f, 2880.3954772949f, 2222.5888977051f, -438.5888977051f,
	-565.5830383301f, 2861.5830383301f, 2243.4013366699f, -443.4013366699f,
	-562.6853942871f, 2842.6853942871f, 2264.1739807129f, -448.1739807129f,
	-559.7040100098f, 2823.7040100098f, 2284.9053649902f, -452.9053649902f,
	-556.6403503418f, 2804.6403503418f, 2305.5940246582f, -457.5940246582f,
	-553.4958801270f, 2785.4958801270f, 2326.2384948730f, -462.2384948730f,
	-550.2720642090f, 2766.2720642090f, 2346.8373107910f, -466.8373107910f,
	-546.9703674316f, 2746.9703674316f, 2367.3890075684f, -471.3890075684f,
	-543.5922546387f, 2727.5922546387f, 2387.8921203613f, -475.8921203613f,
	-540.1391906738f, 2708.1391906738f, 2408.3451843262f, -480.3451843262f,
	-536.6126403809f, 2688.6126403809f, 2428.7467346191f, -484.7467346191f,
	-533.0140686035f, 2669.0140686035f, 2449.0953063965f, -489.0953063965f,
	-529.3449401855f, 2649.3449401855f, 2469.3894348145f, -493.3894348145f,
	-525.6067199707f, 2629.6067199707f, 2489.6276550293f, -497.6276550293f,
	-521.8008728027f, 2609.8008728027f, 2509.8085021973f, -501.8085021973f,
	-517.9288635254f, 2589.9288635254f, 2529.9305114746f, -505.9305114746f,
	-513.9921569824f, 2569.9921569824f, 2549.9922180176f, -509.9922180176f,
	-509.9922180176f, 2549.9922180176f, 2569.9921569824f, -513.9921569824f,
	-505.9305114746f, 2529.9305114746f, 2589.9288635254f, -517.9288635254f,
	-501.8085021973f, 2509.8085021973f, 2609.8008728027f, -521.8008728027f,
	-497.6276550293f, 2489.6276550293f, 2629.6067199707f, -525.6067199707f,
	-493.3894348145f, 2469.3894348145f, 2649.3449401855f, -529.3449401855f,
	-489.0953063965f, 2449.0953063965f, 2669.0140686035f, -533.0140686035f,
	-484.7467346191f, 2428.7467346191f, 2688.6126403809f, -536.6126403809f,
	-480.3451843262f, 2408.3451843262f, 2708.1391906738f, -540.1391906738f,
	-475.8921203613f, 2387.8921203613f, 2727.5922546387f, -543.5922546387f,
	-471.3890075684f, 2367.3890075684f, 2746.9703674316f, -546.9703674316f,
	-466.8373107910f, 2346.8373107910f, 2766.2720642090f, -550.2720642090f,
	-462.2384948730f, 2326.2384948730f, 2785.4958801270f, -553.4958801270f,
	-457.5940246582f, 2305.5940246582f, 2804.6403503418f, -556.6403503418f,
	-452.9053649902f, 2284.9053649902f, 2823.7040100098f, -559.7040100098f,
	-448.1739807129f, 2264.1739807129f, 2842.6853942871f, -562.6853942871f,
	-443.4013366699f, 2243.4013366699f, 2861.5830383301f, -565.5830383301f,
	-438.5888977051f, 2222.5888977051f, 2880.3954772949f, -568.3954772949f,
	-433.7381286621f, 2201.7381286621f, 2899.1212463379f, -571.1212463379f,
	-428.8504943848f, 2180.8504943848f, 2917.7588806152f, -573.7588806152f,
	-423.9274597168f, 2159.9274597168f, 2936.3069152832f, -576.3069152832f,
	-418.9704895020f, 2138.9704895020f, 2954.7638854980f, -578.7638854980f,
	-413.9810485840f, 2117.9810485840f, 2973.1283264160f, -581.1283264160f,
	-408.9606018066f, 2096.9606018066f, 2991.3987731934f, -583.3987731934f,
	-403.9106140137f, 2075.9106140137f, 3009.5737609863f, -585.5737609863f,
	-398.8325500488f, 2054.8325500488f, 3027.6518249512f, -587.6518249512f,
	-393.7278747559f, 2033.7278747559f, 3045.6315002441f, -589.6315002441f,
	-388.5980529785f, 2012.5980529785f, 3063.5113220215f, -591.5113220215f,
	-383.4445495605f, 1991.4445495605f, 3081.2898254395f, -593.2898254395f,
	-378.2688293457f, 1970.2688293457f, 3098.9655456543f, -594.9655456543f,
	-373.0723571777f, 1949.0723571777f, 3116.5370178223f, -596.5370178223f,
	-367.8565979004f, 1927.8565979004f, 3134.0027770996f, -598.0027770996f,
	-362.6230163574f, 1906.6230163574f, 3151.3613586426f, -599.3613586426f,
	-357.3730773926f, 1885.3730773926f, 3168.6112976074f, -600.6112976074f,
	-352.1082458496f, 1864.1082458496f, 3185.7511291504f, -601.7511291504f,
	-346.8299865723f, 1842.8299865723f, 3202.7793884277f, -602.7793884277f,
	-341.5397644043f, 1821.5397644043f, 3219.6946105957f, -603.6946105957f,
	-336.2390441895f, 1800.2390441895f, 3236.4953308105f, -604.4953308105f,
	-330.9292907715f, 1778.9292907715f, 3253.1800842285f, -605.1800842285f,
	-325.6119689941f, 1757.6119689941f, 3269.7474060059f, -605.7474060059f,
	-320.2885437012f, 1736.2885437012f, 3286.1958312988f, -606.1958312988f,
	-314.9604797363f, 1714.9604797363f, 3302.5238952637f, -606.5238952637f,
	-309.6292419434f, 1693.6292419434f, 3318.7301330566f, -606.7301330566f,
	-304.2962951660f, 1672.2962951660f, 3334.8130798340f, -606.8130798340f,
	-298.9631042480f, 1650.9631042480f, 3350.7712707520f, -606.7712707520f,
	-293.6311340332f, 1629.6311340332f, 3366.6032409668f, -606.6032409668f,
	-288.3018493652f, 1608.3018493652f, 3382.3075256348f, -606.3075256348f,
	-282.9767150879f, 1586.9767150879f, 3397.8826599121f, -605.8826599121f,
	-277.6571960449f, 1565.6571960449f, 3413.3271789551f, -605.3271789551f,
	-272.3447570801f, 1544.3447570801f, 3428.6396179199f, -604.6396179199f,
	-267.0408630371f, 1523.0408630371f, 3443.8185119629f, -603.8185119629f,
	-261.7469787598f, 1501.7469787598f, 3458.8623962402f, -602.8623962402f,
	-256.4645690918f, 1480.4645690918f, 3473.7698059082f, -601.7698059082f,
	-251.1950988770f, 1459.1950988770f, 3488.5392761230f, -600.5392761230f,
	-245.9400329590f, 1437.9400329590f, 3503.1693420410f, -599.1693420410f,
	-240.7008361816f, 1416.7008361816f, 3517.6585388184f, -597.6585388184f,
	-235.4789733887f, 1395.4789733887f, 3532.0054016113f, -596.0054016113f,
	-230.2759094238f, 1374.2759094238f, 3546.2084655762f, -594.2084655762f,
	-225.0931091309f, 1353.0931091309f, 3560.2662658691f, -592.2662658691f,
	-219.9320373535f, 1331.9320373535f, 3574.1773376465f, -590.1773376465f,
	-214.7941589355f, 1310.7941589355f, 3587.9402160645f, -587.9402160645f,
	-209.6809387207f, 1289.6809387207f, 3601.5534362793f, -585.5534362793f,
	-204.5938415527f, 1268.5938415527f, 3615.0155334473f, -583.0155334473f,
	-199.5343322754f, 1247.5343322754f, 3628.3250427246f, -580.3250427246f,
	-194.5038757324f, 1226.5038757324f, 3641.4804992676f, -577.4804992676f,
	-189.5039367676f, 1205.5039367676f, 3654.4804382324f, -574.4804382324f,
	-184.5359802246f, 1184.5359802246f, 3667.3233947754f, -571.3233947754f,
	-179.6014709473f, 1163.6014709473f, 3680.0079040527f, -568.0079040527f,
	-174.7018737793f, 1142.7018737793f, 3692.5325012207f, -564.5325012207f,
	-169.8386535645f, 1121.8386535645f, 3704.8957214355f, -560.8957214355f,
	-165.0132751465f, 1101.0132751465f, 3717.0960998535f, -557.0960998535f,
	-160.2272033691f, 1080.2272033691f, 3729.1321716309f, -553.1321716309f,
	-155.4819030762f, 1059.4819030762f, 3741.0024719238f, -549.0024719238f,
	-150.7788391113f, 1038.7788391113f, 3752.7055358887f, -544.7055358887f,
	-146.1194763184f, 1018.1194763184f, 3764.2398986816f, -540.2398986816f,
	-141.5052795410f, 997.5052795410f, 3775.6040954590f, -535.6040954590f,
	-136.9377136230f, 976.9377136230f, 3786.7966613770f, -530.7966613770f,
	-132.4182434082f, 956.4182434082f, 3797.8161315918f, -525.8161315918f,
	-127.9483337402f, 935.9483337402f, 3808.6610412598f, -520.6610412598f,
	-123.5294494629f, 915.5294494629f, 3819.3299255371f, -515.3299255371f,
	-119.1630554199f, 895.1630554199f, 3829.8213195801f, -509.8213195801f,
	-114.8506164551f, 874.8506164551f, 3840.1337585449f, -504.1337585449f,
	-110.5935974121f, 854.5935974121f, 3850.2657775879f, -498.2657775879f,
	-106.3934631348f, 834.3934631348f, 3860.2159118652f, -492.2159118652f,
	-102.2516784668f, 814.2516784668f, 3869.9826965332f, -485.9826965332f,
	-98.1697082520f, 794.1697082520f, 3879.5646667480f, -479.5646667480f,
	-94.1490173340f, 774.1490173340f, 3888.9603576660f, -472.9603576660f,
	-90.1910705566f, 754.1910705566f, 3898.1683044434f, -466.1683044434f,
	-86.2973327637f, 734.2973327637f, 3907.1870422363f, -459.1870422363f,
	-82.4692687988f, 714.4692687988f, 3916.0151062012f, -452.0151062012f,
	-78.7083435059f, 694.7083435059f, 3924.6510314941f, -444.6510314941f,
	-75.0160217285f, 675.0160217285f, 3933.0933532715f, -437.0933532715f,
	-71.3937683105f, 655.3937683105f, 3941.3406066895f, -429.3406066895f,
	-67.8430480957f, 635.8430480957f, 3949.3913269043f, -421.3913269043f,
	-64.3653259277f, 616.3653259277f, 3957.2440490723f, -413.2440490723f,
	-60.9620666504f, 596.9620666504f, 3964.8973083496f, -404.8973083496f,
	-57.6347351074f, 577.6347351074f, 3972.3496398926f, -396.3496398926f,
	-54.3847961426f, 558.3847961426f, 3979.5995788574f, -387.5995788574f,
	-51.2137145996f, 539.2137145996f, 3986.6456604004f, -378.6456604004f,
	-48.1229553223f, 520.1229553223f, 3993.4864196777f, -369.4864196777f,
	-45.1139831543f, 501.1139831543f, 4000.1203918457f, -360.1203918457f,
	-42.1882629395f, 482.1882629395f, 4006.5461120605f, -350.5461120605f,
	-39.3472595215f, 463.3472595215f, 4012.7621154785f, -340.7621154785f,
	-36.5924377441f, 444.5924377441f, 4018.7669372559f, -330.7669372559f,
	-33.9252624512f, 425.9252624512f, 4024.5591125488f, -320.5591125488f,
	-31.3471984863f, 407.3471984863f, 4030.1371765137f, -310.1371765137f,
	-28.8597106934f, 388.8597106934f, 4035.4996643066f, -299.4996643066f,
	-26.4642639160f, 370.4642639160f, 4040.6451110840f, -288.6451110840f,
	-24.1623229980f, 352.1623229980f, 4045.5720520020f, -277.5720520020f,
	-21.9553527832f, 333.9553527832f, 4050.2790222168f, -266.2790222168f,
	-19.8448181152f, 315.8448181152f, 4054.7645568848f, -254.7645568848f,
	-17.8321838379f, 297.8321838379f, 4059.0271911621f, -243.0271911621f,
	-15.9189147949f, 279.9189147949f, 4063.0654602051f, -231.0654602051f,
	-14.1064758301f, 262.1064758301f, 4066.8778991699f, -218.8778991699f,
	-12.3963317871f, 244.3963317871f, 4070.4630432129f, -206.4630432129f,
	-10.7899475098f, 226.7899475098f, 4073.8194274902f, -193.8194274902f,
	-9.2887878418f, 209.2887878418f, 4076.9455871582f, -180.9455871582f,
	-7.8943176270f, 191.8943176270f, 4079.8400573730f, -167.8400573730f,
	-6.6080017090f, 174.6080017090f, 4082.5013732910f, -154.5013732910f,
	-5.4313049316f, 157.4313049316f, 4084.9280700684f, -140.9280700684f,
	-4.3656921387f, 140.3656921387f, 4087.1186828613f, -127.1186828613f,
	-3.4126281738f, 123.4126281738f, 4089.0717468262f, -113.0717468262f,
	-2.5735778809f, 106.5735778809f, 4090.7857971191f, -98.7857971191f,
	-1.8500061035f, 89.8500061035f, 4092.2593688965f, -84.2593688965f,
	-1.2433776855f, 73.2433776855f, 4093.4909973145f, -69.4909973145f,
	-0.7551574707f, 56.7551574707f, 4094.4792175293f, -54.4792175293f,
	-0.3868103027f, 40.3868103027f, 4095.2225646973f, -39.2225646973f,
	-0.1398010254f, 24.1398010254f, 4095.7195739746f, -23.7195739746f,
	-0.0155944824f, 8.0155944824f, 4095.9687805176f, -7.9687805176f
};

/* *********************************************************** */

const mlib_f32 mlib_filters_s16f_bc[] = {
	-0.1247559786f, 255.9993900061f, 0.1254879236f, -0.0001219511f,
	-0.3728059530f, 255.9945164919f, 0.3793848753f, -0.0010954142f,
	-0.6189113855f, 255.9847859144f, 0.6371623278f, -0.0030368567f,
	-0.8630779982f, 255.9702154398f, 0.8988031149f, -0.0059405565f,
	-1.1053115129f, 255.9508222342f, 1.1642900705f, -0.0098007917f,
	-1.3456176519f, 255.9266234636f, 1.4336060286f, -0.0146118402f,
	-1.5840021372f, 255.8976362944f, 1.7067338228f, -0.0203679800f,
	-1.8204706907f, 255.8638778925f, 1.9836562872f, -0.0270634890f,
	-2.0550290346f, 255.8253654242f, 2.2643562555f, -0.0346926451f,
	-2.2876828909f, 255.7821160555f, 2.5488165617f, -0.0432497263f,
	-2.5184379816f, 255.7341469526f, 2.8370200396f, -0.0527290106f,
	-2.7473000288f, 255.6814752817f, 3.1289495230f, -0.0631247759f,
	-2.9742747545f, 255.6241182089f, 3.4245878458f, -0.0744313002f,
	-3.1993678808f, 255.5620929003f, 3.7239178419f, -0.0866428614f,
	-3.4225851297f, 255.4954165220f, 4.0269223452f, -0.0997537374f,
	-3.6439322233f, 255.4241062403f, 4.3335841894f, -0.1137582064f,
	-3.8634148836f, 255.3481792212f, 4.6438862085f, -0.1286505461f,
	-4.0810388327f, 255.2676526308f, 4.9578112364f, -0.1444250345f,
	-4.2968097925f, 255.1825436354f, 5.2753421068f, -0.1610759497f,
	-4.5107334852f, 255.0928694010f, 5.5964616537f, -0.1785975695f,
	-4.7228156328f, 254.9986470938f, 5.9211527109f, -0.1969841719f,
	-4.9330619574f, 254.8998938799f, 6.2493981123f, -0.2162300348f,
	-5.1414781809f, 254.7966269255f, 6.5811806917f, -0.2363294363f,
	-5.3480700254f, 254.6888633966f, 6.9164832830f, -0.2572766542f,
	-5.5528432131f, 254.5766204596f, 7.2552887201f, -0.2790659666f,
	-5.7558034658f, 254.4599152803f, 7.5975798368f, -0.3016916513f,
	-5.9569565058f, 254.3387650251f, 7.9433394670f, -0.3251479864f,
	-6.1563080549f, 254.2131868601f, 8.2925504446f, -0.3494292498f,
	-6.3538638353f, 254.0831979513f, 8.6451956034f, -0.3745297194f,
	-6.5496295691f, 253.9488154650f, 9.0012577772f, -0.4004436731f,
	-6.7436109781f, 253.8100565672f, 9.3607198000f, -0.4271653891f,
	-6.9358137846f, 253.6669384241f, 9.7235645056f, -0.4546891451f,
	-7.1262437105f, 253.5194782019f, 10.0897747278f, -0.4830092192f,
	-7.3149064779f, 253.3676930666f, 10.4593333006f, -0.5121198893f,
	-7.5018078089f, 253.2116001844f, 10.8322230577f, -0.5420154333f,
	-7.6869534254f, 253.0512167215f, 11.2084268332f, -0.5726901293f,
	-7.8703490496f, 252.8865598440f, 11.5879274607f, -0.6041382551f,
	-8.0520004034f, 252.7176467180f, 11.9707077742f, -0.6363540888f,
	-8.2319132090f, 252.5444945097f, 12.3567506075f, -0.6693319082f,
	-8.4100931883f, 252.3671203852f, 12.7460387945f, -0.7030659914f,
	-8.5865460634f, 252.1855415106f, 13.1385551691f, -0.7375506163f,
	-8.7612775564f, 251.9997750521f, 13.5342825651f, -0.7727800608f,
	-8.9342933893f, 251.8098381758f, 13.9332038164f, -0.8087486029f,
	-9.1055992842f, 251.6157480478f, 14.3353017569f, -0.8454505205f,
	-9.2752009630f, 251.4175218344f, 14.7405592203f, -0.8828800917f,
	-9.4431041479f, 251.2151767015f, 15.1489590406f, -0.9210315943f,
	-9.6093145609f, 251.0087298155f, 15.5604840517f, -0.9598993063f,
	-9.7738379240f, 250.7981983423f, 15.9751170874f, -0.9994775057f,
	-9.9366799593f, 250.5835994482f, 16.3928409815f, -1.0397604704f,
	-10.0978463888f, 250.3649502993f, 16.8136385679f, -1.0807424784f,
	-10.2573429346f, 250.1422680616f, 17.2374926805f, -1.1224178076f,
	-10.4151753187f, 249.9155699015f, 17.6643861532f, -1.1647807360f,
	-10.5713492632f, 249.6848729849f, 18.0943018198f, -1.2078255415f,
	-10.7258704901f, 249.4501944780f, 18.5272225142f, -1.2515465021f,
	-10.8787447214f, 249.2115515471f, 18.9631310701f, -1.2959378958f,
	-11.0299776793f, 248.9689613581f, 19.4020103216f, -1.3409940004f,
	-11.1795750856f, 248.7224410772f, 19.8438431025f, -1.3867090940f,
	-11.3275426626f, 248.4720078707f, 20.2886122465f, -1.4330774546f,
	-11.4738861322f, 248.2176789045f, 20.7363005877f, -1.4800933599f,
	-11.6186112165f, 247.9594713449f, 21.1868909597f, -1.5277510881f,
	-11.7617236376f, 247.6974023581f, 21.6403661966f, -1.5760449171f,
	-11.9032291174f, 247.4314891100f, 22.0967091322f, -1.6249691248f,
	-12.0431333780f, 247.1617487669f, 22.5559026003f, -1.6745179892f,
	-12.1814421415f, 246.8881984949f, 23.0179294348f, -1.7246857882f,
	-12.3181611300f, 246.6108554602f, 23.4827724695f, -1.7754667997f,
	-12.4532960653f, 246.3297368288f, 23.9504145384f, -1.8268553019f,
	-12.5868526697f, 246.0448597670f, 24.4208384752f, -1.8788455725f,
	-12.7188366652f, 245.7562414408f, 24.8940271139f, -1.9314318895f,
	-12.8492537737f, 245.4638990164f, 25.3699632883f, -1.9846085310f,
	-12.9781097174f, 245.1678496599f, 25.8486298323f, -2.0383697748f,
	-13.1054102182f, 244.8681105375f, 26.3300095797f, -2.0927098989f,
	-13.2311609983f, 244.5646988153f, 26.8140853643f, -2.1476231813f,
	-13.3553677797f, 244.2576316595f, 27.3008400202f, -2.2031039000f,
	-13.4780362844f, 243.9469262362f, 27.7902563810f, -2.2591463327f,
	-13.5991722345f, 243.6325997114f, 28.2823172808f, -2.3157447577f,
	-13.7187813520f, 243.3146692514f, 28.7770055532f, -2.3728934526f,
	-13.8368693590f, 242.9931520224f, 29.2743040323f, -2.4305866957f,
	-13.9534419775f, 242.6680651903f, 29.7741955519f, -2.4888187647f,
	-14.0685049295f, 242.3394259214f, 30.2766629457f, -2.5475839376f,
	-14.1820639372f, 242.0072513819f, 30.7816890478f, -2.6068764925f,
	-14.2941247225f, 241.6715587378f, 31.2892566919f, -2.6666907072f,
	-14.4046930075f, 241.3323651552f, 31.7993487120f, -2.7270208597f,
	-14.5137745142f, 240.9896878004f, 32.3119479418f, -2.7878612280f,
	-14.6213749647f, 240.6435438395f, 32.8270372152f, -2.8492060900f,
	-14.7275000811f, 240.2939504385f, 33.3445993662f, -2.9110497236f,
	-14.8321555853f, 239.9409247637f, 33.8646172285f, -2.9733864069f,
	-14.9353471994f, 239.5844839811f, 34.3870736361f, -3.0362104177f,
	-15.0370806456f, 239.2246452570f, 34.9119514227f, -3.0995160341f,
	-15.1373616457f, 238.8614257574f, 35.4392334223f, -3.1632975340f,
	-15.2361959219f, 238.4948426485f, 35.9689024687f, -3.2275491953f,
	-15.3335891962f, 238.1249130964f, 36.5009413958f, -3.2922652960f,
	-15.4295471907f, 237.7516542673f, 37.0353330374f, -3.3574401140f,
	-15.5240756273f, 237.3750833273f, 37.5720602274f, -3.4230679274f,
	-15.6171802282f, 236.9952174425f, 38.1111057997f, -3.4891430140f,
	-15.7088667154f, 236.6120737791f, 38.6524525881f, -3.5556596518f,
	-15.7991408110f, 236.2256695032f, 39.1960834265f, -3.6226121187f,
	-15.8880082369f, 235.8360217810f, 39.7419811487f, -3.6899946928f,
	-15.9754747152f, 235.4431477785f, 40.2901285887f, -3.7578016520f,
	-16.0615459681f, 235.0470646620f, 40.8405085802f, -3.8260272741f,
	-16.1462277174f, 234.6477895975f, 41.3931039572f, -3.8946658373f,
	-16.2295256853f, 234.2453397512f, 41.9478975534f, -3.9637116194f,
	-16.3114455938f, 233.8397322893f, 42.5048722029f, -4.0331588984f,
	-16.3919931650f, 233.4309843779f, 43.0640107393f, -4.1030019522f,
	-16.4711741209f, 233.0191131830f, 43.6252959967f, -4.1732350588f,
	-16.5489941835f, 232.6041358709f, 44.1887108088f, -4.2438524961f,
	-16.6254590750f, 232.1860696077f, 44.7542380095f, -4.3148485422f,
	-16.7005745173f, 231.7649315596f, 45.3218604326f, -4.3862174749f,
	-16.7743462324f, 231.3407388926f, 45.8915609121f, -4.4579535723f,
	-16.8467799425f, 230.9135087729f, 46.4633222818f, -4.5300511122f,
	-16.9178813696f, 230.4832583666f, 47.0371273756f, -4.6025043726f,
	-16.9876562357f, 230.0500048399f, 47.6129590273f, -4.6753076315f,
	-17.0561102629f, 229.6137653589f, 48.1908000708f, -4.7484551668f,
	-17.1232491732f, 229.1745570898f, 48.7706333399f, -4.8219412565f,
	-17.1890786886f, 228.7323971987f, 49.3524416685f, -4.8957601786f,
	-17.2536045313f, 228.2873028517f, 49.9362078905f, -4.9699062109f,
	-17.3168324232f, 227.8392912149f, 50.5219148397f, -5.0443736315f,
	-17.3787680864f, 227.3883794546f, 51.1095453501f, -5.1191567183f,
	-17.4394172430f, 226.9345847368f, 51.6990822554f, -5.1942497492f,
	-17.4987856150f, 226.4779242277f, 52.2905083895f, -5.2696470022f,
	-17.5568789244f, 226.0184150934f, 52.8838065863f, -5.3453427553f,
	-17.6137028933f, 225.5560745001f, 53.4789596796f, -5.4213312864f,
	-17.6692632437f, 225.0909196138f, 54.0759505033f, -5.4976068735f,
	-17.7235656977f, 224.6229676008f, 54.6747618914f, -5.5741637945f,
	-17.7766159773f, 224.1522356272f, 55.2753766775f, -5.6509963274f,
	-17.8284198046f, 223.6787408590f, 55.8777776957f, -5.7280987501f,
	-17.8789829016f, 223.2025004625f, 56.4819477797f, -5.8054653406f,
	-17.9283109903f, 222.7235316038f, 57.0878697634f, -5.8830903769f,
	-17.9764097929f, 222.2418514490f, 57.6955264807f, -5.9609681368f,
	-18.0232850313f, 221.7574771643f, 58.3049007654f, -6.0390928984f,
	-18.0689424276f, 221.2704259157f, 58.9159754515f, -6.1174589396f,
	-18.1133877039f, 220.7807148695f, 59.5287333727f, -6.1960605383f,
	-18.1566265821f, 220.2883611917f, 60.1431573629f, -6.2748919725f,
	-18.1986647844f, 219.7933820486f, 60.7592302561f, -6.3539475203f,
	-18.2395080328f, 219.2957946062f, 61.3769348860f, -6.4332214594f,
	-18.2791620493f, 218.7956160307f, 61.9962540865f, -6.5127080679f,
	-18.3176325560f, 218.2928634882f, 62.6171706915f, -6.5924016237f,
	-18.3549252748f, 217.7875541449f, 63.2396675348f, -6.6722964048f,
	-18.3910459280f, 217.2797051668f, 63.8637274504f, -6.7523866892f,
	-18.4260002375f, 216.7693337202f, 64.4893332720f, -6.8326667547f,
	-18.4597939253f, 216.2564569712f, 65.1164678335f, -6.9131308794f,
	-18.4924327135f, 215.7410920858f, 65.7451139688f, -6.9937733412f,
	-18.5239223242f, 215.2232562304f, 66.3752545118f, -7.0745884180f,
	-18.5542684793f, 214.7029665709f, 67.0068722963f, -7.1555703878f,
	-18.5834769011f, 214.1802402735f, 67.6399501562f, -7.2367135286f,
	-18.6115533113f, 213.6550945044f, 68.2744709253f, -7.3180121183f,
	-18.6385034323f, 213.1275464296f, 68.9104174376f, -7.3994604349f,
	-18.6643329859f, 212.5976132154f, 69.5477725267f, -7.4810527563f,
	-18.6890476942f, 212.0653120279f, 70.1865190268f, -7.5627833605f,
	-18.7126532793f, 211.5306600332f, 70.8266397715f, -7.6446465254f,
	-18.7351554632f, 210.9936743975f, 71.4681175947f, -7.7266365290f,
	-18.7565599680f, 210.4543722868f, 72.1109353304f, -7.8087476492f,
	-18.7768725157f, 209.9127708673f, 72.7550758123f, -7.8909741640f,
	-18.7960988283f, 209.3688873053f, 73.4005218744f, -7.9733103514f,
	-18.8142446280f, 208.8227387667f, 74.0472563505f, -8.0557504892f,
	-18.8313156366f, 208.2743424177f, 74.6952620745f, -8.1382888556f,
	-18.8473175764f, 207.7237154245f, 75.3445218801f, -8.2209197283f,
	-18.8622561693f, 207.1708749533f, 75.9950186014f, -8.3036373854f,
	-18.8761371374f, 206.6158381701f, 76.6467350721f, -8.3864361048f,
	-18.8889662027f, 206.0586222410f, 77.2996541262f, -8.4693101645f,
	-18.9007490873f, 205.4992443323f, 77.9537585974f, -8.5522538424f,
	-18.9114915133f, 204.9377216101f, 78.6090313196f, -8.6352614164f,
	-18.9211992025f, 204.3740712404f, 79.2654551268f, -8.7183271646f,
	-18.9298778772f, 203.8083103895f, 79.9230128527f, -8.8014453650f,
	-18.9375332594f, 203.2404562235f, 80.5816873312f, -8.8846102953f,
	-18.9441710711f, 202.6705259085f, 81.2414613962f, -8.9678162336f,
	-18.9497970343f, 202.0985366106f, 81.9023178816f, -9.0510574579f,
	-18.9544168711f, 201.5245054960f, 82.5642396212f, -9.1343282461f,
	-18.9580363035f, 200.9484497309f, 83.2272094488f, -9.2176228762f,
	-18.9606610537f, 200.3703864813f, 83.8912101984f, -9.3009356260f,
	-18.9622968435f, 199.7903329134f, 84.5562247038f, -9.3842607737f,
	-18.9629493952f, 199.2083061934f, 85.2222357988f, -9.4675925970f,
	-18.9626244307f, 198.6243234873f, 85.8892263174f, -9.5509253740f,
	-18.9613276720f, 198.0384019613f, 86.5571790934f, -9.6342533827f,
	-18.9590648413f, 197.4505587816f, 87.2260769606f, -9.7175709009f,
	-18.9558416605f, 196.8608111143f, 87.8959027529f, -9.8008722067f,
	-18.9516638517f, 196.2691761255f, 88.5666393042f, -9.8841515779f,
	-18.9465371370f, 195.6756709814f, 89.2382694483f, -9.9674032927f,
	-18.9404672384f, 195.0803128481f, 89.9107760191f, -10.0506216288f,
	-18.9334598780f, 194.4831188917f, 90.5841418505f, -10.1338008642f,
	-18.9255207777f, 193.8841062784f, 91.2583497763f, -10.2169352770f,
	-18.9166556597f, 193.2832921743f, 91.9333826303f, -10.3000191450f,
	-18.9068702459f, 192.6806937456f, 92.6092232466f, -10.3830467463f,
	-18.8961702585f, 192.0763281584f, 93.2858544588f, -10.4660123587f,
	-18.8845614195f, 191.4702125788f, 93.9632591009f, -10.5489102602f,
	-18.8720494509f, 190.8623641729f, 94.6414200068f, -10.6317347288f,
	-18.8586400747f, 190.2528001070f, 95.3203200102f, -10.7144800425f,
	-18.8443390131f, 189.6415375471f, 95.9999419451f, -10.7971404791f,
	-18.8291519880f, 189.0285936594f, 96.6802686453f, -10.8797103167f,
	-18.8130847216f, 188.4139856100f, 97.3612829447f, -10.9621838331f,
	-18.7961429358f, 187.7977305651f, 98.0429676771f, -11.0445553064f,
	-18.7783323526f, 187.1798456907f, 98.7253056765f, -11.1268190145f,
	-18.7596586943f, 186.5603481531f, 99.4082797766f, -11.2089692354f,
	-18.7401276827f, 185.9392551184f, 100.0918728113f, -11.2910002470f,
	-18.7197450399f, 185.3165837526f, 100.7760676146f, -11.3729063272f,
	-18.6985164881f, 184.6923512220f, 101.4608470201f, -11.4546817541f,
	-18.6764477491f, 184.0665746927f, 102.1461938620f, -11.5363208055f,
	-18.6535445452f, 183.4392713308f, 102.8320909739f, -11.6178177595f,
	-18.6298125982f, 182.8104583025f, 103.5185211897f, -11.6991668940f,
	-18.6052576303f, 182.1801527739f, 104.2054673433f, -11.7803624868f,
	-18.5798853636f, 181.5483719110f, 104.8929122686f, -11.8613988161f,
	-18.5537015200f, 180.9151328802f, 105.5808387995f, -11.9422701597f,
	-18.5267118216f, 180.2804528475f, 106.2692297697f, -12.0229707956f,
	-18.4989219904f, 179.6443489790f, 106.9580680132f, -12.1034950018f,
	-18.4703377485f, 179.0068384409f, 107.6473363638f, -12.1838370562f,
	-18.4409648180f, 178.3679383993f, 108.3370176554f, -12.2639912367f,
	-18.4108089209f, 177.7276660204f, 109.0270947218f, -12.3439518213f,
	-18.3798757792f, 177.0860384703f, 109.7175503969f, -12.4237130880f,
	-18.3481711149f, 176.4430729151f, 110.4083675146f, -12.5032693148f,
	-18.3157006502f, 175.7987865210f, 111.0995289087f, -12.5826147795f,
	-18.2824701071f, 175.1531964540f, 111.7910174131f, -12.6617437601f,
	-18.2484852076f, 174.5063198805f, 112.4828158617f, -12.7406505346f,
	-18.2137516737f, 173.8581739664f, 113.1749070883f, -12.8193293810f,
	-18.1782752275f, 173.2087758780f, 113.8672739267f, -12.8977745771f,
	-18.1420615911f, 172.5581427813f, 114.5598992109f, -12.9759804010f,
	-18.1051164865f, 171.9062918425f, 115.2527657747f, -13.0539411306f,
	-18.0674456358f, 171.2532402277f, 115.9458564520f, -13.1316510439f,
	-18.0290547609f, 170.5990051031f, 116.6391540766f, -13.2091044188f,
	-17.9899495840f, 169.9436036348f, 117.3326414824f, -13.2862955332f,
	-17.9501358271f, 169.2870529890f, 118.0263015032f, -13.3632186651f,
	-17.9096192122f, 168.6293703318f, 118.7201169729f, -13.4398680925f,
	-17.8684054613f, 167.9705728292f, 119.4140707254f, -13.5162380934f,
	-17.8265002966f, 167.3106776476f, 120.1081455946f, -13.5923229456f,
	-17.7839094400f, 166.6497019529f, 120.8023244143f, -13.6681169271f,
	-17.7406386137f, 165.9876629114f, 121.4965900183f, -13.7436143160f,
	-17.6966935396f, 165.3245776892f, 122.1909252405f, -13.8188093901f,
	-17.6520799398f, 164.6604634523f, 122.8853129148f, -13.8936964273f,
	-17.6068035364f, 163.9953373671f, 123.5797358751f, -13.9682697058f,
	-17.5608700514f, 163.3292165995f, 124.2741769552f, -14.0425235033f,
	-17.5142852068f, 162.6621183157f, 124.9686189890f, -14.1164520979f,
	-17.4670547247f, 161.9940596819f, 125.6630448103f, -14.1900497675f,
	-17.4191843271f, 161.3250578642f, 126.3574372530f, -14.2633107901f,
	-17.3706797361f, 160.6551300287f, 127.0517791510f, -14.3362294436f,
	-17.3215466738f, 159.9842933416f, 127.7460533381f, -14.4088000059f,
	-17.2717908621f, 159.3125649691f, 128.4402426481f, -14.4810167551f,
	-17.2214180231f, 158.6399620771f, 129.1343299150f, -14.5528739691f,
	-17.1704338789f, 157.9665018320f, 129.8282979727f, -14.6243659258f,
	-17.1188441515f, 157.2922013998f, 130.5221296549f, -14.6954869032f,
	-17.0666545630f, 156.6170779467f, 131.2158077955f, -14.7662311792f,
	-17.0138708353f, 155.9411486387f, 131.9093152285f, -14.8365930319f,
	-16.9604986906f, 155.2644306421f, 132.6026347876f, -14.9065667391f,
	-16.9065438509f, 154.5869411230f, 133.2957493067f, -14.9761465788f,
	-16.8520120382f, 153.9086972475f, 133.9886416197f, -15.0453268290f,
	-16.7969089746f, 153.2297161818f, 134.6812945604f, -15.1141017675f,
	-16.7412403822f, 152.5500150919f, 135.3736909628f, -15.1824656725f,
	-16.6850119829f, 151.8696111441f, 136.0658136606f, -15.2504128218f,
	-16.6282294989f, 151.1885215044f, 136.7576454878f, -15.3179374933f,
	-16.5708986521f, 150.5067633390f, 137.4491692781f, -15.3850339651f,
	-16.5130251646f, 149.8243538141f, 138.1403678656f, -15.4516965151f,
	-16.4546147585f, 149.1413100958f, 138.8312240839f, -15.5179194212f,
	-16.3956731558f, 148.4576493502f, 139.5217207670f, -15.5836969614f,
	-16.3362060785f, 147.7733887434f, 140.2118407488f, -15.6490234137f,
	-16.2762192488f, 147.0885454416f, 140.9015668631f, -15.7138930559f,
	-16.2157183886f, 146.4031366110f, 141.5908819437f, -15.7783001661f,
	-16.1547092199f, 145.7171794176f, 142.2797688246f, -15.8422390223f,
	-16.0931974649f, 145.0306910276f, 142.9682103395f, -15.9057039022f,
	-16.0311888456f, 144.3436886072f, 143.6561893225f, -15.9686890841f,
	-15.9686890841f, 143.6561893225f, 144.3436886072f, -16.0311888456f,
	-15.9057039022f, 142.9682103395f, 145.0306910276f, -16.0931974649f,
	-15.8422390223f, 142.2797688246f, 145.7171794176f, -16.1547092199f,
	-15.7783001661f, 141.5908819437f, 146.4031366110f, -16.2157183886f,
	-15.7138930559f, 140.9015668631f, 147.0885454416f, -16.2762192488f,
	-15.6490234137f, 140.2118407488f, 147.7733887434f, -16.3362060785f,
	-15.5836969614f, 139.5217207670f, 148.4576493502f, -16.3956731558f,
	-15.5179194212f, 138.8312240839f, 149.1413100958f, -16.4546147585f,
	-15.4516965151f, 138.1403678656f, 149.8243538141f, -16.5130251646f,
	-15.3850339651f, 137.4491692781f, 150.5067633390f, -16.5708986521f,
	-15.3179374933f, 136.7576454878f, 151.1885215044f, -16.6282294989f,
	-15.2504128218f, 136.0658136606f, 151.8696111441f, -16.6850119829f,
	-15.1824656725f, 135.3736909628f, 152.5500150919f, -16.7412403822f,
	-15.1141017675f, 134.6812945604f, 153.2297161818f, -16.7969089746f,
	-15.0453268290f, 133.9886416197f, 153.9086972475f, -16.8520120382f,
	-14.9761465788f, 133.2957493067f, 154.5869411230f, -16.9065438509f,
	-14.9065667391f, 132.6026347876f, 155.2644306421f, -16.9604986906f,
	-14.8365930319f, 131.9093152285f, 155.9411486387f, -17.0138708353f,
	-14.7662311792f, 131.2158077955f, 156.6170779467f, -17.0666545630f,
	-14.6954869032f, 130.5221296549f, 157.2922013998f, -17.1188441515f,
	-14.6243659258f, 129.8282979727f, 157.9665018320f, -17.1704338789f,
	-14.5528739691f, 129.1343299150f, 158.6399620771f, -17.2214180231f,
	-14.4810167551f, 128.4402426481f, 159.3125649691f, -17.2717908621f,
	-14.4088000059f, 127.7460533381f, 159.9842933416f, -17.3215466738f,
	-14.3362294436f, 127.0517791510f, 160.6551300287f, -17.3706797361f,
	-14.2633107901f, 126.3574372530f, 161.3250578642f, -17.4191843271f,
	-14.1900497675f, 125.6630448103f, 161.9940596819f, -17.4670547247f,
	-14.1164520979f, 124.9686189890f, 162.6621183157f, -17.5142852068f,
	-14.0425235033f, 124.2741769552f, 163.3292165995f, -17.5608700514f,
	-13.9682697058f, 123.5797358751f, 163.9953373671f, -17.6068035364f,
	-13.8936964273f, 122.8853129148f, 164.6604634523f, -17.6520799398f,
	-13.8188093901f, 122.1909252405f, 165.3245776892f, -17.6966935396f,
	-13.7436143160f, 121.4965900183f, 165.9876629114f, -17.7406386137f,
	-13.6681169271f, 120.8023244143f, 166.6497019529f, -17.7839094400f,
	-13.5923229456f, 120.1081455946f, 167.3106776476f, -17.8265002966f,
	-13.5162380934f, 119.4140707254f, 167.9705728292f, -17.8684054613f,
	-13.4398680925f, 118.7201169729f, 168.6293703318f, -17.9096192122f,
	-13.3632186651f, 118.0263015032f, 169.2870529890f, -17.9501358271f,
	-13.2862955332f, 117.3326414824f, 169.9436036348f, -17.9899495840f,
	-13.2091044188f, 116.6391540766f, 170.5990051031f, -18.0290547609f,
	-13.1316510439f, 115.9458564520f, 171.2532402277f, -18.0674456358f,
	-13.0539411306f, 115.2527657747f, 171.9062918425f, -18.1051164865f,
	-12.9759804010f, 114.5598992109f, 172.5581427813f, -18.1420615911f,
	-12.8977745771f, 113.8672739267f, 173.2087758780f, -18.1782752275f,
	-12.8193293810f, 113.1749070883f, 173.8581739664f, -18.2137516737f,
	-12.7406505346f, 112.4828158617f, 174.5063198805f, -18.2484852076f,
	-12.6617437601f, 111.7910174131f, 175.1531964540f, -18.2824701071f,
	-12.5826147795f, 111.0995289087f, 175.7987865210f, -18.3157006502f,
	-12.5032693148f, 110.4083675146f, 176.4430729151f, -18.3481711149f,
	-12.4237130880f, 109.7175503969f, 177.0860384703f, -18.3798757792f,
	-12.3439518213f, 109.0270947218f, 177.7276660204f, -18.4108089209f,
	-12.2639912367f, 108.3370176554f, 178.3679383993f, -18.4409648180f,
	-12.1838370562f, 107.6473363638f, 179.0068384409f, -18.4703377485f,
	-12.1034950018f, 106.9580680132f, 179.6443489790f, -18.4989219904f,
	-12.0229707956f, 106.2692297697f, 180.2804528475f, -18.5267118216f,
	-11.9422701597f, 105.5808387995f, 180.9151328802f, -18.5537015200f,
	-11.8613988161f, 104.8929122686f, 181.5483719110f, -18.5798853636f,
	-11.7803624868f, 104.2054673433f, 182.1801527739f, -18.6052576303f,
	-11.6991668940f, 103.5185211897f, 182.8104583025f, -18.6298125982f,
	-11.6178177595f, 102.8320909739f, 183.4392713308f, -18.6535445452f,
	-11.5363208055f, 102.1461938620f, 184.0665746927f, -18.6764477491f,
	-11.4546817541f, 101.4608470201f, 184.6923512220f, -18.6985164881f,
	-11.3729063272f, 100.7760676146f, 185.3165837526f, -18.7197450399f,
	-11.2910002470f, 100.0918728113f, 185.9392551184f, -18.7401276827f,
	-11.2089692354f, 99.4082797766f, 186.5603481531f, -18.7596586943f,
	-11.1268190145f, 98.7253056765f, 187.1798456907f, -18.7783323526f,
	-11.0445553064f, 98.0429676771f, 187.7977305651f, -18.7961429358f,
	-10.9621838331f, 97.3612829447f, 188.4139856100f, -18.8130847216f,
	-10.8797103167f, 96.6802686453f, 189.0285936594f, -18.8291519880f,
	-10.7971404791f, 95.9999419451f, 189.6415375471f, -18.8443390131f,
	-10.7144800425f, 95.3203200102f, 190.2528001070f, -18.8586400747f,
	-10.6317347288f, 94.6414200068f, 190.8623641729f, -18.8720494509f,
	-10.5489102602f, 93.9632591009f, 191.4702125788f, -18.8845614195f,
	-10.4660123587f, 93.2858544588f, 192.0763281584f, -18.8961702585f,
	-10.3830467463f, 92.6092232466f, 192.6806937456f, -18.9068702459f,
	-10.3000191450f, 91.9333826303f, 193.2832921743f, -18.9166556597f,
	-10.2169352770f, 91.2583497763f, 193.8841062784f, -18.9255207777f,
	-10.1338008642f, 90.5841418505f, 194.4831188917f, -18.9334598780f,
	-10.0506216288f, 89.9107760191f, 195.0803128481f, -18.9404672384f,
	-9.9674032927f, 89.2382694483f, 195.6756709814f, -18.9465371370f,
	-9.8841515779f, 88.5666393042f, 196.2691761255f, -18.9516638517f,
	-9.8008722067f, 87.8959027529f, 196.8608111143f, -18.9558416605f,
	-9.7175709009f, 87.2260769606f, 197.4505587816f, -18.9590648413f,
	-9.6342533827f, 86.5571790934f, 198.0384019613f, -18.9613276720f,
	-9.5509253740f, 85.8892263174f, 198.6243234873f, -18.9626244307f,
	-9.4675925970f, 85.2222357988f, 199.2083061934f, -18.9629493952f,
	-9.3842607737f, 84.5562247038f, 199.7903329134f, -18.9622968435f,
	-9.3009356260f, 83.8912101984f, 200.3703864813f, -18.9606610537f,
	-9.2176228762f, 83.2272094488f, 200.9484497309f, -18.9580363035f,
	-9.1343282461f, 82.5642396212f, 201.5245054960f, -18.9544168711f,
	-9.0510574579f, 81.9023178816f, 202.0985366106f, -18.9497970343f,
	-8.9678162336f, 81.2414613962f, 202.6705259085f, -18.9441710711f,
	-8.8846102953f, 80.5816873312f, 203.2404562235f, -18.9375332594f,
	-8.8014453650f, 79.9230128527f, 203.8083103895f, -18.9298778772f,
	-8.7183271646f, 79.2654551268f, 204.3740712404f, -18.9211992025f,
	-8.6352614164f, 78.6090313196f, 204.9377216101f, -18.9114915133f,
	-8.5522538424f, 77.9537585974f, 205.4992443323f, -18.9007490873f,
	-8.4693101645f, 77.2996541262f, 206.0586222410f, -18.8889662027f,
	-8.3864361048f, 76.6467350721f, 206.6158381701f, -18.8761371374f,
	-8.3036373854f, 75.9950186014f, 207.1708749533f, -18.8622561693f,
	-8.2209197283f, 75.3445218801f, 207.7237154245f, -18.8473175764f,
	-8.1382888556f, 74.6952620745f, 208.2743424177f, -18.8313156366f,
	-8.0557504892f, 74.0472563505f, 208.8227387667f, -18.8142446280f,
	-7.9733103514f, 73.4005218744f, 209.3688873053f, -18.7960988283f,
	-7.8909741640f, 72.7550758123f, 209.9127708673f, -18.7768725157f,
	-7.8087476492f, 72.1109353304f, 210.4543722868f, -18.7565599680f,
	-7.7266365290f, 71.4681175947f, 210.9936743975f, -18.7351554632f,
	-7.6446465254f, 70.8266397715f, 211.5306600332f, -18.7126532793f,
	-7.5627833605f, 70.1865190268f, 212.0653120279f, -18.6890476942f,
	-7.4810527563f, 69.5477725267f, 212.5976132154f, -18.6643329859f,
	-7.3994604349f, 68.9104174376f, 213.1275464296f, -18.6385034323f,
	-7.3180121183f, 68.2744709253f, 213.6550945044f, -18.6115533113f,
	-7.2367135286f, 67.6399501562f, 214.1802402735f, -18.5834769011f,
	-7.1555703878f, 67.0068722963f, 214.7029665709f, -18.5542684793f,
	-7.0745884180f, 66.3752545118f, 215.2232562304f, -18.5239223242f,
	-6.9937733412f, 65.7451139688f, 215.7410920858f, -18.4924327135f,
	-6.9131308794f, 65.1164678335f, 216.2564569712f, -18.4597939253f,
	-6.8326667547f, 64.4893332720f, 216.7693337202f, -18.4260002375f,
	-6.7523866892f, 63.8637274504f, 217.2797051668f, -18.3910459280f,
	-6.6722964048f, 63.2396675348f, 217.7875541449f, -18.3549252748f,
	-6.5924016237f, 62.6171706915f, 218.2928634882f, -18.3176325560f,
	-6.5127080679f, 61.9962540865f, 218.7956160307f, -18.2791620493f,
	-6.4332214594f, 61.3769348860f, 219.2957946062f, -18.2395080328f,
	-6.3539475203f, 60.7592302561f, 219.7933820486f, -18.1986647844f,
	-6.2748919725f, 60.1431573629f, 220.2883611917f, -18.1566265821f,
	-6.1960605383f, 59.5287333727f, 220.7807148695f, -18.1133877039f,
	-6.1174589396f, 58.9159754515f, 221.2704259157f, -18.0689424276f,
	-6.0390928984f, 58.3049007654f, 221.7574771643f, -18.0232850313f,
	-5.9609681368f, 57.6955264807f, 222.2418514490f, -17.9764097929f,
	-5.8830903769f, 57.0878697634f, 222.7235316038f, -17.9283109903f,
	-5.8054653406f, 56.4819477797f, 223.2025004625f, -17.8789829016f,
	-5.7280987501f, 55.8777776957f, 223.6787408590f, -17.8284198046f,
	-5.6509963274f, 55.2753766775f, 224.1522356272f, -17.7766159773f,
	-5.5741637945f, 54.6747618914f, 224.6229676008f, -17.7235656977f,
	-5.4976068735f, 54.0759505033f, 225.0909196138f, -17.6692632437f,
	-5.4213312864f, 53.4789596796f, 225.5560745001f, -17.6137028933f,
	-5.3453427553f, 52.8838065863f, 226.0184150934f, -17.5568789244f,
	-5.2696470022f, 52.2905083895f, 226.4779242277f, -17.4987856150f,
	-5.1942497492f, 51.6990822554f, 226.9345847368f, -17.4394172430f,
	-5.1191567183f, 51.1095453501f, 227.3883794546f, -17.3787680864f,
	-5.0443736315f, 50.5219148397f, 227.8392912149f, -17.3168324232f,
	-4.9699062109f, 49.9362078905f, 228.2873028517f, -17.2536045313f,
	-4.8957601786f, 49.3524416685f, 228.7323971987f, -17.1890786886f,
	-4.8219412565f, 48.7706333399f, 229.1745570898f, -17.1232491732f,
	-4.7484551668f, 48.1908000708f, 229.6137653589f, -17.0561102629f,
	-4.6753076315f, 47.6129590273f, 230.0500048399f, -16.9876562357f,
	-4.6025043726f, 47.0371273756f, 230.4832583666f, -16.9178813696f,
	-4.5300511122f, 46.4633222818f, 230.9135087729f, -16.8467799425f,
	-4.4579535723f, 45.8915609121f, 231.3407388926f, -16.7743462324f,
	-4.3862174749f, 45.3218604326f, 231.7649315596f, -16.7005745173f,
	-4.3148485422f, 44.7542380095f, 232.1860696077f, -16.6254590750f,
	-4.2438524961f, 44.1887108088f, 232.6041358709f, -16.5489941835f,
	-4.1732350588f, 43.6252959967f, 233.0191131830f, -16.4711741209f,
	-4.1030019522f, 43.0640107393f, 233.4309843779f, -16.3919931650f,
	-4.0331588984f, 42.5048722029f, 233.8397322893f, -16.3114455938f,
	-3.9637116194f, 41.9478975534f, 234.2453397512f, -16.2295256853f,
	-3.8946658373f, 41.3931039572f, 234.6477895975f, -16.1462277174f,
	-3.8260272741f, 40.8405085802f, 235.0470646620f, -16.0615459681f,
	-3.7578016520f, 40.2901285887f, 235.4431477785f, -15.9754747152f,
	-3.6899946928f, 39.7419811487f, 235.8360217810f, -15.8880082369f,
	-3.6226121187f, 39.1960834265f, 236.2256695032f, -15.7991408110f,
	-3.5556596518f, 38.6524525881f, 236.6120737791f, -15.7088667154f,
	-3.4891430140f, 38.1111057997f, 236.9952174425f, -15.6171802282f,
	-3.4230679274f, 37.5720602274f, 237.3750833273f, -15.5240756273f,
	-3.3574401140f, 37.0353330374f, 237.7516542673f, -15.4295471907f,
	-3.2922652960f, 36.5009413958f, 238.1249130964f, -15.3335891962f,
	-3.2275491953f, 35.9689024687f, 238.4948426485f, -15.2361959219f,
	-3.1632975340f, 35.4392334223f, 238.8614257574f, -15.1373616457f,
	-3.0995160341f, 34.9119514227f, 239.2246452570f, -15.0370806456f,
	-3.0362104177f, 34.3870736361f, 239.5844839811f, -14.9353471994f,
	-2.9733864069f, 33.8646172285f, 239.9409247637f, -14.8321555853f,
	-2.9110497236f, 33.3445993662f, 240.2939504385f, -14.7275000811f,
	-2.8492060900f, 32.8270372152f, 240.6435438395f, -14.6213749647f,
	-2.7878612280f, 32.3119479418f, 240.9896878004f, -14.5137745142f,
	-2.7270208597f, 31.7993487120f, 241.3323651552f, -14.4046930075f,
	-2.6666907072f, 31.2892566919f, 241.6715587378f, -14.2941247225f,
	-2.6068764925f, 30.7816890478f, 242.0072513819f, -14.1820639372f,
	-2.5475839376f, 30.2766629457f, 242.3394259214f, -14.0685049295f,
	-2.4888187647f, 29.7741955519f, 242.6680651903f, -13.9534419775f,
	-2.4305866957f, 29.2743040323f, 242.9931520224f, -13.8368693590f,
	-2.3728934526f, 28.7770055532f, 243.3146692514f, -13.7187813520f,
	-2.3157447577f, 28.2823172808f, 243.6325997114f, -13.5991722345f,
	-2.2591463327f, 27.7902563810f, 243.9469262362f, -13.4780362844f,
	-2.2031039000f, 27.3008400202f, 244.2576316595f, -13.3553677797f,
	-2.1476231813f, 26.8140853643f, 244.5646988153f, -13.2311609983f,
	-2.0927098989f, 26.3300095797f, 244.8681105375f, -13.1054102182f,
	-2.0383697748f, 25.8486298323f, 245.1678496599f, -12.9781097174f,
	-1.9846085310f, 25.3699632883f, 245.4638990164f, -12.8492537737f,
	-1.9314318895f, 24.8940271139f, 245.7562414408f, -12.7188366652f,
	-1.8788455725f, 24.4208384752f, 246.0448597670f, -12.5868526697f,
	-1.8268553019f, 23.9504145384f, 246.3297368288f, -12.4532960653f,
	-1.7754667997f, 23.4827724695f, 246.6108554602f, -12.3181611300f,
	-1.7246857882f, 23.0179294348f, 246.8881984949f, -12.1814421415f,
	-1.6745179892f, 22.5559026003f, 247.1617487669f, -12.0431333780f,
	-1.6249691248f, 22.0967091322f, 247.4314891100f, -11.9032291174f,
	-1.5760449171f, 21.6403661966f, 247.6974023581f, -11.7617236376f,
	-1.5277510881f, 21.1868909597f, 247.9594713449f, -11.6186112165f,
	-1.4800933599f, 20.7363005877f, 248.2176789045f, -11.4738861322f,
	-1.4330774546f, 20.2886122465f, 248.4720078707f, -11.3275426626f,
	-1.3867090940f, 19.8438431025f, 248.7224410772f, -11.1795750856f,
	-1.3409940004f, 19.4020103216f, 248.9689613581f, -11.0299776793f,
	-1.2959378958f, 18.9631310701f, 249.2115515471f, -10.8787447214f,
	-1.2515465021f, 18.5272225142f, 249.4501944780f, -10.7258704901f,
	-1.2078255415f, 18.0943018198f, 249.6848729849f, -10.5713492632f,
	-1.1647807360f, 17.6643861532f, 249.9155699015f, -10.4151753187f,
	-1.1224178076f, 17.2374926805f, 250.1422680616f, -10.2573429346f,
	-1.0807424784f, 16.8136385679f, 250.3649502993f, -10.0978463888f,
	-1.0397604704f, 16.3928409815f, 250.5835994482f, -9.9366799593f,
	-0.9994775057f, 15.9751170874f, 250.7981983423f, -9.7738379240f,
	-0.9598993063f, 15.5604840517f, 251.0087298155f, -9.6093145609f,
	-0.9210315943f, 15.1489590406f, 251.2151767015f, -9.4431041479f,
	-0.8828800917f, 14.7405592203f, 251.4175218344f, -9.2752009630f,
	-0.8454505205f, 14.3353017569f, 251.6157480478f, -9.1055992842f,
	-0.8087486029f, 13.9332038164f, 251.8098381758f, -8.9342933893f,
	-0.7727800608f, 13.5342825651f, 251.9997750521f, -8.7612775564f,
	-0.7375506163f, 13.1385551691f, 252.1855415106f, -8.5865460634f,
	-0.7030659914f, 12.7460387945f, 252.3671203852f, -8.4100931883f,
	-0.6693319082f, 12.3567506075f, 252.5444945097f, -8.2319132090f,
	-0.6363540888f, 11.9707077742f, 252.7176467180f, -8.0520004034f,
	-0.6041382551f, 11.5879274607f, 252.8865598440f, -7.8703490496f,
	-0.5726901293f, 11.2084268332f, 253.0512167215f, -7.6869534254f,
	-0.5420154333f, 10.8322230577f, 253.2116001844f, -7.5018078089f,
	-0.5121198893f, 10.4593333006f, 253.3676930666f, -7.3149064779f,
	-0.4830092192f, 10.0897747278f, 253.5194782019f, -7.1262437105f,
	-0.4546891451f, 9.7235645056f, 253.6669384241f, -6.9358137846f,
	-0.4271653891f, 9.3607198000f, 253.8100565672f, -6.7436109781f,
	-0.4004436731f, 9.0012577772f, 253.9488154650f, -6.5496295691f,
	-0.3745297194f, 8.6451956034f, 254.0831979513f, -6.3538638353f,
	-0.3494292498f, 8.2925504446f, 254.2131868601f, -6.1563080549f,
	-0.3251479864f, 7.9433394670f, 254.3387650251f, -5.9569565058f,
	-0.3016916513f, 7.5975798368f, 254.4599152803f, -5.7558034658f,
	-0.2790659666f, 7.2552887201f, 254.5766204596f, -5.5528432131f,
	-0.2572766542f, 6.9164832830f, 254.6888633966f, -5.3480700254f,
	-0.2363294363f, 6.5811806917f, 254.7966269255f, -5.1414781809f,
	-0.2162300348f, 6.2493981123f, 254.8998938799f, -4.9330619574f,
	-0.1969841719f, 5.9211527109f, 254.9986470938f, -4.7228156328f,
	-0.1785975695f, 5.5964616537f, 255.0928694010f, -4.5107334852f,
	-0.1610759497f, 5.2753421068f, 255.1825436354f, -4.2968097925f,
	-0.1444250345f, 4.9578112364f, 255.2676526308f, -4.0810388327f,
	-0.1286505461f, 4.6438862085f, 255.3481792212f, -3.8634148836f,
	-0.1137582064f, 4.3335841894f, 255.4241062403f, -3.6439322233f,
	-0.0997537374f, 4.0269223452f, 255.4954165220f, -3.4225851297f,
	-0.0866428614f, 3.7239178419f, 255.5620929003f, -3.1993678808f,
	-0.0744313002f, 3.4245878458f, 255.6241182089f, -2.9742747545f,
	-0.0631247759f, 3.1289495230f, 255.6814752817f, -2.7473000288f,
	-0.0527290106f, 2.8370200396f, 255.7341469526f, -2.5184379816f,
	-0.0432497263f, 2.5488165617f, 255.7821160555f, -2.2876828909f,
	-0.0346926451f, 2.2643562555f, 255.8253654242f, -2.0550290346f,
	-0.0270634890f, 1.9836562872f, 255.8638778925f, -1.8204706907f,
	-0.0203679800f, 1.7067338228f, 255.8976362944f, -1.5840021372f,
	-0.0146118402f, 1.4336060286f, 255.9266234636f, -1.3456176519f,
	-0.0098007917f, 1.1642900705f, 255.9508222342f, -1.1053115129f,
	-0.0059405565f, 0.8988031149f, 255.9702154398f, -0.8630779982f,
	-0.0030368567f, 0.6371623278f, 255.9847859144f, -0.6189113855f,
	-0.0010954142f, 0.3793848753f, 255.9945164919f, -0.3728059530f,
	-0.0001219511f, 0.1254879236f, 255.9993900061f, -0.1247559786f
};

/* *********************************************************** */

const mlib_f32 mlib_filters_s16f_bc2[] = {
	-0.2495119572f, 255.9995119572f, 0.2502439022f, -0.0002439022f,
	-0.7456119061f, 255.9956119061f, 0.7521908283f, -0.0021908283f,
	-1.2378227711f, 255.9878227711f, 1.2560737133f, -0.0060737133f,
	-1.7261559963f, 255.9761559963f, 1.7618811131f, -0.0118811131f,
	-2.2106230259f, 255.9606230259f, 2.2696015835f, -0.0196015835f,
	-2.6912353039f, 255.9412353039f, 2.7792236805f, -0.0292236805f,
	-3.1680042744f, 255.9180042744f, 3.2907359600f, -0.0407359600f,
	-3.6409413815f, 255.8909413815f, 3.8041269779f, -0.0541269779f,
	-4.1100580692f, 255.8600580692f, 4.3193852901f, -0.0693852901f,
	-4.5753657818f, 255.8253657818f, 4.8364994526f, -0.0864994526f,
	-5.0368759632f, 255.7868759632f, 5.3554580212f, -0.1054580212f,
	-5.4946000576f, 255.7446000576f, 5.8762495518f, -0.1262495518f,
	-5.9485495090f, 255.6985495090f, 6.3988626003f, -0.1488626003f,
	-6.3987357616f, 255.6487357616f, 6.9232857227f, -0.1732857227f,
	-6.8451702595f, 255.5951702595f, 7.4495074749f, -0.1995074749f,
	-7.2878644466f, 255.5378644466f, 7.9775164127f, -0.2275164127f,
	-7.7268297672f, 255.4768297672f, 8.5073010921f, -0.2573010921f,
	-8.1620776653f, 255.4120776653f, 9.0388500690f, -0.2888500690f,
	-8.5936195850f, 255.3436195850f, 9.5721518993f, -0.3221518993f,
	-9.0214669704f, 255.2714669704f, 10.1071951389f, -0.3571951389f,
	-9.4456312656f, 255.1956312656f, 10.6439683437f, -0.3939683437f,
	-9.8661239147f, 255.1161239147f, 11.1824600697f, -0.4324600697f,
	-10.2829563618f, 255.0329563618f, 11.7226588726f, -0.4726588726f,
	-10.6961400509f, 254.9461400509f, 12.2645533085f, -0.5145533085f,
	-11.1056864262f, 254.8556864262f, 12.8081319332f, -0.5581319332f,
	-11.5116069317f, 254.7616069317f, 13.3533833027f, -0.6033833027f,
	-11.9139130116f, 254.6639130116f, 13.9002959728f, -0.6502959728f,
	-12.3126161098f, 254.5626161098f, 14.4488584995f, -0.6988584995f,
	-12.7077276707f, 254.4577276707f, 14.9990594387f, -0.7490594387f,
	-13.0992591381f, 254.3492591381f, 15.5508873463f, -0.8008873463f,
	-13.4872219563f, 254.2372219563f, 16.1043307781f, -0.8543307781f,
	-13.8716275692f, 254.1216275692f, 16.6593782902f, -0.9093782902f,
	-14.2524874210f, 254.0024874210f, 17.2160184383f, -0.9660184383f,
	-14.6298129559f, 253.8798129559f, 17.7742397785f, -1.0242397785f,
	-15.0036156178f, 253.7536156178f, 18.3340308666f, -1.0840308666f,
	-15.3739068508f, 253.6239068508f, 18.8953802586f, -1.1453802586f,
	-15.7406980991f, 253.4906980991f, 19.4582765102f, -1.2082765102f,
	-16.1040008068f, 253.3540008068f, 20.0227081776f, -1.2727081776f,
	-16.4638264179f, 253.2138264179f, 20.5886638165f, -1.3386638165f,
	-16.8201863766f, 253.0701863766f, 21.1561319828f, -1.4061319828f,
	-17.1730921268f, 252.9230921268f, 21.7251012325f, -1.4751012325f,
	-17.5225551128f, 252.7725551128f, 22.2955601215f, -1.5455601215f,
	-17.8685867786f, 252.6185867786f, 22.8674972057f, -1.6174972057f,
	-18.2111985683f, 252.4611985683f, 23.4409010410f, -1.6909010410f,
	-18.5504019260f, 252.3004019260f, 24.0157601833f, -1.7657601833f,
	-18.8862082958f, 252.1362082958f, 24.5920631886f, -1.8420631886f,
	-19.2186291218f, 251.9686291218f, 25.1697986126f, -1.9197986126f,
	-19.5476758480f, 251.7976758480f, 25.7489550114f, -1.9989550114f,
	-19.8733599186f, 251.6233599186f, 26.3295209408f, -2.0795209408f,
	-20.1956927776f, 251.4456927776f, 26.9114849567f, -2.1614849567f,
	-20.5146858692f, 251.2646858692f, 27.4948356152f, -2.2448356152f,
	-20.8303506374f, 251.0803506374f, 28.0795614719f, -2.3295614719f,
	-21.1426985264f, 250.8926985264f, 28.6656510830f, -2.4156510830f,
	-21.4517409801f, 250.7017409801f, 29.2530930042f, -2.5030930042f,
	-21.7574894428f, 250.5074894428f, 29.8418757915f, -2.5918757915f,
	-22.0599553585f, 250.3099553585f, 30.4319880009f, -2.6819880009f,
	-22.3591501713f, 250.1091501713f, 31.0234181881f, -2.7734181881f,
	-22.6550853252f, 249.9050853252f, 31.6161549091f, -2.8661549091f,
	-22.9477722645f, 249.6977722645f, 32.2101867199f, -2.9601867199f,
	-23.2372224331f, 249.4872224331f, 32.8055021763f, -3.0555021763f,
	-23.5234472752f, 249.2734472752f, 33.4020898342f, -3.1520898342f,
	-23.8064582348f, 249.0564582348f, 33.9999382496f, -3.2499382496f,
	-24.0862667561f, 248.8362667561f, 34.5990359783f, -3.3490359783f,
	-24.3628842831f, 248.6128842831f, 35.1993715763f, -3.4493715763f,
	-24.6363222599f, 248.3863222599f, 35.8009335995f, -3.5509335995f,
	-24.9065921307f, 248.1565921307f, 36.4037106037f, -3.6537106037f,
	-25.1737053394f, 247.9237053394f, 37.0076911449f, -3.7576911449f,
	-25.4376733303f, 247.6876733303f, 37.6128637791f, -3.8628637791f,
	-25.6985075474f, 247.4485075474f, 38.2192170620f, -3.9692170620f,
	-25.9562194347f, 247.2062194347f, 38.8267395496f, -4.0767395496f,
	-26.2108204365f, 246.9608204365f, 39.4354197979f, -4.1854197979f,
	-26.4623219967f, 246.7123219967f, 40.0452463627f, -4.2952463627f,
	-26.7107355595f, 246.4607355595f, 40.6562077999f, -4.4062077999f,
	-26.9560725689f, 246.2060725689f, 41.2682926655f, -4.5182926655f,
	-27.1983444691f, 245.9483444691f, 41.8814895153f, -4.6314895153f,
	-27.4375627041f, 245.6875627041f, 42.4957869053f, -4.7457869053f,
	-27.6737387180f, 245.4237387180f, 43.1111733913f, -4.8611733913f,
	-27.9068839550f, 245.1568839550f, 43.7276375294f, -4.9776375294f,
	-28.1370098591f, 244.8870098591f, 44.3451678753f, -5.0951678753f,
	-28.3641278744f, 244.6141278744f, 44.9637529850f, -5.2137529850f,
	-28.5882494450f, 244.3382494450f, 45.5833814144f, -5.3333814144f,
	-28.8093860149f, 244.0593860149f, 46.2040417194f, -5.4540417194f,
	-29.0275490284f, 243.7775490284f, 46.8257224560f, -5.5757224560f,
	-29.2427499294f, 243.4927499294f, 47.4484121799f, -5.6984121799f,
	-29.4550001621f, 243.2050001621f, 48.0720994473f, -5.8220994473f,
	-29.6643111706f, 242.9143111706f, 48.6967728138f, -5.9467728138f,
	-29.8706943989f, 242.6206943989f, 49.3224208355f, -6.0724208355f,
	-30.0741612911f, 242.3241612911f, 49.9490320683f, -6.1990320683f,
	-30.2747232914f, 242.0247232914f, 50.5765950680f, -6.3265950680f,
	-30.4723918438f, 241.7223918438f, 51.2050983906f, -6.4550983906f,
	-30.6671783924f, 241.4171783924f, 51.8345305920f, -6.5845305920f,
	-30.8590943813f, 241.1090943813f, 52.4648802280f, -6.7148802280f,
	-31.0481512547f, 240.7981512547f, 53.0961358547f, -6.8461358547f,
	-31.2343604565f, 240.4843604565f, 53.7282860279f, -6.9782860279f,
	-31.4177334309f, 240.1677334309f, 54.3613193035f, -7.1113193035f,
	-31.5982816219f, 239.8482816219f, 54.9952242374f, -7.2452242374f,
	-31.7760164738f, 239.5260164738f, 55.6299893856f, -7.3799893856f,
	-31.9509494305f, 239.2009494305f, 56.2656033039f, -7.5156033039f,
	-32.1230919361f, 238.8730919361f, 56.9020545483f, -7.6520545483f,
	-32.2924554348f, 238.5424554348f, 57.5393316746f, -7.7893316746f,
	-32.4590513706f, 238.2090513706f, 58.1774232388f, -7.9274232388f,
	-32.6228911877f, 237.8728911877f, 58.8163177967f, -8.0663177967f,
	-32.7839863300f, 237.5339863300f, 59.4560039043f, -8.2060039043f,
	-32.9423482418f, 237.1923482418f, 60.0964701176f, -8.3464701176f,
	-33.0979883671f, 236.8479883671f, 60.7377049923f, -8.4877049923f,
	-33.2509181499f, 236.5009181499f, 61.3796970844f, -8.6296970844f,
	-33.4011490345f, 236.1511490345f, 62.0224349499f, -8.7724349499f,
	-33.5486924648f, 235.7986924648f, 62.6659071445f, -8.9159071445f,
	-33.6935598850f, 235.4435598850f, 63.3101022243f, -9.0601022243f,
	-33.8357627392f, 235.0857627392f, 63.9550087452f, -9.2050087452f,
	-33.9753124714f, 234.7253124714f, 64.6006152630f, -9.3506152630f,
	-34.1122205257f, 234.3622205257f, 65.2469103336f, -9.4969103336f,
	-34.2464983463f, 233.9964983463f, 65.8938825130f, -9.6438825130f,
	-34.3781573772f, 233.6281573772f, 66.5415203571f, -9.7915203571f,
	-34.5072090626f, 233.2572090626f, 67.1898124218f, -9.9398124218f,
	-34.6336648464f, 232.8836648464f, 67.8387472630f, -10.0887472630f,
	-34.7575361729f, 232.5075361729f, 68.4883134365f, -10.2383134365f,
	-34.8788344860f, 232.1288344860f, 69.1384994984f, -10.3884994984f,
	-34.9975712299f, 231.7475712299f, 69.7892940044f, -10.5392940044f,
	-35.1137578487f, 231.3637578487f, 70.4406855106f, -10.6906855106f,
	-35.2274057865f, 230.9774057865f, 71.0926625729f, -10.8426625729f,
	-35.3385264874f, 230.5885264874f, 71.7452137470f, -10.9952137470f,
	-35.4471313953f, 230.1971313953f, 72.3983275890f, -11.1483275890f,
	-35.5532319546f, 229.8032319546f, 73.0519926548f, -11.3019926548f,
	-35.6568396091f, 229.4068396091f, 73.7061975002f, -11.4561975002f,
	-35.7579658031f, 229.0079658031f, 74.3609306812f, -11.6109306812f,
	-35.8566219807f, 228.6066219807f, 75.0161807537f, -11.7661807537f,
	-35.9528195858f, 228.2028195858f, 75.6719362736f, -11.9219362736f,
	-36.0465700626f, 227.7965700626f, 76.3281857967f, -12.0781857967f,
	-36.1378848553f, 227.3878848553f, 76.9849178791f, -12.2349178791f,
	-36.2267754078f, 226.9767754078f, 77.6421210766f, -12.3921210766f,
	-36.3132531643f, 226.5632531643f, 78.2997839451f, -12.5497839451f,
	-36.3973295689f, 226.1473295689f, 78.9578950405f, -12.7078950405f,
	-36.4790160656f, 225.7290160656f, 79.6164429188f, -12.8664429188f,
	-36.5583240986f, 225.3083240986f, 80.2754161358f, -13.0254161358f,
	-36.6352651119f, 224.8852651119f, 80.9348032475f, -13.1848032475f,
	-36.7098505497f, 224.4598505497f, 81.5945928097f, -13.3445928097f,
	-36.7820918560f, 224.0320918560f, 82.2547733784f, -13.5047733784f,
	-36.8520004749f, 223.6020004749f, 82.9153335094f, -13.6653335094f,
	-36.9195878506f, 223.1695878506f, 83.5762617588f, -13.8262617588f,
	-36.9848654270f, 222.7348654270f, 84.2375466824f, -13.9875466824f,
	-37.0478446484f, 222.2978446484f, 84.8991768360f, -14.1491768360f,
	-37.1085369587f, 221.8585369587f, 85.5611407757f, -14.3111407757f,
	-37.1669538021f, 221.4169538021f, 86.2234270573f, -14.4734270573f,
	-37.2231066227f, 220.9731066227f, 86.8860242367f, -14.6360242367f,
	-37.2770068645f, 220.5270068645f, 87.5489208698f, -14.7989208698f,
	-37.3286659718f, 220.0786659718f, 88.2121055126f, -14.9621055126f,
	-37.3780953884f, 219.6280953884f, 88.8755667210f, -15.1255667210f,
	-37.4253065586f, 219.1753065586f, 89.5392930508f, -15.2892930508f,
	-37.4703109264f, 218.7203109264f, 90.2032730579f, -15.4532730579f,
	-37.5131199360f, 218.2631199360f, 90.8674952984f, -15.6174952984f,
	-37.5537450314f, 217.8037450314f, 91.5319483280f, -15.7819483280f,
	-37.5921976566f, 217.3421976566f, 92.1966207027f, -15.9466207027f,
	-37.6284892559f, 216.8784892559f, 92.8615009785f, -16.1115009785f,
	-37.6626312733f, 216.4126312733f, 93.5265777111f, -16.2765777111f,
	-37.6946351528f, 215.9446351528f, 94.1918394566f, -16.4418394566f,
	-37.7245123386f, 215.4745123386f, 94.8572747707f, -16.6072747707f,
	-37.7522742748f, 215.0022742748f, 95.5228722095f, -16.7728722095f,
	-37.7779324055f, 214.5279324055f, 96.1886203289f, -16.9386203289f,
	-37.8014981747f, 214.0514981747f, 96.8545076847f, -17.1045076847f,
	-37.8229830265f, 213.5729830265f, 97.5205228329f, -17.2705228329f,
	-37.8423984051f, 213.0923984051f, 98.1866543293f, -17.4366543293f,
	-37.8597557545f, 212.6097557545f, 98.8528907299f, -17.6028907299f,
	-37.8750665188f, 212.1250665188f, 99.5192205906f, -17.7692205906f,
	-37.8883421421f, 211.6383421421f, 100.1856324673f, -17.9356324673f,
	-37.8995940685f, 211.1495940685f, 100.8521149158f, -18.1021149158f,
	-37.9088337421f, 210.6588337421f, 101.5186564922f, -18.2686564922f,
	-37.9160726070f, 210.1660726070f, 102.1852457523f, -18.4352457523f,
	-37.9213221073f, 209.6713221073f, 102.8518712521f, -18.6018712521f,
	-37.9245936871f, 209.1745936871f, 103.5185215473f, -18.7685215473f,
	-37.9258987904f, 208.6758987904f, 104.1851851940f, -18.9351851940f,
	-37.9252488613f, 208.1752488613f, 104.8518507481f, -19.1018507481f,
	-37.9226553440f, 207.6726553440f, 105.5185067654f, -19.2685067654f,
	-37.9181296825f, 207.1681296825f, 106.1851418018f, -19.4351418018f,
	-37.9116833210f, 206.6616833210f, 106.8517444134f, -19.6017444134f,
	-37.9033277035f, 206.1533277035f, 107.5183031559f, -19.7683031559f,
	-37.8930742741f, 205.6430742741f, 108.1848065853f, -19.9348065853f,
	-37.8809344769f, 205.1309344769f, 108.8512432575f, -20.1012432575f,
	-37.8669197559f, 204.6169197559f, 109.5176017284f, -20.2676017284f,
	-37.8510415554f, 204.1010415554f, 110.1838705540f, -20.4338705540f,
	-37.8333113194f, 203.5833113194f, 110.8500382900f, -20.6000382900f,
	-37.8137404919f, 203.0637404919f, 111.5160934925f, -20.7660934925f,
	-37.7923405170f, 202.5423405170f, 112.1820247173f, -20.9320247173f,
	-37.7691228390f, 202.0191228390f, 112.8478205204f, -21.0978205204f,
	-37.7440989017f, 201.4940989017f, 113.5134694576f, -21.2634694576f,
	-37.7172801495f, 200.9672801495f, 114.1789600849f, -21.4289600849f,
	-37.6886780262f, 200.4386780262f, 114.8442809582f, -21.5942809582f,
	-37.6583039761f, 199.9083039761f, 115.5094206333f, -21.7594206333f,
	-37.6261694431f, 199.3761694431f, 116.1743676662f, -21.9243676662f,
	-37.5922858715f, 198.8422858715f, 116.8391106129f, -22.0891106129f,
	-37.5566647053f, 198.3066647053f, 117.5036380291f, -22.2536380291f,
	-37.5193173885f, 197.7693173885f, 118.1679384708f, -22.4179384708f,
	-37.4802553654f, 197.2302553654f, 118.8320004940f, -22.5820004940f,
	-37.4394900799f, 196.6894900799f, 119.4958126545f, -22.7458126545f,
	-37.3970329762f, 196.1470329762f, 120.1593635082f, -22.9093635082f,
	-37.3528954983f, 195.6028954983f, 120.8226416111f, -23.0726416111f,
	-37.3070890903f, 195.0570890903f, 121.4856355190f, -23.2356355190f,
	-37.2596251965f, 194.5096251965f, 122.1483337879f, -23.3983337879f,
	-37.2105152607f, 193.9605152607f, 122.8107249737f, -23.5607249737f,
	-37.1597707272f, 193.4097707272f, 123.4727976322f, -23.7227976322f,
	-37.1074030399f, 192.8574030399f, 124.1345403194f, -23.8845403194f,
	-37.0534236431f, 192.3034236431f, 124.7959415913f, -24.0459415913f,
	-36.9978439808f, 191.7478439808f, 125.4569900036f, -24.2069900036f,
	-36.9406754971f, 191.1906754971f, 126.1176741123f, -24.3676741123f,
	-36.8819296360f, 190.6319296360f, 126.7779824734f, -24.5279824734f,
	-36.8216178417f, 190.0716178417f, 127.4379036427f, -24.6879036427f,
	-36.7597515583f, 189.5097515583f, 128.0974261761f, -24.8474261761f,
	-36.6963422298f, 188.9463422298f, 128.7565386295f, -25.0065386295f,
	-36.6314013004f, 188.3814013004f, 129.4152295589f, -25.1652295589f,
	-36.5649402142f, 187.8149402142f, 130.0734875202f, -25.3234875202f,
	-36.4969704151f, 187.2469704151f, 130.7313010693f, -25.4813010693f,
	-36.4275033474f, 186.6775033474f, 131.3886587620f, -25.6386587620f,
	-36.3565504551f, 186.1065504551f, 132.0455491543f, -25.7955491543f,
	-36.2841231823f, 185.5341231823f, 132.7019608021f, -25.9519608021f,
	-36.2102329731f, 184.9602329731f, 133.3578822613f, -26.1078822613f,
	-36.1348912716f, 184.3848912716f, 134.0133020878f, -26.2633020878f,
	-36.0581095219f, 183.8081095219f, 134.6682088375f, -26.4182088375f,
	-35.9798991680f, 183.2298991680f, 135.3225910664f, -26.5725910664f,
	-35.9002716541f, 182.6502716541f, 135.9764373302f, -26.7264373302f,
	-35.8192384243f, 182.0692384243f, 136.6297361851f, -26.8797361851f,
	-35.7368109226f, 181.4868109226f, 137.2824761868f, -27.0324761868f,
	-35.6530005932f, 180.9030005932f, 137.9346458912f, -27.1846458912f,
	-35.5678188801f, 180.3178188801f, 138.5862338543f, -27.3362338543f,
	-35.4812772274f, 179.7312772274f, 139.2372286320f, -27.4872286320f,
	-35.3933870792f, 179.1433870792f, 139.8876187801f, -27.6376187801f,
	-35.3041598797f, 178.5541598797f, 140.5373928547f, -27.7873928547f,
	-35.2136070728f, 177.9636070728f, 141.1865394115f, -27.9365394115f,
	-35.1217401028f, 177.3717401028f, 141.8350470066f, -28.0850470066f,
	-35.0285704136f, 176.7785704136f, 142.4829041958f, -28.2329041958f,
	-34.9341094494f, 176.1841094494f, 143.1300995350f, -28.3800995350f,
	-34.8383686543f, 175.5883686543f, 143.7766215801f, -28.5266215801f,
	-34.7413594723f, 174.9913594723f, 144.4224588871f, -28.6724588871f,
	-34.6430933475f, 174.3930933475f, 145.0676000118f, -28.8176000118f,
	-34.5435817242f, 173.7935817242f, 145.7120335102f, -28.9620335102f,
	-34.4428360462f, 173.1928360462f, 146.3557479382f, -29.1057479382f,
	-34.3408677578f, 172.5908677578f, 146.9987318516f, -29.2487318516f,
	-34.2376883030f, 171.9876883030f, 147.6409738064f, -29.3909738064f,
	-34.1333091259f, 171.3833091259f, 148.2824623585f, -29.5324623585f,
	-34.0277416706f, 170.7777416706f, 148.9231860638f, -29.6731860638f,
	-33.9209973812f, 170.1709973812f, 149.5631334782f, -29.8131334782f,
	-33.8130877018f, 169.5630877018f, 150.2022931576f, -29.9522931576f,
	-33.7040240765f, 168.9540240765f, 150.8406536579f, -30.0906536579f,
	-33.5938179493f, 168.3438179493f, 151.4782035351f, -30.2282035351f,
	-33.4824807644f, 167.7324807644f, 152.1149313450f, -30.3649313450f,
	-33.3700239658f, 167.1200239658f, 152.7508256435f, -30.5008256435f,
	-33.2564589977f, 166.5064589977f, 153.3858749866f, -30.6358749866f,
	-33.1417973042f, 165.8917973042f, 154.0200679302f, -30.7700679302f,
	-33.0260503292f, 165.2760503292f, 154.6533930302f, -30.9033930302f,
	-32.9092295170f, 164.6592295170f, 155.2858388424f, -31.0358388424f,
	-32.7913463116f, 164.0413463116f, 155.9173939228f, -31.1673939228f,
	-32.6724121571f, 163.4224121571f, 156.5480468273f, -31.2980468273f,
	-32.5524384975f, 162.8024384975f, 157.1777861118f, -31.4277861118f,
	-32.4314367771f, 162.1814367771f, 157.8066003323f, -31.5566003323f,
	-32.3094184399f, 161.5594184399f, 158.4344780445f, -31.6844780445f,
	-32.1863949299f, 160.9363949299f, 159.0614078045f, -31.8114078045f,
	-32.0623776913f, 160.3123776913f, 159.6873781681f, -31.9373781681f,
	-31.9373781681f, 159.6873781681f, 160.3123776913f, -32.0623776913f,
	-31.8114078045f, 159.0614078045f, 160.9363949299f, -32.1863949299f,
	-31.6844780445f, 158.4344780445f, 161.5594184399f, -32.3094184399f,
	-31.5566003323f, 157.8066003323f, 162.1814367771f, -32.4314367771f,
	-31.4277861118f, 157.1777861118f, 162.8024384975f, -32.5524384975f,
	-31.2980468273f, 156.5480468273f, 163.4224121571f, -32.6724121571f,
	-31.1673939228f, 155.9173939228f, 164.0413463116f, -32.7913463116f,
	-31.0358388424f, 155.2858388424f, 164.6592295170f, -32.9092295170f,
	-30.9033930302f, 154.6533930302f, 165.2760503292f, -33.0260503292f,
	-30.7700679302f, 154.0200679302f, 165.8917973042f, -33.1417973042f,
	-30.6358749866f, 153.3858749866f, 166.5064589977f, -33.2564589977f,
	-30.5008256435f, 152.7508256435f, 167.1200239658f, -33.3700239658f,
	-30.3649313450f, 152.1149313450f, 167.7324807644f, -33.4824807644f,
	-30.2282035351f, 151.4782035351f, 168.3438179493f, -33.5938179493f,
	-30.0906536579f, 150.8406536579f, 168.9540240765f, -33.7040240765f,
	-29.9522931576f, 150.2022931576f, 169.5630877018f, -33.8130877018f,
	-29.8131334782f, 149.5631334782f, 170.1709973812f, -33.9209973812f,
	-29.6731860638f, 148.9231860638f, 170.7777416706f, -34.0277416706f,
	-29.5324623585f, 148.2824623585f, 171.3833091259f, -34.1333091259f,
	-29.3909738064f, 147.6409738064f, 171.9876883030f, -34.2376883030f,
	-29.2487318516f, 146.9987318516f, 172.5908677578f, -34.3408677578f,
	-29.1057479382f, 146.3557479382f, 173.1928360462f, -34.4428360462f,
	-28.9620335102f, 145.7120335102f, 173.7935817242f, -34.5435817242f,
	-28.8176000118f, 145.0676000118f, 174.3930933475f, -34.6430933475f,
	-28.6724588871f, 144.4224588871f, 174.9913594723f, -34.7413594723f,
	-28.5266215801f, 143.7766215801f, 175.5883686543f, -34.8383686543f,
	-28.3800995350f, 143.1300995350f, 176.1841094494f, -34.9341094494f,
	-28.2329041958f, 142.4829041958f, 176.7785704136f, -35.0285704136f,
	-28.0850470066f, 141.8350470066f, 177.3717401028f, -35.1217401028f,
	-27.9365394115f, 141.1865394115f, 177.9636070728f, -35.2136070728f,
	-27.7873928547f, 140.5373928547f, 178.5541598797f, -35.3041598797f,
	-27.6376187801f, 139.8876187801f, 179.1433870792f, -35.3933870792f,
	-27.4872286320f, 139.2372286320f, 179.7312772274f, -35.4812772274f,
	-27.3362338543f, 138.5862338543f, 180.3178188801f, -35.5678188801f,
	-27.1846458912f, 137.9346458912f, 180.9030005932f, -35.6530005932f,
	-27.0324761868f, 137.2824761868f, 181.4868109226f, -35.7368109226f,
	-26.8797361851f, 136.6297361851f, 182.0692384243f, -35.8192384243f,
	-26.7264373302f, 135.9764373302f, 182.6502716541f, -35.9002716541f,
	-26.5725910664f, 135.3225910664f, 183.2298991680f, -35.9798991680f,
	-26.4182088375f, 134.6682088375f, 183.8081095219f, -36.0581095219f,
	-26.2633020878f, 134.0133020878f, 184.3848912716f, -36.1348912716f,
	-26.1078822613f, 133.3578822613f, 184.9602329731f, -36.2102329731f,
	-25.9519608021f, 132.7019608021f, 185.5341231823f, -36.2841231823f,
	-25.7955491543f, 132.0455491543f, 186.1065504551f, -36.3565504551f,
	-25.6386587620f, 131.3886587620f, 186.6775033474f, -36.4275033474f,
	-25.4813010693f, 130.7313010693f, 187.2469704151f, -36.4969704151f,
	-25.3234875202f, 130.0734875202f, 187.8149402142f, -36.5649402142f,
	-25.1652295589f, 129.4152295589f, 188.3814013004f, -36.6314013004f,
	-25.0065386295f, 128.7565386295f, 188.9463422298f, -36.6963422298f,
	-24.8474261761f, 128.0974261761f, 189.5097515583f, -36.7597515583f,
	-24.6879036427f, 127.4379036427f, 190.0716178417f, -36.8216178417f,
	-24.5279824734f, 126.7779824734f, 190.6319296360f, -36.8819296360f,
	-24.3676741123f, 126.1176741123f, 191.1906754971f, -36.9406754971f,
	-24.2069900036f, 125.4569900036f, 191.7478439808f, -36.9978439808f,
	-24.0459415913f, 124.7959415913f, 192.3034236431f, -37.0534236431f,
	-23.8845403194f, 124.1345403194f, 192.8574030399f, -37.1074030399f,
	-23.7227976322f, 123.4727976322f, 193.4097707272f, -37.1597707272f,
	-23.5607249737f, 122.8107249737f, 193.9605152607f, -37.2105152607f,
	-23.3983337879f, 122.1483337879f, 194.5096251965f, -37.2596251965f,
	-23.2356355190f, 121.4856355190f, 195.0570890903f, -37.3070890903f,
	-23.0726416111f, 120.8226416111f, 195.6028954983f, -37.3528954983f,
	-22.9093635082f, 120.1593635082f, 196.1470329762f, -37.3970329762f,
	-22.7458126545f, 119.4958126545f, 196.6894900799f, -37.4394900799f,
	-22.5820004940f, 118.8320004940f, 197.2302553654f, -37.4802553654f,
	-22.4179384708f, 118.1679384708f, 197.7693173885f, -37.5193173885f,
	-22.2536380291f, 117.5036380291f, 198.3066647053f, -37.5566647053f,
	-22.0891106129f, 116.8391106129f, 198.8422858715f, -37.5922858715f,
	-21.9243676662f, 116.1743676662f, 199.3761694431f, -37.6261694431f,
	-21.7594206333f, 115.5094206333f, 199.9083039761f, -37.6583039761f,
	-21.5942809582f, 114.8442809582f, 200.4386780262f, -37.6886780262f,
	-21.4289600849f, 114.1789600849f, 200.9672801495f, -37.7172801495f,
	-21.2634694576f, 113.5134694576f, 201.4940989017f, -37.7440989017f,
	-21.0978205204f, 112.8478205204f, 202.0191228390f, -37.7691228390f,
	-20.9320247173f, 112.1820247173f, 202.5423405170f, -37.7923405170f,
	-20.7660934925f, 111.5160934925f, 203.0637404919f, -37.8137404919f,
	-20.6000382900f, 110.8500382900f, 203.5833113194f, -37.8333113194f,
	-20.4338705540f, 110.1838705540f, 204.1010415554f, -37.8510415554f,
	-20.2676017284f, 109.5176017284f, 204.6169197559f, -37.8669197559f,
	-20.1012432575f, 108.8512432575f, 205.1309344769f, -37.8809344769f,
	-19.9348065853f, 108.1848065853f, 205.6430742741f, -37.8930742741f,
	-19.7683031559f, 107.5183031559f, 206.1533277035f, -37.9033277035f,
	-19.6017444134f, 106.8517444134f, 206.6616833210f, -37.9116833210f,
	-19.4351418018f, 106.1851418018f, 207.1681296825f, -37.9181296825f,
	-19.2685067654f, 105.5185067654f, 207.6726553440f, -37.9226553440f,
	-19.1018507481f, 104.8518507481f, 208.1752488613f, -37.9252488613f,
	-18.9351851940f, 104.1851851940f, 208.6758987904f, -37.9258987904f,
	-18.7685215473f, 103.5185215473f, 209.1745936871f, -37.9245936871f,
	-18.6018712521f, 102.8518712521f, 209.6713221073f, -37.9213221073f,
	-18.4352457523f, 102.1852457523f, 210.1660726070f, -37.9160726070f,
	-18.2686564922f, 101.5186564922f, 210.6588337421f, -37.9088337421f,
	-18.1021149158f, 100.8521149158f, 211.1495940685f, -37.8995940685f,
	-17.9356324673f, 100.1856324673f, 211.6383421421f, -37.8883421421f,
	-17.7692205906f, 99.5192205906f, 212.1250665188f, -37.8750665188f,
	-17.6028907299f, 98.8528907299f, 212.6097557545f, -37.8597557545f,
	-17.4366543293f, 98.1866543293f, 213.0923984051f, -37.8423984051f,
	-17.2705228329f, 97.5205228329f, 213.5729830265f, -37.8229830265f,
	-17.1045076847f, 96.8545076847f, 214.0514981747f, -37.8014981747f,
	-16.9386203289f, 96.1886203289f, 214.5279324055f, -37.7779324055f,
	-16.7728722095f, 95.5228722095f, 215.0022742748f, -37.7522742748f,
	-16.6072747707f, 94.8572747707f, 215.4745123386f, -37.7245123386f,
	-16.4418394566f, 94.1918394566f, 215.9446351528f, -37.6946351528f,
	-16.2765777111f, 93.5265777111f, 216.4126312733f, -37.6626312733f,
	-16.1115009785f, 92.8615009785f, 216.8784892559f, -37.6284892559f,
	-15.9466207027f, 92.1966207027f, 217.3421976566f, -37.5921976566f,
	-15.7819483280f, 91.5319483280f, 217.8037450314f, -37.5537450314f,
	-15.6174952984f, 90.8674952984f, 218.2631199360f, -37.5131199360f,
	-15.4532730579f, 90.2032730579f, 218.7203109264f, -37.4703109264f,
	-15.2892930508f, 89.5392930508f, 219.1753065586f, -37.4253065586f,
	-15.1255667210f, 88.8755667210f, 219.6280953884f, -37.3780953884f,
	-14.9621055126f, 88.2121055126f, 220.0786659718f, -37.3286659718f,
	-14.7989208698f, 87.5489208698f, 220.5270068645f, -37.2770068645f,
	-14.6360242367f, 86.8860242367f, 220.9731066227f, -37.2231066227f,
	-14.4734270573f, 86.2234270573f, 221.4169538021f, -37.1669538021f,
	-14.3111407757f, 85.5611407757f, 221.8585369587f, -37.1085369587f,
	-14.1491768360f, 84.8991768360f, 222.2978446484f, -37.0478446484f,
	-13.9875466824f, 84.2375466824f, 222.7348654270f, -36.9848654270f,
	-13.8262617588f, 83.5762617588f, 223.1695878506f, -36.9195878506f,
	-13.6653335094f, 82.9153335094f, 223.6020004749f, -36.8520004749f,
	-13.5047733784f, 82.2547733784f, 224.0320918560f, -36.7820918560f,
	-13.3445928097f, 81.5945928097f, 224.4598505497f, -36.7098505497f,
	-13.1848032475f, 80.9348032475f, 224.8852651119f, -36.6352651119f,
	-13.0254161358f, 80.2754161358f, 225.3083240986f, -36.5583240986f,
	-12.8664429188f, 79.6164429188f, 225.7290160656f, -36.4790160656f,
	-12.7078950405f, 78.9578950405f, 226.1473295689f, -36.3973295689f,
	-12.5497839451f, 78.2997839451f, 226.5632531643f, -36.3132531643f,
	-12.3921210766f, 77.6421210766f, 226.9767754078f, -36.2267754078f,
	-12.2349178791f, 76.9849178791f, 227.3878848553f, -36.1378848553f,
	-12.0781857967f, 76.3281857967f, 227.7965700626f, -36.0465700626f,
	-11.9219362736f, 75.6719362736f, 228.2028195858f, -35.9528195858f,
	-11.7661807537f, 75.0161807537f, 228.6066219807f, -35.8566219807f,
	-11.6109306812f, 74.3609306812f, 229.0079658031f, -35.7579658031f,
	-11.4561975002f, 73.7061975002f, 229.4068396091f, -35.6568396091f,
	-11.3019926548f, 73.0519926548f, 229.8032319546f, -35.5532319546f,
	-11.1483275890f, 72.3983275890f, 230.1971313953f, -35.4471313953f,
	-10.9952137470f, 71.7452137470f, 230.5885264874f, -35.3385264874f,
	-10.8426625729f, 71.0926625729f, 230.9774057865f, -35.2274057865f,
	-10.6906855106f, 70.4406855106f, 231.3637578487f, -35.1137578487f,
	-10.5392940044f, 69.7892940044f, 231.7475712299f, -34.9975712299f,
	-10.3884994984f, 69.1384994984f, 232.1288344860f, -34.8788344860f,
	-10.2383134365f, 68.4883134365f, 232.5075361729f, -34.7575361729f,
	-10.0887472630f, 67.8387472630f, 232.8836648464f, -34.6336648464f,
	-9.9398124218f, 67.1898124218f, 233.2572090626f, -34.5072090626f,
	-9.7915203571f, 66.5415203571f, 233.6281573772f, -34.3781573772f,
	-9.6438825130f, 65.8938825130f, 233.9964983463f, -34.2464983463f,
	-9.4969103336f, 65.2469103336f, 234.3622205257f, -34.1122205257f,
	-9.3506152630f, 64.6006152630f, 234.7253124714f, -33.9753124714f,
	-9.2050087452f, 63.9550087452f, 235.0857627392f, -33.8357627392f,
	-9.0601022243f, 63.3101022243f, 235.4435598850f, -33.6935598850f,
	-8.9159071445f, 62.6659071445f, 235.7986924648f, -33.5486924648f,
	-8.7724349499f, 62.0224349499f, 236.1511490345f, -33.4011490345f,
	-8.6296970844f, 61.3796970844f, 236.5009181499f, -33.2509181499f,
	-8.4877049923f, 60.7377049923f, 236.8479883671f, -33.0979883671f,
	-8.3464701176f, 60.0964701176f, 237.1923482418f, -32.9423482418f,
	-8.2060039043f, 59.4560039043f, 237.5339863300f, -32.7839863300f,
	-8.0663177967f, 58.8163177967f, 237.8728911877f, -32.6228911877f,
	-7.9274232388f, 58.1774232388f, 238.2090513706f, -32.4590513706f,
	-7.7893316746f, 57.5393316746f, 238.5424554348f, -32.2924554348f,
	-7.6520545483f, 56.9020545483f, 238.8730919361f, -32.1230919361f,
	-7.5156033039f, 56.2656033039f, 239.2009494305f, -31.9509494305f,
	-7.3799893856f, 55.6299893856f, 239.5260164738f, -31.7760164738f,
	-7.2452242374f, 54.9952242374f, 239.8482816219f, -31.5982816219f,
	-7.1113193035f, 54.3613193035f, 240.1677334309f, -31.4177334309f,
	-6.9782860279f, 53.7282860279f, 240.4843604565f, -31.2343604565f,
	-6.8461358547f, 53.0961358547f, 240.7981512547f, -31.0481512547f,
	-6.7148802280f, 52.4648802280f, 241.1090943813f, -30.8590943813f,
	-6.5845305920f, 51.8345305920f, 241.4171783924f, -30.6671783924f,
	-6.4550983906f, 51.2050983906f, 241.7223918438f, -30.4723918438f,
	-6.3265950680f, 50.5765950680f, 242.0247232914f, -30.2747232914f,
	-6.1990320683f, 49.9490320683f, 242.3241612911f, -30.0741612911f,
	-6.0724208355f, 49.3224208355f, 242.6206943989f, -29.8706943989f,
	-5.9467728138f, 48.6967728138f, 242.9143111706f, -29.6643111706f,
	-5.8220994473f, 48.0720994473f, 243.2050001621f, -29.4550001621f,
	-5.6984121799f, 47.4484121799f, 243.4927499294f, -29.2427499294f,
	-5.5757224560f, 46.8257224560f, 243.7775490284f, -29.0275490284f,
	-5.4540417194f, 46.2040417194f, 244.0593860149f, -28.8093860149f,
	-5.3333814144f, 45.5833814144f, 244.3382494450f, -28.5882494450f,
	-5.2137529850f, 44.9637529850f, 244.6141278744f, -28.3641278744f,
	-5.0951678753f, 44.3451678753f, 244.8870098591f, -28.1370098591f,
	-4.9776375294f, 43.7276375294f, 245.1568839550f, -27.9068839550f,
	-4.8611733913f, 43.1111733913f, 245.4237387180f, -27.6737387180f,
	-4.7457869053f, 42.4957869053f, 245.6875627041f, -27.4375627041f,
	-4.6314895153f, 41.8814895153f, 245.9483444691f, -27.1983444691f,
	-4.5182926655f, 41.2682926655f, 246.2060725689f, -26.9560725689f,
	-4.4062077999f, 40.6562077999f, 246.4607355595f, -26.7107355595f,
	-4.2952463627f, 40.0452463627f, 246.7123219967f, -26.4623219967f,
	-4.1854197979f, 39.4354197979f, 246.9608204365f, -26.2108204365f,
	-4.0767395496f, 38.8267395496f, 247.2062194347f, -25.9562194347f,
	-3.9692170620f, 38.2192170620f, 247.4485075474f, -25.6985075474f,
	-3.8628637791f, 37.6128637791f, 247.6876733303f, -25.4376733303f,
	-3.7576911449f, 37.0076911449f, 247.9237053394f, -25.1737053394f,
	-3.6537106037f, 36.4037106037f, 248.1565921307f, -24.9065921307f,
	-3.5509335995f, 35.8009335995f, 248.3863222599f, -24.6363222599f,
	-3.4493715763f, 35.1993715763f, 248.6128842831f, -24.3628842831f,
	-3.3490359783f, 34.5990359783f, 248.8362667561f, -24.0862667561f,
	-3.2499382496f, 33.9999382496f, 249.0564582348f, -23.8064582348f,
	-3.1520898342f, 33.4020898342f, 249.2734472752f, -23.5234472752f,
	-3.0555021763f, 32.8055021763f, 249.4872224331f, -23.2372224331f,
	-2.9601867199f, 32.2101867199f, 249.6977722645f, -22.9477722645f,
	-2.8661549091f, 31.6161549091f, 249.9050853252f, -22.6550853252f,
	-2.7734181881f, 31.0234181881f, 250.1091501713f, -22.3591501713f,
	-2.6819880009f, 30.4319880009f, 250.3099553585f, -22.0599553585f,
	-2.5918757915f, 29.8418757915f, 250.5074894428f, -21.7574894428f,
	-2.5030930042f, 29.2530930042f, 250.7017409801f, -21.4517409801f,
	-2.4156510830f, 28.6656510830f, 250.8926985264f, -21.1426985264f,
	-2.3295614719f, 28.0795614719f, 251.0803506374f, -20.8303506374f,
	-2.2448356152f, 27.4948356152f, 251.2646858692f, -20.5146858692f,
	-2.1614849567f, 26.9114849567f, 251.4456927776f, -20.1956927776f,
	-2.0795209408f, 26.3295209408f, 251.6233599186f, -19.8733599186f,
	-1.9989550114f, 25.7489550114f, 251.7976758480f, -19.5476758480f,
	-1.9197986126f, 25.1697986126f, 251.9686291218f, -19.2186291218f,
	-1.8420631886f, 24.5920631886f, 252.1362082958f, -18.8862082958f,
	-1.7657601833f, 24.0157601833f, 252.3004019260f, -18.5504019260f,
	-1.6909010410f, 23.4409010410f, 252.4611985683f, -18.2111985683f,
	-1.6174972057f, 22.8674972057f, 252.6185867786f, -17.8685867786f,
	-1.5455601215f, 22.2955601215f, 252.7725551128f, -17.5225551128f,
	-1.4751012325f, 21.7251012325f, 252.9230921268f, -17.1730921268f,
	-1.4061319828f, 21.1561319828f, 253.0701863766f, -16.8201863766f,
	-1.3386638165f, 20.5886638165f, 253.2138264179f, -16.4638264179f,
	-1.2727081776f, 20.0227081776f, 253.3540008068f, -16.1040008068f,
	-1.2082765102f, 19.4582765102f, 253.4906980991f, -15.7406980991f,
	-1.1453802586f, 18.8953802586f, 253.6239068508f, -15.3739068508f,
	-1.0840308666f, 18.3340308666f, 253.7536156178f, -15.0036156178f,
	-1.0242397785f, 17.7742397785f, 253.8798129559f, -14.6298129559f,
	-0.9660184383f, 17.2160184383f, 254.0024874210f, -14.2524874210f,
	-0.9093782902f, 16.6593782902f, 254.1216275692f, -13.8716275692f,
	-0.8543307781f, 16.1043307781f, 254.2372219563f, -13.4872219563f,
	-0.8008873463f, 15.5508873463f, 254.3492591381f, -13.0992591381f,
	-0.7490594387f, 14.9990594387f, 254.4577276707f, -12.7077276707f,
	-0.6988584995f, 14.4488584995f, 254.5626161098f, -12.3126161098f,
	-0.6502959728f, 13.9002959728f, 254.6639130116f, -11.9139130116f,
	-0.6033833027f, 13.3533833027f, 254.7616069317f, -11.5116069317f,
	-0.5581319332f, 12.8081319332f, 254.8556864262f, -11.1056864262f,
	-0.5145533085f, 12.2645533085f, 254.9461400509f, -10.6961400509f,
	-0.4726588726f, 11.7226588726f, 255.0329563618f, -10.2829563618f,
	-0.4324600697f, 11.1824600697f, 255.1161239147f, -9.8661239147f,
	-0.3939683437f, 10.6439683437f, 255.1956312656f, -9.4456312656f,
	-0.3571951389f, 10.1071951389f, 255.2714669704f, -9.0214669704f,
	-0.3221518993f, 9.5721518993f, 255.3436195850f, -8.5936195850f,
	-0.2888500690f, 9.0388500690f, 255.4120776653f, -8.1620776653f,
	-0.2573010921f, 8.5073010921f, 255.4768297672f, -7.7268297672f,
	-0.2275164127f, 7.9775164127f, 255.5378644466f, -7.2878644466f,
	-0.1995074749f, 7.4495074749f, 255.5951702595f, -6.8451702595f,
	-0.1732857227f, 6.9232857227f, 255.6487357616f, -6.3987357616f,
	-0.1488626003f, 6.3988626003f, 255.6985495090f, -5.9485495090f,
	-0.1262495518f, 5.8762495518f, 255.7446000576f, -5.4946000576f,
	-0.1054580212f, 5.3554580212f, 255.7868759632f, -5.0368759632f,
	-0.0864994526f, 4.8364994526f, 255.8253657818f, -4.5753657818f,
	-0.0693852901f, 4.3193852901f, 255.8600580692f, -4.1100580692f,
	-0.0541269779f, 3.8041269779f, 255.8909413815f, -3.6409413815f,
	-0.0407359600f, 3.2907359600f, 255.9180042744f, -3.1680042744f,
	-0.0292236805f, 2.7792236805f, 255.9412353039f, -2.6912353039f,
	-0.0196015835f, 2.2696015835f, 255.9606230259f, -2.2106230259f,
	-0.0118811131f, 1.7618811131f, 255.9761559963f, -1.7261559963f,
	-0.0060737133f, 1.2560737133f, 255.9878227711f, -1.2378227711f,
	-0.0021908283f, 0.7521908283f, 255.9956119061f, -0.7456119061f,
	-0.0002439022f, 0.2502439022f, 255.9995119572f, -0.2495119572f
};

/* *********************************************************** */
/* *********************************************************** */

const mlib_s16 mlib_filters_u8_bc[] = {
	-16, 16384, 16, 0,
	-47, 16383, 49, 0,
	-78, 16380, 83, -1,
	-109, 16376, 118, -2,
	-139, 16371, 154, -2,
	-169, 16365, 191, -4,
	-198, 16358, 229, -5,
	-226, 16349, 268, -7,
	-254, 16340, 307, -9,
	-282, 16329, 348, -11,
	-309, 16317, 389, -13,
	-336, 16304, 432, -16,
	-362, 16289, 475, -19,
	-388, 16274, 520, -22,
	-413, 16257, 565, -25,
	-438, 16239, 611, -28,
	-462, 16220, 658, -32,
	-486, 16200, 705, -36,
	-510, 16179, 754, -40,
	-533, 16157, 803, -44,
	-555, 16134, 854, -48,
	-577, 16110, 905, -53,
	-599, 16084, 956, -58,
	-620, 16058, 1009, -63,
	-641, 16030, 1063, -68,
	-662, 16002, 1117, -73,
	-682, 15972, 1172, -79,
	-701, 15942, 1228, -84,
	-720, 15910, 1284, -90,
	-739, 15878, 1342, -96,
	-757, 15844, 1400, -102,
	-775, 15810, 1458, -109,
	-793, 15774, 1518, -115,
	-810, 15738, 1578, -122,
	-826, 15700, 1639, -129,
	-843, 15662, 1701, -136,
	-859, 15623, 1763, -143,
	-874, 15582, 1826, -150,
	-889, 15541, 1890, -157,
	-904, 15499, 1954, -165,
	-918, 15456, 2019, -173,
	-932, 15412, 2084, -180,
	-946, 15368, 2151, -188,
	-959, 15322, 2218, -196,
	-972, 15275, 2285, -205,
	-984, 15228, 2353, -213,
	-997, 15180, 2422, -221,
	-1008, 15131, 2491, -230,
	-1020, 15081, 2561, -238,
	-1031, 15030, 2631, -247,
	-1041, 14979, 2702, -256,
	-1052, 14926, 2774, -265,
	-1062, 14873, 2846, -274,
	-1071, 14819, 2919, -283,
	-1080, 14765, 2992, -292,
	-1089, 14709, 3066, -302,
	-1098, 14653, 3140, -311,
	-1106, 14596, 3215, -320,
	-1114, 14538, 3290, -330,
	-1122, 14480, 3366, -340,
	-1129, 14421, 3442, -349,
	-1136, 14361, 3518, -359,
	-1143, 14300, 3595, -369,
	-1149, 14239, 3673, -379,
	-1155, 14177, 3751, -389,
	-1161, 14114, 3829, -399,
	-1166, 14051, 3908, -409,
	-1171, 13987, 3988, -419,
	-1176, 13922, 4067, -430,
	-1180, 13857, 4147, -440,
	-1185, 13791, 4228, -450,
	-1188, 13724, 4309, -461,
	-1192, 13657, 4390, -471,
	-1195, 13589, 4471, -481,
	-1198, 13521, 4553, -492,
	-1201, 13452, 4636, -502,
	-1204, 13382, 4718, -513,
	-1206, 13312, 4801, -523,
	-1208, 13241, 4885, -534,
	-1209, 13170, 4968, -545,
	-1211, 13098, 5052, -555,
	-1212, 13026, 5136, -566,
	-1213, 12953, 5221, -577,
	-1213, 12879, 5305, -587,
	-1214, 12805, 5390, -598,
	-1214, 12731, 5476, -609,
	-1213, 12656, 5561, -619,
	-1213, 12580, 5647, -630,
	-1212, 12504, 5733, -641,
	-1211, 12428, 5819, -651,
	-1210, 12351, 5905, -662,
	-1209, 12274, 5992, -672,
	-1207, 12196, 6079, -683,
	-1206, 12117, 6166, -694,
	-1204, 12039, 6253, -704,
	-1201, 11960, 6340, -715,
	-1199, 11880, 6428, -725,
	-1196, 11800, 6515, -736,
	-1193, 11720, 6603, -746,
	-1190, 11639, 6691, -757,
	-1187, 11558, 6779, -767,
	-1183, 11477, 6867, -777,
	-1179, 11395, 6956, -787,
	-1175, 11313, 7044, -798,
	-1171, 11230, 7132, -808,
	-1167, 11148, 7221, -818,
	-1162, 11065, 7310, -828,
	-1158, 10981, 7398, -838,
	-1153, 10897, 7487, -848,
	-1148, 10813, 7576, -858,
	-1142, 10729, 7665, -867,
	-1137, 10644, 7754, -877,
	-1131, 10560, 7842, -887,
	-1125, 10474, 7931, -896,
	-1119, 10389, 8020, -906,
	-1113, 10303, 8109, -915,
	-1107, 10218, 8198, -924,
	-1101, 10131, 8287, -934,
	-1094, 10045, 8376, -943,
	-1087, 9959, 8464, -952,
	-1080, 9872, 8553, -961,
	-1073, 9785, 8642, -969,
	-1066, 9698, 8730, -978,
	-1059, 9611, 8819, -987,
	-1051, 9523, 8907, -995,
	-1044, 9436, 8996, -1004,
	-1036, 9348, 9084, -1012,
	-1028, 9260, 9172, -1020,
	-1020, 9172, 9260, -1028,
	-1012, 9084, 9348, -1036,
	-1004, 8996, 9436, -1044,
	-995, 8907, 9523, -1051,
	-987, 8819, 9611, -1059,
	-978, 8730, 9698, -1066,
	-969, 8642, 9785, -1073,
	-961, 8553, 9872, -1080,
	-952, 8464, 9959, -1087,
	-943, 8376, 10045, -1094,
	-934, 8287, 10131, -1101,
	-924, 8198, 10218, -1107,
	-915, 8109, 10303, -1113,
	-906, 8020, 10389, -1119,
	-896, 7931, 10474, -1125,
	-887, 7842, 10560, -1131,
	-877, 7754, 10644, -1137,
	-867, 7665, 10729, -1142,
	-858, 7576, 10813, -1148,
	-848, 7487, 10897, -1153,
	-838, 7398, 10981, -1158,
	-828, 7310, 11065, -1162,
	-818, 7221, 11148, -1167,
	-808, 7132, 11230, -1171,
	-798, 7044, 11313, -1175,
	-787, 6956, 11395, -1179,
	-777, 6867, 11477, -1183,
	-767, 6779, 11558, -1187,
	-757, 6691, 11639, -1190,
	-746, 6603, 11720, -1193,
	-736, 6515, 11800, -1196,
	-725, 6428, 11880, -1199,
	-715, 6340, 11960, -1201,
	-704, 6253, 12039, -1204,
	-694, 6166, 12117, -1206,
	-683, 6079, 12196, -1207,
	-672, 5992, 12274, -1209,
	-662, 5905, 12351, -1210,
	-651, 5819, 12428, -1211,
	-641, 5733, 12504, -1212,
	-630, 5647, 12580, -1213,
	-619, 5561, 12656, -1213,
	-609, 5476, 12731, -1214,
	-598, 5390, 12805, -1214,
	-587, 5305, 12879, -1213,
	-577, 5221, 12953, -1213,
	-566, 5136, 13026, -1212,
	-555, 5052, 13098, -1211,
	-545, 4968, 13170, -1209,
	-534, 4885, 13241, -1208,
	-523, 4801, 13312, -1206,
	-513, 4718, 13382, -1204,
	-502, 4636, 13452, -1201,
	-492, 4553, 13521, -1198,
	-481, 4471, 13589, -1195,
	-471, 4390, 13657, -1192,
	-461, 4309, 13724, -1188,
	-450, 4228, 13791, -1185,
	-440, 4147, 13857, -1180,
	-430, 4067, 13922, -1176,
	-419, 3988, 13987, -1171,
	-409, 3908, 14051, -1166,
	-399, 3829, 14114, -1161,
	-389, 3751, 14177, -1155,
	-379, 3673, 14239, -1149,
	-369, 3595, 14300, -1143,
	-359, 3518, 14361, -1136,
	-349, 3442, 14421, -1129,
	-340, 3366, 14480, -1122,
	-330, 3290, 14538, -1114,
	-320, 3215, 14596, -1106,
	-311, 3140, 14653, -1098,
	-302, 3066, 14709, -1089,
	-292, 2992, 14765, -1080,
	-283, 2919, 14819, -1071,
	-274, 2846, 14873, -1062,
	-265, 2774, 14926, -1052,
	-256, 2702, 14979, -1041,
	-247, 2631, 15030, -1031,
	-238, 2561, 15081, -1020,
	-230, 2491, 15131, -1008,
	-221, 2422, 15180, -997,
	-213, 2353, 15228, -984,
	-205, 2285, 15275, -972,
	-196, 2218, 15322, -959,
	-188, 2151, 15368, -946,
	-180, 2084, 15412, -932,
	-173, 2019, 15456, -918,
	-165, 1954, 15499, -904,
	-157, 1890, 15541, -889,
	-150, 1826, 15582, -874,
	-143, 1763, 15623, -859,
	-136, 1701, 15662, -843,
	-129, 1639, 15700, -826,
	-122, 1578, 15738, -810,
	-115, 1518, 15774, -793,
	-109, 1458, 15810, -775,
	-102, 1400, 15844, -757,
	-96, 1342, 15878, -739,
	-90, 1284, 15910, -720,
	-84, 1228, 15942, -701,
	-79, 1172, 15972, -682,
	-73, 1117, 16002, -662,
	-68, 1063, 16030, -641,
	-63, 1009, 16058, -620,
	-58, 956, 16084, -599,
	-53, 905, 16110, -577,
	-48, 854, 16134, -555,
	-44, 803, 16157, -533,
	-40, 754, 16179, -510,
	-36, 705, 16200, -486,
	-32, 658, 16220, -462,
	-28, 611, 16239, -438,
	-25, 565, 16257, -413,
	-22, 520, 16274, -388,
	-19, 475, 16289, -362,
	-16, 432, 16304, -336,
	-13, 389, 16317, -309,
	-11, 348, 16329, -282,
	-9, 307, 16340, -254,
	-7, 268, 16349, -226,
	-5, 229, 16358, -198,
	-4, 191, 16365, -169,
	-2, 154, 16371, -139,
	-2, 118, 16376, -109,
	-1, 83, 16380, -78,
	0, 49, 16383, -47,
	0, 16, 16384, -16
};

/* *********************************************************** */

const mlib_s16 mlib_filters_u8_bc2[] = {
	-32, 16384, 32, 0,
	-95, 16383, 97, -1,
	-157, 16381, 162, -2,
	-218, 16378, 227, -3,
	-278, 16374, 293, -5,
	-337, 16369, 359, -7,
	-395, 16363, 426, -10,
	-452, 16356, 494, -14,
	-508, 16348, 561, -17,
	-564, 16340, 630, -22,
	-618, 16330, 698, -26,
	-671, 16319, 768, -32,
	-724, 16308, 837, -37,
	-775, 16295, 907, -43,
	-826, 16282, 978, -50,
	-876, 16268, 1048, -56,
	-924, 16252, 1120, -64,
	-972, 16236, 1191, -71,
	-1019, 16219, 1263, -79,
	-1065, 16201, 1336, -88,
	-1110, 16182, 1409, -97,
	-1155, 16163, 1482, -106,
	-1198, 16142, 1555, -115,
	-1241, 16121, 1629, -125,
	-1282, 16098, 1704, -136,
	-1323, 16075, 1778, -146,
	-1363, 16051, 1853, -157,
	-1402, 16026, 1929, -169,
	-1440, 16000, 2004, -180,
	-1478, 15974, 2080, -192,
	-1515, 15947, 2157, -205,
	-1550, 15918, 2234, -218,
	-1585, 15889, 2311, -231,
	-1620, 15860, 2388, -244,
	-1653, 15829, 2465, -257,
	-1686, 15798, 2543, -271,
	-1717, 15765, 2622, -286,
	-1748, 15732, 2700, -300,
	-1779, 15699, 2779, -315,
	-1808, 15664, 2858, -330,
	-1837, 15629, 2937, -345,
	-1865, 15593, 3017, -361,
	-1892, 15556, 3097, -377,
	-1918, 15518, 3177, -393,
	-1944, 15480, 3257, -409,
	-1969, 15441, 3338, -426,
	-1993, 15401, 3418, -442,
	-2017, 15361, 3499, -459,
	-2039, 15319, 3581, -477,
	-2061, 15277, 3662, -494,
	-2083, 15235, 3744, -512,
	-2103, 15191, 3826, -530,
	-2123, 15147, 3908, -548,
	-2142, 15102, 3990, -566,
	-2161, 15057, 4072, -584,
	-2179, 15011, 4155, -603,
	-2196, 14964, 4238, -622,
	-2213, 14917, 4321, -641,
	-2228, 14868, 4404, -660,
	-2244, 14820, 4487, -679,
	-2258, 14770, 4571, -699,
	-2272, 14720, 4654, -718,
	-2285, 14669, 4738, -738,
	-2298, 14618, 4822, -758,
	-2310, 14566, 4906, -778,
	-2321, 14513, 4990, -798,
	-2332, 14460, 5074, -818,
	-2342, 14406, 5159, -839,
	-2352, 14352, 5243, -859,
	-2361, 14297, 5328, -880,
	-2369, 14241, 5412, -900,
	-2377, 14185, 5497, -921,
	-2384, 14128, 5582, -942,
	-2391, 14071, 5667, -963,
	-2397, 14013, 5752, -984,
	-2402, 13954, 5837, -1005,
	-2407, 13895, 5922, -1026,
	-2411, 13835, 6007, -1047,
	-2415, 13775, 6092, -1068,
	-2419, 13715, 6177, -1089,
	-2421, 13653, 6263, -1111,
	-2424, 13592, 6348, -1132,
	-2425, 13529, 6433, -1153,
	-2426, 13466, 6519, -1175,
	-2427, 13403, 6604, -1196,
	-2427, 13339, 6689, -1217,
	-2427, 13275, 6775, -1239,
	-2426, 13210, 6860, -1260,
	-2425, 13145, 6945, -1281,
	-2423, 13079, 7030, -1302,
	-2421, 13013, 7116, -1324,
	-2418, 12946, 7201, -1345,
	-2415, 12879, 7286, -1366,
	-2411, 12811, 7371, -1387,
	-2407, 12743, 7456, -1408,
	-2402, 12674, 7541, -1429,
	-2397, 12605, 7626, -1450,
	-2392, 12536, 7711, -1471,
	-2386, 12466, 7796, -1492,
	-2380, 12396, 7881, -1513,
	-2373, 12325, 7966, -1534,
	-2366, 12254, 8050, -1554,
	-2359, 12183, 8135, -1575,
	-2351, 12111, 8219, -1595,
	-2342, 12038, 8304, -1616,
	-2334, 11966, 8388, -1636,
	-2325, 11893, 8472, -1656,
	-2315, 11819, 8556, -1676,
	-2305, 11745, 8640, -1696,
	-2295, 11671, 8723, -1715,
	-2284, 11596, 8807, -1735,
	-2274, 11522, 8890, -1754,
	-2262, 11446, 8974, -1774,
	-2251, 11371, 9057, -1793,
	-2239, 11295, 9140, -1812,
	-2227, 11219, 9222, -1830,
	-2214, 11142, 9305, -1849,
	-2201, 11065, 9387, -1867,
	-2188, 10988, 9470, -1886,
	-2174, 10910, 9552, -1904,
	-2161, 10833, 9633, -1921,
	-2146, 10754, 9715, -1939,
	-2132, 10676, 9796, -1956,
	-2117, 10597, 9878, -1974,
	-2102, 10518, 9959, -1991,
	-2087, 10439, 10039, -2007,
	-2072, 10360, 10120, -2024,
	-2056, 10280, 10200, -2040,
	-2040, 10200, 10280, -2056,
	-2024, 10120, 10360, -2072,
	-2007, 10039, 10439, -2087,
	-1991, 9959, 10518, -2102,
	-1974, 9878, 10597, -2117,
	-1956, 9796, 10676, -2132,
	-1939, 9715, 10754, -2146,
	-1921, 9633, 10833, -2161,
	-1904, 9552, 10910, -2174,
	-1886, 9470, 10988, -2188,
	-1867, 9387, 11065, -2201,
	-1849, 9305, 11142, -2214,
	-1830, 9222, 11219, -2227,
	-1812, 9140, 11295, -2239,
	-1793, 9057, 11371, -2251,
	-1774, 8974, 11446, -2262,
	-1754, 8890, 11522, -2274,
	-1735, 8807, 11596, -2284,
	-1715, 8723, 11671, -2295,
	-1696, 8640, 11745, -2305,
	-1676, 8556, 11819, -2315,
	-1656, 8472, 11893, -2325,
	-1636, 8388, 11966, -2334,
	-1616, 8304, 12038, -2342,
	-1595, 8219, 12111, -2351,
	-1575, 8135, 12183, -2359,
	-1554, 8050, 12254, -2366,
	-1534, 7966, 12325, -2373,
	-1513, 7881, 12396, -2380,
	-1492, 7796, 12466, -2386,
	-1471, 7711, 12536, -2392,
	-1450, 7626, 12605, -2397,
	-1429, 7541, 12674, -2402,
	-1408, 7456, 12743, -2407,
	-1387, 7371, 12811, -2411,
	-1366, 7286, 12879, -2415,
	-1345, 7201, 12946, -2418,
	-1324, 7116, 13013, -2421,
	-1302, 7030, 13079, -2423,
	-1281, 6945, 13145, -2425,
	-1260, 6860, 13210, -2426,
	-1239, 6775, 13275, -2427,
	-1217, 6689, 13339, -2427,
	-1196, 6604, 13403, -2427,
	-1175, 6519, 13466, -2426,
	-1153, 6433, 13529, -2425,
	-1132, 6348, 13592, -2424,
	-1111, 6263, 13653, -2421,
	-1089, 6177, 13715, -2419,
	-1068, 6092, 13775, -2415,
	-1047, 6007, 13835, -2411,
	-1026, 5922, 13895, -2407,
	-1005, 5837, 13954, -2402,
	-984, 5752, 14013, -2397,
	-963, 5667, 14071, -2391,
	-942, 5582, 14128, -2384,
	-921, 5497, 14185, -2377,
	-900, 5412, 14241, -2369,
	-880, 5328, 14297, -2361,
	-859, 5243, 14352, -2352,
	-839, 5159, 14406, -2342,
	-818, 5074, 14460, -2332,
	-798, 4990, 14513, -2321,
	-778, 4906, 14566, -2310,
	-758, 4822, 14618, -2298,
	-738, 4738, 14669, -2285,
	-718, 4654, 14720, -2272,
	-699, 4571, 14770, -2258,
	-679, 4487, 14820, -2244,
	-660, 4404, 14868, -2228,
	-641, 4321, 14917, -2213,
	-622, 4238, 14964, -2196,
	-603, 4155, 15011, -2179,
	-584, 4072, 15057, -2161,
	-566, 3990, 15102, -2142,
	-548, 3908, 15147, -2123,
	-530, 3826, 15191, -2103,
	-512, 3744, 15235, -2083,
	-494, 3662, 15277, -2061,
	-477, 3581, 15319, -2039,
	-459, 3499, 15361, -2017,
	-442, 3418, 15401, -1993,
	-426, 3338, 15441, -1969,
	-409, 3257, 15480, -1944,
	-393, 3177, 15518, -1918,
	-377, 3097, 15556, -1892,
	-361, 3017, 15593, -1865,
	-345, 2937, 15629, -1837,
	-330, 2858, 15664, -1808,
	-315, 2779, 15699, -1779,
	-300, 2700, 15732, -1748,
	-286, 2622, 15765, -1717,
	-271, 2543, 15798, -1686,
	-257, 2465, 15829, -1653,
	-244, 2388, 15860, -1620,
	-231, 2311, 15889, -1585,
	-218, 2234, 15918, -1550,
	-205, 2157, 15947, -1515,
	-192, 2080, 15974, -1478,
	-180, 2004, 16000, -1440,
	-169, 1929, 16026, -1402,
	-157, 1853, 16051, -1363,
	-146, 1778, 16075, -1323,
	-136, 1704, 16098, -1282,
	-125, 1629, 16121, -1241,
	-115, 1555, 16142, -1198,
	-106, 1482, 16163, -1155,
	-97, 1409, 16182, -1110,
	-88, 1336, 16201, -1065,
	-79, 1263, 16219, -1019,
	-71, 1191, 16236, -972,
	-64, 1120, 16252, -924,
	-56, 1048, 16268, -876,
	-50, 978, 16282, -826,
	-43, 907, 16295, -775,
	-37, 837, 16308, -724,
	-32, 768, 16319, -671,
	-26, 698, 16330, -618,
	-22, 630, 16340, -564,
	-17, 561, 16348, -508,
	-14, 494, 16356, -452,
	-10, 426, 16363, -395,
	-7, 359, 16369, -337,
	-5, 293, 16374, -278,
	-3, 227, 16378, -218,
	-2, 162, 16381, -157,
	-1, 97, 16383, -95,
	0, 32, 16384, -32
};

/* *********************************************************** */

const mlib_s16 mlib_filters_s16_bc[] = {
	-16, 32767, 16, 0,
	-48, 32767, 49, 0,
	-79, 32766, 82, 0,
	-110, 32764, 115, -1,
	-141, 32762, 149, -1,
	-172, 32759, 184, -2,
	-203, 32755, 218, -3,
	-233, 32751, 254, -3,
	-263, 32746, 290, -4,
	-293, 32740, 326, -6,
	-322, 32734, 363, -7,
	-352, 32727, 401, -8,
	-381, 32720, 438, -10,
	-410, 32712, 477, -11,
	-438, 32703, 515, -13,
	-466, 32694, 555, -15,
	-495, 32685, 594, -16,
	-522, 32674, 635, -18,
	-550, 32663, 675, -21,
	-577, 32652, 716, -23,
	-605, 32640, 758, -25,
	-631, 32627, 800, -28,
	-658, 32614, 842, -30,
	-685, 32600, 885, -33,
	-711, 32586, 929, -36,
	-737, 32571, 972, -39,
	-762, 32555, 1017, -42,
	-788, 32539, 1061, -45,
	-813, 32523, 1107, -48,
	-838, 32505, 1152, -51,
	-863, 32488, 1198, -55,
	-888, 32469, 1245, -58,
	-912, 32450, 1291, -62,
	-936, 32431, 1339, -66,
	-960, 32411, 1387, -69,
	-984, 32391, 1435, -73,
	-1007, 32369, 1483, -77,
	-1031, 32348, 1532, -81,
	-1054, 32326, 1582, -86,
	-1076, 32303, 1631, -90,
	-1099, 32280, 1682, -94,
	-1121, 32256, 1732, -99,
	-1144, 32232, 1783, -104,
	-1166, 32207, 1835, -108,
	-1187, 32181, 1887, -113,
	-1209, 32156, 1939, -118,
	-1230, 32129, 1992, -123,
	-1251, 32102, 2045, -128,
	-1272, 32075, 2098, -133,
	-1293, 32047, 2152, -138,
	-1313, 32018, 2206, -144,
	-1333, 31989, 2261, -149,
	-1353, 31960, 2316, -155,
	-1373, 31930, 2371, -160,
	-1392, 31899, 2427, -166,
	-1412, 31868, 2483, -172,
	-1431, 31836, 2540, -177,
	-1450, 31804, 2597, -183,
	-1469, 31772, 2654, -189,
	-1487, 31739, 2712, -196,
	-1506, 31705, 2770, -202,
	-1524, 31671, 2828, -208,
	-1542, 31637, 2887, -214,
	-1559, 31602, 2946, -221,
	-1577, 31566, 3006, -227,
	-1594, 31530, 3066, -234,
	-1611, 31494, 3126, -240,
	-1628, 31457, 3186, -247,
	-1645, 31419, 3247, -254,
	-1661, 31381, 3309, -261,
	-1677, 31343, 3370, -268,
	-1694, 31304, 3432, -275,
	-1709, 31265, 3495, -282,
	-1725, 31225, 3557, -289,
	-1741, 31185, 3620, -296,
	-1756, 31144, 3683, -304,
	-1771, 31103, 3747, -311,
	-1786, 31062, 3811, -319,
	-1801, 31019, 3875, -326,
	-1815, 30977, 3940, -334,
	-1830, 30934, 4005, -341,
	-1844, 30891, 4070, -349,
	-1858, 30847, 4136, -357,
	-1872, 30802, 4202, -365,
	-1885, 30758, 4268, -373,
	-1899, 30712, 4335, -381,
	-1912, 30667, 4402, -389,
	-1925, 30621, 4469, -397,
	-1938, 30574, 4536, -405,
	-1950, 30527, 4604, -413,
	-1963, 30480, 4672, -421,
	-1975, 30432, 4741, -430,
	-1987, 30384, 4809, -438,
	-1999, 30335, 4878, -447,
	-2011, 30286, 4948, -455,
	-2022, 30237, 5017, -464,
	-2034, 30187, 5087, -472,
	-2045, 30137, 5157, -481,
	-2056, 30086, 5228, -490,
	-2067, 30035, 5298, -499,
	-2077, 29983, 5369, -507,
	-2088, 29931, 5441, -516,
	-2098, 29879, 5512, -525,
	-2108, 29826, 5584, -534,
	-2118, 29773, 5656, -543,
	-2128, 29720, 5729, -552,
	-2138, 29666, 5801, -561,
	-2147, 29612, 5874, -571,
	-2156, 29557, 5947, -580,
	-2165, 29502, 6021, -589,
	-2174, 29446, 6094, -598,
	-2183, 29391, 6168, -608,
	-2192, 29334, 6243, -617,
	-2200, 29278, 6317, -627,
	-2208, 29221, 6392, -636,
	-2217, 29163, 6467, -646,
	-2224, 29106, 6542, -655,
	-2232, 29048, 6617, -665,
	-2240, 28989, 6693, -675,
	-2247, 28930, 6769, -684,
	-2255, 28871, 6845, -694,
	-2262, 28812, 6922, -704,
	-2269, 28752, 6998, -713,
	-2275, 28691, 7075, -723,
	-2282, 28631, 7152, -733,
	-2289, 28570, 7230, -743,
	-2295, 28509, 7307, -753,
	-2301, 28447, 7385, -763,
	-2307, 28385, 7463, -773,
	-2313, 28323, 7541, -783,
	-2319, 28260, 7620, -793,
	-2324, 28197, 7698, -803,
	-2329, 28134, 7777, -813,
	-2335, 28070, 7856, -823,
	-2340, 28006, 7936, -834,
	-2345, 27941, 8015, -844,
	-2349, 27877, 8095, -854,
	-2354, 27812, 8175, -864,
	-2359, 27746, 8255, -875,
	-2363, 27681, 8335, -885,
	-2367, 27615, 8415, -895,
	-2371, 27549, 8496, -906,
	-2375, 27482, 8577, -916,
	-2379, 27415, 8658, -926,
	-2382, 27348, 8739, -937,
	-2386, 27280, 8821, -947,
	-2389, 27212, 8902, -958,
	-2392, 27144, 8984, -968,
	-2395, 27076, 9066, -979,
	-2398, 27007, 9148, -989,
	-2401, 26938, 9230, -1000,
	-2403, 26869, 9313, -1010,
	-2406, 26799, 9395, -1021,
	-2408, 26729, 9478, -1031,
	-2410, 26659, 9561, -1042,
	-2412, 26589, 9644, -1052,
	-2414, 26518, 9727, -1063,
	-2416, 26447, 9811, -1073,
	-2418, 26376, 9894, -1084,
	-2419, 26304, 9978, -1095,
	-2421, 26232, 10062, -1105,
	-2422, 26160, 10146, -1116,
	-2423, 26087, 10230, -1127,
	-2424, 26015, 10314, -1137,
	-2425, 25942, 10399, -1148,
	-2426, 25869, 10483, -1159,
	-2426, 25795, 10568, -1169,
	-2427, 25721, 10653, -1180,
	-2427, 25647, 10738, -1191,
	-2427, 25573, 10823, -1201,
	-2427, 25499, 10908, -1212,
	-2427, 25424, 10994, -1223,
	-2427, 25349, 11079, -1233,
	-2427, 25274, 11165, -1244,
	-2426, 25198, 11251, -1255,
	-2426, 25122, 11337, -1265,
	-2425, 25046, 11422, -1276,
	-2424, 24970, 11509, -1286,
	-2423, 24894, 11595, -1297,
	-2422, 24817, 11681, -1308,
	-2421, 24740, 11767, -1318,
	-2420, 24663, 11854, -1329,
	-2419, 24586, 11941, -1340,
	-2417, 24508, 12027, -1350,
	-2416, 24430, 12114, -1361,
	-2414, 24352, 12201, -1371,
	-2412, 24274, 12288, -1382,
	-2410, 24196, 12375, -1393,
	-2408, 24117, 12462, -1403,
	-2406, 24038, 12549, -1414,
	-2404, 23959, 12637, -1424,
	-2401, 23880, 12724, -1435,
	-2399, 23800, 12812, -1445,
	-2396, 23721, 12899, -1456,
	-2393, 23641, 12987, -1466,
	-2391, 23561, 13075, -1477,
	-2388, 23480, 13163, -1487,
	-2385, 23400, 13250, -1497,
	-2381, 23319, 13338, -1508,
	-2378, 23238, 13426, -1518,
	-2375, 23157, 13514, -1529,
	-2371, 23076, 13602, -1539,
	-2368, 22994, 13691, -1549,
	-2364, 22913, 13779, -1560,
	-2360, 22831, 13867, -1570,
	-2357, 22749, 13955, -1580,
	-2353, 22667, 14044, -1590,
	-2349, 22585, 14132, -1600,
	-2344, 22502, 14221, -1611,
	-2340, 22420, 14309, -1621,
	-2336, 22337, 14398, -1631,
	-2331, 22254, 14486, -1641,
	-2327, 22171, 14575, -1651,
	-2322, 22087, 14664, -1661,
	-2317, 22004, 14752, -1671,
	-2313, 21920, 14841, -1681,
	-2308, 21837, 14930, -1691,
	-2303, 21753, 15019, -1701,
	-2298, 21669, 15107, -1710,
	-2292, 21585, 15196, -1720,
	-2287, 21500, 15285, -1730,
	-2282, 21416, 15374, -1740,
	-2276, 21331, 15463, -1750,
	-2271, 21246, 15552, -1759,
	-2265, 21162, 15640, -1769,
	-2259, 21077, 15729, -1778,
	-2254, 20991, 15818, -1788,
	-2248, 20906, 15907, -1797,
	-2242, 20821, 15996, -1807,
	-2236, 20735, 16085, -1816,
	-2230, 20650, 16174, -1826,
	-2223, 20564, 16263, -1835,
	-2217, 20478, 16351, -1844,
	-2211, 20392, 16440, -1854,
	-2204, 20306, 16529, -1863,
	-2198, 20220, 16618, -1872,
	-2191, 20133, 16707, -1881,
	-2185, 20047, 16796, -1890,
	-2178, 19960, 16884, -1899,
	-2171, 19874, 16973, -1908,
	-2164, 19787, 17062, -1917,
	-2157, 19700, 17151, -1926,
	-2150, 19613, 17239, -1935,
	-2143, 19526, 17328, -1943,
	-2136, 19439, 17416, -1952,
	-2128, 19352, 17505, -1961,
	-2121, 19265, 17593, -1969,
	-2114, 19178, 17682, -1978,
	-2106, 19090, 17770, -1986,
	-2099, 19003, 17859, -1995,
	-2091, 18915, 17947, -2003,
	-2083, 18827, 18035, -2011,
	-2076, 18740, 18124, -2020,
	-2068, 18652, 18212, -2028,
	-2060, 18564, 18300, -2036,
	-2052, 18476, 18388, -2044,
	-2044, 18388, 18476, -2052,
	-2036, 18300, 18564, -2060,
	-2028, 18212, 18652, -2068,
	-2020, 18124, 18740, -2076,
	-2011, 18035, 18827, -2083,
	-2003, 17947, 18915, -2091,
	-1995, 17859, 19003, -2099,
	-1986, 17770, 19090, -2106,
	-1978, 17682, 19178, -2114,
	-1969, 17593, 19265, -2121,
	-1961, 17505, 19352, -2128,
	-1952, 17416, 19439, -2136,
	-1943, 17328, 19526, -2143,
	-1935, 17239, 19613, -2150,
	-1926, 17151, 19700, -2157,
	-1917, 17062, 19787, -2164,
	-1908, 16973, 19874, -2171,
	-1899, 16884, 19960, -2178,
	-1890, 16796, 20047, -2185,
	-1881, 16707, 20133, -2191,
	-1872, 16618, 20220, -2198,
	-1863, 16529, 20306, -2204,
	-1854, 16440, 20392, -2211,
	-1844, 16351, 20478, -2217,
	-1835, 16263, 20564, -2223,
	-1826, 16174, 20650, -2230,
	-1816, 16085, 20735, -2236,
	-1807, 15996, 20821, -2242,
	-1797, 15907, 20906, -2248,
	-1788, 15818, 20991, -2254,
	-1778, 15729, 21077, -2259,
	-1769, 15640, 21162, -2265,
	-1759, 15552, 21246, -2271,
	-1750, 15463, 21331, -2276,
	-1740, 15374, 21416, -2282,
	-1730, 15285, 21500, -2287,
	-1720, 15196, 21585, -2292,
	-1710, 15107, 21669, -2298,
	-1701, 15019, 21753, -2303,
	-1691, 14930, 21837, -2308,
	-1681, 14841, 21920, -2313,
	-1671, 14752, 22004, -2317,
	-1661, 14664, 22087, -2322,
	-1651, 14575, 22171, -2327,
	-1641, 14486, 22254, -2331,
	-1631, 14398, 22337, -2336,
	-1621, 14309, 22420, -2340,
	-1611, 14221, 22502, -2344,
	-1600, 14132, 22585, -2349,
	-1590, 14044, 22667, -2353,
	-1580, 13955, 22749, -2357,
	-1570, 13867, 22831, -2360,
	-1560, 13779, 22913, -2364,
	-1549, 13691, 22994, -2368,
	-1539, 13602, 23076, -2371,
	-1529, 13514, 23157, -2375,
	-1518, 13426, 23238, -2378,
	-1508, 13338, 23319, -2381,
	-1497, 13250, 23400, -2385,
	-1487, 13163, 23480, -2388,
	-1477, 13075, 23561, -2391,
	-1466, 12987, 23641, -2393,
	-1456, 12899, 23721, -2396,
	-1445, 12812, 23800, -2399,
	-1435, 12724, 23880, -2401,
	-1424, 12637, 23959, -2404,
	-1414, 12549, 24038, -2406,
	-1403, 12462, 24117, -2408,
	-1393, 12375, 24196, -2410,
	-1382, 12288, 24274, -2412,
	-1371, 12201, 24352, -2414,
	-1361, 12114, 24430, -2416,
	-1350, 12027, 24508, -2417,
	-1340, 11941, 24586, -2419,
	-1329, 11854, 24663, -2420,
	-1318, 11767, 24740, -2421,
	-1308, 11681, 24817, -2422,
	-1297, 11595, 24894, -2423,
	-1286, 11509, 24970, -2424,
	-1276, 11422, 25046, -2425,
	-1265, 11337, 25122, -2426,
	-1255, 11251, 25198, -2426,
	-1244, 11165, 25274, -2427,
	-1233, 11079, 25349, -2427,
	-1223, 10994, 25424, -2427,
	-1212, 10908, 25499, -2427,
	-1201, 10823, 25573, -2427,
	-1191, 10738, 25647, -2427,
	-1180, 10653, 25721, -2427,
	-1169, 10568, 25795, -2426,
	-1159, 10483, 25869, -2426,
	-1148, 10399, 25942, -2425,
	-1137, 10314, 26015, -2424,
	-1127, 10230, 26087, -2423,
	-1116, 10146, 26160, -2422,
	-1105, 10062, 26232, -2421,
	-1095, 9978, 26304, -2419,
	-1084, 9894, 26376, -2418,
	-1073, 9811, 26447, -2416,
	-1063, 9727, 26518, -2414,
	-1052, 9644, 26589, -2412,
	-1042, 9561, 26659, -2410,
	-1031, 9478, 26729, -2408,
	-1021, 9395, 26799, -2406,
	-1010, 9313, 26869, -2403,
	-1000, 9230, 26938, -2401,
	-989, 9148, 27007, -2398,
	-979, 9066, 27076, -2395,
	-968, 8984, 27144, -2392,
	-958, 8902, 27212, -2389,
	-947, 8821, 27280, -2386,
	-937, 8739, 27348, -2382,
	-926, 8658, 27415, -2379,
	-916, 8577, 27482, -2375,
	-906, 8496, 27549, -2371,
	-895, 8415, 27615, -2367,
	-885, 8335, 27681, -2363,
	-875, 8255, 27746, -2359,
	-864, 8175, 27812, -2354,
	-854, 8095, 27877, -2349,
	-844, 8015, 27941, -2345,
	-834, 7936, 28006, -2340,
	-823, 7856, 28070, -2335,
	-813, 7777, 28134, -2329,
	-803, 7698, 28197, -2324,
	-793, 7620, 28260, -2319,
	-783, 7541, 28323, -2313,
	-773, 7463, 28385, -2307,
	-763, 7385, 28447, -2301,
	-753, 7307, 28509, -2295,
	-743, 7230, 28570, -2289,
	-733, 7152, 28631, -2282,
	-723, 7075, 28691, -2275,
	-713, 6998, 28752, -2269,
	-704, 6922, 28812, -2262,
	-694, 6845, 28871, -2255,
	-684, 6769, 28930, -2247,
	-675, 6693, 28989, -2240,
	-665, 6617, 29048, -2232,
	-655, 6542, 29106, -2224,
	-646, 6467, 29163, -2217,
	-636, 6392, 29221, -2208,
	-627, 6317, 29278, -2200,
	-617, 6243, 29334, -2192,
	-608, 6168, 29391, -2183,
	-598, 6094, 29446, -2174,
	-589, 6021, 29502, -2165,
	-580, 5947, 29557, -2156,
	-571, 5874, 29612, -2147,
	-561, 5801, 29666, -2138,
	-552, 5729, 29720, -2128,
	-543, 5656, 29773, -2118,
	-534, 5584, 29826, -2108,
	-525, 5512, 29879, -2098,
	-516, 5441, 29931, -2088,
	-507, 5369, 29983, -2077,
	-499, 5298, 30035, -2067,
	-490, 5228, 30086, -2056,
	-481, 5157, 30137, -2045,
	-472, 5087, 30187, -2034,
	-464, 5017, 30237, -2022,
	-455, 4948, 30286, -2011,
	-447, 4878, 30335, -1999,
	-438, 4809, 30384, -1987,
	-430, 4741, 30432, -1975,
	-421, 4672, 30480, -1963,
	-413, 4604, 30527, -1950,
	-405, 4536, 30574, -1938,
	-397, 4469, 30621, -1925,
	-389, 4402, 30667, -1912,
	-381, 4335, 30712, -1899,
	-373, 4268, 30758, -1885,
	-365, 4202, 30802, -1872,
	-357, 4136, 30847, -1858,
	-349, 4070, 30891, -1844,
	-341, 4005, 30934, -1830,
	-334, 3940, 30977, -1815,
	-326, 3875, 31019, -1801,
	-319, 3811, 31062, -1786,
	-311, 3747, 31103, -1771,
	-304, 3683, 31144, -1756,
	-296, 3620, 31185, -1741,
	-289, 3557, 31225, -1725,
	-282, 3495, 31265, -1709,
	-275, 3432, 31304, -1694,
	-268, 3370, 31343, -1677,
	-261, 3309, 31381, -1661,
	-254, 3247, 31419, -1645,
	-247, 3186, 31457, -1628,
	-240, 3126, 31494, -1611,
	-234, 3066, 31530, -1594,
	-227, 3006, 31566, -1577,
	-221, 2946, 31602, -1559,
	-214, 2887, 31637, -1542,
	-208, 2828, 31671, -1524,
	-202, 2770, 31705, -1506,
	-196, 2712, 31739, -1487,
	-189, 2654, 31772, -1469,
	-183, 2597, 31804, -1450,
	-177, 2540, 31836, -1431,
	-172, 2483, 31868, -1412,
	-166, 2427, 31899, -1392,
	-160, 2371, 31930, -1373,
	-155, 2316, 31960, -1353,
	-149, 2261, 31989, -1333,
	-144, 2206, 32018, -1313,
	-138, 2152, 32047, -1293,
	-133, 2098, 32075, -1272,
	-128, 2045, 32102, -1251,
	-123, 1992, 32129, -1230,
	-118, 1939, 32156, -1209,
	-113, 1887, 32181, -1187,
	-108, 1835, 32207, -1166,
	-104, 1783, 32232, -1144,
	-99, 1732, 32256, -1121,
	-94, 1682, 32280, -1099,
	-90, 1631, 32303, -1076,
	-86, 1582, 32326, -1054,
	-81, 1532, 32348, -1031,
	-77, 1483, 32369, -1007,
	-73, 1435, 32391, -984,
	-69, 1387, 32411, -960,
	-66, 1339, 32431, -936,
	-62, 1291, 32450, -912,
	-58, 1245, 32469, -888,
	-55, 1198, 32488, -863,
	-51, 1152, 32505, -838,
	-48, 1107, 32523, -813,
	-45, 1061, 32539, -788,
	-42, 1017, 32555, -762,
	-39, 972, 32571, -737,
	-36, 929, 32586, -711,
	-33, 885, 32600, -685,
	-30, 842, 32614, -658,
	-28, 800, 32627, -631,
	-25, 758, 32640, -605,
	-23, 716, 32652, -577,
	-21, 675, 32663, -550,
	-18, 635, 32674, -522,
	-16, 594, 32685, -495,
	-15, 555, 32694, -466,
	-13, 515, 32703, -438,
	-11, 477, 32712, -410,
	-10, 438, 32720, -381,
	-8, 401, 32727, -352,
	-7, 363, 32734, -322,
	-6, 326, 32740, -293,
	-4, 290, 32746, -263,
	-3, 254, 32751, -233,
	-3, 218, 32755, -203,
	-2, 184, 32759, -172,
	-1, 149, 32762, -141,
	-1, 115, 32764, -110,
	0, 82, 32766, -79,
	0, 49, 32767, -48,
	0, 16, 32767, -16
};

/* *********************************************************** */

const mlib_s16 mlib_filters_s16_bc2[] = {
	-32, 32767, 32, 0,
	-95, 32767, 96, 0,
	-158, 32766, 161, -1,
	-221, 32765, 226, -2,
	-283, 32763, 291, -3,
	-344, 32760, 356, -4,
	-406, 32758, 421, -5,
	-466, 32754, 487, -7,
	-526, 32750, 553, -9,
	-586, 32746, 619, -11,
	-645, 32741, 685, -13,
	-703, 32735, 752, -16,
	-761, 32729, 819, -19,
	-819, 32723, 886, -22,
	-876, 32716, 954, -26,
	-933, 32709, 1021, -29,
	-989, 32701, 1089, -33,
	-1045, 32693, 1157, -37,
	-1100, 32684, 1225, -41,
	-1155, 32675, 1294, -46,
	-1209, 32665, 1362, -50,
	-1263, 32655, 1431, -55,
	-1316, 32644, 1501, -61,
	-1369, 32633, 1570, -66,
	-1422, 32622, 1639, -71,
	-1473, 32609, 1709, -77,
	-1525, 32597, 1779, -83,
	-1576, 32584, 1849, -89,
	-1627, 32571, 1920, -96,
	-1677, 32557, 1991, -103,
	-1726, 32542, 2061, -109,
	-1776, 32528, 2132, -116,
	-1824, 32512, 2204, -124,
	-1873, 32497, 2275, -131,
	-1920, 32480, 2347, -139,
	-1968, 32464, 2419, -147,
	-2015, 32447, 2491, -155,
	-2061, 32429, 2563, -163,
	-2107, 32411, 2635, -171,
	-2153, 32393, 2708, -180,
	-2198, 32374, 2781, -189,
	-2243, 32355, 2854, -198,
	-2287, 32335, 2927, -207,
	-2331, 32315, 3000, -216,
	-2374, 32294, 3074, -226,
	-2417, 32273, 3148, -236,
	-2460, 32252, 3222, -246,
	-2502, 32230, 3296, -256,
	-2544, 32208, 3370, -266,
	-2585, 32185, 3445, -277,
	-2626, 32162, 3519, -287,
	-2666, 32138, 3594, -298,
	-2706, 32114, 3669, -309,
	-2746, 32090, 3744, -320,
	-2785, 32065, 3820, -332,
	-2824, 32040, 3895, -343,
	-2862, 32014, 3971, -355,
	-2900, 31988, 4047, -367,
	-2937, 31961, 4123, -379,
	-2974, 31934, 4199, -391,
	-3011, 31907, 4275, -403,
	-3047, 31879, 4352, -416,
	-3083, 31851, 4429, -429,
	-3118, 31822, 4506, -442,
	-3153, 31793, 4583, -455,
	-3188, 31764, 4660, -468,
	-3222, 31734, 4737, -481,
	-3256, 31704, 4814, -494,
	-3289, 31673, 4892, -508,
	-3322, 31642, 4970, -522,
	-3355, 31611, 5048, -536,
	-3387, 31579, 5126, -550,
	-3419, 31547, 5204, -564,
	-3450, 31514, 5282, -578,
	-3481, 31481, 5361, -593,
	-3512, 31448, 5439, -607,
	-3542, 31414, 5518, -622,
	-3572, 31380, 5597, -637,
	-3602, 31346, 5676, -652,
	-3631, 31311, 5755, -667,
	-3659, 31275, 5835, -683,
	-3688, 31240, 5914, -698,
	-3716, 31204, 5994, -714,
	-3743, 31167, 6073, -729,
	-3770, 31130, 6153, -745,
	-3797, 31093, 6233, -761,
	-3823, 31055, 6313, -777,
	-3849, 31017, 6393, -793,
	-3875, 30979, 6474, -810,
	-3900, 30940, 6554, -826,
	-3925, 30901, 6635, -843,
	-3950, 30862, 6716, -860,
	-3974, 30822, 6796, -876,
	-3998, 30782, 6877, -893,
	-4021, 30741, 6958, -910,
	-4045, 30701, 7039, -927,
	-4067, 30659, 7121, -945,
	-4090, 30618, 7202, -962,
	-4112, 30576, 7283, -979,
	-4133, 30533, 7365, -997,
	-4155, 30491, 7447, -1015,
	-4176, 30448, 7528, -1032,
	-4196, 30404, 7610, -1050,
	-4217, 30361, 7692, -1068,
	-4237, 30317, 7774, -1086,
	-4256, 30272, 7857, -1105,
	-4275, 30227, 7939, -1123,
	-4294, 30182, 8021, -1141,
	-4313, 30137, 8104, -1160,
	-4331, 30091, 8186, -1178,
	-4349, 30045, 8269, -1197,
	-4366, 29998, 8352, -1216,
	-4384, 29952, 8434, -1234,
	-4400, 29904, 8517, -1253,
	-4417, 29857, 8600, -1272,
	-4433, 29809, 8683, -1291,
	-4449, 29761, 8767, -1311,
	-4464, 29712, 8850, -1330,
	-4480, 29664, 8933, -1349,
	-4495, 29615, 9016, -1368,
	-4509, 29565, 9100, -1388,
	-4523, 29515, 9183, -1407,
	-4537, 29465, 9267, -1427,
	-4551, 29415, 9351, -1447,
	-4564, 29364, 9434, -1466,
	-4577, 29313, 9518, -1486,
	-4590, 29262, 9602, -1506,
	-4602, 29210, 9686, -1526,
	-4614, 29158, 9770, -1546,
	-4626, 29106, 9854, -1566,
	-4637, 29053, 9938, -1586,
	-4648, 29000, 10022, -1606,
	-4659, 28947, 10107, -1627,
	-4669, 28893, 10191, -1647,
	-4679, 28839, 10275, -1667,
	-4689, 28785, 10360, -1688,
	-4699, 28731, 10444, -1708,
	-4708, 28676, 10529, -1729,
	-4717, 28621, 10613, -1749,
	-4726, 28566, 10698, -1770,
	-4734, 28510, 10782, -1790,
	-4742, 28454, 10867, -1811,
	-4750, 28398, 10952, -1832,
	-4757, 28341, 11037, -1853,
	-4765, 28285, 11121, -1873,
	-4771, 28227, 11206, -1894,
	-4778, 28170, 11291, -1915,
	-4784, 28112, 11376, -1936,
	-4790, 28054, 11461, -1957,
	-4796, 27996, 11546, -1978,
	-4802, 27938, 11631, -1999,
	-4807, 27879, 11716, -2020,
	-4812, 27820, 11801, -2041,
	-4816, 27760, 11886, -2062,
	-4821, 27701, 11971, -2083,
	-4825, 27641, 12057, -2105,
	-4829, 27581, 12142, -2126,
	-4832, 27520, 12227, -2147,
	-4836, 27460, 12312, -2168,
	-4839, 27399, 12397, -2189,
	-4841, 27337, 12483, -2211,
	-4844, 27276, 12568, -2232,
	-4846, 27214, 12653, -2253,
	-4848, 27152, 12738, -2274,
	-4850, 27090, 12824, -2296,
	-4851, 27027, 12909, -2317,
	-4852, 26964, 12994, -2338,
	-4853, 26901, 13080, -2360,
	-4854, 26838, 13165, -2381,
	-4854, 26774, 13250, -2402,
	-4855, 26711, 13336, -2424,
	-4854, 26646, 13421, -2445,
	-4854, 26582, 13506, -2466,
	-4854, 26518, 13592, -2488,
	-4853, 26453, 13677, -2509,
	-4852, 26388, 13762, -2530,
	-4850, 26322, 13848, -2552,
	-4849, 26257, 13933, -2573,
	-4847, 26191, 14018, -2594,
	-4845, 26125, 14104, -2616,
	-4843, 26059, 14189, -2637,
	-4840, 25992, 14274, -2658,
	-4837, 25925, 14359, -2679,
	-4834, 25858, 14445, -2701,
	-4831, 25791, 14530, -2722,
	-4828, 25724, 14615, -2743,
	-4824, 25656, 14700, -2764,
	-4820, 25588, 14785, -2785,
	-4816, 25520, 14870, -2806,
	-4812, 25452, 14955, -2827,
	-4807, 25383, 15040, -2848,
	-4802, 25314, 15125, -2869,
	-4797, 25245, 15210, -2890,
	-4792, 25176, 15295, -2911,
	-4787, 25107, 15380, -2932,
	-4781, 25037, 15465, -2953,
	-4775, 24967, 15550, -2974,
	-4769, 24897, 15635, -2995,
	-4763, 24827, 15720, -3016,
	-4756, 24756, 15805, -3037,
	-4750, 24686, 15889, -3057,
	-4743, 24615, 15974, -3078,
	-4736, 24544, 16058, -3098,
	-4728, 24472, 16143, -3119,
	-4721, 24401, 16228, -3140,
	-4713, 24329, 16312, -3160,
	-4705, 24257, 16396, -3180,
	-4697, 24185, 16481, -3201,
	-4689, 24113, 16565, -3221,
	-4680, 24040, 16649, -3241,
	-4672, 23968, 16734, -3262,
	-4663, 23895, 16818, -3282,
	-4654, 23822, 16902, -3302,
	-4644, 23748, 16986, -3322,
	-4635, 23675, 17070, -3342,
	-4625, 23601, 17154, -3362,
	-4615, 23527, 17238, -3382,
	-4605, 23453, 17321, -3401,
	-4595, 23379, 17405, -3421,
	-4585, 23305, 17489, -3441,
	-4574, 23230, 17572, -3460,
	-4564, 23156, 17656, -3480,
	-4553, 23081, 17739, -3499,
	-4542, 23006, 17822, -3518,
	-4530, 22930, 17906, -3538,
	-4519, 22855, 17989, -3557,
	-4507, 22779, 18072, -3576,
	-4496, 22704, 18155, -3595,
	-4484, 22628, 18238, -3614,
	-4472, 22552, 18321, -3633,
	-4459, 22475, 18403, -3651,
	-4447, 22399, 18486, -3670,
	-4434, 22322, 18569, -3689,
	-4422, 22246, 18651, -3707,
	-4409, 22169, 18734, -3726,
	-4396, 22092, 18816, -3744,
	-4382, 22014, 18898, -3762,
	-4369, 21937, 18980, -3780,
	-4356, 21860, 19062, -3798,
	-4342, 21782, 19144, -3816,
	-4328, 21704, 19226, -3834,
	-4314, 21626, 19308, -3852,
	-4300, 21548, 19389, -3869,
	-4286, 21470, 19471, -3887,
	-4271, 21391, 19552, -3904,
	-4257, 21313, 19633, -3921,
	-4242, 21234, 19715, -3939,
	-4227, 21155, 19796, -3956,
	-4212, 21076, 19877, -3973,
	-4197, 20997, 19957, -3989,
	-4182, 20918, 20038, -4006,
	-4167, 20839, 20119, -4023,
	-4151, 20759, 20199, -4039,
	-4136, 20680, 20280, -4056,
	-4120, 20600, 20360, -4072,
	-4104, 20520, 20440, -4088,
	-4088, 20440, 20520, -4104,
	-4072, 20360, 20600, -4120,
	-4056, 20280, 20680, -4136,
	-4039, 20199, 20759, -4151,
	-4023, 20119, 20839, -4167,
	-4006, 20038, 20918, -4182,
	-3989, 19957, 20997, -4197,
	-3973, 19877, 21076, -4212,
	-3956, 19796, 21155, -4227,
	-3939, 19715, 21234, -4242,
	-3921, 19633, 21313, -4257,
	-3904, 19552, 21391, -4271,
	-3887, 19471, 21470, -4286,
	-3869, 19389, 21548, -4300,
	-3852, 19308, 21626, -4314,
	-3834, 19226, 21704, -4328,
	-3816, 19144, 21782, -4342,
	-3798, 19062, 21860, -4356,
	-3780, 18980, 21937, -4369,
	-3762, 18898, 22014, -4382,
	-3744, 18816, 22092, -4396,
	-3726, 18734, 22169, -4409,
	-3707, 18651, 22246, -4422,
	-3689, 18569, 22322, -4434,
	-3670, 18486, 22399, -4447,
	-3651, 18403, 22475, -4459,
	-3633, 18321, 22552, -4472,
	-3614, 18238, 22628, -4484,
	-3595, 18155, 22704, -4496,
	-3576, 18072, 22779, -4507,
	-3557, 17989, 22855, -4519,
	-3538, 17906, 22930, -4530,
	-3518, 17822, 23006, -4542,
	-3499, 17739, 23081, -4553,
	-3480, 17656, 23156, -4564,
	-3460, 17572, 23230, -4574,
	-3441, 17489, 23305, -4585,
	-3421, 17405, 23379, -4595,
	-3401, 17321, 23453, -4605,
	-3382, 17238, 23527, -4615,
	-3362, 17154, 23601, -4625,
	-3342, 17070, 23675, -4635,
	-3322, 16986, 23748, -4644,
	-3302, 16902, 23822, -4654,
	-3282, 16818, 23895, -4663,
	-3262, 16734, 23968, -4672,
	-3241, 16649, 24040, -4680,
	-3221, 16565, 24113, -4689,
	-3201, 16481, 24185, -4697,
	-3180, 16396, 24257, -4705,
	-3160, 16312, 24329, -4713,
	-3140, 16228, 24401, -4721,
	-3119, 16143, 24472, -4728,
	-3098, 16058, 24544, -4736,
	-3078, 15974, 24615, -4743,
	-3057, 15889, 24686, -4750,
	-3037, 15805, 24756, -4756,
	-3016, 15720, 24827, -4763,
	-2995, 15635, 24897, -4769,
	-2974, 15550, 24967, -4775,
	-2953, 15465, 25037, -4781,
	-2932, 15380, 25107, -4787,
	-2911, 15295, 25176, -4792,
	-2890, 15210, 25245, -4797,
	-2869, 15125, 25314, -4802,
	-2848, 15040, 25383, -4807,
	-2827, 14955, 25452, -4812,
	-2806, 14870, 25520, -4816,
	-2785, 14785, 25588, -4820,
	-2764, 14700, 25656, -4824,
	-2743, 14615, 25724, -4828,
	-2722, 14530, 25791, -4831,
	-2701, 14445, 25858, -4834,
	-2679, 14359, 25925, -4837,
	-2658, 14274, 25992, -4840,
	-2637, 14189, 26059, -4843,
	-2616, 14104, 26125, -4845,
	-2594, 14018, 26191, -4847,
	-2573, 13933, 26257, -4849,
	-2552, 13848, 26322, -4850,
	-2530, 13762, 26388, -4852,
	-2509, 13677, 26453, -4853,
	-2488, 13592, 26518, -4854,
	-2466, 13506, 26582, -4854,
	-2445, 13421, 26646, -4854,
	-2424, 13336, 26711, -4855,
	-2402, 13250, 26774, -4854,
	-2381, 13165, 26838, -4854,
	-2360, 13080, 26901, -4853,
	-2338, 12994, 26964, -4852,
	-2317, 12909, 27027, -4851,
	-2296, 12824, 27090, -4850,
	-2274, 12738, 27152, -4848,
	-2253, 12653, 27214, -4846,
	-2232, 12568, 27276, -4844,
	-2211, 12483, 27337, -4841,
	-2189, 12397, 27399, -4839,
	-2168, 12312, 27460, -4836,
	-2147, 12227, 27520, -4832,
	-2126, 12142, 27581, -4829,
	-2105, 12057, 27641, -4825,
	-2083, 11971, 27701, -4821,
	-2062, 11886, 27760, -4816,
	-2041, 11801, 27820, -4812,
	-2020, 11716, 27879, -4807,
	-1999, 11631, 27938, -4802,
	-1978, 11546, 27996, -4796,
	-1957, 11461, 28054, -4790,
	-1936, 11376, 28112, -4784,
	-1915, 11291, 28170, -4778,
	-1894, 11206, 28227, -4771,
	-1873, 11121, 28285, -4765,
	-1853, 11037, 28341, -4757,
	-1832, 10952, 28398, -4750,
	-1811, 10867, 28454, -4742,
	-1790, 10782, 28510, -4734,
	-1770, 10698, 28566, -4726,
	-1749, 10613, 28621, -4717,
	-1729, 10529, 28676, -4708,
	-1708, 10444, 28731, -4699,
	-1688, 10360, 28785, -4689,
	-1667, 10275, 28839, -4679,
	-1647, 10191, 28893, -4669,
	-1627, 10107, 28947, -4659,
	-1606, 10022, 29000, -4648,
	-1586, 9938, 29053, -4637,
	-1566, 9854, 29106, -4626,
	-1546, 9770, 29158, -4614,
	-1526, 9686, 29210, -4602,
	-1506, 9602, 29262, -4590,
	-1486, 9518, 29313, -4577,
	-1466, 9434, 29364, -4564,
	-1447, 9351, 29415, -4551,
	-1427, 9267, 29465, -4537,
	-1407, 9183, 29515, -4523,
	-1388, 9100, 29565, -4509,
	-1368, 9016, 29615, -4495,
	-1349, 8933, 29664, -4480,
	-1330, 8850, 29712, -4464,
	-1311, 8767, 29761, -4449,
	-1291, 8683, 29809, -4433,
	-1272, 8600, 29857, -4417,
	-1253, 8517, 29904, -4400,
	-1234, 8434, 29952, -4384,
	-1216, 8352, 29998, -4366,
	-1197, 8269, 30045, -4349,
	-1178, 8186, 30091, -4331,
	-1160, 8104, 30137, -4313,
	-1141, 8021, 30182, -4294,
	-1123, 7939, 30227, -4275,
	-1105, 7857, 30272, -4256,
	-1086, 7774, 30317, -4237,
	-1068, 7692, 30361, -4217,
	-1050, 7610, 30404, -4196,
	-1032, 7528, 30448, -4176,
	-1015, 7447, 30491, -4155,
	-997, 7365, 30533, -4133,
	-979, 7283, 30576, -4112,
	-962, 7202, 30618, -4090,
	-945, 7121, 30659, -4067,
	-927, 7039, 30701, -4045,
	-910, 6958, 30741, -4021,
	-893, 6877, 30782, -3998,
	-876, 6796, 30822, -3974,
	-860, 6716, 30862, -3950,
	-843, 6635, 30901, -3925,
	-826, 6554, 30940, -3900,
	-810, 6474, 30979, -3875,
	-793, 6393, 31017, -3849,
	-777, 6313, 31055, -3823,
	-761, 6233, 31093, -3797,
	-745, 6153, 31130, -3770,
	-729, 6073, 31167, -3743,
	-714, 5994, 31204, -3716,
	-698, 5914, 31240, -3688,
	-683, 5835, 31275, -3659,
	-667, 5755, 31311, -3631,
	-652, 5676, 31346, -3602,
	-637, 5597, 31380, -3572,
	-622, 5518, 31414, -3542,
	-607, 5439, 31448, -3512,
	-593, 5361, 31481, -3481,
	-578, 5282, 31514, -3450,
	-564, 5204, 31547, -3419,
	-550, 5126, 31579, -3387,
	-536, 5048, 31611, -3355,
	-522, 4970, 31642, -3322,
	-508, 4892, 31673, -3289,
	-494, 4814, 31704, -3256,
	-481, 4737, 31734, -3222,
	-468, 4660, 31764, -3188,
	-455, 4583, 31793, -3153,
	-442, 4506, 31822, -3118,
	-429, 4429, 31851, -3083,
	-416, 4352, 31879, -3047,
	-403, 4275, 31907, -3011,
	-391, 4199, 31934, -2974,
	-379, 4123, 31961, -2937,
	-367, 4047, 31988, -2900,
	-355, 3971, 32014, -2862,
	-343, 3895, 32040, -2824,
	-332, 3820, 32065, -2785,
	-320, 3744, 32090, -2746,
	-309, 3669, 32114, -2706,
	-298, 3594, 32138, -2666,
	-287, 3519, 32162, -2626,
	-277, 3445, 32185, -2585,
	-266, 3370, 32208, -2544,
	-256, 3296, 32230, -2502,
	-246, 3222, 32252, -2460,
	-236, 3148, 32273, -2417,
	-226, 3074, 32294, -2374,
	-216, 3000, 32315, -2331,
	-207, 2927, 32335, -2287,
	-198, 2854, 32355, -2243,
	-189, 2781, 32374, -2198,
	-180, 2708, 32393, -2153,
	-171, 2635, 32411, -2107,
	-163, 2563, 32429, -2061,
	-155, 2491, 32447, -2015,
	-147, 2419, 32464, -1968,
	-139, 2347, 32480, -1920,
	-131, 2275, 32497, -1873,
	-124, 2204, 32512, -1824,
	-116, 2132, 32528, -1776,
	-109, 2061, 32542, -1726,
	-103, 1991, 32557, -1677,
	-96, 1920, 32571, -1627,
	-89, 1849, 32584, -1576,
	-83, 1779, 32597, -1525,
	-77, 1709, 32609, -1473,
	-71, 1639, 32622, -1422,
	-66, 1570, 32633, -1369,
	-61, 1501, 32644, -1316,
	-55, 1431, 32655, -1263,
	-50, 1362, 32665, -1209,
	-46, 1294, 32675, -1155,
	-41, 1225, 32684, -1100,
	-37, 1157, 32693, -1045,
	-33, 1089, 32701, -989,
	-29, 1021, 32709, -933,
	-26, 954, 32716, -876,
	-22, 886, 32723, -819,
	-19, 819, 32729, -761,
	-16, 752, 32735, -703,
	-13, 685, 32741, -645,
	-11, 619, 32746, -586,
	-9, 553, 32750, -526,
	-7, 487, 32754, -466,
	-5, 421, 32758, -406,
	-4, 356, 32760, -344,
	-3, 291, 32763, -283,
	-2, 226, 32765, -221,
	-1, 161, 32766, -158,
	0, 96, 32767, -95,
	0, 32, 32767, -32
};

/* *********************************************************** */
