/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)mlib_ImageExpTbl.c	9.2	07/10/09 SMI"

/*
 * Tables of constants for mlib_ImageExp_Fp function
 */

#include <mlib_types.h>
#include <mlib_ImageExpTbl.h>

const mlib_d64 mlib_constexp_hi[] = {
/* 2 ** (  0/256) */
	1.0000000000000000000e+00,
/* 2 ** (  1/256) */
	1.0027112750502024854e+00,
/* 2 ** (  2/256) */
	1.0054299011128028214e+00,
/* 2 ** (  3/256) */
	1.0081558981184175158e+00,
/* 2 ** (  4/256) */
	1.0108892860517004600e+00,
/* 2 ** (  5/256) */
	1.0136300849514894388e+00,
/* 2 ** (  6/256) */
	1.0163783149109530379e+00,
/* 2 ** (  7/256) */
	1.0191339960777379497e+00,
/* 2 ** (  8/256) */
	1.0218971486541166782e+00,
/* 2 ** (  9/256) */
	1.0246677928971356451e+00,
/* 2 ** ( 10/256) */
	1.0274459491187636965e+00,
/* 2 ** ( 11/256) */
	1.0302316376860410129e+00,
/* 2 ** ( 12/256) */
	1.0330248790212284225e+00,
/* 2 ** ( 13/256) */
	1.0358256936019571200e+00,
/* 2 ** ( 14/256) */
	1.0386341019613787906e+00,
/* 2 ** ( 15/256) */
	1.0414501246883161413e+00,
/* 2 ** ( 16/256) */
	1.0442737824274138403e+00,
/* 2 ** ( 17/256) */
	1.0471050958792898661e+00,
/* 2 ** ( 18/256) */
	1.0499440858006872661e+00,
/* 2 ** ( 19/256) */
	1.0527907730046263271e+00,
/* 2 ** ( 20/256) */
	1.0556451783605571588e+00,
/* 2 ** ( 21/256) */
	1.0585073227945126901e+00,
/* 2 ** ( 22/256) */
	1.0613772272892620810e+00,
/* 2 ** ( 23/256) */
	1.0642549128844645498e+00,
/* 2 ** ( 24/256) */
	1.0671404006768236182e+00,
/* 2 ** ( 25/256) */
	1.0700337118202417735e+00,
/* 2 ** ( 26/256) */
	1.0729348675259755514e+00,
/* 2 ** ( 27/256) */
	1.0758438890627910378e+00,
/* 2 ** ( 28/256) */
	1.0787607977571197937e+00,
/* 2 ** ( 29/256) */
	1.0816856149932152019e+00,
/* 2 ** ( 30/256) */
	1.0846183622133092378e+00,
/* 2 ** ( 31/256) */
	1.0875590609177696653e+00,
/* 2 ** ( 32/256) */
	1.0905077326652576592e+00,
/* 2 ** ( 33/256) */
	1.0934643990728858542e+00,
/* 2 ** ( 34/256) */
	1.0964290818163768234e+00,
/* 2 ** ( 35/256) */
	1.0994018026302219855e+00,
/* 2 ** ( 36/256) */
	1.1023825833078409436e+00,
/* 2 ** ( 37/256) */
	1.1053714457017412556e+00,
/* 2 ** ( 38/256) */
	1.1083684117236786380e+00,
/* 2 ** ( 39/256) */
	1.1113735033448176039e+00,
/* 2 ** ( 40/256) */
	1.1143867425958925363e+00,
/* 2 ** ( 41/256) */
	1.1174081515673691991e+00,
/* 2 ** ( 42/256) */
	1.1204377524096066844e+00,
/* 2 ** ( 43/256) */
	1.1234755673330198007e+00,
/* 2 ** ( 44/256) */
	1.1265216186082418998e+00,
/* 2 ** ( 45/256) */
	1.1295759285662881460e+00,
/* 2 ** ( 46/256) */
	1.1326385195987192280e+00,
/* 2 ** ( 47/256) */
	1.1357094141578055142e+00,
/* 2 ** ( 48/256) */
	1.1387886347566916537e+00,
/* 2 ** ( 49/256) */
	1.1418762039695616227e+00,
/* 2 ** ( 50/256) */
	1.1449721444318042194e+00,
/* 2 ** ( 51/256) */
	1.1480764788401790068e+00,
/* 2 ** ( 52/256) */
	1.1511892299529827058e+00,
/* 2 ** ( 53/256) */
	1.1543104205902160395e+00,
/* 2 ** ( 54/256) */
	1.1574400736337510296e+00,
/* 2 ** ( 55/256) */
	1.1605782120274987464e+00,
/* 2 ** ( 56/256) */
	1.1637248587775775138e+00,
/* 2 ** ( 57/256) */
	1.1668800369524815706e+00,
/* 2 ** ( 58/256) */
	1.1700437696832501881e+00,
/* 2 ** ( 59/256) */
	1.1732160801636372475e+00,
/* 2 ** ( 60/256) */
	1.1763969916502812763e+00,
/* 2 ** ( 61/256) */
	1.1795865274628759455e+00,
/* 2 ** ( 62/256) */
	1.1827847109843410299e+00,
/* 2 ** ( 63/256) */
	1.1859915656609938314e+00,
/* 2 ** ( 64/256) */
	1.1892071150027210667e+00,
/* 2 ** ( 65/256) */
	1.1924313825831512221e+00,
/* 2 ** ( 66/256) */
	1.1956643920398273746e+00,
/* 2 ** ( 67/256) */
	1.1989061670743804818e+00,
/* 2 ** ( 68/256) */
	1.2021567314527031421e+00,
/* 2 ** ( 69/256) */
	1.2054161090051238256e+00,
/* 2 ** ( 70/256) */
	1.2086843236265815774e+00,
/* 2 ** ( 71/256) */
	1.2119613992768011945e+00,
/* 2 ** ( 72/256) */
	1.2152473599804688781e+00,
/* 2 ** ( 73/256) */
	1.2185422298274083618e+00,
/* 2 ** ( 74/256) */
	1.2218460329727575169e+00,
/* 2 ** ( 75/256) */
	1.2251587936371454377e+00,
/* 2 ** ( 76/256) */
	1.2284805361068700057e+00,
/* 2 ** ( 77/256) */
	1.2318112847340759359e+00,
/* 2 ** ( 78/256) */
	1.2351510639369333057e+00,
/* 2 ** ( 79/256) */
	1.2384998981998165678e+00,
/* 2 ** ( 80/256) */
	1.2418578120734840486e+00,
/* 2 ** ( 81/256) */
	1.2452248301752579328e+00,
/* 2 ** ( 82/256) */
	1.2486009771892047366e+00,
/* 2 ** ( 83/256) */
	1.2519862778663162701e+00,
/* 2 ** ( 84/256) */
	1.2553807570246910896e+00,
/* 2 ** ( 85/256) */
	1.2587844395497164431e+00,
/* 2 ** ( 86/256) */
	1.2621973503942507080e+00,
/* 2 ** ( 87/256) */
	1.2656195145788063242e+00,
/* 2 ** ( 88/256) */
	1.2690509571917332226e+00,
/* 2 ** ( 89/256) */
	1.2724917033894027512e+00,
/* 2 ** ( 90/256) */
	1.2759417783963921004e+00,
/* 2 ** ( 91/256) */
	1.2794012075056692269e+00,
/* 2 ** ( 92/256) */
	1.2828700160787782807e+00,
/* 2 ** ( 93/256) */
	1.2863482295460255336e+00,
/* 2 ** ( 94/256) */
	1.2898358734066658122e+00,
/* 2 ** ( 95/256) */
	1.2933329732290894367e+00,
/* 2 ** ( 96/256) */
	1.2968395546510096659e+00,
/* 2 ** ( 97/256) */
	1.3003556433796506510e+00,
/* 2 ** ( 98/256) */
	1.3038812651919358986e+00,
/* 2 ** ( 99/256) */
	1.3074164459346772448e+00,
/* 2 ** (100/256) */
	1.3109612115247643419e+00,
/* 2 ** (101/256) */
	1.3145155879493546585e+00,
/* 2 ** (102/256) */
	1.3180796012660639947e+00,
/* 2 ** (103/256) */
	1.3216532776031575143e+00,
/* 2 ** (104/256) */
	1.3252366431597412946e+00,
/* 2 ** (105/256) */
	1.3288297242059543955e+00,
/* 2 ** (106/256) */
	1.3324325470831614494e+00,
/* 2 ** (107/256) */
	1.3360451382041457734e+00,
/* 2 ** (108/256) */
	1.3396675240533030054e+00,
/* 2 ** (109/256) */
	1.3432997311868352638e+00,
/* 2 ** (110/256) */
	1.3469417862329458358e+00,
/* 2 ** (111/256) */
	1.3505937158920343914e+00,
/* 2 ** (112/256) */
	1.3542555469368927283e+00,
/* 2 ** (113/256) */
	1.3579273062129010465e+00,
/* 2 ** (114/256) */
	1.3616090206382247556e+00,
/* 2 ** (115/256) */
	1.3653007172040118154e+00,
/* 2 ** (116/256) */
	1.3690024229745906119e+00,
/* 2 ** (117/256) */
	1.3727141650876683693e+00,
/* 2 ** (118/256) */
	1.3764359707545301002e+00,
/* 2 ** (119/256) */
	1.3801678672602380956e+00,
/* 2 ** (120/256) */
	1.3839098819638319549e+00,
/* 2 ** (121/256) */
	1.3876620422985291590e+00,
/* 2 ** (122/256) */
	1.3914243757719261871e+00,
/* 2 ** (123/256) */
	1.3951969099662001783e+00,
/* 2 ** (124/256) */
	1.3989796725383111402e+00,
/* 2 ** (125/256) */
	1.4027726912202047064e+00,
/* 2 ** (126/256) */
	1.4065759938190154425e+00,
/* 2 ** (127/256) */
	1.4103896082172707044e+00,
/* 2 ** (128/256) */
	1.4142135623730950488e+00,
/* 2 ** (129/256) */
	1.4180478843204151978e+00,
/* 2 ** (130/256) */
	1.4218926021691655598e+00,
/* 2 ** (131/256) */
	1.4257477441054943068e+00,
/* 2 ** (132/256) */
	1.4296133383919700112e+00,
/* 2 ** (133/256) */
	1.4334894133677888425e+00,
/* 2 ** (134/256) */
	1.4373759974489823256e+00,
/* 2 ** (135/256) */
	1.4412731191286256627e+00,
/* 2 ** (136/256) */
	1.4451808069770466200e+00,
/* 2 ** (137/256) */
	1.4490990896420349805e+00,
/* 2 ** (138/256) */
	1.4530279958490525648e+00,
/* 2 ** (139/256) */
	1.4569675544014438216e+00,
/* 2 ** (140/256) */
	1.4609177941806469887e+00,
/* 2 ** (141/256) */
	1.4648787441464058266e+00,
/* 2 ** (142/256) */
	1.4688504333369819269e+00,
/* 2 ** (143/256) */
	1.4728328908693675950e+00,
/* 2 ** (144/256) */
	1.4768261459394993114e+00,
/* 2 ** (145/256) */
	1.4808302278224717705e+00,
/* 2 ** (146/256) */
	1.4848451658727525005e+00,
/* 2 ** (147/256) */
	1.4888709895243970654e+00,
/* 2 ** (148/256) */
	1.4929077282912648492e+00,
/* 2 ** (149/256) */
	1.4969554117672354268e+00,
/* 2 ** (150/256) */
	1.5010140696264255203e+00,
/* 2 ** (151/256) */
	1.5050837316234065441e+00,
/* 2 ** (152/256) */
	1.5091644275934227398e+00,
/* 2 ** (153/256) */
	1.5132561874526099022e+00,
/* 2 ** (154/256) */
	1.5173590411982146988e+00,
/* 2 ** (155/256) */
	1.5214730189088145835e+00,
/* 2 ** (156/256) */
	1.5255981507445383069e+00,
/* 2 ** (157/256) */
	1.5297344669472870239e+00,
/* 2 ** (158/256) */
	1.5338819978409560018e+00,
/* 2 ** (159/256) */
	1.5380407738316569284e+00,
/* 2 ** (160/256) */
	1.5422108254079408236e+00,
/* 2 ** (161/256) */
	1.5463921831410215549e+00,
/* 2 ** (162/256) */
	1.5505848776849999591e+00,
/* 2 ** (163/256) */
	1.5547889397770885721e+00,
/* 2 ** (164/256) */
	1.5590044002378369670e+00,
/* 2 ** (165/256) */
	1.5632312899713577041e+00,
/* 2 ** (166/256) */
	1.5674696399655528931e+00,
/* 2 ** (167/256) */
	1.5717194812923413692e+00,
/* 2 ** (168/256) */
	1.5759808451078864865e+00,
/* 2 ** (169/256) */
	1.5802537626528245268e+00,
/* 2 ** (170/256) */
	1.5845382652524937301e+00,
/* 2 ** (171/256) */
	1.5888343843171639442e+00,
/* 2 ** (172/256) */
	1.5931421513422668979e+00,
/* 2 ** (173/256) */
	1.5974615979086270983e+00,
/* 2 ** (174/256) */
	1.6017927556826933538e+00,
/* 2 ** (175/256) */
	1.6061356564167709257e+00,
/* 2 ** (176/256) */
	1.6104903319492543082e+00,
/* 2 ** (177/256) */
	1.6148568142048606401e+00,
/* 2 ** (178/256) */
	1.6192351351948637493e+00,
/* 2 ** (179/256) */
	1.6236253270173288318e+00,
/* 2 ** (180/256) */
	1.6280274218573477668e+00,
/* 2 ** (181/256) */
	1.6324414519872750703e+00,
/* 2 ** (182/256) */
	1.6368674497669644878e+00,
/* 2 ** (183/256) */
	1.6413054476440062287e+00,
/* 2 ** (184/256) */
	1.6457554781539648445e+00,
/* 2 ** (185/256) */
	1.6502175739206177510e+00,
/* 2 ** (186/256) */
	1.6546917676561943976e+00,
/* 2 ** (187/256) */
	1.6591780921616160854e+00,
/* 2 ** (188/256) */
	1.6636765803267364350e+00,
/* 2 ** (189/256) */
	1.6681872651305825067e+00,
/* 2 ** (190/256) */
	1.6727101796415965736e+00,
/* 2 ** (191/256) */
	1.6772453570178785518e+00,
/* 2 ** (192/256) */
	1.6817928305074290861e+00,
/* 2 ** (193/256) */
	1.6863526334483932959e+00,
/* 2 ** (194/256) */
	1.6909247992693051820e+00,
/* 2 ** (195/256) */
	1.6955093614893326950e+00,
/* 2 ** (196/256) */
	1.7001063537185234695e+00,
/* 2 ** (197/256) */
	1.7047158096580512237e+00,
/* 2 ** (198/256) */
	1.7093377631004628271e+00,
/* 2 ** (199/256) */
	1.7139722479299260386e+00,
/* 2 ** (200/256) */
	1.7186192981224779156e+00,
/* 2 ** (201/256) */
	1.7232789477462738972e+00,
/* 2 ** (202/256) */
	1.7279512309618375622e+00,
/* 2 ** (203/256) */
	1.7326361820223110649e+00,
/* 2 ** (204/256) */
	1.7373338352737062490e+00,
/* 2 ** (205/256) */
	1.7420442251551564435e+00,
/* 2 ** (206/256) */
	1.7467673861991689401e+00,
/* 2 ** (207/256) */
	1.7515033530318781561e+00,
/* 2 ** (208/256) */
	1.7562521603732994831e+00,
/* 2 ** (209/256) */
	1.7610138430375838242e+00,
/* 2 ** (210/256) */
	1.7657884359332728210e+00,
/* 2 ** (211/256) */
	1.7705759740635547735e+00,
/* 2 ** (212/256) */
	1.7753764925265212526e+00,
/* 2 ** (213/256) */
	1.7801900265154244090e+00,
/* 2 ** (214/256) */
	1.7850166113189349801e+00,
/* 2 ** (215/256) */
	1.7898562823214009960e+00,
/* 2 ** (216/256) */
	1.7947090750031071864e+00,
/* 2 ** (217/256) */
	1.7995750249405350921e+00,
/* 2 ** (218/256) */
	1.8044541678066238803e+00,
/* 2 ** (219/256) */
	1.8093465393710318685e+00,
/* 2 ** (220/256) */
	1.8142521755003987562e+00,
/* 2 ** (221/256) */
	1.8191711121586085683e+00,
/* 2 ** (222/256) */
	1.8241033854070533110e+00,
/* 2 ** (223/256) */
	1.8290490314048973431e+00,
/* 2 ** (224/256) */
	1.8340080864093424635e+00,
/* 2 ** (225/256) */
	1.8389805867758937177e+00,
/* 2 ** (226/256) */
	1.8439665689586259251e+00,
/* 2 ** (227/256) */
	1.8489660695104509284e+00,
/* 2 ** (228/256) */
	1.8539791250833855684e+00,
/* 2 ** (229/256) */
	1.8590057724288203846e+00,
/* 2 ** (230/256) */
	1.8640460483977890448e+00,
/* 2 ** (231/256) */
	1.8690999899412385049e+00,
/* 2 ** (232/256) */
	1.8741676341102999013e+00,
/* 2 ** (233/256) */
	1.8792490180565601780e+00,
/* 2 ** (234/256) */
	1.8843441790323344497e+00,
/* 2 ** (235/256) */
	1.8894531543909391035e+00,
/* 2 ** (236/256) */
	1.8945759815869656413e+00,
/* 2 ** (237/256) */
	1.8997126981765552647e+00,
/* 2 ** (238/256) */
	1.9048633418176742037e+00,
/* 2 ** (239/256) */
	1.9100279502703897924e+00,
/* 2 ** (240/256) */
	1.9152065613971472939e+00,
/* 2 ** (241/256) */
	1.9203992131630474739e+00,
/* 2 ** (242/256) */
	1.9256059436361249290e+00,
/* 2 ** (243/256) */
	1.9308267909876271679e+00,
/* 2 ** (244/256) */
	1.9360617934922944506e+00,
/* 2 ** (245/256) */
	1.9413109895286403852e+00,
/* 2 ** (246/256) */
	1.9465744175792332863e+00,
/* 2 ** (247/256) */
	1.9518521162309782959e+00,
/* 2 ** (248/256) */
	1.9571441241754002690e+00,
/* 2 ** (249/256) */
	1.9624504802089274268e+00,
/* 2 ** (250/256) */
	1.9677712232331757781e+00,
/* 2 ** (251/256) */
	1.9731063922552343129e+00,
/* 2 ** (252/256) */
	1.9784560263879509683e+00,
/* 2 ** (253/256) */
	1.9838201648502193699e+00,
/* 2 ** (254/256) */
	1.9891988469672663513e+00,
	1.9945921121709402525e+00	/* 2 ** (255/256) */
};

/* *********************************************************** */

const mlib_d64 mlib_constexp_lo[] = {
/* low part of  2 ** (  0/256) */
	0.0000000000000000000,
/* low part of  2 ** (  1/256) */
	-3.6366159286922640214e-17,
/* low part of  2 ** (  2/256) */
	9.4991865354550320267e-17,
/* low part of  2 ** (  3/256) */
	-3.2520587560843078105e-17,
/* low part of  2 ** (  4/256) */
	-1.5234778603368578332e-17,
/* low part of  2 ** (  5/256) */
	9.2835997681835679727e-18,
/* low part of  2 ** (  6/256) */
	-5.7721700731996600662e-17,
/* low part of  2 ** (  7/256) */
	3.6019049822596614140e-17,
/* low part of  2 ** (  8/256) */
	5.1092250289734439706e-17,
/* low part of  2 ** (  9/256) */
	-7.5616078684877790545e-17,
/* low part of  2 ** ( 10/256) */
	-4.9560741746453702864e-17,
/* low part of  2 ** ( 11/256) */
	3.3198300410808128860e-17,
/* low part of  2 ** ( 12/256) */
	7.6008388740270888745e-18,
/* low part of  2 ** ( 13/256) */
	-7.8067823913376361092e-17,
/* low part of  2 ** ( 14/256) */
	5.9962737888525102332e-17,
/* low part of  2 ** ( 15/256) */
	3.7848304802875759400e-17,
/* low part of  2 ** ( 16/256) */
	8.5518897055379644492e-17,
/* low part of  2 ** ( 17/256) */
	7.2770772431043148064e-17,
/* low part of  2 ** ( 18/256) */
	5.5929378481270031834e-17,
/* low part of  2 ** ( 19/256) */
	-9.6294828990269358550e-17,
/* low part of  2 ** ( 20/256) */
	1.7593257387720917915e-18,
/* low part of  2 ** ( 21/256) */
	-7.1526518566377813157e-17,
/* low part of  2 ** ( 22/256) */
	-1.1973537085365657950e-17,
/* low part of  2 ** ( 23/256) */
	5.0787541986112305476e-17,
/* low part of  2 ** ( 24/256) */
	-7.8998539668415818719e-17,
/* low part of  2 ** ( 25/256) */
	-9.9371627112889193619e-17,
/* low part of  2 ** ( 26/256) */
	-3.8396688433588241919e-18,
/* low part of  2 ** ( 27/256) */
	-1.0002716151144135342e-17,
/* low part of  2 ** ( 28/256) */
	-6.6566604360565929694e-17,
/* low part of  2 ** ( 29/256) */
	-4.7826239029970864967e-17,
/* low part of  2 ** ( 30/256) */
	3.1661528458163460387e-17,
/* low part of  2 ** ( 31/256) */
	5.4093493078202911444e-18,
/* low part of  2 ** ( 32/256) */
	-3.0467820798124709351e-17,
/* low part of  2 ** ( 33/256) */
	1.4413958147269209727e-17,
/* low part of  2 ** ( 34/256) */
	-5.9199334844493157278e-17,
/* low part of  2 ** ( 35/256) */
	7.1704595997019234367e-17,
/* low part of  2 ** ( 36/256) */
	5.2660368715706944636e-17,
/* low part of  2 ** ( 37/256) */
	8.2392887605002134937e-17,
/* low part of  2 ** ( 38/256) */
	-8.7868138451805268082e-17,
/* low part of  2 ** ( 39/256) */
	5.5639450266696975276e-17,
/* low part of  2 ** ( 40/256) */
	1.0410278456845571090e-16,
/* low part of  2 ** ( 41/256) */
	-7.9768059026282207834e-17,
/* low part of  2 ** ( 42/256) */
	-6.2010859065541781529e-17,
/* low part of  2 ** ( 43/256) */
	-9.6997375889870432265e-17,
/* low part of  2 ** ( 44/256) */
	5.1658567587954566793e-17,
/* low part of  2 ** ( 45/256) */
	6.7128058587262564913e-17,
/* low part of  2 ** ( 46/256) */
	3.2373561667380000326e-17,
/* low part of  2 ** ( 47/256) */
	5.0665999261261557239e-17,
/* low part of  2 ** ( 48/256) */
	8.9128126760254075660e-17,
/* low part of  2 ** ( 49/256) */
	4.6510911775314125030e-17,
/* low part of  2 ** ( 50/256) */
	4.6412898921700106758e-17,
/* low part of  2 ** ( 51/256) */
	6.8977402366271921941e-17,
/* low part of  2 ** ( 52/256) */
	3.2507102188638272890e-17,
/* low part of  2 ** ( 53/256) */
	1.0417128946273265647e-16,
/* low part of  2 ** ( 54/256) */
	-9.1238712311343998634e-17,
/* low part of  2 ** ( 55/256) */
	-3.2610402054173937026e-17,
/* low part of  2 ** ( 56/256) */
	3.8292048369240935758e-17,
/* low part of  2 ** ( 57/256) */
	-8.7918795799991700309e-17,
/* low part of  2 ** ( 58/256) */
	-1.8477442017900045018e-18,
/* low part of  2 ** ( 59/256) */
	-7.2875625865849950569e-17,
/* low part of  2 ** ( 60/256) */
	5.5542032542180788087e-17,
/* low part of  2 ** ( 61/256) */
	1.0092312775100390686e-16,
/* low part of  2 ** ( 62/256) */
	1.5429754300790761355e-17,
/* low part of  2 ** ( 63/256) */
	-9.2095068352931053272e-18,
/* low part of  2 ** ( 64/256) */
	3.9820152314656462458e-17,
/* low part of  2 ** ( 65/256) */
	4.3975514156097211931e-17,
/* low part of  2 ** ( 66/256) */
	4.6166036704814815322e-17,
/* low part of  2 ** ( 67/256) */
	-9.8091933560084236385e-17,
/* low part of  2 ** ( 68/256) */
	6.6449814992523008597e-17,
/* low part of  2 ** ( 69/256) */
	-3.3572721932675296730e-17,
/* low part of  2 ** ( 70/256) */
	-4.7467259452289843285e-17,
/* low part of  2 ** ( 71/256) */
	-4.8906110775211180492e-17,
/* low part of  2 ** ( 72/256) */
	-7.7126306926814876687e-17,
/* low part of  2 ** ( 73/256) */
	-9.0067269583638376171e-17,
/* low part of  2 ** ( 74/256) */
	-1.0611021211402691007e-16,
/* low part of  2 ** ( 75/256) */
	-8.9035338142699837761e-17,
/* low part of  2 ** ( 76/256) */
	-1.8987816313025298953e-17,
/* low part of  2 ** ( 77/256) */
	7.3893824716100508051e-17,
/* low part of  2 ** ( 78/256) */
	-1.0755244344307841552e-16,
/* low part of  2 ** ( 79/256) */
	2.7677020555739674300e-17,
/* low part of  2 ** ( 80/256) */
	4.6580275918369365794e-17,
/* low part of  2 ** ( 81/256) */
	-4.6772404498467275582e-17,
/* low part of  2 ** ( 82/256) */
	-8.2618109990219638586e-17,
/* low part of  2 ** ( 83/256) */
	4.8341671524698977729e-17,
/* low part of  2 ** ( 84/256) */
	-6.7113898212968784185e-18,
/* low part of  2 ** ( 85/256) */
	-8.4217825877305997034e-17,
/* low part of  2 ** ( 86/256) */
	-3.0844648874738462149e-17,
/* low part of  2 ** ( 87/256) */
	4.2505770034508684059e-17,
/* low part of  2 ** ( 88/256) */
	2.6679321313421859026e-18,
/* low part of  2 ** ( 89/256) */
	-1.0577916267212421414e-17,
/* low part of  2 ** ( 90/256) */
	9.9154302442142907917e-17,
/* low part of  2 ** ( 91/256) */
	-9.7590950083560623452e-17,
/* low part of  2 ** ( 92/256) */
	1.7135949182435610644e-17,
/* low part of  2 ** ( 93/256) */
	-3.4169557069361816682e-17,
/* low part of  2 ** ( 94/256) */
	8.9492575308975918375e-17,
/* low part of  2 ** ( 95/256) */
	-2.9745904431327515495e-17,
/* low part of  2 ** ( 96/256) */
	2.5382502794888315152e-17,
/* low part of  2 ** ( 97/256) */
	5.6787281028022171524e-17,
/* low part of  2 ** ( 98/256) */
	8.6476755982678712758e-17,
/* low part of  2 ** ( 99/256) */
	-7.3366456528788691812e-17,
/* low part of  2 ** (100/256) */
	-7.1815361355194538570e-17,
/* low part of  2 ** (101/256) */
	2.2675433151045855488e-17,
/* low part of  2 ** (102/256) */
	-5.4579558271491534832e-17,
/* low part of  2 ** (103/256) */
	-2.4806382459130218378e-17,
/* low part of  2 ** (104/256) */
	-2.8587312100388612962e-17,
/* low part of  2 ** (105/256) */
	4.0890862239101599557e-17,
/* low part of  2 ** (106/256) */
	-5.1015866309167438632e-17,
/* low part of  2 ** (107/256) */
	-5.8918663563888008710e-17,
/* low part of  2 ** (108/256) */
	8.9272825948317319265e-17,
/* low part of  2 ** (109/256) */
	-5.8025808902014383098e-17,
/* low part of  2 ** (110/256) */
	3.2240651012546788995e-17,
/* low part of  2 ** (111/256) */
	-8.2871103814624162630e-17,
/* low part of  2 ** (112/256) */
	7.7009483798029892498e-17,
/* low part of  2 ** (113/256) */
	-9.5296357448251884626e-17,
/* low part of  2 ** (114/256) */
	1.5337876612706682385e-18,
/* low part of  2 ** (115/256) */
	-1.0005363125974764821e-16,
/* low part of  2 ** (116/256) */
	9.5937979191188482911e-17,
/* low part of  2 ** (117/256) */
	-4.4959605952348411079e-17,
/* low part of  2 ** (118/256) */
	-6.8985889358718011379e-17,
/* low part of  2 ** (119/256) */
	1.0510314579969983888e-16,
/* low part of  2 ** (120/256) */
	-6.7705116587947862486e-17,
/* low part of  2 ** (121/256) */
	8.4229842748754157413e-17,
/* low part of  2 ** (122/256) */
	-4.9061748652889892475e-17,
/* low part of  2 ** (123/256) */
	-9.3293362242254961477e-17,
/* low part of  2 ** (124/256) */
	-9.6142132090513226679e-17,
/* low part of  2 ** (125/256) */
	-5.2957832494079889150e-17,
/* low part of  2 ** (126/256) */
	7.0349148121364218028e-18,
/* low part of  2 ** (127/256) */
	4.1665487284350620086e-17,
/* low part of  2 ** (128/256) */
	-9.6672933134529130274e-17,
/* low part of  2 ** (129/256) */
	2.2744385421855295101e-17,
/* low part of  2 ** (130/256) */
	-1.6077828915890243363e-17,
/* low part of  2 ** (131/256) */
	9.8806907585006072265e-17,
/* low part of  2 ** (132/256) */
	-1.2031642489053655179e-17,
/* low part of  2 ** (133/256) */
	-5.8024542439268262379e-17,
/* low part of  2 ** (134/256) */
	-4.2040340164675566700e-17,
/* low part of  2 ** (135/256) */
	5.6025036508789852898e-18,
/* low part of  2 ** (136/256) */
	-3.0237581349939874927e-17,
/* low part of  2 ** (137/256) */
	-6.2594050008193095048e-17,
/* low part of  2 ** (138/256) */
	-5.7799486093961056400e-17,
/* low part of  2 ** (139/256) */
	5.6486794538769986605e-17,
/* low part of  2 ** (140/256) */
	-5.6003771860752163009e-17,
/* low part of  2 ** (141/256) */
	9.5307675435871572997e-17,
/* low part of  2 ** (142/256) */
	8.4658827565336272039e-17,
/* low part of  2 ** (143/256) */
	6.6917740819405892946e-17,
/* low part of  2 ** (144/256) */
	-3.4839945568927958151e-17,
/* low part of  2 ** (145/256) */
	-9.6869521026306187517e-17,
/* low part of  2 ** (146/256) */
	1.0780086764407480197e-16,
/* low part of  2 ** (147/256) */
	6.1553671577428708296e-17,
/* low part of  2 ** (148/256) */
	1.4192920154284036156e-17,
/* low part of  2 ** (149/256) */
	-2.8616632538991580378e-17,
/* low part of  2 ** (150/256) */
	-6.4137672757902347690e-17,
/* low part of  2 ** (151/256) */
	7.0747106135828468843e-17,
/* low part of  2 ** (152/256) */
	-1.0164553277542950391e-16,
/* low part of  2 ** (153/256) */
	8.8844978513387123798e-17,
/* low part of  2 ** (154/256) */
	-4.3086994720433410126e-17,
/* low part of  2 ** (155/256) */
	-5.9963876759456832273e-18,
/* low part of  2 ** (156/256) */
	-1.1024941712342561225e-16,
/* low part of  2 ** (157/256) */
	3.7857921151572195376e-17,
/* low part of  2 ** (158/256) */
	8.8752268444384467191e-17,
/* low part of  2 ** (159/256) */
	1.0174672351161358697e-16,
/* low part of  2 ** (160/256) */
	7.9498348096976207599e-17,
/* low part of  2 ** (161/256) */
	1.0683960005657220381e-16,
/* low part of  2 ** (162/256) */
	-1.4600706590689385757e-17,
/* low part of  2 ** (163/256) */
	-8.0031613501160352944e-17,
/* low part of  2 ** (164/256) */
	3.7812070533575275211e-17,
/* low part of  2 ** (165/256) */
	7.4847776455907348704e-17,
/* low part of  2 ** (166/256) */
	-1.0352061768849721738e-16,
/* low part of  2 ** (167/256) */
	-3.3429840046872003197e-17,
/* low part of  2 ** (168/256) */
	-1.0136916471278303210e-17,
/* low part of  2 ** (169/256) */
	-5.1634029295544682734e-17,
/* low part of  2 ** (170/256) */
	-1.9337717034585703123e-17,
/* low part of  2 ** (171/256) */
	-5.9949501188244790153e-18,
/* low part of  2 ** (172/256) */
	-1.0094406542311963259e-16,
/* low part of  2 ** (173/256) */
	2.4868392796220997474e-17,
/* low part of  2 ** (174/256) */
	-6.0549174535277844003e-17,
/* low part of  2 ** (175/256) */
	-1.0354545288059995143e-16,
/* low part of  2 ** (176/256) */
	2.4707192569797889008e-17,
/* low part of  2 ** (177/256) */
	-7.3166633991251233782e-17,
/* low part of  2 ** (178/256) */
	2.0941334154229092407e-17,
/* low part of  2 ** (179/256) */
	-3.5845128514144744981e-17,
/* low part of  2 ** (180/256) */
	-6.7129550847070838937e-17,
/* low part of  2 ** (181/256) */
	9.8528192304299935034e-17,
/* low part of  2 ** (182/256) */
	7.6983250713198759597e-17,
/* low part of  2 ** (183/256) */
	-9.2475687376407060666e-17,
/* low part of  2 ** (184/256) */
	-1.0125679913674772681e-16,
/* low part of  2 ** (185/256) */
	9.1332795887299043827e-18,
/* low part of  2 ** (186/256) */
	9.6432943031960282184e-17,
/* low part of  2 ** (187/256) */
	-7.2755455508230503655e-17,
/* low part of  2 ** (188/256) */
	5.8909926967130999016e-17,
/* low part of  2 ** (189/256) */
	4.2691780195706149750e-17,
/* low part of  2 ** (190/256) */
	-5.4767159645995631339e-17,
/* low part of  2 ** (191/256) */
	8.3039495099507324194e-17,
/* low part of  2 ** (192/256) */
	8.1990100205814970401e-17,
/* low part of  2 ** (193/256) */
	-7.1814632783580103088e-17,
/* low part of  2 ** (194/256) */
	-9.6696714743948799733e-17,
/* low part of  2 ** (195/256) */
	7.2384168728451661786e-17,
/* low part of  2 ** (196/256) */
	-8.0237193703976998607e-18,
/* low part of  2 ** (197/256) */
	-2.7288832847972816203e-17,
/* low part of  2 ** (198/256) */
	-9.8687794566329311533e-17,
/* low part of  2 ** (199/256) */
	6.4739751077533673145e-17,
/* low part of  2 ** (200/256) */
	-1.8513804182631109112e-17,
/* low part of  2 ** (201/256) */
	-9.5221238003937997316e-17,
/* low part of  2 ** (202/256) */
	-1.0750981861204642465e-16,
/* low part of  2 ** (203/256) */
	-1.6980510743154158793e-18,
/* low part of  2 ** (204/256) */
	3.1643892992929572162e-17,
/* low part of  2 ** (205/256) */
	-1.5259591189507889850e-18,
/* low part of  2 ** (206/256) */
	-1.0752290483507514427e-16,
/* low part of  2 ** (207/256) */
	-5.1244504205967247364e-17,
/* low part of  2 ** (208/256) */
	2.9601406954488734418e-17,
/* low part of  2 ** (209/256) */
	-7.9432531250392278261e-17,
/* low part of  2 ** (210/256) */
	9.4613150180832680784e-17,
/* low part of  2 ** (211/256) */
	5.9617945100405560595e-17,
/* low part of  2 ** (212/256) */
	6.4297317965565717065e-17,
/* low part of  2 ** (213/256) */
	-5.2846272890916174807e-17,
/* low part of  2 ** (214/256) */
	1.5330400121031314396e-17,
/* low part of  2 ** (215/256) */
	-4.1543546606833503873e-17,
/* low part of  2 ** (216/256) */
	1.8227458427912088118e-17,
/* low part of  2 ** (217/256) */
	-2.5268892333588977789e-17,
/* low part of  2 ** (218/256) */
	-5.1772224087933179411e-17,
/* low part of  2 ** (219/256) */
	-9.0326414024500297782e-17,
/* low part of  2 ** (220/256) */
	-9.9695315389203493784e-17,
/* low part of  2 ** (221/256) */
	7.4026769011458383892e-17,
/* low part of  2 ** (222/256) */
	-1.0159627862277083046e-16,
/* low part of  2 ** (223/256) */
	6.8891929088356959836e-17,
/* low part of  2 ** (224/256) */
	3.2831072242456271265e-17,
/* low part of  2 ** (225/256) */
	6.9189697402725121349e-18,
/* low part of  2 ** (226/256) */
	-5.9397420269499646851e-17,
/* low part of  2 ** (227/256) */
	9.0275804462610896733e-17,
/* low part of  2 ** (228/256) */
	9.7618874907275939814e-17,
/* low part of  2 ** (229/256) */
	-9.5287054619899409948e-17,
/* low part of  2 ** (230/256) */
	6.5409126806205711520e-17,
/* low part of  2 ** (231/256) */
	-9.9385052142550668518e-17,
/* low part of  2 ** (232/256) */
	-6.1227634130041420609e-17,
/* low part of  2 ** (233/256) */
	-1.6226315557835843624e-17,
/* low part of  2 ** (234/256) */
	-8.2265931255337114448e-17,
/* low part of  2 ** (235/256) */
	-9.0051682850591262172e-17,
/* low part of  2 ** (236/256) */
	3.4034035352165298825e-17,
/* low part of  2 ** (237/256) */
	-3.8597397693785142653e-17,
/* low part of  2 ** (238/256) */
	6.5338575147182781282e-17,
/* low part of  2 ** (239/256) */
	-5.9096880067440600635e-17,
/* low part of  2 ** (240/256) */
	-1.0619946056195962946e-16,
/* low part of  2 ** (241/256) */
	7.1166815406303137047e-17,
/* low part of  2 ** (242/256) */
	-9.9149637696937412742e-17,
/* low part of  2 ** (243/256) */
	6.1671497061691096106e-17,
/* low part of  2 ** (244/256) */
	1.0332385960676326342e-16,
/* low part of  2 ** (245/256) */
	-6.6380298916214883558e-17,
/* low part of  2 ** (246/256) */
	6.8110223495338775888e-17,
/* low part of  2 ** (247/256) */
	-2.1990169699793510860e-17,
/* low part of  2 ** (248/256) */
	8.9607677910366676520e-17,
/* low part of  2 ** (249/256) */
	1.0976844000913547161e-16,
/* low part of  2 ** (250/256) */
	-1.0314928011531131068e-16,
/* low part of  2 ** (251/256) */
	-7.4516178639560382565e-18,
/* low part of  2 ** (252/256) */
	4.0388753109278166768e-17,
/* low part of  2 ** (253/256) */
	-2.2034544123910625609e-17,
/* low part of  2 ** (254/256) */
	8.2051326383691998007e-18,
	1.7909710352002645278e-17	/* low part of 2 ** (255/256) */
};

/* *********************************************************** */
