/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)mlib_c_VideoColorTables.c	9.2	07/10/09 SMI"

/*
 * DESCRIPTION:
 *
 * mlib_u8  mlib_tClip[288*2 + 544*2] U8 Saturation table with zero in 288*2
 *
 * mlib_u16 mlib_tYY[i] = (int)(i*1.1644*2 + 0.49999999f)
 * mlib_u16 mlib_tRV[i] = (int)(i*1.5966*2 + 0.49999999f)
 * mlib_u16 mlib_tGU[i] = (int)(135.6352*2 - i*0.3920*2 + 0.49999999f)
 * mlib_u16 mlib_tGV[i] = (int)(i*0.8132*2 + 0.49999999f)
 * mlib_u16 mlib_tBU[i] = (int)(i*2.0184*2 + 0.49999999f)
 *
 * mlib_u16 mlib_tRCr[i] = (int)(i*1.40200*2 + 0.49999999)
 * mlib_u16 mlib_tGCb[i] = (int)(135.45984 * 2 - i*0.34414*2 + 0.49999999)
 * mlib_u16 mlib_tGCr[i] = (int)(i*0.71414*2 + 0.49999999)
 * mlib_u16 mlib_tBCb[i] = (int)(i*1.77200*2 + 0.49999999)
 *
 * tables for RGB -> JFIFYCC conversions
 * mlib_u32 mlib_t_r2j[i] = (int)(0.299*i + 0.5) +
 *			    (((int)(-0.16874*i - 0.5) & 0x1ff) << 10) +
 *			    (((int)(0.5*i) & 0x1ff) << 21);
 * mlib_u32 mlib_t_g2j[i] = (int)(0.587*i + 0.5) +
 *			    (((int)(-0.33126*i + 128.5) & 0x1ff) << 10) +
 *			    (((int)(-0.41869*i + 128.5) & 0x1ff) << 21);
 * mlib_u32 mlib_t_b2j[i] = (int)(0.114*i + 0.5) +
 *			    (((int)(0.5*i) & 0x1ff) << 10) +
 *			    (((int)(-0.08131*i - 0.5) & 0x1ff) << 21);
 *
 *      Y  =  0.29900 * R + 0.58700 * G + 0.11400 * B
 *      Cb = -0.16874 * R - 0.33126 * G + 0.50000 * B  + 128
 *      Cr =  0.50000 * R - 0.41869 * G - 0.08131 * B  + 128
 *
 * mlib_u8 mlib_video_pClipOff256[i] =
 *
 * mlib_s32 mlib_t_Yuv2rgb[i] =
 * mlib_s32 mlib_t_yUv2rgb[i] =
 * mlib_s32 mlib_t_yuV2rgb[i] =
 *
 * REFERENCING:
 *
 *     mlib_c_VideoColorColorYUV2ABGR411
 *     mlib_c_VideoColorColorYUV2ABGR420
 *     mlib_c_VideoColorColorYUV2ABGR422
 *     mlib_c_VideoColorColorYUV2ABGR444
 *     mlib_c_VideoColorColorYUV2ARGB411
 *     mlib_c_VideoColorColorYUV2ARGB420
 *     mlib_c_VideoColorColorYUV2ARGB422
 *     mlib_c_VideoColorColorYUV2ARGB444
 *     mlib_c_VideoColorColorYUV2RGB411
 *     mlib_c_VideoColorColorYUV2RGB420
 *     mlib_c_VideoColorColorYUV2RGB422
 *     mlib_c_VideoColorColorYUV2RGB444
 *
 */

#include <mlib_c_VideoColorYUV.h>

/* *********************************************************** */

/* U8 Saturation table with zero in 288*2 */
const mlib_u8 mlib_tClip[288 * 2 + 544 * 2] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7,
	8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15,
	16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23,
	24, 24, 25, 25, 26, 26, 27, 27, 28, 28, 29, 29, 30, 30, 31, 31,
	32, 32, 33, 33, 34, 34, 35, 35, 36, 36, 37, 37, 38, 38, 39, 39,
	40, 40, 41, 41, 42, 42, 43, 43, 44, 44, 45, 45, 46, 46, 47, 47,
	48, 48, 49, 49, 50, 50, 51, 51, 52, 52, 53, 53, 54, 54, 55, 55,
	56, 56, 57, 57, 58, 58, 59, 59, 60, 60, 61, 61, 62, 62, 63, 63,
	64, 64, 65, 65, 66, 66, 67, 67, 68, 68, 69, 69, 70, 70, 71, 71,
	72, 72, 73, 73, 74, 74, 75, 75, 76, 76, 77, 77, 78, 78, 79, 79,
	80, 80, 81, 81, 82, 82, 83, 83, 84, 84, 85, 85, 86, 86, 87, 87,
	88, 88, 89, 89, 90, 90, 91, 91, 92, 92, 93, 93, 94, 94, 95, 95,
	96, 96, 97, 97, 98, 98, 99, 99, 100, 100, 101, 101, 102, 102, 103, 103,
	104, 104, 105, 105, 106, 106, 107, 107, 108, 108, 109, 109, 110, 110,
		111, 111,
	112, 112, 113, 113, 114, 114, 115, 115, 116, 116, 117, 117, 118, 118,
		119, 119,
	120, 120, 121, 121, 122, 122, 123, 123, 124, 124, 125, 125, 126, 126,
		127, 127,
	128, 128, 129, 129, 130, 130, 131, 131, 132, 132, 133, 133, 134, 134,
		135, 135,
	136, 136, 137, 137, 138, 138, 139, 139, 140, 140, 141, 141, 142, 142,
		143, 143,
	144, 144, 145, 145, 146, 146, 147, 147, 148, 148, 149, 149, 150, 150,
		151, 151,
	152, 152, 153, 153, 154, 154, 155, 155, 156, 156, 157, 157, 158, 158,
		159, 159,
	160, 160, 161, 161, 162, 162, 163, 163, 164, 164, 165, 165, 166, 166,
		167, 167,
	168, 168, 169, 169, 170, 170, 171, 171, 172, 172, 173, 173, 174, 174,
		175, 175,
	176, 176, 177, 177, 178, 178, 179, 179, 180, 180, 181, 181, 182, 182,
		183, 183,
	184, 184, 185, 185, 186, 186, 187, 187, 188, 188, 189, 189, 190, 190,
		191, 191,
	192, 192, 193, 193, 194, 194, 195, 195, 196, 196, 197, 197, 198, 198,
		199, 199,
	200, 200, 201, 201, 202, 202, 203, 203, 204, 204, 205, 205, 206, 206,
		207, 207,
	208, 208, 209, 209, 210, 210, 211, 211, 212, 212, 213, 213, 214, 214,
		215, 215,
	216, 216, 217, 217, 218, 218, 219, 219, 220, 220, 221, 221, 222, 222,
		223, 223,
	224, 224, 225, 225, 226, 226, 227, 227, 228, 228, 229, 229, 230, 230,
		231, 231,
	232, 232, 233, 233, 234, 234, 235, 235, 236, 236, 237, 237, 238, 238,
		239, 239,
	240, 240, 241, 241, 242, 242, 243, 243, 244, 244, 245, 245, 246, 246,
		247, 247,
	248, 248, 249, 249, 250, 250, 251, 251, 252, 252, 253, 253, 254, 254,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
};

/* mlib_tYY[i] = (int)(i*1.1644*2 + 0.49999999f) */
const mlib_u16 mlib_tYY[256] = {
	0, 2, 5, 7, 9, 12, 14, 16, 19, 21, 23, 26, 28, 30, 33, 35,
	37, 40, 42, 44, 47, 49, 51, 54, 56, 58, 61, 63, 65, 68, 70, 72,
	75, 77, 79, 82, 84, 86, 88, 91, 93, 95, 98, 100, 102, 105, 107, 109,
	112, 114, 116, 119, 121, 123, 126, 128, 130, 133, 135, 137, 140, 142,
		144, 147,
	149, 151, 154, 156, 158, 161, 163, 165, 168, 170, 172, 175, 177, 179,
		182, 184,
	186, 189, 191, 193, 196, 198, 200, 203, 205, 207, 210, 212, 214, 217,
		219, 221,
	224, 226, 228, 231, 233, 235, 238, 240, 242, 245, 247, 249, 252, 254,
		256, 258,
	261, 263, 265, 268, 270, 272, 275, 277, 279, 282, 284, 286, 289, 291,
		293, 296,
	298, 300, 303, 305, 307, 310, 312, 314, 317, 319, 321, 324, 326, 328,
		331, 333,
	335, 338, 340, 342, 345, 347, 349, 352, 354, 356, 359, 361, 363, 366,
		368, 370,
	373, 375, 377, 380, 382, 384, 387, 389, 391, 394, 396, 398, 401, 403,
		405, 408,
	410, 412, 415, 417, 419, 422, 424, 426, 428, 431, 433, 435, 438, 440,
		442, 445,
	447, 449, 452, 454, 456, 459, 461, 463, 466, 468, 470, 473, 475, 477,
		480, 482,
	484, 487, 489, 491, 494, 496, 498, 501, 503, 505, 508, 510, 512, 515,
		517, 519,
	522, 524, 526, 529, 531, 533, 536, 538, 540, 543, 545, 547, 550, 552,
		554, 557,
	559, 561, 564, 566, 568, 571, 573, 575, 578, 580, 582, 585, 587, 589,
		592, 594,
};

/* mlib_tRV[i] = (int)(i*1.5966*2 + 0.49999999f) */
const mlib_u16 mlib_tRV[256] = {
	0, 3, 6, 10, 13, 16, 19, 22, 26, 29, 32, 35, 38, 42, 45, 48,
	51, 54, 57, 61, 64, 67, 70, 73, 77, 80, 83, 86, 89, 93, 96, 99,
	102, 105, 109, 112, 115, 118, 121, 125, 128, 131, 134, 137, 141, 144,
		147, 150,
	153, 156, 160, 163, 166, 169, 172, 176, 179, 182, 185, 188, 192, 195,
		198, 201,
	204, 208, 211, 214, 217, 220, 224, 227, 230, 233, 236, 239, 243, 246,
		249, 252,
	255, 259, 262, 265, 268, 271, 275, 278, 281, 284, 287, 291, 294, 297,
		300, 303,
	307, 310, 313, 316, 319, 323, 326, 329, 332, 335, 338, 342, 345, 348,
		351, 354,
	358, 361, 364, 367, 370, 374, 377, 380, 383, 386, 390, 393, 396, 399,
		402, 406,
	409, 412, 415, 418, 422, 425, 428, 431, 434, 437, 441, 444, 447, 450,
		453, 457,
	460, 463, 466, 469, 473, 476, 479, 482, 485, 489, 492, 495, 498, 501,
		505, 508,
	511, 514, 517, 520, 524, 527, 530, 533, 536, 540, 543, 546, 549, 552,
		556, 559,
	562, 565, 568, 572, 575, 578, 581, 584, 588, 591, 594, 597, 600, 604,
		607, 610,
	613, 616, 619, 623, 626, 629, 632, 635, 639, 642, 645, 648, 651, 655,
		658, 661,
	664, 667, 671, 674, 677, 680, 683, 687, 690, 693, 696, 699, 703, 706,
		709, 712,
	715, 718, 722, 725, 728, 731, 734, 738, 741, 744, 747, 750, 754, 757,
		760, 763,
	766, 770, 773, 776, 779, 782, 786, 789, 792, 795, 798, 801, 805, 808,
		811, 814,
};

/* mlib_tGU[i] = (int)(135.6352*2 - i*0.3920*2 + 0.49999999f) */
const mlib_u16 mlib_tGU[256] = {
	271, 270, 270, 269, 268, 267, 267, 266, 265, 264, 263, 263, 262, 261,
		260, 260,
	259, 258, 257, 256, 256, 255, 254, 253, 252, 252, 251, 250, 249, 249,
		248, 247,
	246, 245, 245, 244, 243, 242, 241, 241, 240, 239, 238, 238, 237, 236,
		235, 234,
	234, 233, 232, 231, 231, 230, 229, 228, 227, 227, 226, 225, 224, 223,
		223, 222,
	221, 220, 220, 219, 218, 217, 216, 216, 215, 214, 213, 212, 212, 211,
		210, 209,
	209, 208, 207, 206, 205, 205, 204, 203, 202, 201, 201, 200, 199, 198,
		198, 197,
	196, 195, 194, 194, 193, 192, 191, 191, 190, 189, 188, 187, 187, 186,
		185, 184,
	183, 183, 182, 181, 180, 180, 179, 178, 177, 176, 176, 175, 174, 173,
		172, 172,
	171, 170, 169, 169, 168, 167, 166, 165, 165, 164, 163, 162, 162, 161,
		160, 159,
	158, 158, 157, 156, 155, 154, 154, 153, 152, 151, 151, 150, 149, 148,
		147, 147,
	146, 145, 144, 143, 143, 142, 141, 140, 140, 139, 138, 137, 136, 136,
		135, 134,
	133, 133, 132, 131, 130, 129, 129, 128, 127, 126, 125, 125, 124, 123,
		122, 122,
	121, 120, 119, 118, 118, 117, 116, 115, 114, 114, 113, 112, 111, 111,
		110, 109,
	108, 107, 107, 106, 105, 104, 103, 103, 102, 101, 100, 100, 99, 98, 97,
		96,
	96, 95, 94, 93, 93, 92, 91, 90, 89, 89, 88, 87, 86, 85, 85, 84,
	83, 82, 82, 81, 80, 79, 78, 78, 77, 76, 75, 74, 74, 73, 72, 71,
};

/* mlib_tGV[i] = (int)(i*0.8132*2 + 0.49999999f) */
const mlib_u16 mlib_tGV[256] = {
	0, 2, 3, 5, 7, 8, 10, 11, 13, 15, 16, 18, 20, 21, 23, 24,
	26, 28, 29, 31, 33, 34, 36, 37, 39, 41, 42, 44, 46, 47, 49, 50,
	52, 54, 55, 57, 59, 60, 62, 63, 65, 67, 68, 70, 72, 73, 75, 76,
	78, 80, 81, 83, 85, 86, 88, 89, 91, 93, 94, 96, 98, 99, 101, 102,
	104, 106, 107, 109, 111, 112, 114, 115, 117, 119, 120, 122, 124, 125,
		127, 128,
	130, 132, 133, 135, 137, 138, 140, 141, 143, 145, 146, 148, 150, 151,
		153, 155,
	156, 158, 159, 161, 163, 164, 166, 168, 169, 171, 172, 174, 176, 177,
		179, 181,
	182, 184, 185, 187, 189, 190, 192, 194, 195, 197, 198, 200, 202, 203,
		205, 207,
	208, 210, 211, 213, 215, 216, 218, 220, 221, 223, 224, 226, 228, 229,
		231, 233,
	234, 236, 237, 239, 241, 242, 244, 246, 247, 249, 250, 252, 254, 255,
		257, 259,
	260, 262, 263, 265, 267, 268, 270, 272, 273, 275, 276, 278, 280, 281,
		283, 285,
	286, 288, 289, 291, 293, 294, 296, 298, 299, 301, 303, 304, 306, 307,
		309, 311,
	312, 314, 316, 317, 319, 320, 322, 324, 325, 327, 329, 330, 332, 333,
		335, 337,
	338, 340, 342, 343, 345, 346, 348, 350, 351, 353, 355, 356, 358, 359,
		361, 363,
	364, 366, 368, 369, 371, 372, 374, 376, 377, 379, 381, 382, 384, 385,
		387, 389,
	390, 392, 394, 395, 397, 398, 400, 402, 403, 405, 407, 408, 410, 411,
		413, 415,
};

/* mlib_tBU[i] = (int)(i*2.0184*2 + 0.49999999f) */
const mlib_u16 mlib_tBU[256] = {
	0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 57, 61,
	65, 69, 73, 77, 81, 85, 89, 93, 97, 101, 105, 109, 113, 117, 121, 125,
	129, 133, 137, 141, 145, 149, 153, 157, 161, 166, 170, 174, 178, 182,
		186, 190,
	194, 198, 202, 206, 210, 214, 218, 222, 226, 230, 234, 238, 242, 246,
		250, 254,
	258, 262, 266, 270, 275, 279, 283, 287, 291, 295, 299, 303, 307, 311,
		315, 319,
	323, 327, 331, 335, 339, 343, 347, 351, 355, 359, 363, 367, 371, 375,
		379, 383,
	388, 392, 396, 400, 404, 408, 412, 416, 420, 424, 428, 432, 436, 440,
		444, 448,
	452, 456, 460, 464, 468, 472, 476, 480, 484, 488, 492, 497, 501, 505,
		509, 513,
	517, 521, 525, 529, 533, 537, 541, 545, 549, 553, 557, 561, 565, 569,
		573, 577,
	581, 585, 589, 593, 597, 601, 606, 610, 614, 618, 622, 626, 630, 634,
		638, 642,
	646, 650, 654, 658, 662, 666, 670, 674, 678, 682, 686, 690, 694, 698,
		702, 706,
	710, 715, 719, 723, 727, 731, 735, 739, 743, 747, 751, 755, 759, 763,
		767, 771,
	775, 779, 783, 787, 791, 795, 799, 803, 807, 811, 815, 819, 824, 828,
		832, 836,
	840, 844, 848, 852, 856, 860, 864, 868, 872, 876, 880, 884, 888, 892,
		896, 900,
	904, 908, 912, 916, 920, 924, 928, 933, 937, 941, 945, 949, 953, 957,
		961, 965,
	969, 973, 977, 981, 985, 989, 993, 997, 1001, 1005, 1009, 1013, 1017,
		1021, 1025, 1029,
};

/* *********************************************************** */

/* mlib_tRCr[i] = (int)(i*1.40200*2 + 0.49999999) */
const mlib_u16 mlib_tRCr[256] = {
	0, 3, 6, 8, 11, 14, 17, 20, 22, 25, 28, 31, 34, 36, 39, 42,
	45, 48, 50, 53, 56, 59, 62, 64, 67, 70, 73, 76, 79, 81, 84, 87,
	90, 93, 95, 98, 101, 104, 107, 109, 112, 115, 118, 121, 123, 126, 129,
		132,
	135, 137, 140, 143, 146, 149, 151, 154, 157, 160, 163, 165, 168, 171,
		174, 177,
	179, 182, 185, 188, 191, 193, 196, 199, 202, 205, 207, 210, 213, 216,
		219, 222,
	224, 227, 230, 233, 236, 238, 241, 244, 247, 250, 252, 255, 258, 261,
		264, 266,
	269, 272, 275, 278, 280, 283, 286, 289, 292, 294, 297, 300, 303, 306,
		308, 311,
	314, 317, 320, 322, 325, 328, 331, 334, 336, 339, 342, 345, 348, 350,
		353, 356,
	359, 362, 365, 367, 370, 373, 376, 379, 381, 384, 387, 390, 393, 395,
		398, 401,
	404, 407, 409, 412, 415, 418, 421, 423, 426, 429, 432, 435, 437, 440,
		443, 446,
	449, 451, 454, 457, 460, 463, 465, 468, 471, 474, 477, 479, 482, 485,
		488, 491,
	494, 496, 499, 502, 505, 508, 510, 513, 516, 519, 522, 524, 527, 530,
		533, 536,
	538, 541, 544, 547, 550, 552, 555, 558, 561, 564, 566, 569, 572, 575,
		578, 580,
	583, 586, 589, 592, 594, 597, 600, 603, 606, 608, 611, 614, 617, 620,
		622, 625,
	628, 631, 634, 637, 639, 642, 645, 648, 651, 653, 656, 659, 662, 665,
		667, 670,
	673, 676, 679, 681, 684, 687, 690, 693, 695, 698, 701, 704, 707, 709,
		712, 715
};

/* mlib_tGCb[i] = (int)(135.45984 * 2 - i*0.34414*2 + 0.49999999) */
const mlib_u16 mlib_tGCb[256] = {
	271, 270, 270, 269, 268, 267, 267, 266, 265, 265, 264, 263, 263, 262,
		261, 261,
	260, 259, 259, 258, 257, 256, 256, 255, 254, 254, 253, 252, 252, 251,
		250, 250,
	249, 248, 248, 247, 246, 245, 245, 244, 243, 243, 242, 241, 241, 240,
		239, 239,
	238, 237, 237, 236, 235, 234, 234, 233, 232, 232, 231, 230, 230, 229,
		228, 228,
	227, 226, 225, 225, 224, 223, 223, 222, 221, 221, 220, 219, 219, 218,
		217, 217,
	216, 215, 214, 214, 213, 212, 212, 211, 210, 210, 209, 208, 208, 207,
		206, 206,
	205, 204, 203, 203, 202, 201, 201, 200, 199, 199, 198, 197, 197, 196,
		195, 195,
	194, 193, 192, 192, 191, 190, 190, 189, 188, 188, 187, 186, 186, 185,
		184, 184,
	183, 182, 181, 181, 180, 179, 179, 178, 177, 177, 176, 175, 175, 174,
		173, 172,
	172, 171, 170, 170, 169, 168, 168, 167, 166, 166, 165, 164, 164, 163,
		162, 161,
	161, 160, 159, 159, 158, 157, 157, 156, 155, 155, 154, 153, 153, 152,
		151, 150,
	150, 149, 148, 148, 147, 146, 146, 145, 144, 144, 143, 142, 142, 141,
		140, 139,
	139, 138, 137, 137, 136, 135, 135, 134, 133, 133, 132, 131, 131, 130,
		129, 128,
	128, 127, 126, 126, 125, 124, 124, 123, 122, 122, 121, 120, 119, 119,
		118, 117,
	117, 116, 115, 115, 114, 113, 113, 112, 111, 111, 110, 109, 108, 108,
		107, 106,
	106, 105, 104, 104, 103, 102, 102, 101, 100, 100, 99, 98, 97, 97, 96, 95
};

/* mlib_tGCr[i] = (int)(i*0.71414*2 + 0.49999999) */
const mlib_u16 mlib_tGCr[256] = {
	0, 1, 3, 4, 6, 7, 9, 10, 11, 13, 14, 16, 17, 19, 20, 21,
	23, 24, 26, 27, 29, 30, 31, 33, 34, 36, 37, 39, 40, 41, 43, 44,
	46, 47, 49, 50, 51, 53, 54, 56, 57, 59, 60, 61, 63, 64, 66, 67,
	69, 70, 71, 73, 74, 76, 77, 79, 80, 81, 83, 84, 86, 87, 89, 90,
	91, 93, 94, 96, 97, 99, 100, 101, 103, 104, 106, 107, 109, 110, 111,
		113,
	114, 116, 117, 119, 120, 121, 123, 124, 126, 127, 129, 130, 131, 133,
		134, 136,
	137, 139, 140, 141, 143, 144, 146, 147, 149, 150, 151, 153, 154, 156,
		157, 159,
	160, 161, 163, 164, 166, 167, 169, 170, 171, 173, 174, 176, 177, 179,
		180, 181,
	183, 184, 186, 187, 189, 190, 191, 193, 194, 196, 197, 199, 200, 201,
		203, 204,
	206, 207, 209, 210, 211, 213, 214, 216, 217, 219, 220, 221, 223, 224,
		226, 227,
	229, 230, 231, 233, 234, 236, 237, 239, 240, 241, 243, 244, 246, 247,
		249, 250,
	251, 253, 254, 256, 257, 259, 260, 261, 263, 264, 266, 267, 269, 270,
		271, 273,
	274, 276, 277, 279, 280, 281, 283, 284, 286, 287, 289, 290, 291, 293,
		294, 296,
	297, 299, 300, 301, 303, 304, 306, 307, 309, 310, 311, 313, 314, 316,
		317, 319,
	320, 321, 323, 324, 326, 327, 329, 330, 331, 333, 334, 336, 337, 339,
		340, 341,
	343, 344, 346, 347, 349, 350, 351, 353, 354, 356, 357, 358, 360, 361,
		363, 364
};

/* mlib_tBCb[i] = (int)(i*1.77200*2 + 0.49999999) */
const mlib_u16 mlib_tBCb[256] = {
	0, 4, 7, 11, 14, 18, 21, 25, 28, 32, 35, 39, 43, 46, 50, 53,
	57, 60, 64, 67, 71, 74, 78, 82, 85, 89, 92, 96, 99, 103, 106, 110,
	113, 117, 120, 124, 128, 131, 135, 138, 142, 145, 149, 152, 156, 159,
		163, 167,
	170, 174, 177, 181, 184, 188, 191, 195, 198, 202, 206, 209, 213, 216,
		220, 223,
	227, 230, 234, 237, 241, 245, 248, 252, 255, 259, 262, 266, 269, 273,
		276, 280,
	284, 287, 291, 294, 298, 301, 305, 308, 312, 315, 319, 323, 326, 330,
		333, 337,
	340, 344, 347, 351, 354, 358, 361, 365, 369, 372, 376, 379, 383, 386,
		390, 393,
	397, 400, 404, 408, 411, 415, 418, 422, 425, 429, 432, 436, 439, 443,
		447, 450,
	454, 457, 461, 464, 468, 471, 475, 478, 482, 486, 489, 493, 496, 500,
		503, 507,
	510, 514, 517, 521, 525, 528, 532, 535, 539, 542, 546, 549, 553, 556,
		560, 563,
	567, 571, 574, 578, 581, 585, 588, 592, 595, 599, 602, 606, 610, 613,
		617, 620,
	624, 627, 631, 634, 638, 641, 645, 649, 652, 656, 659, 663, 666, 670,
		673, 677,
	680, 684, 688, 691, 695, 698, 702, 705, 709, 712, 716, 719, 723, 727,
		730, 734,
	737, 741, 744, 748, 751, 755, 758, 762, 766, 769, 773, 776, 780, 783,
		787, 790,
	794, 797, 801, 804, 808, 812, 815, 819, 822, 826, 829, 833, 836, 840,
		843, 847,
	851, 854, 858, 861, 865, 868, 872, 875, 879, 882, 886, 890, 893, 897,
		900, 904
};

/* *********************************************************** */

const mlib_u32 mlib_t_r2j[256] = {
	0, 0, 2097153, 2620417, 4717569, 4717569, 6814722, 6814722,
	8911874, 8910851, 11008003, 11008003, 13105156, 13105156, 15202308,
		15201284,
	17298437, 17298437, 19395589, 19395590, 21492742, 21491718, 23588871,
		23588871,
	25686023, 25686023, 27783176, 27782152, 29879304, 29879305, 31976457,
		31976457,
	34073610, 34072586, 36169738, 36169738, 38266891, 38266891, 40364043,
		40363020,
	42460172, 42460172, 44557325, 44557325, 46654477, 46653453, 48750606,
		48750606,
	50847758, 50847759, 52944911, 52943887, 55041040, 55041040, 57138192,
		57138192,
	59235345, 59234321, 61331473, 61331474, 63428626, 63428626, 65525779,
		65524755,
	67621907, 67621907, 69719060, 69719060, 71816212, 71815189, 73912341,
		73912341,
	76009494, 76009494, 78106646, 78105622, 80202775, 80202775, 82299927,
		82299928,
	84397080, 84396056, 86493209, 86493209, 88590361, 88590361, 90686490,
		90686490,
	92783642, 92783643, 94880795, 94880795, 96976924, 96976924, 99074076,
		99074076,
	101171229, 101171229, 103267357, 103267358, 105364510, 105364510,
		107461662, 107461663,
	109557791, 109557791, 111654944, 111654944, 113752096, 113752097,
		115848225, 115848225,
	117945377, 117945378, 120042530, 120042530, 122138659, 122138659,
		124235811, 124235812,
	126332964, 126332964, 128429092, 128429093, 130526245, 130526245,
		132623398, 132623398,
	134719526, 134719527, 136816679, 136816679, 138913831, 138913832,
		141009960, 141009960,
	143107113, 143107113, 145204265, 145204266, 147300394, 147300394,
		149397546, 149397547,
	151494699, 151494699, 153590828, 153590828, 155687980, 155687981,
		157785133, 157785133,
	159881261, 159881262, 161978414, 161978414, 164075567, 164075567,
		166171695, 166171696,
	168268848, 168268848, 170366000, 170364977, 172462129, 172462129,
		174559282, 174559282,
	176656434, 176655411, 178752563, 178752563, 180849715, 180849716,
		182946868, 182945844,
	185042997, 185042997, 187140149, 187140150, 189237302, 189236278,
		191333430, 191333431,
	193430583, 193430583, 195527736, 195526712, 197623864, 197623865,
		199721017, 199721017,
	201818169, 201817146, 203914298, 203914298, 206011451, 206011451,
		208108603, 208107579,
	210204732, 210204732, 212301884, 212301885, 214399037, 214398013,
		216495166, 216495166,
	218592318, 218592318, 220689471, 220688447, 222785599, 222785600,
		224882752, 224882752,
	226979905, 226978881, 229076033, 229076033, 231173186, 231173186,
		233270338, 233269315,
	235366467, 235366467, 237463620, 237463620, 239560772, 239559748,
		241656901, 241656901,
	243754053, 243754054, 245851206, 245850182, 247947335, 247947335,
		250044487, 250044487,
	252141640, 252140616, 254237768, 254237769, 256334921, 256334921,
		258431050, 258431050,
	260528202, 260528202, 262625355, 262625355, 264721483, 264721484,
		266818636, 266818636
};

const mlib_u32 mlib_t_g2j[256] = {
	268566528, 268566529, 266468353, 266468354, 264371202, 264370179,
		262273028, 262273028,
	262272005, 260174853, 260174854, 258076678, 258076679, 258076680,
		255978504, 255978505,
	253881353, 253880330, 251783179, 251783179, 251782156, 249685004,
		249685005, 247586830,
	247586830, 247586831, 245488655, 245488656, 243391504, 243390481,
		241293330, 241293330,
	241292307, 239195155, 239195156, 237096981, 237096981, 237096982,
		234998806, 234998807,
	232901655, 232900632, 230803481, 230803481, 230802458, 228705306,
		228705307, 226607132,
	226607132, 224509981, 224508957, 224508958, 222411807, 222410783,
		220313632, 220313632,
	220312609, 218215457, 218215458, 216117283, 216117283, 214020132,
		214019108, 214019109,
	211921958, 211920934, 209823783, 209823783, 209822760, 207725609,
		207725609, 205627434,
	205627434, 203530283, 203529259, 203529260, 201432109, 201431085,
		199333934, 199333934,
	199333935, 197235760, 197235760, 195138609, 195137585, 193040434,
		193040434, 193039411,
	190942260, 190942260, 188844085, 188844085, 186746934, 186745911,
		186745911, 184648760,
	184647736, 182550585, 182550586, 182549562, 180452411, 180452411,
		178354236, 178354236,
	176257085, 176256062, 176256062, 174158911, 174157887, 172060736,
		172060737, 172059713,
	169962562, 169962562, 167864387, 167864388, 165767236, 165766213,
		165766213, 163669062,
	163668038, 161570887, 161570888, 161569864, 159472713, 159472713,
		157374538, 157374539,
	155277387, 155276364, 155276364, 153179213, 153178189, 151081038,
		151081039, 148982863,
	148982864, 148982864, 146884689, 146884690, 144787538, 144786515,
		144786515, 142689364,
	142688341, 140591189, 140591190, 138493014, 138493015, 138493015,
		136394840, 136394841,
	134297689, 134296666, 134296666, 132199515, 132198492, 130101340,
		130101341, 128003165,
	128003166, 128003167, 125904991, 125904992, 123807840, 123806817,
		121709665, 121709666,
	121708643, 119611491, 119611492, 117513316, 117513317, 117513318,
		115415142, 115415143,
	113317991, 113316968, 111219816, 111219817, 111218794, 109121642,
		109121643, 107023467,
	107023468, 107023469, 104925293, 104925294, 102828142, 102827119,
		100729968, 100729968,
	100728945, 98631793, 98631794, 96533618, 96533619, 96533620, 94435444,
		94435445,
	92338293, 92337270, 90240119, 90240119, 90239096, 88141944, 88141945,
		86043770,
	86043770, 83946619, 83945595, 83945596, 81848444, 81847421, 79750270,
		79750270,
	79749247, 77652095, 77652096, 75553921, 75553921, 73456770, 73455746,
		73455747,
	71358595, 71357572, 69260421, 69260421, 69259398, 67162246, 67162247,
		65064072,
	65064072, 62966921, 62965897, 62965898, 60868747, 60867723, 58770572,
		58770572,
	58769549, 56672397, 56672398, 54575247, 54574223, 52477072, 52477072,
		52476049,
	50378898, 50378898, 48280723, 48280723, 46183572, 46182549, 46182549,
		44085398
};

const mlib_u32 mlib_t_b2j[256] = {
	0, 0, 1024, 1024, 2048, 2049, 3073, 1071647745,
	1071648769, 1071648769, 1071649793, 1071649793, 1071650817, 1071650817,
		1071651842, 1071651842,
	1071652866, 1071652866, 1071653890, 1069556738, 1069557762, 1069557762,
		1069558787, 1069558787,
	1069559811, 1069559811, 1069560835, 1069560835, 1069561859, 1069561859,
		1069562883, 1067465732,
	1067466756, 1067466756, 1067467780, 1067467780, 1067468804, 1067468804,
		1067469828, 1067469828,
	1067470853, 1067470853, 1067471877, 1067471877, 1065375749, 1065375749,
		1065376773, 1065376773,
	1065377797, 1065377798, 1065378822, 1065378822, 1065379846, 1065379846,
		1065380870, 1065380870,
	1063284742, 1063284742, 1063285767, 1063285767, 1063286791, 1063286791,
		1063287815, 1063287815,
	1063288839, 1063288839, 1063289864, 1063289864, 1061193736, 1061193736,
		1061194760, 1061194760,
	1061195784, 1061195784, 1061196808, 1061196809, 1061197833, 1061197833,
		1061198857, 1061198857,
	1059102729, 1059102729, 1059103753, 1059103753, 1059104778, 1059104778,
		1059105802, 1059105802,
	1059106826, 1059106826, 1059107850, 1059107850, 1059108874, 1057011723,
		1057012747, 1057012747,
	1057013771, 1057013771, 1057014795, 1057014795, 1057015819, 1057015820,
		1057016844, 1057016844,
	1057017868, 1054920716, 1054921740, 1054921740, 1054922764, 1054922764,
		1054923789, 1054923789,
	1054924813, 1054924813, 1054925837, 1054925837, 1054926861, 1052829709,
		1052830733, 1052830734,
	1052831758, 1052831758, 1052832782, 1052832782, 1052833806, 1052833806,
		1052834830, 1052834830,
	1052835855, 1052835855, 1050739727, 1050739727, 1050740751, 1050740751,
		1050741775, 1050741775,
	1050742800, 1050742800, 1050743824, 1050743824, 1050744848, 1050744848,
		1048648720, 1048648720,
	1048649744, 1048649745, 1048650769, 1048650769, 1048651793, 1048651793,
		1048652817, 1048652817,
	1048653841, 1048653841, 1046557714, 1046557714, 1046558738, 1046558738,
		1046559762, 1046559762,
	1046560786, 1046560786, 1046561810, 1046561811, 1046562835, 1046562835,
		1046563859, 1044466707,
	1044467731, 1044467731, 1044468755, 1044468755, 1044469780, 1044469780,
		1044470804, 1044470804,
	1044471828, 1044471828, 1044472852, 1042375700, 1042376725, 1042376725,
		1042377749, 1042377749,
	1042378773, 1042378773, 1042379797, 1042379797, 1042380821, 1042380822,
		1042381846, 1040284694,
	1040285718, 1040285718, 1040286742, 1040286742, 1040287766, 1040287766,
		1040288791, 1040288791,
	1040289815, 1040289815, 1040290839, 1038193687, 1038194711, 1038194711,
		1038195735, 1038195736,
	1038196760, 1038196760, 1038197784, 1038197784, 1038198808, 1038198808,
		1038199832, 1038199833,
	1036103705, 1036103705, 1036104729, 1036104729, 1036105753, 1036105753,
		1036106777, 1036106777,
	1036107802, 1036107802, 1036108826, 1036108826, 1034012698, 1034012698,
		1034013722, 1034013722,
	1034014746, 1034014747, 1034015771, 1034015771, 1034016795, 1034016795,
		1034017819, 1034017819,
	1031921691, 1031921691, 1031922716, 1031922716, 1031923740, 1031923740,
		1031924764, 1031924764,
	1031925788, 1031925788, 1031926812, 1031926813, 1031927837, 1029830685,
		1029831709, 1029831709
};

/* *********************************************************** */

const mlib_u8 mlib_video_pClipOff256[800] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
	16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
	48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
	64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
	80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
	96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110,
		111,
	112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125,
		126, 127,
	128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141,
		142, 143,
	144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157,
		158, 159,
	160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173,
		174, 175,
	176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189,
		190, 191,
	192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205,
		206, 207,
	208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221,
		222, 223,
	224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237,
		238, 239,
	240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253,
		254, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
		255, 255
};

/* *********************************************************** */

const mlib_s32 mlib_t_Yuv2rgb[256] = {
	33, 1049634, 2099235, 3148836, 5248038, 6297639, 7347240, 8396841,
	9446442, 10496043, 12595245, 13644846, 14694447, 15744048, 16793649,
		17843250,
	19942452, 20992053, 22041654, 23091255, 24140856, 25190457, 27289659,
		28339260,
	29388861, 30438462, 31488063, 32537664, 34636866, 35686467, 36736068,
		37785669,
	38835270, 39884871, 41984073, 43033674, 44083275, 45132876, 46182477,
		47232078,
	49331280, 50380881, 51430482, 52480083, 53529684, 54579285, 56678487,
		57728088,
	58777689, 59827290, 60876891, 61926492, 64025694, 65075295, 66124896,
		67174497,
	68224098, 69273699, 71372901, 72422502, 73472103, 74521704, 75571305,
		76620906,
	78720108, 79769709, 80819310, 81868911, 82918512, 83968113, 86067315,
		87116916,
	88166517, 89216118, 90265719, 91315320, 92364921, 94464123, 95513724,
		96563325,
	97612926, 98662527, 99712128, 101811330, 102860931, 103910532,
		104960133, 106009734,
	107059335, 109158537, 110208138, 111257739, 112307340, 113356941,
		114406542, 116505744,
	117555345, 118604946, 119654547, 120704148, 121753749, 123852951,
		124902552, 125952153,
	127001754, 128051355, 129100956, 131200158, 132249759, 133299360,
		134348961, 135398562,
	136448163, 138547365, 139596966, 140646567, 141696168, 142745769,
		143795370, 145894572,
	146944173, 147993774, 149043375, 150092976, 151142577, 153241779,
		154291380, 155340981,
	156390582, 157440183, 158489784, 160588986, 161638587, 162688188,
		163737789, 164787390,
	165836991, 167936193, 168985794, 170035395, 171084996, 172134597,
		173184198, 175283400,
	176333001, 177382602, 178432203, 179481804, 180531405, 181581007,
		183680208, 184729809,
	185779410, 186829011, 187878612, 188928213, 191027415, 192077016,
		193126617, 194176218,
	195225819, 196275420, 198374622, 199424223, 200473824, 201523425,
		202573026, 203622627,
	205721829, 206771430, 207821031, 208870632, 209920233, 210969834,
		213069036, 214118637,
	215168238, 216217839, 217267440, 218317041, 220416243, 221465844,
		222515445, 223565046,
	224614647, 225664248, 227763450, 228813051, 229862652, 230912253,
		231961854, 233011455,
	235110657, 236160258, 237209859, 238259460, 239309061, 240358662,
		242457864, 243507465,
	244557066, 245606667, 246656268, 247705869, 249805071, 250854672,
		251904273, 252953874,
	254003475, 255053076, 257152278, 258201879, 259251480, 260301081,
		261350682, 262400283,
	264499485, 265549086, 266598687, 267648288, 268697889, 269747490,
		270797092, 272896293,
	273945894, 274995495, 276045096, 277094697, 278144298, 280243500,
		281293101, 282342702,
	283392303, 284441904, 285491505, 287590707, 288640308, 289689909,
		290739510, 291789111,
	292838712, 294937914, 295987515, 297037116, 298086717, 299136318,
		300185919, 302285121,
	303334722, 304384323, 305433924, 306483525, 307533126, 309632328,
		310681929, 311731530
};

const mlib_s32 mlib_t_yUv2rgb[256] = {
	-290316288, -288220160, -286123008, -284026880, -281929728, -279832576,
		-277736448, -275639296,
	-273543168, -271446016, -269348864, -267252736, -265155584, -263058432,
		-260962304, -258865152,
	-256769024, -254671872, -252574720, -250478592, -248381440, -246285312,
		-244188160, -242091008,
	-239994880, -237897728, -235801600, -232655872, -230558720, -228462592,
		-226365440, -224269312,
	-222172160, -220075008, -217978880, -215881728, -213784576, -211688448,
		-209591296, -207495168,
	-205398016, -203300864, -201204736, -199107584, -197011456, -194914304,
		-192817152, -190721024,
	-188623872, -186527744, -184430592, -182333440, -180237312, -178140160,
		-176044032, -173946880,
	-171849728, -169753600, -167656448, -165559296, -163463168, -161366016,
		-159269888, -157172736,
	-155075584, -152979456, -150882304, -148786176, -146689024, -144591872,
		-142495744, -140398592,
	-138302464, -136205312, -134108160, -132012032, -129914880, -127818752,
		-125721600, -123624448,
	-121528320, -118382592, -116286464, -114189312, -112092160, -109996032,
		-107898880, -105801728,
	-103705600, -101608448, -99512320, -97415168, -95318016, -93221888,
		-91124736, -89028608,
	-86931456, -84834304, -82738176, -80641024, -78544896, -76447744,
		-74350592, -72254464,
	-70157312, -68061184, -65964032, -63866880, -61770752, -59673600,
		-57576448, -55480320,
	-53383168, -51287040, -49189888, -47092736, -44996608, -42899456,
		-40803328, -38706176,
	-36609024, -34512896, -32415744, -30319616, -28222464, -26125312,
		-24029184, -21932032,
	-19835904, -17738752, -15641600, -13545472, -11448320, -9352192,
		-7255040, -5157888,
	-2013184, 83968, 2181120, 4277248, 6374400, 8470528, 10567680, 12664832,
	14760960, 16858112, 18954240, 21051392, 23148544, 25244672, 27341824,
		29437952,
	31535104, 33632256, 35728384, 37825536, 39921664, 42018816, 44115968,
		46212096,
	48309248, 50406400, 52502528, 54599680, 56695808, 58792960, 60890112,
		62986240,
	65083392, 67179520, 69276672, 71373824, 73469952, 75567104, 77663232,
		79760384,
	81857536, 83953664, 86050816, 88146944, 90244096, 92341248, 94437376,
		96534528,
	98631680, 100727808, 102824960, 104921088, 107018240, 109115392,
		112260096, 114357248,
	116453376, 118550528, 120647680, 122743808, 124840960, 126937088,
		129034240, 131131392,
	133227520, 135324672, 137420800, 139517952, 141615104, 143711232,
		145808384, 147904512,
	150001664, 152098816, 154194944, 156292096, 158389248, 160485376,
		162582528, 164678656,
	166775808, 168872960, 170969088, 173066240, 175162368, 177259520,
		179356672, 181452800,
	183549952, 185646080, 187743232, 189840384, 191936512, 194033664,
		196129792, 198226944,
	200324096, 202420224, 204517376, 206614528, 208710656, 210807808,
		212903936, 215001088,
	217098240, 219194368, 221291520, 223387648, 226533376, 228630528,
		230726656, 232823808,
	234919936, 237017088, 239114240, 241210368, 243307520, 245403648,
		247500800, 249597952
};

const mlib_s32 mlib_t_yuV2rgb[256] = {
	262144, 261122, 260099, 260101, 259078, 258056, 257034, 256011,
	254989, 254990, 253968, 252946, 251923, 250901, 250902, 249880,
	248858, 247835, 246813, 246814, 245792, 244770, 243747, 242725,
	241702, 241704, 240682, 239659, 238637, 237614, 237616, 236593,
	235571, 234549, 233526, 233528, 232505, 231483, 230461, 229438,
	228416, 228417, 227395, 226373, 225350, 224328, 224329, 223307,
	222285, 221262, 220240, 220241, 219219, 218197, 217174, 216152,
	215129, 215131, 214109, 213086, 212064, 211041, 211043, 210021,
	208998, 207976, 206953, 206955, 205933, 204910, 203888, 202865,
	201843, 201845, 200822, 199800, 198777, 197755, 197757, 196734,
	195712, 194689, 193667, 193669, 192646, 191624, 190601, 189579,
	188557, 188558, 187536, 186513, 185491, 184468, 184470, 183448,
	182425, 181403, 180380, 179358, 179360, 178337, 177315, 176292,
	175270, 175272, 174249, 173227, 172204, 171182, 171184, 170161,
	169139, 168116, 167094, 166072, 166073, 165051, 164028, 163006,
	161984, 161985, 160963, 159940, 158918, 157896, 157897, 156875,
	155852, 154830, 153808, 152785, 152787, 151764, 150742, 149720,
	148697, 148699, 147676, 146654, 145632, 144609, 144611, 143588,
	142566, 141544, 140521, 139499, 139500, 138478, 137455, 136433,
	135411, 135412, 134390, 133367, 132345, 131323, 131324, 130302,
	129279, 128257, 127235, 126212, 126214, 125191, 124169, 123147,
	122124, 122126, 121103, 120081, 119059, 118036, 118038, 117015,
	115993, 114971, 113948, 112926, 112927, 111905, 110883, 109860,
	108838, 108839, 107817, 106795, 105772, 104750, 103727, 103729,
	102707, 101684, 100662, 99639, 99641, 98619, 97596, 96574,
	95551, 95553, 94531, 93508, 92486, 91463, 90441, 90442,
	89420, 88398, 87375, 86353, 86354, 85332, 84310, 83287,
	82265, 82266, 81244, 80222, 79199, 78177, 77154, 77156,
	76134, 75111, 74089, 73066, 73068, 72046, 71023, 70001,
	68978, 68980, 67958, 66935, 65913, 64890, 63868, 63870,
	62847, 61825, 60802, 59780, 59782, 58759, 57737, 56714,
	55692, 55694, 54671, 53649, 52626, 51604, 50582, 50583
};

/* *********************************************************** */
