/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)mlib_v_GraphicsTabAlias.c	9.3	07/11/05 SMI"

/*
 *  DESCRIPTION
 *    for i = 0, ..., 127 :
 *      TabAlias[i] = PI * R^2 * H / 3 - fun_alias(0.5+i/256) -
 *                    - fun_alias(0.5-i/256)
 *    for i = 128, ..., 256 :
 *      TabAlias[i] = fun_alias(i/256-0.5) - fun_alias(0.5+i/256)
 *    for i = 256, ..., 399 :
 *      TabAlias[i] = fun_alias(i/256 - 0.5)
 *
 *    where
 *    fun_alias(x) = H * (R^2 * acos(x/R) / 3 - 2 / 3  * x * sqrt(R^2 - x^2)
 *                       + x^3 / R * log((R + sqrt(R^2 - x^2)) / x) / 3).
 *    for x = 0 : fun_alias(x) = PI * R^2 * H / 6
 *    R = 1.5
 *    H = 1 / 1.35463400720551940815
 *
 *  COMMENTS
 *    This table is used by VIS versions of the many
 *    mlib_Graphics... functions with antialiasing mode.
 *    All table's elements are in Q14 data type.
 */

#include <mlib_graphics.h>

#define	__DECLARE_MLIB_V_TABALIAS

#include <mlib_v_GraphicsTabAlias.h>

/* *********************************************************** */

const mlib_u16 mlib_v_TabAlias[] = {
	0x4000, 0x4000, 0x4000, 0x4000,
	0x4000, 0x4000, 0x4000, 0x4000,
	0x4000, 0x3fff, 0x3fff, 0x3fff,
	0x4000, 0x3ffe, 0x3ffe, 0x3ffe,
	0x4000, 0x3ffd, 0x3ffd, 0x3ffd,
	0x4000, 0x3ffb, 0x3ffb, 0x3ffb,
	0x4000, 0x3ff8, 0x3ff8, 0x3ff8,
	0x4000, 0x3ff5, 0x3ff5, 0x3ff5,
	0x4000, 0x3ff2, 0x3ff2, 0x3ff2,
	0x4000, 0x3fee, 0x3fee, 0x3fee,
	0x4000, 0x3fea, 0x3fea, 0x3fea,
	0x4000, 0x3fe6, 0x3fe6, 0x3fe6,
	0x4000, 0x3fe1, 0x3fe1, 0x3fe1,
	0x4000, 0x3fdb, 0x3fdb, 0x3fdb,
	0x4000, 0x3fd6, 0x3fd6, 0x3fd6,
	0x4000, 0x3fcf, 0x3fcf, 0x3fcf,
	0x4000, 0x3fc9, 0x3fc9, 0x3fc9,
	0x4000, 0x3fc1, 0x3fc1, 0x3fc1,
	0x4000, 0x3fba, 0x3fba, 0x3fba,
	0x4000, 0x3fb2, 0x3fb2, 0x3fb2,
	0x4000, 0x3fa9, 0x3fa9, 0x3fa9,
	0x4000, 0x3fa1, 0x3fa1, 0x3fa1,
	0x4000, 0x3f97, 0x3f97, 0x3f97,
	0x4000, 0x3f8d, 0x3f8d, 0x3f8d,
	0x4000, 0x3f83, 0x3f83, 0x3f83,
	0x4000, 0x3f79, 0x3f79, 0x3f79,
	0x4000, 0x3f6e, 0x3f6e, 0x3f6e,
	0x4000, 0x3f62, 0x3f62, 0x3f62,
	0x4000, 0x3f56, 0x3f56, 0x3f56,
	0x4000, 0x3f4a, 0x3f4a, 0x3f4a,
	0x4000, 0x3f3d, 0x3f3d, 0x3f3d,
	0x4000, 0x3f30, 0x3f30, 0x3f30,
	0x4000, 0x3f23, 0x3f23, 0x3f23,
	0x4000, 0x3f15, 0x3f15, 0x3f15,
	0x4000, 0x3f06, 0x3f06, 0x3f06,
	0x4000, 0x3ef7, 0x3ef7, 0x3ef7,
	0x4000, 0x3ee8, 0x3ee8, 0x3ee8,
	0x4000, 0x3ed8, 0x3ed8, 0x3ed8,
	0x4000, 0x3ec8, 0x3ec8, 0x3ec8,
	0x4000, 0x3eb8, 0x3eb8, 0x3eb8,
	0x4000, 0x3ea7, 0x3ea7, 0x3ea7,
	0x4000, 0x3e96, 0x3e96, 0x3e96,
	0x4000, 0x3e84, 0x3e84, 0x3e84,
	0x4000, 0x3e72, 0x3e72, 0x3e72,
	0x4000, 0x3e5f, 0x3e5f, 0x3e5f,
	0x4000, 0x3e4c, 0x3e4c, 0x3e4c,
	0x4000, 0x3e38, 0x3e38, 0x3e38,
	0x4000, 0x3e25, 0x3e25, 0x3e25,
	0x4000, 0x3e10, 0x3e10, 0x3e10,
	0x4000, 0x3dfc, 0x3dfc, 0x3dfc,
	0x4000, 0x3de7, 0x3de7, 0x3de7,
	0x4000, 0x3dd1, 0x3dd1, 0x3dd1,
	0x4000, 0x3dbb, 0x3dbb, 0x3dbb,
	0x4000, 0x3da5, 0x3da5, 0x3da5,
	0x4000, 0x3d8e, 0x3d8e, 0x3d8e,
	0x4000, 0x3d77, 0x3d77, 0x3d77,
	0x4000, 0x3d5f, 0x3d5f, 0x3d5f,
	0x4000, 0x3d47, 0x3d47, 0x3d47,
	0x4000, 0x3d2f, 0x3d2f, 0x3d2f,
	0x4000, 0x3d16, 0x3d16, 0x3d16,
	0x4000, 0x3cfd, 0x3cfd, 0x3cfd,
	0x4000, 0x3ce3, 0x3ce3, 0x3ce3,
	0x4000, 0x3cca, 0x3cca, 0x3cca,
	0x4000, 0x3caf, 0x3caf, 0x3caf,
	0x4000, 0x3c94, 0x3c94, 0x3c94,
	0x4000, 0x3c79, 0x3c79, 0x3c79,
	0x4000, 0x3c5e, 0x3c5e, 0x3c5e,
	0x4000, 0x3c42, 0x3c42, 0x3c42,
	0x4000, 0x3c25, 0x3c25, 0x3c25,
	0x4000, 0x3c09, 0x3c09, 0x3c09,
	0x4000, 0x3bec, 0x3bec, 0x3bec,
	0x4000, 0x3bce, 0x3bce, 0x3bce,
	0x4000, 0x3bb0, 0x3bb0, 0x3bb0,
	0x4000, 0x3b92, 0x3b92, 0x3b92,
	0x4000, 0x3b73, 0x3b73, 0x3b73,
	0x4000, 0x3b54, 0x3b54, 0x3b54,
	0x4000, 0x3b35, 0x3b35, 0x3b35,
	0x4000, 0x3b15, 0x3b15, 0x3b15,
	0x4000, 0x3af5, 0x3af5, 0x3af5,
	0x4000, 0x3ad4, 0x3ad4, 0x3ad4,
	0x4000, 0x3ab3, 0x3ab3, 0x3ab3,
	0x4000, 0x3a92, 0x3a92, 0x3a92,
	0x4000, 0x3a70, 0x3a70, 0x3a70,
	0x4000, 0x3a4e, 0x3a4e, 0x3a4e,
	0x4000, 0x3a2c, 0x3a2c, 0x3a2c,
	0x4000, 0x3a09, 0x3a09, 0x3a09,
	0x4000, 0x39e6, 0x39e6, 0x39e6,
	0x4000, 0x39c3, 0x39c3, 0x39c3,
	0x4000, 0x399f, 0x399f, 0x399f,
	0x4000, 0x397b, 0x397b, 0x397b,
	0x4000, 0x3956, 0x3956, 0x3956,
	0x4000, 0x3931, 0x3931, 0x3931,
	0x4000, 0x390c, 0x390c, 0x390c,
	0x4000, 0x38e6, 0x38e6, 0x38e6,
	0x4000, 0x38c0, 0x38c0, 0x38c0,
	0x4000, 0x389a, 0x389a, 0x389a,
	0x4000, 0x3873, 0x3873, 0x3873,
	0x4000, 0x384c, 0x384c, 0x384c,
	0x4000, 0x3825, 0x3825, 0x3825,
	0x4000, 0x37fd, 0x37fd, 0x37fd,
	0x4000, 0x37d5, 0x37d5, 0x37d5,
	0x4000, 0x37ad, 0x37ad, 0x37ad,
	0x4000, 0x3784, 0x3784, 0x3784,
	0x4000, 0x375b, 0x375b, 0x375b,
	0x4000, 0x3732, 0x3732, 0x3732,
	0x4000, 0x3708, 0x3708, 0x3708,
	0x4000, 0x36de, 0x36de, 0x36de,
	0x4000, 0x36b4, 0x36b4, 0x36b4,
	0x4000, 0x3689, 0x3689, 0x3689,
	0x4000, 0x365e, 0x365e, 0x365e,
	0x4000, 0x3633, 0x3633, 0x3633,
	0x4000, 0x3608, 0x3608, 0x3608,
	0x4000, 0x35dc, 0x35dc, 0x35dc,
	0x4000, 0x35b0, 0x35b0, 0x35b0,
	0x4000, 0x3583, 0x3583, 0x3583,
	0x4000, 0x3556, 0x3556, 0x3556,
	0x4000, 0x3529, 0x3529, 0x3529,
	0x4000, 0x34fc, 0x34fc, 0x34fc,
	0x4000, 0x34ce, 0x34ce, 0x34ce,
	0x4000, 0x34a1, 0x34a1, 0x34a1,
	0x4000, 0x3472, 0x3472, 0x3472,
	0x4000, 0x3444, 0x3444, 0x3444,
	0x4000, 0x3415, 0x3415, 0x3415,
	0x4000, 0x33e6, 0x33e6, 0x33e6,
	0x4000, 0x33b7, 0x33b7, 0x33b7,
	0x4000, 0x3388, 0x3388, 0x3388,
	0x4000, 0x3358, 0x3358, 0x3358,
	0x4000, 0x3328, 0x3328, 0x3328,
	0x4000, 0x32f8, 0x32f8, 0x32f8,
	0x4000, 0x32c7, 0x32c7, 0x32c7,
	0x4000, 0x3296, 0x3296, 0x3296,
	0x4000, 0x3265, 0x3265, 0x3265,
	0x4000, 0x3234, 0x3234, 0x3234,
	0x4000, 0x3203, 0x3203, 0x3203,
	0x4000, 0x31d1, 0x31d1, 0x31d1,
	0x4000, 0x31a0, 0x31a0, 0x31a0,
	0x4000, 0x316e, 0x316e, 0x316e,
	0x4000, 0x313b, 0x313b, 0x313b,
	0x4000, 0x3109, 0x3109, 0x3109,
	0x4000, 0x30d6, 0x30d6, 0x30d6,
	0x4000, 0x30a4, 0x30a4, 0x30a4,
	0x4000, 0x3071, 0x3071, 0x3071,
	0x4000, 0x303e, 0x303e, 0x303e,
	0x4000, 0x300a, 0x300a, 0x300a,
	0x4000, 0x2fd7, 0x2fd7, 0x2fd7,
	0x4000, 0x2fa3, 0x2fa3, 0x2fa3,
	0x4000, 0x2f6f, 0x2f6f, 0x2f6f,
	0x4000, 0x2f3b, 0x2f3b, 0x2f3b,
	0x4000, 0x2f07, 0x2f07, 0x2f07,
	0x4000, 0x2ed3, 0x2ed3, 0x2ed3,
	0x4000, 0x2e9f, 0x2e9f, 0x2e9f,
	0x4000, 0x2e6a, 0x2e6a, 0x2e6a,
	0x4000, 0x2e35, 0x2e35, 0x2e35,
	0x4000, 0x2e00, 0x2e00, 0x2e00,
	0x4000, 0x2dcb, 0x2dcb, 0x2dcb,
	0x4000, 0x2d96, 0x2d96, 0x2d96,
	0x4000, 0x2d61, 0x2d61, 0x2d61,
	0x4000, 0x2d2b, 0x2d2b, 0x2d2b,
	0x4000, 0x2cf6, 0x2cf6, 0x2cf6,
	0x4000, 0x2cc0, 0x2cc0, 0x2cc0,
	0x4000, 0x2c8a, 0x2c8a, 0x2c8a,
	0x4000, 0x2c54, 0x2c54, 0x2c54,
	0x4000, 0x2c1e, 0x2c1e, 0x2c1e,
	0x4000, 0x2be8, 0x2be8, 0x2be8,
	0x4000, 0x2bb2, 0x2bb2, 0x2bb2,
	0x4000, 0x2b7b, 0x2b7b, 0x2b7b,
	0x4000, 0x2b45, 0x2b45, 0x2b45,
	0x4000, 0x2b0e, 0x2b0e, 0x2b0e,
	0x4000, 0x2ad8, 0x2ad8, 0x2ad8,
	0x4000, 0x2aa1, 0x2aa1, 0x2aa1,
	0x4000, 0x2a6a, 0x2a6a, 0x2a6a,
	0x4000, 0x2a33, 0x2a33, 0x2a33,
	0x4000, 0x29fc, 0x29fc, 0x29fc,
	0x4000, 0x29c4, 0x29c4, 0x29c4,
	0x4000, 0x298d, 0x298d, 0x298d,
	0x4000, 0x2956, 0x2956, 0x2956,
	0x4000, 0x291e, 0x291e, 0x291e,
	0x4000, 0x28e7, 0x28e7, 0x28e7,
	0x4000, 0x28af, 0x28af, 0x28af,
	0x4000, 0x2877, 0x2877, 0x2877,
	0x4000, 0x2840, 0x2840, 0x2840,
	0x4000, 0x2808, 0x2808, 0x2808,
	0x4000, 0x27d0, 0x27d0, 0x27d0,
	0x4000, 0x2798, 0x2798, 0x2798,
	0x4000, 0x2760, 0x2760, 0x2760,
	0x4000, 0x2728, 0x2728, 0x2728,
	0x4000, 0x26f0, 0x26f0, 0x26f0,
	0x4000, 0x26b7, 0x26b7, 0x26b7,
	0x4000, 0x267f, 0x267f, 0x267f,
	0x4000, 0x2647, 0x2647, 0x2647,
	0x4000, 0x260f, 0x260f, 0x260f,
	0x4000, 0x25d6, 0x25d6, 0x25d6,
	0x4000, 0x259e, 0x259e, 0x259e,
	0x4000, 0x2565, 0x2565, 0x2565,
	0x4000, 0x252d, 0x252d, 0x252d,
	0x4000, 0x24f4, 0x24f4, 0x24f4,
	0x4000, 0x24bc, 0x24bc, 0x24bc,
	0x4000, 0x2483, 0x2483, 0x2483,
	0x4000, 0x244a, 0x244a, 0x244a,
	0x4000, 0x2412, 0x2412, 0x2412,
	0x4000, 0x23d9, 0x23d9, 0x23d9,
	0x4000, 0x23a0, 0x23a0, 0x23a0,
	0x4000, 0x2368, 0x2368, 0x2368,
	0x4000, 0x232f, 0x232f, 0x232f,
	0x4000, 0x22f6, 0x22f6, 0x22f6,
	0x4000, 0x22bd, 0x22bd, 0x22bd,
	0x4000, 0x2285, 0x2285, 0x2285,
	0x4000, 0x224c, 0x224c, 0x224c,
	0x4000, 0x2213, 0x2213, 0x2213,
	0x4000, 0x21da, 0x21da, 0x21da,
	0x4000, 0x21a2, 0x21a2, 0x21a2,
	0x4000, 0x2169, 0x2169, 0x2169,
	0x4000, 0x2130, 0x2130, 0x2130,
	0x4000, 0x20f8, 0x20f8, 0x20f8,
	0x4000, 0x20bf, 0x20bf, 0x20bf,
	0x4000, 0x2086, 0x2086, 0x2086,
	0x4000, 0x204e, 0x204e, 0x204e,
	0x4000, 0x2015, 0x2015, 0x2015,
	0x4000, 0x1fdc, 0x1fdc, 0x1fdc,
	0x4000, 0x1fa4, 0x1fa4, 0x1fa4,
	0x4000, 0x1f6b, 0x1f6b, 0x1f6b,
	0x4000, 0x1f33, 0x1f33, 0x1f33,
	0x4000, 0x1efa, 0x1efa, 0x1efa,
	0x4000, 0x1ec2, 0x1ec2, 0x1ec2,
	0x4000, 0x1e89, 0x1e89, 0x1e89,
	0x4000, 0x1e51, 0x1e51, 0x1e51,
	0x4000, 0x1e19, 0x1e19, 0x1e19,
	0x4000, 0x1de1, 0x1de1, 0x1de1,
	0x4000, 0x1da8, 0x1da8, 0x1da8,
	0x4000, 0x1d70, 0x1d70, 0x1d70,
	0x4000, 0x1d38, 0x1d38, 0x1d38,
	0x4000, 0x1d00, 0x1d00, 0x1d00,
	0x4000, 0x1cc8, 0x1cc8, 0x1cc8,
	0x4000, 0x1c90, 0x1c90, 0x1c90,
	0x4000, 0x1c59, 0x1c59, 0x1c59,
	0x4000, 0x1c21, 0x1c21, 0x1c21,
	0x4000, 0x1be9, 0x1be9, 0x1be9,
	0x4000, 0x1bb2, 0x1bb2, 0x1bb2,
	0x4000, 0x1b7a, 0x1b7a, 0x1b7a,
	0x4000, 0x1b43, 0x1b43, 0x1b43,
	0x4000, 0x1b0c, 0x1b0c, 0x1b0c,
	0x4000, 0x1ad5, 0x1ad5, 0x1ad5,
	0x4000, 0x1a9e, 0x1a9e, 0x1a9e,
	0x4000, 0x1a67, 0x1a67, 0x1a67,
	0x4000, 0x1a30, 0x1a30, 0x1a30,
	0x4000, 0x19f9, 0x19f9, 0x19f9,
	0x4000, 0x19c3, 0x19c3, 0x19c3,
	0x4000, 0x198c, 0x198c, 0x198c,
	0x4000, 0x1956, 0x1956, 0x1956,
	0x4000, 0x1920, 0x1920, 0x1920,
	0x4000, 0x18ea, 0x18ea, 0x18ea,
	0x4000, 0x18b4, 0x18b4, 0x18b4,
	0x4000, 0x187e, 0x187e, 0x187e,
	0x4000, 0x1848, 0x1848, 0x1848,
	0x4000, 0x1813, 0x1813, 0x1813,
	0x4000, 0x17de, 0x17de, 0x17de,
	0x4000, 0x17a9, 0x17a9, 0x17a9,
	0x4000, 0x1774, 0x1774, 0x1774,
	0x4000, 0x173f, 0x173f, 0x173f,
	0x4000, 0x170b, 0x170b, 0x170b,
	0x4000, 0x16d7, 0x16d7, 0x16d7,
	0x4000, 0x16a3, 0x16a3, 0x16a3,
	0x4000, 0x166f, 0x166f, 0x166f,
	0x4000, 0x163c, 0x163c, 0x163c,
	0x4000, 0x1608, 0x1608, 0x1608,
	0x4000, 0x15d5, 0x15d5, 0x15d5,
	0x4000, 0x15a2, 0x15a2, 0x15a2,
	0x4000, 0x1570, 0x1570, 0x1570,
	0x4000, 0x153d, 0x153d, 0x153d,
	0x4000, 0x150b, 0x150b, 0x150b,
	0x4000, 0x14d9, 0x14d9, 0x14d9,
	0x4000, 0x14a8, 0x14a8, 0x14a8,
	0x4000, 0x1476, 0x1476, 0x1476,
	0x4000, 0x1445, 0x1445, 0x1445,
	0x4000, 0x1414, 0x1414, 0x1414,
	0x4000, 0x13e3, 0x13e3, 0x13e3,
	0x4000, 0x13b2, 0x13b2, 0x13b2,
	0x4000, 0x1382, 0x1382, 0x1382,
	0x4000, 0x1352, 0x1352, 0x1352,
	0x4000, 0x1322, 0x1322, 0x1322,
	0x4000, 0x12f2, 0x12f2, 0x12f2,
	0x4000, 0x12c3, 0x12c3, 0x12c3,
	0x4000, 0x1294, 0x1294, 0x1294,
	0x4000, 0x1265, 0x1265, 0x1265,
	0x4000, 0x1236, 0x1236, 0x1236,
	0x4000, 0x1207, 0x1207, 0x1207,
	0x4000, 0x11d9, 0x11d9, 0x11d9,
	0x4000, 0x11ab, 0x11ab, 0x11ab,
	0x4000, 0x117d, 0x117d, 0x117d,
	0x4000, 0x1150, 0x1150, 0x1150,
	0x4000, 0x1122, 0x1122, 0x1122,
	0x4000, 0x10f5, 0x10f5, 0x10f5,
	0x4000, 0x10c8, 0x10c8, 0x10c8,
	0x4000, 0x109c, 0x109c, 0x109c,
	0x4000, 0x106f, 0x106f, 0x106f,
	0x4000, 0x1043, 0x1043, 0x1043,
	0x4000, 0x1017, 0x1017, 0x1017,
	0x4000, 0xfec, 0xfec, 0xfec,
	0x4000, 0xfc0, 0xfc0, 0xfc0,
	0x4000, 0xf95, 0xf95, 0xf95,
	0x4000, 0xf6a, 0xf6a, 0xf6a,
	0x4000, 0xf3f, 0xf3f, 0xf3f,
	0x4000, 0xf15, 0xf15, 0xf15,
	0x4000, 0xeea, 0xeea, 0xeea,
	0x4000, 0xec0, 0xec0, 0xec0,
	0x4000, 0xe97, 0xe97, 0xe97,
	0x4000, 0xe6d, 0xe6d, 0xe6d,
	0x4000, 0xe44, 0xe44, 0xe44,
	0x4000, 0xe1b, 0xe1b, 0xe1b,
	0x4000, 0xdf2, 0xdf2, 0xdf2,
	0x4000, 0xdc9, 0xdc9, 0xdc9,
	0x4000, 0xda1, 0xda1, 0xda1,
	0x4000, 0xd79, 0xd79, 0xd79,
	0x4000, 0xd51, 0xd51, 0xd51,
	0x4000, 0xd29, 0xd29, 0xd29,
	0x4000, 0xd02, 0xd02, 0xd02,
	0x4000, 0xcdb, 0xcdb, 0xcdb,
	0x4000, 0xcb4, 0xcb4, 0xcb4,
	0x4000, 0xc8d, 0xc8d, 0xc8d,
	0x4000, 0xc67, 0xc67, 0xc67,
	0x4000, 0xc41, 0xc41, 0xc41,
	0x4000, 0xc1b, 0xc1b, 0xc1b,
	0x4000, 0xbf5, 0xbf5, 0xbf5,
	0x4000, 0xbd0, 0xbd0, 0xbd0,
	0x4000, 0xbaa, 0xbaa, 0xbaa,
	0x4000, 0xb86, 0xb86, 0xb86,
	0x4000, 0xb61, 0xb61, 0xb61,
	0x4000, 0xb3c, 0xb3c, 0xb3c,
	0x4000, 0xb18, 0xb18, 0xb18,
	0x4000, 0xaf4, 0xaf4, 0xaf4,
	0x4000, 0xad0, 0xad0, 0xad0,
	0x4000, 0xaad, 0xaad, 0xaad,
	0x4000, 0xa8a, 0xa8a, 0xa8a,
	0x4000, 0xa67, 0xa67, 0xa67,
	0x4000, 0xa44, 0xa44, 0xa44,
	0x4000, 0xa22, 0xa22, 0xa22,
	0x4000, 0x9ff, 0x9ff, 0x9ff,
	0x4000, 0x9dd, 0x9dd, 0x9dd,
	0x4000, 0x9bb, 0x9bb, 0x9bb,
	0x4000, 0x99a, 0x99a, 0x99a,
	0x4000, 0x979, 0x979, 0x979,
	0x4000, 0x958, 0x958, 0x958,
	0x4000, 0x937, 0x937, 0x937,
	0x4000, 0x916, 0x916, 0x916,
	0x4000, 0x8f6, 0x8f6, 0x8f6,
	0x4000, 0x8d6, 0x8d6, 0x8d6,
	0x4000, 0x8b6, 0x8b6, 0x8b6,
	0x4000, 0x897, 0x897, 0x897,
	0x4000, 0x877, 0x877, 0x877,
	0x4000, 0x858, 0x858, 0x858,
	0x4000, 0x839, 0x839, 0x839,
	0x4000, 0x81b, 0x81b, 0x81b,
	0x4000, 0x7fc, 0x7fc, 0x7fc,
	0x4000, 0x7de, 0x7de, 0x7de,
	0x4000, 0x7c0, 0x7c0, 0x7c0,
	0x4000, 0x7a3, 0x7a3, 0x7a3,
	0x4000, 0x785, 0x785, 0x785,
	0x4000, 0x768, 0x768, 0x768,
	0x4000, 0x74b, 0x74b, 0x74b,
	0x4000, 0x72f, 0x72f, 0x72f,
	0x4000, 0x712, 0x712, 0x712,
	0x4000, 0x6f6, 0x6f6, 0x6f6,
	0x4000, 0x6da, 0x6da, 0x6da,
	0x4000, 0x6bf, 0x6bf, 0x6bf,
	0x4000, 0x6a3, 0x6a3, 0x6a3,
	0x4000, 0x688, 0x688, 0x688,
	0x4000, 0x66d, 0x66d, 0x66d,
	0x4000, 0x652, 0x652, 0x652,
	0x4000, 0x638, 0x638, 0x638,
	0x4000, 0x61e, 0x61e, 0x61e,
	0x4000, 0x604, 0x604, 0x604,
	0x4000, 0x5ea, 0x5ea, 0x5ea,
	0x4000, 0x5d0, 0x5d0, 0x5d0,
	0x4000, 0x5b7, 0x5b7, 0x5b7,
	0x4000, 0x59e, 0x59e, 0x59e,
	0x4000, 0x585, 0x585, 0x585,
	0x4000, 0x56d, 0x56d, 0x56d,
	0x4000, 0x555, 0x555, 0x555,
	0x4000, 0x53d, 0x53d, 0x53d,
	0x4000, 0x525, 0x525, 0x525,
	0x4000, 0x50d, 0x50d, 0x50d,
	0x4000, 0x4f6, 0x4f6, 0x4f6,
	0x4000, 0x4df, 0x4df, 0x4df,
	0x4000, 0x4c8, 0x4c8, 0x4c8,
	0x4000, 0x4b1, 0x4b1, 0x4b1,
	0x4000, 0x49b, 0x49b, 0x49b,
	0x4000, 0x485, 0x485, 0x485,
	0x4000, 0x46f, 0x46f, 0x46f,
	0x4000, 0x459, 0x459, 0x459,
	0x4000, 0x444, 0x444, 0x444,
	0x4000, 0x42e, 0x42e, 0x42e,
	0x4000, 0x419, 0x419, 0x419,
	0x4000, 0x405, 0x405, 0x405,
	0x4000, 0x3f0, 0x3f0, 0x3f0,
	0x4000, 0x3dc, 0x3dc, 0x3dc,
	0x4000, 0x3c8, 0x3c8, 0x3c8,
	0x4000, 0x3b4, 0x3b4, 0x3b4,
	0x4000, 0x3a0, 0x3a0, 0x3a0,
	0x4000, 0x38d, 0x38d, 0x38d,
	0x4000, 0x37a, 0x37a, 0x37a
};

/* *********************************************************** */
