/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/* Copyright (c) 1988 AT&T */
/* All Rights Reserved */
/*
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * Use is subject to license terms.
 */
/*
 * @(#)defines.h 1.21 06/12/12
 */

#ident	"@(#)defines.h"
#ident	"@(#)sccs:hdr/defines.h"
# include	<sys/types.h>
# include	<sys/param.h>
# include	<sys/stat.h>
# include	<errno.h>
# include	<fcntl.h>
# include	<stdio.h>
# include	<stdlib.h>
# include	<unistd.h>
# include	<string.h>
# include	<locale.h>
# include	<macros.h>
# undef		abs
# include	<fatal.h>
# include	<time.h>
# include 	"fatal.h"

#define ALIGNMENT  	(sizeof(long long))
#define ROUND(x,base)   (((x) + (base-1)) & ~(base-1))

# define CTLSTR		"%c%c\n"

# define CTLCHAR	1
# define HEAD		'h'

# define STATS		's'

# define BDELTAB	'd'
# define INCLUDE	'i'
# define EXCLUDE	'x'
# define IGNORE		'g'
# define MRNUM		'm'
# define COMMENTS	'c'
# define EDELTAB	'e'

# define BUSERNAM	'u'
# define EUSERNAM	'U'

# define NFLAGS	28

# define FLAG		'f'
# define NULLFLAG	'n'
# define JOINTFLAG	'j'
# define DEFTFLAG	'd'
# define TYPEFLAG	't'
# define VALFLAG	'v'
# define CMFFLAG	'z'
# define BRCHFLAG	'b'
# define IDFLAG		'i'
# define MODFLAG	'm'
# define FLORFLAG	'f'
# define CEILFLAG	'c'
# define QSECTFLAG	'q'
# define LOCKFLAG	'l'
# define ENCODEFLAG	'e'
# define SCANFLAG	's'
# define EXPANDFLAG	'y'

# define BUSERTXT	't'
# define EUSERTXT	'T'

# define INS		'I'
# define DEL		'D'
# define END		'E'

# define MINR		1		/* minimum release number */
# define MAXR		9999		/* maximum release number */
# define FILESIZE	MAXPATHLEN
# define MAXLINE	BUFSIZ
# define DEF_LINE_SIZE	128
# define MAX		9999
# define DELIVER	'*'
# define LOGSIZE	(33)		/* TWCP SCCS compatibility */
# define MAXERRORLEN	(1024+MAXPATHLEN)	/* max length of SccsError buffer */

# define FAILPUT    fatal("fputs could not write to file (ut13)")
# define SCCS_LOCK_ATTEMPTS	4       /* maximum number of lock   attempts  */
# define SCCS_CREAT_ATTEMPTS	4       /* maximum number of create attempts  */

/*
 Declares for external functions in lib/cassi
*/
extern	char*	gf();
extern	int	sweep();
extern	int	cmrcheck();
extern	int	deltack();
extern	void	error();

/*
 Declares for external functions in lib/comobj
*/

extern	char*	auxf();
extern	void	sinit();
extern	void	setup();
extern	void	finduser();
extern	void	permiss();
extern	char*	sid_ab();
extern	char*	sid_ba();
extern	char*	omit_sid();
extern	int	date_ab();
extern	char*	date_ba();
extern	char	del_ab();
extern	char*	del_ba();
extern	void	stats_ab();
extern	void	pf_ab();
extern	int	getser();
extern	int	sidtoser();
extern	int	eqsid();
extern	void	chksid();
extern	void	newsid();
extern	void	newstats(); 
extern	void	condset();
extern	void	dolist();
extern	void	dohist();
extern	void	doie();
extern	void	doflags();
extern	struct idel *dodelt();
extern	void	do_file(char *, void (*func)(), int);
extern	void	fmterr();
extern	char	*getline();
extern	void	putline();
extern	char*	logname();
extern	int	mystrptime();
extern	char*	savecmt();
extern	void	mrfixup();
extern	void	xrm();
extern	void	flushto();
extern	void	flushline();
extern	int 	chkid();
extern	int	valmrs();
extern	void	encode();
extern	void	decode();
extern	int	readmod();
extern	int	parse_date();
extern	int	cmpdate();
extern	void	addq();
extern	void	remq();
extern	void	setkeep();
extern	void	get_Del_Date_time();
extern	char*	stalloc();

/*
 Declares for external functions in lib/mpwlib
*/

extern	int	any();
extern	char	*abspath();
extern	char	*sname();
extern	char	*cat();
extern	char	*dname();
extern	char	*satoi();
extern	int	patoi();
extern	char	*repl();
extern	char	*strend();
extern	char	*trnslat();
extern	char	*zero();
extern	void	*fmalloc();
extern	void	ffree();
extern	void	ffreeall();
extern	int	fatal();
extern	int	lockit();
extern	int	unlockit();
extern	int	mylock();
extern	int	sccs_index();
extern	int	imatch();
extern	int	xmsg();
extern	FILE*	fdfopen();
extern	int	xcreat();
extern	int	xopen();
extern	int	xlink();
extern	int	xunlink();
extern	int	xpipe();
extern	void	setsig();
extern	int	check_permission_SccsDir();
extern  char*	get_Sccs_Comments();


/*
	SCCS Internal Structures.
*/

struct apply {
	char	a_inline;	/* in the line of normally applied deltas */
	int	a_code;		/* APPLY, NOAPPLY or SX_EMPTY */
	int	a_reason;
};

#define SX_EMPTY	(0)
#define APPLY		(1)
#define NOAPPLY		(2)

# define IGNR		0100
# define USER		040
# define INCL		1
# define EXCL		2
# define CUTOFF		4
# define INCLUSER	(USER | INCL)
# define EXCLUSER	(USER | EXCL)
# define IGNRUSER	(USER | IGNR)

struct queue {
	struct queue *q_next;
	int	q_sernum;	/* serial number */
	char    q_keep;		/* keep switch setting */
	char	q_iord;		/* INS or DEL */
	char	q_ixmsg;	/* caused inex msg */
	char	q_user;		/* inex'ed by user */
};

#define YES	(1)
#define NO	(2)

struct	sid {
	int	s_rel;
	int	s_lev;
	int	s_br;
	int	s_seq;
};

struct	deltab {
	struct	sid	d_sid;
	int	d_serial;
	int	d_pred;
	time_t	d_datetime;
	char	d_pgmr[LOGSIZE];
	char	d_type;
};

struct	ixg {
	struct	ixg	*i_next;
	char	i_type;
	char	i_cnt;
	int	i_ser[1];
};

struct	idel {
	struct	sid	i_sid;
	struct	ixg	*i_ixg;
	int	i_pred;
	time_t	i_datetime;
};

# define maxser(pkt)	((pkt)->p_idel->i_pred)
# define sccsfile(f)	imatch("s.", sname(f))

struct packet {
	char	p_file[FILESIZE]; /* file name containing module */
	struct	sid p_reqsid;	/* requested SID, then new SID */
	struct	sid p_gotsid;	/* gotten SID */
	struct	sid p_inssid;	/* SID which inserted current line */
	char	p_verbose;	/* verbose flags (see #define's below) */
	char	p_upd;		/* update flag (!0 = update mode) */
	time_t	p_cutoff;	/* specified cutoff date-time */
	int	p_ihash;	/* initial (input) hash */
	int	p_chash;	/* current (input) hash */
	int	p_uchash;	/* current unsigned (input) hash */
	int	p_nhash;	/* new (output) hash */
	int	p_glnno;	/* line number of current gfile line */
	int	p_slnno;	/* line number of current input line */
	char	p_wrttn;	/* written flag (!0 = written) */
	char	p_keep;		/* keep switch for readmod() */
	struct	apply *p_apply;	/* ptr to apply array */
	struct	queue *p_q;	/* ptr to control queue */
	FILE	*p_iop;		/* input file */
	char	p_buf[BUFSIZ];	/* input file buffer */
	char	*p_line;	/* buffer for getline() */
	size_t	p_line_size;	/* size of the buffer for getline() */
	time_t	p_cdt;		/* date/time of newest applied delta */
	char	*p_lfile;	/* 0 = no l-file; else ptr to l arg */
	struct	idel *p_idel;	/* ptr to internal delta table */
	FILE	*p_stdout;	/* standard output for warnings and messages */
	FILE	*p_gout;	/* g-file output file */
	char	p_user;		/* !0 = user on user list */
	char	p_chkeof;	/* 0 = eof generates error */
	int	p_maxr;		/* largest release number */
	int	p_ixmsg;	/* inex msg counter */
	int	p_reopen;	/* reopen flag used by getline on eof */
	int	p_ixuser;	/* HADI | HADX (in get) */
	int	do_chksum;	/* for getline(), 1 = do check sum */
};

struct	stats {
	int	s_ins;
	int	s_del;
	int	s_unc;
};

struct	pfile	{
	struct	sid	pf_gsid;
	struct	sid	pf_nsid;
	char	pf_user[LOGSIZE];
	time_t	pf_date;
	char	*pf_ilist;
	char	*pf_elist;
	char 	*pf_cmrlist;
};

# define RESPSIZE	1024
# define NVARGS		64
# define VSTART		3

/*
**	The following five definitions (copy, xfopen, xfcreat, remove,
**	USXALLOC) are taken from macros.h 1.1
*/

# define copy(srce,dest)	cat(dest,srce,0)
# define xfopen(file,mode)	fdfopen(xopen(file,mode),mode)
# define xfcreat(file,mode)	fdfopen(xcreat(file,mode),1)
# define remove(file)		xunlink(file)
# define USXALLOC() \
		char *alloc(n) {return((char *)xalloc((unsigned)n));} \
		free(n) char *n; {xfree(n);} \
		char *malloc(n) unsigned n; {int p; p=xalloc(n); \
			return((char *)(p != -1?p:0));}

