/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.text.MessageFormat;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.commands.change.AbstractUpdateFBNElementCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.Demultiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Multiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.impl.ConfigurableFBManagement;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.ErrorDataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;

public class ChangeStructCommand
extends AbstractUpdateFBNElementCommand {
    private final TypeEntry newStructTypeEntry;
    private final String newVisibleChildren;
    private boolean reloadDatatype = true;

    public ChangeStructCommand(StructManipulator mux) {
        this(mux, mux.getDataType(), ChangeStructCommand.getOldVisibleChildren(mux));
    }

    public ChangeStructCommand(StructManipulator mux, DataType newStruct) {
        this(mux, newStruct, ChangeStructCommand.getOldVisibleChildren(mux));
    }

    public ChangeStructCommand(StructManipulator mux, DataType newStruct, boolean doNotReload) {
        this(mux, newStruct, ChangeStructCommand.getOldVisibleChildren(mux));
        this.reloadDatatype = !doNotReload;
    }

    public ChangeStructCommand(Demultiplexer demux, String newVisibleChildren) {
        this((StructManipulator)demux, demux.getDataType(), newVisibleChildren);
    }

    private ChangeStructCommand(StructManipulator demux, DataType datatype, String newVisibleChildren) {
        super((FBNetworkElement)demux);
        this.newStructTypeEntry = datatype != null ? datatype.getTypeEntry() : null;
        this.entry = demux.getTypeEntry();
        this.newVisibleChildren = newVisibleChildren;
    }

    private static String getOldVisibleChildren(StructManipulator mux) {
        Demultiplexer demux;
        if (mux instanceof Demultiplexer && (demux = (Demultiplexer)mux).isIsConfigured()) {
            return ConfigurableFBManagement.buildVisibleChildrenString((EList)demux.getMemberVars());
        }
        return null;
    }

    @Override
    protected FBNetworkElement createCopiedFBEntry(FBNetworkElement srcElement) {
        Multiplexer copy = null;
        if (srcElement instanceof Multiplexer) {
            copy = LibraryElementFactory.eINSTANCE.createMultiplexer();
        } else if (srcElement instanceof Demultiplexer) {
            copy = LibraryElementFactory.eINSTANCE.createDemultiplexer();
        }
        if (copy != null) {
            copy.setTypeEntry(this.entry);
        }
        return copy;
    }

    @Override
    protected void handleConfigurableFB() {
        if (this.newStructTypeEntry != null) {
            this.getNewMux().setDataType(this.getDataTypeFromTypeEntry());
        }
        if (this.isDemuxConfiguration()) {
            this.getNewMux().loadConfiguration("VisibleChildren", this.newVisibleChildren);
        } else {
            this.getNewMux().updateConfiguration();
        }
    }

    private boolean isDemuxConfiguration() {
        FBNetworkElement fBNetworkElement = this.newElement;
        if (fBNetworkElement instanceof Demultiplexer) {
            Demultiplexer demux = (Demultiplexer)fBNetworkElement;
            return demux.isIsConfigured() || this.newVisibleChildren != null;
        }
        return false;
    }

    public StructManipulator getNewMux() {
        return (StructManipulator)this.newElement;
    }

    public StructManipulator getOldMux() {
        return (StructManipulator)this.oldElement;
    }

    private DataType getDataTypeFromTypeEntry() {
        StructuredType structuredType;
        if (this.newStructTypeEntry == null) {
            return IecTypes.GenericTypes.ANY_STRUCT;
        }
        LibraryElement type = this.newStructTypeEntry.getType();
        if (this.reloadDatatype) {
            DataTypeLibrary datatypeLib = this.entry.getTypeLibrary().getDataTypeLibrary();
            DataTypeEntry reloadedTypeEntry = datatypeLib.getDerivedTypeEntry(this.newStructTypeEntry.getFullTypeName());
            if (this.newStructTypeEntry instanceof ErrorDataTypeEntry) {
                if (reloadedTypeEntry != null && reloadedTypeEntry != this.newStructTypeEntry) {
                    type = reloadedTypeEntry.getType();
                }
            } else if (reloadedTypeEntry == null) {
                type = datatypeLib.createErrorMarkerType(this.newStructTypeEntry.getFullTypeName(), MessageFormat.format("Typeentry for StructManipulator `{0}` not available!", this.getOldMux().getName()));
            }
        }
        if (type instanceof DataType) {
            DataType dt = (DataType)type;
            structuredType = dt;
        } else {
            structuredType = IecTypes.GenericTypes.ANY_STRUCT;
        }
        return structuredType;
    }
}

