/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;
import org.eclipse.gef.commands.Command;

public class OrganizeImportsCommand
extends Command
implements ScopedCommand {
    private final LibraryElement libraryElement;
    private EList<Import> oldImports;
    private EList<Import> newImports;

    public OrganizeImportsCommand(LibraryElement libraryElement) {
        this.libraryElement = Objects.requireNonNull(libraryElement);
    }

    public void execute() {
        this.oldImports = ECollections.newBasicEList((Iterable)ImportHelper.getImports((LibraryElement)this.libraryElement));
        try {
            try {
                ImportHelper.organizeImports((LibraryElement)this.libraryElement, (Set)VariableOperations.getAllDependencies((EObject)this.libraryElement));
            }
            catch (Exception e) {
                ErrorMessenger.popUpErrorMessage((String)e.getLocalizedMessage());
                this.newImports = ECollections.newBasicEList((Iterable)ImportHelper.getImports((LibraryElement)this.libraryElement));
            }
        }
        finally {
            this.newImports = ECollections.newBasicEList((Iterable)ImportHelper.getImports((LibraryElement)this.libraryElement));
        }
    }

    public void redo() {
        ECollections.setEList((EList)ImportHelper.getMutableImports((LibraryElement)this.libraryElement), this.newImports);
    }

    public void undo() {
        ECollections.setEList((EList)ImportHelper.getMutableImports((LibraryElement)this.libraryElement), this.oldImports);
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.libraryElement);
    }
}

