/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.datatype.helper;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.MemberVarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.Value;

public final class InternalAttributeDeclarations {
    private static final String ATTRIBUTE_DECLARATION_LIB_URI = "internal_attribute_declarations.lib";
    private static final Resource ATTRIBUTE_DECLARATION_RES = new ResourceImpl(URI.createURI((String)"internal_attribute_declarations.lib"));
    public static final AttributeDeclaration VAR_CONFIG = InternalAttributeDeclarations.createAttributeDeclaration("VarConfig", IecTypes.ElementaryTypes.BOOL);
    public static final AttributeDeclaration VISIBLE = InternalAttributeDeclarations.createAttributeDeclaration("Visible", IecTypes.ElementaryTypes.BOOL);
    public static final AttributeDeclaration INOUT_VISIBLE_OUT = InternalAttributeDeclarations.createAttributeDeclaration("VisibleOutSide", IecTypes.ElementaryTypes.BOOL);
    public static final AttributeDeclaration UNFOLDED = InternalAttributeDeclarations.createAttributeDeclaration("Unfolded", IecTypes.ElementaryTypes.BOOL);
    public static final AttributeDeclaration RETAIN = InternalAttributeDeclarations.createAttributeDeclaration("Retain", IecTypes.ElementaryTypes.USINT);
    public static final AttributeDeclaration TARGET = InternalAttributeDeclarations.createTargetAttributeDeclaration();
    private static final List<AttributeDeclaration> allAttributes = List.of(VAR_CONFIG, VISIBLE, INOUT_VISIBLE_OUT, UNFOLDED, RETAIN, TARGET);

    private static boolean addAttribbuteDeclarationToResource(AttributeDeclaration decl) {
        return ATTRIBUTE_DECLARATION_RES.getContents().add((Object)decl);
    }

    private static AttributeDeclaration createAttributeDeclaration(String name, DataType type) {
        AttributeDeclaration declaration = LibraryElementFactory.eINSTANCE.createAttributeDeclaration();
        declaration.setName(name);
        DirectlyDerivedType directlyDerivedType = DataFactory.eINSTANCE.createDirectlyDerivedType();
        directlyDerivedType.setBaseType(type);
        declaration.setType(directlyDerivedType);
        InternalAttributeDeclarations.addAttribbuteDeclarationToResource(declaration);
        return declaration;
    }

    private static AttributeDeclaration createTargetAttributeDeclaration() {
        AttributeDeclaration declaration = LibraryElementFactory.eINSTANCE.createAttributeDeclaration();
        declaration.setName("TARGET");
        StructuredType structType = DataFactory.eINSTANCE.createStructuredType();
        structType.getMemberVariables().add((Object)InternalAttributeDeclarations.createTargetMember(IInterfaceElement.class.getSimpleName()));
        structType.getMemberVariables().add((Object)InternalAttributeDeclarations.createTargetMember(SubApp.class.getSimpleName()));
        structType.getMemberVariables().add((Object)InternalAttributeDeclarations.createTargetMember(FBType.class.getSimpleName()));
        structType.getMemberVariables().add((Object)InternalAttributeDeclarations.createTargetMember(Application.class.getSimpleName()));
        structType.getMemberVariables().add((Object)InternalAttributeDeclarations.createTargetMember(Connection.class.getSimpleName()));
        structType.getMemberVariables().add((Object)InternalAttributeDeclarations.createTargetMember(FB.class.getSimpleName()));
        structType.getMemberVariables().add((Object)InternalAttributeDeclarations.createTargetMember(DataType.class.getSimpleName()));
        declaration.setType(structType);
        InternalAttributeDeclarations.addAttribbuteDeclarationToResource(declaration);
        return declaration;
    }

    private static MemberVarDeclaration createTargetMember(String name) {
        MemberVarDeclaration member = LibraryElementFactory.eINSTANCE.createMemberVarDeclaration();
        member.setName(name);
        member.setType(IecTypes.ElementaryTypes.BOOL);
        Value val = LibraryElementFactory.eINSTANCE.createValue();
        val.setValue("TRUE");
        member.setValue(val);
        return member;
    }

    public static AttributeDeclaration getInternalAttributeByName(String name) {
        return InternalAttributeDeclarations.getAllInternalAttributes().stream().filter(decl -> decl.getName().equals(name)).findFirst().orElse(null);
    }

    public static List<AttributeDeclaration> getAllInternalAttributes() {
        return allAttributes;
    }

    public static boolean isInternalAttribute(AttributeDeclaration declaration) {
        if (declaration == null) {
            return false;
        }
        return InternalAttributeDeclarations.getAllInternalAttributes().contains(declaration);
    }

    public static boolean isInternalAttribute(Attribute attribute) {
        return InternalAttributeDeclarations.getInternalAttributeByName(attribute.getName()) != null;
    }

    private InternalAttributeDeclarations() {
        throw new UnsupportedOperationException();
    }
}

