/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.variable;

import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.model.data.AnyType;
import org.eclipse.fordiac.ide.model.eval.value.AnyValue;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.AbstractVariable;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.value.TypedValue;

public class GenericVariable
extends AbstractVariable<AnyValue> {
    private Variable<AnyValue> variable;

    public GenericVariable(String name, AnyType type) {
        this(name, type, ValueOperations.defaultValue((LibraryElement)type));
    }

    public GenericVariable(String name, AnyType type, String value) {
        super(name, (LibraryElement)type);
        this.setValue(value);
    }

    public GenericVariable(String name, AnyType type, Value value) {
        super(name, (LibraryElement)type);
        this.setValue(value);
    }

    @Override
    public void setValue(String value, TypeLibrary typeLibrary) {
        try {
            this.variable.setValue(value, typeLibrary);
        }
        catch (Exception e) {
            super.setValue(value, typeLibrary);
        }
    }

    @Override
    public void setValue(TypedValue value) {
        if (this.variable != null && this.variable.getType().equals(value.type())) {
            try {
                this.variable.setValue(value);
            }
            catch (Exception e) {
                super.setValue(value);
            }
        } else {
            super.setValue(value);
        }
    }

    @Override
    public boolean validateValue(String value, TypeLibrary typeLibrary) {
        return this.variable.validateValue(value, typeLibrary) || super.validateValue(value, typeLibrary);
    }

    @Override
    public void setValue(Value value) {
        Objects.requireNonNull(value);
        if (this.variable != null && this.variable.getType().equals(value.getType())) {
            this.variable.setValue(value);
        } else {
            this.variable = VariableOperations.newVariable(this.getName(), ValueOperations.castValue(value, (LibraryElement)this.getType()));
        }
    }

    public AnyType getType() {
        return (AnyType)super.getType();
    }

    @Override
    public AnyValue getValue() {
        return this.variable.getValue();
    }

    @Override
    public Stream<Variable<?>> getChildren() {
        return this.variable.getChildren();
    }

    public Variable<?> getVariable() {
        return this.variable;
    }
}

