/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bimap;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.bimap.BiMap;
import org.eclipse.collections.api.bimap.MutableBiMap;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.tuple.Pair;

public abstract class AbstractBiMap<K, V>
implements BiMap<K, V> {
    protected abstract MapIterable<K, V> getDelegate();

    protected abstract MapIterable<V, K> getInverse();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map map = (Map)obj;
        return this.getDelegate().equals((Object)map);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    public int size() {
        return this.getDelegate().size();
    }

    public V get(Object key) {
        return (V)this.getDelegate().get(key);
    }

    public V getFirst() {
        return (V)this.getDelegate().getFirst();
    }

    public V getLast() {
        return (V)this.getDelegate().getLast();
    }

    public V getOnly() {
        return (V)this.getDelegate().getOnly();
    }

    public V getIfAbsent(K key, Function0<? extends V> function) {
        return (V)this.getDelegate().getIfAbsent(key, function);
    }

    public V getOrDefault(Object key, V defaultValue) {
        return this.getIfAbsentValue(key, defaultValue);
    }

    public V getIfAbsentValue(K key, V value) {
        return (V)this.getDelegate().getIfAbsentValue(key, value);
    }

    public <P> V getIfAbsentWith(K key, Function<? super P, ? extends V> function, P parameter) {
        return (V)this.getDelegate().getIfAbsentWith(key, function, parameter);
    }

    public <A> A ifPresentApply(K key, Function<? super V, ? extends A> function) {
        return (A)this.getDelegate().ifPresentApply(key, function);
    }

    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public boolean notEmpty() {
        return this.getDelegate().notEmpty();
    }

    public boolean contains(Object object) {
        return this.getInverse().containsKey(object);
    }

    public boolean containsKey(Object key) {
        return this.getDelegate().containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.getInverse().containsKey(value);
    }

    public boolean containsAllIterable(Iterable<?> source) {
        return this.getInverse().keysView().containsAllIterable(source);
    }

    public boolean containsAll(Collection<?> source) {
        return this.getInverse().keysView().containsAll(source);
    }

    public boolean containsAllArguments(Object ... elements) {
        return this.getInverse().keysView().containsAllArguments(elements);
    }

    public RichIterable<K> keysView() {
        return this.getDelegate().keysView();
    }

    public RichIterable<V> valuesView() {
        return this.getDelegate().valuesView();
    }

    public RichIterable<Pair<K, V>> keyValuesView() {
        return this.getDelegate().keyValuesView();
    }

    public <R extends Collection<V>> R into(R target) {
        return (R)this.getDelegate().into(target);
    }

    public MutableList<V> toList() {
        return this.getDelegate().toList();
    }

    public MutableList<V> toSortedList() {
        return this.getDelegate().toSortedList();
    }

    public MutableList<V> toSortedList(Comparator<? super V> comparator) {
        return this.getDelegate().toSortedList(comparator);
    }

    public MutableSet<V> toSet() {
        return this.getDelegate().toSet();
    }

    public MutableSortedSet<V> toSortedSet() {
        return this.getDelegate().toSortedSet();
    }

    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator) {
        return this.getDelegate().toSortedSet(comparator);
    }

    public MutableBag<V> toBag() {
        return this.getDelegate().toBag();
    }

    public MutableSortedBag<V> toSortedBag() {
        return this.getDelegate().toSortedBag();
    }

    public MutableSortedBag<V> toSortedBag(Comparator<? super V> comparator) {
        return this.getDelegate().toSortedBag(comparator);
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.getDelegate().toMap(keyFunction, valueFunction);
    }

    public <NK, NV, R extends Map<NK, NV>> R toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction, R target) {
        return (R)this.getDelegate().toMap(keyFunction, valueFunction, target);
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.getDelegate().toSortedMap(keyFunction, valueFunction);
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.getDelegate().toSortedMap(comparator, keyFunction, valueFunction);
    }

    public <NK, NV> MutableBiMap<NK, NV> toBiMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.getDelegate().toBiMap(keyFunction, valueFunction);
    }

    public Object[] toArray() {
        return this.getDelegate().toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.getDelegate().toArray((Object[])a);
    }

    public String toString() {
        return this.getDelegate().toString();
    }

    public String makeString() {
        return this.getDelegate().makeString();
    }

    public String makeString(String separator) {
        return this.getDelegate().makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.getDelegate().makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.getDelegate().appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.getDelegate().appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.getDelegate().appendString(appendable, start, separator, end);
    }

    public void forEachValue(Procedure<? super V> procedure) {
        this.getDelegate().forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure) {
        this.getDelegate().forEachKey(procedure);
    }

    public void forEachKeyValue(Procedure2<? super K, ? super V> procedure) {
        this.getDelegate().forEachKeyValue(procedure);
    }

    public void each(Procedure<? super V> procedure) {
        this.getDelegate().forEachValue(procedure);
    }

    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        this.getDelegate().forEachWithIndex(objectIntProcedure);
    }

    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        this.getDelegate().forEachWith(procedure, parameter);
    }

    public LazyIterable<V> asLazy() {
        return this.getDelegate().asLazy();
    }

    public int count(Predicate<? super V> predicate) {
        return this.getDelegate().count(predicate);
    }

    public <P> int countWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.getDelegate().countWith(predicate, parameter);
    }

    public V min(Comparator<? super V> comparator) {
        return (V)this.getDelegate().min(comparator);
    }

    public V min() {
        return (V)this.getDelegate().min();
    }

    public <VV extends Comparable<? super VV>> V minBy(Function<? super V, ? extends VV> function) {
        return (V)this.getDelegate().minBy(function);
    }

    public V max(Comparator<? super V> comparator) {
        return (V)this.getDelegate().max(comparator);
    }

    public V max() {
        return (V)this.getDelegate().max();
    }

    public <VV extends Comparable<? super VV>> V maxBy(Function<? super V, ? extends VV> function) {
        return (V)this.getDelegate().maxBy(function);
    }

    public Pair<K, V> detect(Predicate2<? super K, ? super V> predicate) {
        return this.getDelegate().detect(predicate);
    }

    public V detect(Predicate<? super V> predicate) {
        return (V)this.getDelegate().detect(predicate);
    }

    public <P> V detectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return (V)this.getDelegate().detectWith(predicate, parameter);
    }

    public Optional<Pair<K, V>> detectOptional(Predicate2<? super K, ? super V> predicate) {
        return this.getDelegate().detectOptional(predicate);
    }

    public Optional<V> detectOptional(Predicate<? super V> predicate) {
        return this.getDelegate().detectOptional(predicate);
    }

    public <P> Optional<V> detectWithOptional(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.getDelegate().detectWithOptional(predicate, parameter);
    }

    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function) {
        return (V)this.getDelegate().detectIfNone(predicate, function);
    }

    public <P> V detectWithIfNone(Predicate2<? super V, ? super P> predicate, P parameter, Function0<? extends V> function) {
        return (V)this.getDelegate().detectWithIfNone(predicate, parameter, function);
    }

    public boolean anySatisfy(Predicate<? super V> predicate) {
        return this.getDelegate().anySatisfy(predicate);
    }

    public <P> boolean anySatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.getDelegate().anySatisfyWith(predicate, parameter);
    }

    public boolean allSatisfy(Predicate<? super V> predicate) {
        return this.getDelegate().allSatisfy(predicate);
    }

    public <P> boolean allSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.getDelegate().allSatisfyWith(predicate, parameter);
    }

    public boolean noneSatisfy(Predicate<? super V> predicate) {
        return this.getDelegate().noneSatisfy(predicate);
    }

    public <P> boolean noneSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.getDelegate().noneSatisfyWith(predicate, parameter);
    }

    public <VV, R extends Collection<VV>> R collect(Function<? super V, ? extends VV> function, R target) {
        return (R)this.getDelegate().collect(function, target);
    }

    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super V> booleanFunction, R target) {
        return (R)this.getDelegate().collectBoolean(booleanFunction, target);
    }

    public <R extends MutableBooleanCollection> R flatCollectBoolean(Function<? super V, ? extends BooleanIterable> function, R target) {
        return (R)this.getDelegate().flatCollectBoolean(function, target);
    }

    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super V> byteFunction, R target) {
        return (R)this.getDelegate().collectByte(byteFunction, target);
    }

    public <R extends MutableByteCollection> R flatCollectByte(Function<? super V, ? extends ByteIterable> function, R target) {
        return (R)this.getDelegate().flatCollectByte(function, target);
    }

    public <R extends MutableCharCollection> R collectChar(CharFunction<? super V> charFunction, R target) {
        return (R)this.getDelegate().collectChar(charFunction, target);
    }

    public <R extends MutableCharCollection> R flatCollectChar(Function<? super V, ? extends CharIterable> function, R target) {
        return (R)this.getDelegate().flatCollectChar(function, target);
    }

    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super V> doubleFunction, R target) {
        return (R)this.getDelegate().collectDouble(doubleFunction, target);
    }

    public <R extends MutableDoubleCollection> R flatCollectDouble(Function<? super V, ? extends DoubleIterable> function, R target) {
        return (R)this.getDelegate().flatCollectDouble(function, target);
    }

    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super V> floatFunction, R target) {
        return (R)this.getDelegate().collectFloat(floatFunction, target);
    }

    public <R extends MutableFloatCollection> R flatCollectFloat(Function<? super V, ? extends FloatIterable> function, R target) {
        return (R)this.getDelegate().flatCollectFloat(function, target);
    }

    public <R extends MutableIntCollection> R collectInt(IntFunction<? super V> intFunction, R target) {
        return (R)this.getDelegate().collectInt(intFunction, target);
    }

    public <R extends MutableIntCollection> R flatCollectInt(Function<? super V, ? extends IntIterable> function, R target) {
        return (R)this.getDelegate().flatCollectInt(function, target);
    }

    public <R extends MutableLongCollection> R collectLong(LongFunction<? super V> longFunction, R target) {
        return (R)this.getDelegate().collectLong(longFunction, target);
    }

    public <R extends MutableLongCollection> R flatCollectLong(Function<? super V, ? extends LongIterable> function, R target) {
        return (R)this.getDelegate().flatCollectLong(function, target);
    }

    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super V> shortFunction, R target) {
        return (R)this.getDelegate().collectShort(shortFunction, target);
    }

    public <R extends MutableShortCollection> R flatCollectShort(Function<? super V, ? extends ShortIterable> function, R target) {
        return (R)this.getDelegate().flatCollectShort(function, target);
    }

    public <P, VV, R extends Collection<VV>> R collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter, R targetCollection) {
        return (R)this.getDelegate().collectWith(function, parameter, targetCollection);
    }

    public <VV, R extends Collection<VV>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function, R target) {
        return (R)this.getDelegate().collectIf(predicate, function, target);
    }

    public <VV, R extends Collection<VV>> R flatCollect(Function<? super V, ? extends Iterable<VV>> function, R target) {
        return (R)this.getDelegate().flatCollect(function, target);
    }

    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target) {
        return (R)this.getDelegate().select(predicate, target);
    }

    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        return (R)this.getDelegate().selectWith(predicate, parameter, targetCollection);
    }

    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target) {
        return (R)this.getDelegate().reject(predicate, target);
    }

    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        return (R)this.getDelegate().rejectWith(predicate, parameter, targetCollection);
    }

    @Deprecated
    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target) {
        return (R)this.getDelegate().zip(that, target);
    }

    @Deprecated
    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target) {
        return (R)this.getDelegate().zipWithIndex(target);
    }

    public RichIterable<RichIterable<V>> chunk(int size) {
        return this.getDelegate().chunk(size);
    }

    public <VV, R extends MutableMultimap<VV, V>> R groupBy(Function<? super V, ? extends VV> function, R target) {
        return (R)this.getDelegate().groupBy(function, target);
    }

    public <VV, R extends MutableMultimap<VV, V>> R groupByEach(Function<? super V, ? extends Iterable<VV>> function, R target) {
        return (R)this.getDelegate().groupByEach(function, target);
    }

    public <VV, R extends MutableMapIterable<VV, V>> R groupByUniqueKey(Function<? super V, ? extends VV> function, R target) {
        return (R)this.getDelegate().groupByUniqueKey(function, target);
    }

    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function) {
        return (IV)this.getDelegate().injectInto(injectedValue, function);
    }

    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function) {
        return this.getDelegate().injectIntoInt(injectedValue, function);
    }

    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function) {
        return this.getDelegate().injectIntoLong(injectedValue, function);
    }

    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function) {
        return this.getDelegate().injectIntoFloat(injectedValue, function);
    }

    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function) {
        return this.getDelegate().injectIntoDouble(injectedValue, function);
    }

    public long sumOfInt(IntFunction<? super V> function) {
        return this.getDelegate().sumOfInt(function);
    }

    public double sumOfFloat(FloatFunction<? super V> function) {
        return this.getDelegate().sumOfFloat(function);
    }

    public long sumOfLong(LongFunction<? super V> function) {
        return this.getDelegate().sumOfLong(function);
    }

    public double sumOfDouble(DoubleFunction<? super V> function) {
        return this.getDelegate().sumOfDouble(function);
    }
}

