/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.local;

import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.Platform;

public class Convert {
    private static String defaultEncoding = Platform.getSystemCharset().name();
    public static final String WIN32_RAW_PATH_PREFIX = "\\\\?\\";
    public static final String WIN32_UNC_RAW_PATH_PREFIX = "\\\\?\\UNC";

    public static String fromPlatformBytes(byte[] source, int length) {
        if (defaultEncoding == null) {
            return new String(source, 0, length);
        }
        try {
            return new String(source, 0, length, defaultEncoding);
        }
        catch (UnsupportedEncodingException e) {
            defaultEncoding = null;
            return new String(source, 0, length);
        }
    }

    public static byte[] toPlatformBytes(String target) {
        if (defaultEncoding == null) {
            return target.getBytes();
        }
        try {
            return target.getBytes(defaultEncoding);
        }
        catch (UnsupportedEncodingException e) {
            defaultEncoding = null;
            return target.getBytes();
        }
    }
}

