/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.watch;

import java.util.List;
import java.util.SequencedSet;
import org.eclipse.debug.core.DebugException;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugDevice;
import org.eclipse.fordiac.ide.deployment.debug.Messages;
import org.eclipse.fordiac.ide.deployment.debug.watch.AbstractVariableWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchData;
import org.eclipse.fordiac.ide.deployment.debug.watch.IVariableWatch;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;

public abstract class AbstractVirtualWatch
extends AbstractVariableWatch {
    private final SequencedSet<SubWatch> watches;

    protected AbstractVirtualWatch(Variable<?> variable, ITypedElement element, SequencedSet<SubWatch> watches, DeploymentDebugDevice debugTarget) {
        super(variable, element, debugTarget);
        this.watches = watches;
    }

    @Override
    public void addWatch() throws DebugException {
        for (SubWatch watch : this.watches) {
            watch.watch().addWatch();
        }
    }

    @Override
    public void removeWatch() throws DebugException {
        for (SubWatch watch : this.watches) {
            watch.watch().removeWatch();
        }
    }

    @Override
    public void updateValue(DeploymentDebugWatchData watchData) {
        if (this.watches.isEmpty()) {
            this.setError(Messages.AbstractVariableWatch_NoValue);
            return;
        }
        for (SubWatch watch : this.watches) {
            watch.watch().updateValue(watchData);
            if (!watch.watch().hasError()) continue;
            this.setError(Messages.AbstractVariableWatch_NoValue);
            return;
        }
        this.updateValue(this.watches.stream().map(SubWatch::value).toList());
    }

    protected abstract void updateValue(List<Value> var1);

    public SequencedSet<SubWatch> getWatches() {
        return this.watches;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public record SubWatch(IVariableWatch watch, boolean negate) {
        public Value value() {
            return this.convertValue(this.watch.getInternalValue());
        }

        public Value convertValue(Value value) {
            if (this.negate) {
                return ValueOperations.bitwiseNot((Value)value);
            }
            return value;
        }
    }
}

