/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.tests;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.acute.AcutePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.osgi.framework.Bundle;

public class AbstractAcuteTest {
    private Map<String, IProject> provisionedProjects;

    @Before
    public void setUp() throws Exception {
        PlatformUI.getWorkbench().getIntroManager().closeIntro(PlatformUI.getWorkbench().getIntroManager().getIntro());
        this.provisionedProjects = new HashMap<String, IProject>();
    }

    protected IProject provisionProject(String projectName) throws IOException, CoreException, InterruptedException {
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.acute.tests"), (IPath)Path.fromPortableString((String)("projects/" + projectName)), Collections.emptyMap());
        File folder = new File((url = FileLocator.toFileURL((URL)url)).getFile());
        if (folder != null && folder.exists()) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(projectName) + "_" + this.getClass().getName() + "_" + System.currentTimeMillis());
            project.create((IProgressMonitor)new NullProgressMonitor());
            this.provisionedProjects.put(projectName, project);
            FileUtils.copyDirectory((File)folder, (File)project.getLocation().toFile());
            ProcessBuilder dotnetRestoreBuilder = new ProcessBuilder(AcutePlugin.getDotnetCommand(), "restore");
            dotnetRestoreBuilder.directory(project.getLocation().toFile());
            Assert.assertEquals((long)0L, (long)dotnetRestoreBuilder.start().waitFor());
            project.open((IProgressMonitor)new NullProgressMonitor());
            project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            return project;
        }
        return null;
    }

    @After
    public void tearDown() throws CoreException {
        this.provisionedProjects.values().forEach(project -> {
            try {
                project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        });
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
    }

    protected IProject getProject(String projectPrefix) throws Exception {
        if (!this.provisionedProjects.containsKey(projectPrefix)) {
            this.provisionProject(projectPrefix);
        }
        return this.provisionedProjects.get(projectPrefix);
    }

    protected static ITextViewer getTextViewer(IEditorPart part) throws InvocationTargetException {
        try {
            if (part instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)part;
                Method getSourceViewerMethod = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
                getSourceViewerMethod.setAccessible(true);
                return (ITextViewer)getSourceViewerMethod.invoke((Object)textEditor, new Object[0]);
            }
            Assert.fail((String)"Unable to open editor");
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new InvocationTargetException(e);
        }
    }
}

