/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcherExtension;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CharacterPair;
import org.eclipse.tm4e.ui.utils.ContentTypeHelper;
import org.eclipse.tm4e.ui.utils.ContentTypeInfo;

public class LanguageConfigurationCharacterPairMatcher
implements ICharacterPairMatcher,
ICharacterPairMatcherExtension {
    private DefaultCharacterPairMatcher matcher;
    private IDocument document;

    public IRegion match(IDocument document, int offset) {
        DefaultCharacterPairMatcher matcher = this.getMatcher(document);
        return matcher != null ? matcher.match(document, offset) : null;
    }

    public IRegion match(IDocument document, int offset, int length) {
        DefaultCharacterPairMatcher matcher = this.getMatcher(document);
        return matcher != null ? matcher.match(document, offset, length) : null;
    }

    public int getAnchor() {
        return this.matcher != null ? this.matcher.getAnchor() : -1;
    }

    public IRegion findEnclosingPeerCharacters(IDocument document, int offset, int length) {
        DefaultCharacterPairMatcher matcher = this.getMatcher(document);
        return matcher != null ? matcher.findEnclosingPeerCharacters(document, offset, length) : null;
    }

    public boolean isMatchedChar(char ch) {
        DefaultCharacterPairMatcher matcher = this.getMatcher(this.document);
        return matcher != null ? matcher.isMatchedChar(ch) : false;
    }

    public boolean isMatchedChar(char ch, IDocument document, int offset) {
        DefaultCharacterPairMatcher matcher = this.getMatcher(document);
        return matcher != null ? matcher.isMatchedChar(ch, document, offset) : false;
    }

    public boolean isRecomputationOfEnclosingPairRequired(IDocument document, IRegion currentSelection, IRegion previousSelection) {
        DefaultCharacterPairMatcher matcher = this.getMatcher(document);
        return matcher != null ? matcher.isRecomputationOfEnclosingPairRequired(document, currentSelection, previousSelection) : false;
    }

    public void dispose() {
        if (this.matcher != null) {
            this.matcher.dispose();
        }
        this.matcher = null;
    }

    public void clear() {
        if (this.matcher != null) {
            this.matcher.clear();
        }
    }

    private DefaultCharacterPairMatcher getMatcher(IDocument document) {
        if (!document.equals(this.document)) {
            this.matcher = null;
        }
        if (this.matcher == null) {
            StringBuilder chars = new StringBuilder();
            IContentType[] contentTypes = this.findContentTypes(document);
            if (contentTypes != null) {
                LanguageConfigurationRegistryManager registry = LanguageConfigurationRegistryManager.getInstance();
                IContentType[] iContentTypeArray = contentTypes;
                int n = contentTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IContentType contentType = iContentTypeArray[n2];
                    if (registry.shouldSurroundingPairs(document, -1, contentType)) {
                        List<CharacterPair> surroundingPairs = registry.getSurroundingPairs(contentType);
                        for (CharacterPair surroundingPair : surroundingPairs) {
                            chars.append((String)surroundingPair.getKey());
                            chars.append((String)surroundingPair.getValue());
                        }
                    }
                    ++n2;
                }
            }
            this.matcher = new DefaultCharacterPairMatcher(chars.toString().toCharArray());
        }
        return this.matcher;
    }

    private IContentType[] findContentTypes(IDocument document) {
        try {
            ContentTypeInfo info = ContentTypeHelper.findContentTypes((IDocument)document);
            this.document = document;
            return info.getContentTypes();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }
}

