/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.function.tests;

import junit.textui.TestRunner;
import org.metaabm.IID;
import org.metaabm.IValue;
import org.metaabm.MetaABMFactory;
import org.metaabm.SAttribute;
import org.metaabm.SAttributeArray;
import org.metaabm.SAttributeType;
import org.metaabm.function.FArgumentArrayPrototype;
import org.metaabm.function.FArgumentPrototype;
import org.metaabm.function.FOperator;
import org.metaabm.function.MetaABMFunctionFactory;
import org.metaabm.function.tests.FFunctionTest;

public class FOperatorTest
extends FFunctionTest {
    public static void main(String[] args) {
        TestRunner.run(FOperatorTest.class);
    }

    public FOperatorTest(String name) {
        super(name);
    }

    protected FOperator getFixture() {
        return (FOperator)this.fixture;
    }

    public void testAccepts() {
        FArgumentPrototype argF = MetaABMFunctionFactory.eINSTANCE.createFArgumentPrototype();
        argF.setSType(SAttributeType.REAL_LITERAL);
        this.getFixture().getInputPrototypes().add((Object)argF);
        FArgumentPrototype argF1 = MetaABMFunctionFactory.eINSTANCE.createFArgumentPrototype();
        argF1.setSType(SAttributeType.REAL_LITERAL);
        this.getFixture().getInputPrototypes().add((Object)argF1);
        SAttribute testInput = MetaABMFactory.eINSTANCE.createSAttribute();
        testInput.setSType(SAttributeType.REAL_LITERAL);
        FOperatorTest.assertTrue((boolean)this.getFixture().accepts((IValue)testInput, 0));
        FOperatorTest.assertTrue((boolean)this.getFixture().accepts((IValue)testInput, 1));
        FOperatorTest.assertFalse((boolean)this.getFixture().accepts((IValue)testInput, 2));
        testInput.setSType(SAttributeType.INTEGER_LITERAL);
        FOperatorTest.assertTrue((boolean)this.getFixture().accepts((IValue)testInput, 0));
        testInput.setSType(SAttributeType.INTEGER_LITERAL);
        FOperatorTest.assertTrue((boolean)this.getFixture().accepts((IValue)testInput, 0));
        testInput.setSType(SAttributeType.NUMERIC_LITERAL);
        FOperatorTest.assertTrue((boolean)this.getFixture().accepts((IValue)testInput, 0));
        testInput.setSType(SAttributeType.BOOLEAN_LITERAL);
        FOperatorTest.assertFalse((boolean)this.getFixture().accepts((IValue)testInput, 0));
        argF.setSType(SAttributeType.UNDEFINED_LITERAL);
        testInput.setSType(SAttributeType.BOOLEAN_LITERAL);
        FOperatorTest.assertTrue((boolean)this.getFixture().accepts((IValue)testInput, 0));
        testInput.setSType(SAttributeType.REAL_LITERAL);
        FOperatorTest.assertTrue((boolean)this.getFixture().accepts((IValue)testInput, 0));
        testInput.setSType(SAttributeType.INTEGER_LITERAL);
        FOperatorTest.assertTrue((boolean)this.getFixture().accepts((IValue)testInput, 0));
        testInput.setSType(SAttributeType.NUMERIC_LITERAL);
        FOperatorTest.assertTrue((boolean)this.getFixture().accepts((IValue)testInput, 0));
        testInput.setSType(SAttributeType.SYMBOL_LITERAL);
        FOperatorTest.assertTrue((boolean)this.getFixture().accepts((IValue)testInput, 0));
        this.getFixture().getInputPrototypes().remove((Object)argF);
        FArgumentArrayPrototype argAr = MetaABMFunctionFactory.eINSTANCE.createFArgumentArrayPrototype();
        argAr.setSType(SAttributeType.REAL_LITERAL);
        argAr.setSize(2);
        this.getFixture().getInputPrototypes().add(0, (Object)argAr);
        SAttributeArray testArrayInput = MetaABMFactory.eINSTANCE.createSAttributeArray();
        testArrayInput.setSType(SAttributeType.REAL_LITERAL);
        testArrayInput.setSize(2);
        FOperatorTest.assertTrue((boolean)this.getFixture().accepts((IValue)testArrayInput, 0));
        FOperatorTest.assertFalse((boolean)this.getFixture().accepts((IValue)testArrayInput, 1));
        testArrayInput.setSize(3);
        FOperatorTest.assertFalse((boolean)this.getFixture().accepts((IValue)testArrayInput, 0));
    }

    protected void setUp() throws Exception {
        if (this.getFixture() == null) {
            this.setFixture((IID)MetaABMFunctionFactory.eINSTANCE.createFOperator());
        }
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.setFixture(null);
    }

    public void testGetArity() {
        FOperatorTest.assertEquals((int)this.getFixture().getArity(), (int)0);
        FArgumentPrototype argF = MetaABMFunctionFactory.eINSTANCE.createFArgumentPrototype();
        argF.setSType(SAttributeType.REAL_LITERAL);
        this.getFixture().getInputPrototypes().add((Object)argF);
        FOperatorTest.assertEquals((int)this.getFixture().getArity(), (int)1);
        FArgumentPrototype argF1 = MetaABMFunctionFactory.eINSTANCE.createFArgumentPrototype();
        argF1.setSType(SAttributeType.REAL_LITERAL);
        this.getFixture().getInputPrototypes().add((Object)argF1);
        FOperatorTest.assertEquals((int)this.getFixture().getArity(), (int)2);
    }
}

