/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf.tree;

import java.util.List;
import org.eclipse.amp.agf.GenericGraphicsProvider;
import org.eclipse.amp.agf.IGraphicsAdapter;
import org.eclipse.amp.agf.tree.AgentTreePart;
import org.eclipse.amp.axf.core.ICompositionProvider;
import org.eclipse.amp.axf.space.IGraphProvider;
import org.eclipse.amp.axf.space.ILocation2D;
import org.eclipse.amp.axf.space.ILocationProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Image;

public class ScapeTreePart
extends AgentTreePart {
    boolean updating;
    boolean firstRefresh = true;
    ILocationProvider locationProvider;
    ICompositionProvider compositionProvider;
    IGraphProvider graphProvider;

    public ScapeTreePart(ICompositionProvider compositionProvider, ILocationProvider locationProvider, IGraphProvider graphProvider, IGraphicsAdapter graphicsAdapter) {
        super(graphicsAdapter);
        this.locationProvider = locationProvider;
        this.compositionProvider = compositionProvider;
        this.graphProvider = graphProvider;
    }

    public void refresh() {
        super.refresh();
        if (this.compositionProvider.isMutable(this.getModel())) {
            for (Object child : this.getChildren()) {
                ((EditPart)child).refresh();
            }
            this.firstRefresh = false;
        }
    }

    @Override
    protected Image getImage() {
        if (this.compositionProvider.isChildrenComposition(this.getModel())) {
            return GenericGraphicsProvider.SCAPE_IMAGE;
        }
        if (this.graphProvider.isGraph(this.getModel())) {
            return GenericGraphicsProvider.GRAPH_IMAGE;
        }
        if (this.locationProvider.getExtent(this.getModel()) instanceof ILocation2D) {
            return GenericGraphicsProvider.GRID_IMAGE;
        }
        return GenericGraphicsProvider.LIST_IMAGE;
    }

    protected List getModelChildren() {
        List use = this.compositionProvider.getList(this.getModel());
        return use;
    }
}

