/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.ide;

import java.util.ArrayList;
import org.ascape.AscapeRuntimePlugin;
import org.ascape.model.Agent;
import org.ascape.model.Scape;
import org.ascape.model.event.ControlEvent;
import org.ascape.model.event.ScapeEvent;
import org.ascape.model.event.ScapeListener;
import org.ascape.model.rule.PropogateScapeOnly;
import org.ascape.model.rule.Rule;
import org.ascape.runtime.NonGraphicRunner;
import org.ascape.view.nonvis.IMessageStream;
import org.eclipse.amp.axf.core.EngineControl;
import org.eclipse.amp.axf.core.EngineStateAdapter;
import org.eclipse.amp.axf.core.IEngine;
import org.eclipse.amp.axf.core.IEngineObserver;
import org.eclipse.amp.axf.core.ILifeCycleListener;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.ide.ModelViewManager;
import org.eclipse.amp.axf.ide.view.DelayView;
import org.eclipse.amp.axf.ide.view.RunMonitorView;
import org.eclipse.amp.axf.time.ITimeGranularity;
import org.eclipse.amp.axf.time.TimeGranularity;
import org.eclipse.amp.escape.ascape.wrap.ModelWrapperScapeListener;
import org.eclipse.amp.escape.ascape.wrap.ScapeWrapperModel;
import org.eclipse.amp.escape.ascape.wrap.ScapeWrapperModelListener;
import org.eclipse.amp.escape.ide.EscapeIDEPlugin;
import org.eclipse.amp.escape.ide.LoaderCreationException;
import org.eclipse.amp.escape.ide.MessageAdapter;
import org.eclipse.amp.escape.ide.ProjectLoader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.statushandlers.StatusManager;

public class EclipseEscapeRunner
extends NonGraphicRunner
implements IEngine {
    private static final long serialVersionUID = 1L;
    protected ProjectLoader delegateLoader;
    protected IProgressMonitor modelMonitor;
    private IModel model;
    private IProject project;
    private IStatus finishStatus = Status.OK_STATUS;
    private ITimeGranularity updateGranularity = TimeGranularity.DEFAULT_GRANULARITY;
    public static final long KILL_AFTER_NO_RESPONSE_TIME = 5000L;
    private boolean closeOnStop = false;
    boolean modelShutdown = false;
    private Job escapeRun;
    private ArrayList<IEngineObserver> observers = new ArrayList();
    private EngineStateAdapter engineStateAdapter = new EngineStateAdapter(this.isRunning(), this.isStep(), this.isPaused(), this.getPeriod() == this.getStopPeriod());

    public void open(IResource modelResource, String modelClassName, String modelName) {
        this.open(modelResource, modelClassName, modelName, new String[0]);
    }

    public void open(IResource projectResource, String modelClassName, String modelName, String[] args) {
        this.open(projectResource, modelClassName, modelName, args, true);
    }

    public void open(IResource projectResource, String modelClassName, String modelName, String[] args, boolean block) {
        this.openNotStart(projectResource, modelClassName, modelName, args);
        this.start();
        if (block) {
            while (!this.modelShutdown) {
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void openNotStart(IResource projectResource, String modelClassName, String modelName, String[] args) {
        Scape newAgent;
        this.project = projectResource.getProject();
        EclipseEscapeRunner.setStartOnOpen((boolean)false);
        this.setAutoRestart(false);
        this.addConsole(modelName);
        AscapeRuntimePlugin.getDefault();
        try {
            this.delegateLoader = new ProjectLoader(projectResource.getProject());
        }
        catch (LoaderCreationException e) {
            StatusManager.getManager().handle((IStatus)new Status(2, this.project.getName(), "Couldn't create project classloader; falling back to default loader", (Throwable)e));
        }
        try {
            newAgent = (Scape)this.instanceFromName(modelClassName);
        }
        catch (RuntimeException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, this.project.getName(), "Could not read class: " + modelClassName + ". Please ensure that the class exists in class path.", (Throwable)e), 3);
            this.dispose();
            throw e;
        }
        newAgent.setName(modelName);
        this.setRootScape(newAgent);
        this.model = new ScapeWrapperModel(this.getRootScape());
        ModelViewManager.getInstance().register(this.model, (IEngine)this, (Object)this.getRootScape());
        try {
            this.open(args, true);
        }
        catch (RuntimeException e) {
            this.closeFinally();
            throw e;
        }
        final ArrayList newListeners = new ArrayList();
        this.getRootScape().executeOnRoot((Rule)new PropogateScapeOnly(){
            private static final long serialVersionUID = -6277857634508661314L;

            public void execute(Agent agent) {
                newListeners.addAll(((Scape)agent).getScapeListeners());
                super.execute(agent);
            }
        });
        for (ScapeListener scapeListener : newListeners) {
            if (scapeListener instanceof ModelWrapperScapeListener) continue;
            ScapeWrapperModelListener listenerWrapper = new ScapeWrapperModelListener(this.getRootScape(), scapeListener);
            this.model.addModelListener((ILifeCycleListener)listenerWrapper);
        }
    }

    protected void addConsole(String modelName) {
        MessageConsole eclipseConsole = new MessageConsole("Run " + modelName, null);
        this.getEnvironment().getConsole().setIMessageStream((IMessageStream)new MessageAdapter(eclipseConsole));
        IConsole[] consules = new IConsole[]{eclipseConsole};
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(consules);
        eclipseConsole.activate();
    }

    private void removeModel() {
        if (ModelViewManager.getInstance().getModels().contains(this.model)) {
            ModelViewManager.getInstance().remove(this.model);
        }
        this.modelShutdown = true;
    }

    private void dispose() {
        if (this.delegateLoader != null) {
            this.delegateLoader.restore();
        }
        this.delegateLoader = null;
    }

    public void start() {
        this.escapeRun = new Job("Run " + this.getModel().getName()){

            protected IStatus run(IProgressMonitor runMonitor) {
                try {
                    EclipseEscapeRunner.this.setMonitor(runMonitor);
                    RunMonitorView runMonitorView = new RunMonitorView(runMonitor);
                    EclipseEscapeRunner.this.getModel().addModelListener((ILifeCycleListener)runMonitorView);
                    DelayView delayView = new DelayView();
                    EclipseEscapeRunner.this.getModel().addModelListener((ILifeCycleListener)delayView);
                    try {
                        EclipseEscapeRunner.this.run();
                        if (EclipseEscapeRunner.this.isCloseOnStop()) {
                            EclipseEscapeRunner.this.close();
                        }
                    }
                    catch (RuntimeException e) {
                        EclipseEscapeRunner.this.closeFinally();
                        throw e;
                    }
                    EclipseEscapeRunner.this.getModel().removeModelListener((ILifeCycleListener)runMonitorView);
                }
                catch (RuntimeException e) {
                    String message = "An exception occurred: ";
                    if (EclipseEscapeRunner.this.model != null) {
                        message = "An exception occurred when running: " + EclipseEscapeRunner.this.getModel().getName();
                    }
                    StatusManager.getManager().handle((IStatus)new Status(4, EclipseEscapeRunner.this.project.getName(), message, (Throwable)e), 3);
                    if (EclipseEscapeRunner.this.isCloseOnStop()) {
                        EclipseEscapeRunner.this.close();
                    }
                    EclipseEscapeRunner.this.stop();
                }
                return Status.OK_STATUS;
            }

            protected void canceling() {
                EclipseEscapeRunner.this.close();
            }
        };
        this.escapeRun.setPriority(20);
        this.escapeRun.schedule();
    }

    public void close() {
        if (!this.isCloseRequested()) {
            this.setCloseRequested(true);
            Thread closeThread = new Thread((Runnable)((Object)this), "Close Escape Model"){

                @Override
                public void run() {
                    EclipseEscapeRunner.this.setPaused(false);
                    EclipseEscapeRunner.super.close();
                }
            };
            closeThread.start();
        }
        if (this.modelMonitor != null) {
            this.modelMonitor.setTaskName("Waiting for Close...");
        }
        try {
            long elapsed = 0L;
            while (this.isCloseRequested() && this.isThreadAlive() && elapsed <= 5000L) {
                if (elapsed >= 5000L) {
                    if (this.modelMonitor != null) {
                        this.modelMonitor.setTaskName("Forcing Close");
                    }
                    EscapeIDEPlugin.warn("Couldn't close model normally, forcing stop.", null);
                    if (this.escapeRun != null) {
                        this.escapeRun.getThread().stop();
                    }
                    this.closeFinally();
                }
                Thread.sleep(30L);
                elapsed += 30L;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.modelMonitor != null) {
            this.modelMonitor.setTaskName("Closed");
        }
        this.modelShutdown = true;
    }

    public void closeFinally() {
        super.closeFinally();
        this.modelShutdown = true;
        ((ScapeWrapperModel)this.getModel()).setClosed(true);
        this.removeModel();
        this.dispose();
    }

    public IStatus getFinishStatus() {
        return this.finishStatus;
    }

    public void setFinishStatus(IStatus finishStatus) {
        this.finishStatus = finishStatus;
    }

    public IModel getModel() {
        return this.model;
    }

    public int getIterationsPerRedraw() {
        return this.getScape().getIterationsPerRedraw();
    }

    public void respondControl(final ControlEvent control) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EclipseEscapeRunner.super.respondControl(control);
            }
        }).start();
    }

    public void control(EngineControl control) {
        super.respondControl(this.adaptEngineControl(control));
    }

    public void waitForViewsUpdate() {
        super.waitForViewsUpdate();
        this.updateStateAdapter();
    }

    public void setPaused(boolean paused) {
        super.setPaused(paused);
        this.updateStateAdapter();
    }

    public void setStep(boolean step) {
        super.setStep(step);
        this.updateStateAdapter();
    }

    public void setRunning(boolean running) {
        super.setRunning(running);
        this.updateStateAdapter();
    }

    private void updateStateAdapter() {
        if (this.engineStateAdapter.update(this.isRunning(), this.isStep(), this.isPaused(), this.getPeriod() == this.getStopPeriod())) {
            for (IEngineObserver observer : this.observers) {
                observer.engineStateChanged((IEngine)this, this.engineStateAdapter.getState());
            }
        }
    }

    public void addEngineObserver(IEngineObserver observer) {
        if (!this.observers.contains(observer)) {
            this.observers.add(observer);
        }
    }

    public void removeEngineObserver(IEngineObserver observer) {
        if (this.observers.contains(observer)) {
            this.observers.remove(observer);
        }
    }

    private ControlEvent adaptEngineControl(EngineControl control) {
        int id = 0;
        switch (control) {
            case OPEN: {
                id = -6;
                break;
            }
            case START: {
                id = 2;
                break;
            }
            case RESTART: {
                id = 5;
                break;
            }
            case STEP: {
                id = 4;
                break;
            }
            case PAUSE: {
                id = -1;
                break;
            }
            case RESUME: {
                id = -2;
                break;
            }
            case STOP: {
                id = 3;
                break;
            }
            case CLOSE: {
                id = -5;
                break;
            }
            case SAVE: {
                id = -4;
                break;
            }
            default: {
                throw new RuntimeException("Couldn't convert control: " + control);
            }
        }
        return new ControlEvent((Object)this.getScape(), id);
    }

    public void notify(ScapeEvent event, ScapeListener listener) {
        listener.scapeNotification(event);
    }

    public void setIterationsPerRedraw(int iterations) {
        this.getScape().setIterationsPerRedraw(iterations);
    }

    public Scape getScape() {
        return this.getRootScape();
    }

    public IProgressMonitor getMonitor() {
        return this.modelMonitor;
    }

    public void setMonitor(IProgressMonitor modelMonitor) {
        this.modelMonitor = modelMonitor;
    }

    public void observationComplete(ILifeCycleListener observer) {
    }

    public ITimeGranularity getUpdateGranularity() {
        return this.updateGranularity;
    }

    public void setUpdateGranularity(ITimeGranularity granularity) {
        this.updateGranularity = granularity;
    }

    public IProject getExecutingProject() {
        return this.project;
    }

    public boolean isCloseOnStop() {
        return this.closeOnStop;
    }

    public void setCloseOnStop(boolean closeOnStop) {
        this.closeOnStop = closeOnStop;
    }

    public boolean isThreadAlive() {
        return this.getModelThread() != null && this.getModelThread().isAlive();
    }

    public Job getEscapeRun() {
        return this.escapeRun;
    }
}

