/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.ui.ElementQueryDescriptor;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.QueryableArtifactRepositoryManager;
import org.eclipse.equinox.internal.p2.ui.QueryableMetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.ui.RepositoryLocationQuery;
import org.eclipse.equinox.internal.p2.ui.model.CategoryElement;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositories;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElement;
import org.eclipse.equinox.internal.p2.ui.model.Updates;
import org.eclipse.equinox.internal.p2.ui.query.ArtifactKeyWrapper;
import org.eclipse.equinox.internal.p2.ui.query.ArtifactRepositoryElementWrapper;
import org.eclipse.equinox.internal.p2.ui.query.AvailableIUWrapper;
import org.eclipse.equinox.internal.p2.ui.query.CategoryElementWrapper;
import org.eclipse.equinox.internal.p2.ui.query.IUViewQueryContext;
import org.eclipse.equinox.internal.p2.ui.query.InstalledIUElementWrapper;
import org.eclipse.equinox.internal.p2.ui.query.MetadataRepositoryElementWrapper;
import org.eclipse.equinox.internal.p2.ui.query.ProfileElementWrapper;
import org.eclipse.equinox.internal.p2.ui.query.QueryableUpdates;
import org.eclipse.equinox.internal.p2.ui.query.RequiredIUsQuery;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IExpressionFactory;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryProvider {
    private ProvisioningUI ui;
    public static final int METADATA_REPOS = 1;
    public static final int ARTIFACT_REPOS = 2;
    public static final int PROFILES = 3;
    public static final int AVAILABLE_IUS = 4;
    public static final int AVAILABLE_UPDATES = 5;
    public static final int INSTALLED_IUS = 6;
    public static final int AVAILABLE_ARTIFACTS = 7;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public QueryProvider(ProvisioningUI ui) {
        this.ui = ui;
    }

    private static Map<String, String> getEnvFromProfile(IProfile profile) {
        String environments = profile.getProperty("org.eclipse.equinox.p2.environments");
        if (environments == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(environments, ",");
        while (tokenizer.hasMoreElements()) {
            String entry = tokenizer.nextToken();
            int i = entry.indexOf(61);
            String key = entry.substring(0, i).trim();
            String value = entry.substring(i + 1).trim();
            result.put(key, value);
        }
        return result;
    }

    private IQuery<IInstallableUnit> createEnvironmentFilterQuery(IUViewQueryContext context, IProfile profile, IQuery<IInstallableUnit> query) {
        if (!context.getFilterOnEnv()) {
            return query;
        }
        Map<String, String> environment = QueryProvider.getEnvFromProfile(profile);
        if (environment == null) {
            return query;
        }
        IInstallableUnit envIU = InstallableUnit.contextIU(environment);
        IQuery filterQuery = QueryUtil.createMatchQuery((String)"filter == null || $0 ~= filter", (Object[])new Object[]{envIU});
        return QueryUtil.createCompoundQuery(query, (IQuery)filterQuery, (boolean)true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ElementQueryDescriptor getQueryDescriptor(QueriedElement element) {
        Policy policy = this.ui.getPolicy();
        IQueryable<URI> queryable = element.getQueryable();
        int queryType = element.getQueryType();
        IUViewQueryContext context = element.getQueryContext();
        if (context == null) {
            context = ProvUI.getQueryContext(policy);
        }
        switch (queryType) {
            case 2: {
                queryable = new QueryableArtifactRepositoryManager(this.ui, false).locationsQueriable();
                return new ElementQueryDescriptor(queryable, (IQuery<?>)new RepositoryLocationQuery(), (Collector<?>)new Collector(), new ArtifactRepositoryElementWrapper(null, (Object)element));
            }
            case 4: {
                IQuery memberOfCategoryQuery;
                boolean drillDownTheChildren;
                boolean showLatest = context.getShowLatestVersionsOnly();
                boolean hideInstalled = context.getHideAlreadyInstalled();
                IProfile targetProfile = null;
                String profileId = context.getInstalledProfileId();
                if (profileId != null) {
                    targetProfile = ProvUI.getProfileRegistry(this.ui.getSession()).getProfile(profileId);
                }
                IQuery topLevelQuery = policy.getVisibleAvailableIUQuery();
                IQuery<IInstallableUnit> categoryQuery = QueryUtil.createIUCategoryQuery();
                topLevelQuery = this.createEnvironmentFilterQuery(context, targetProfile, topLevelQuery);
                categoryQuery = this.createEnvironmentFilterQuery(context, targetProfile, categoryQuery);
                if (element instanceof MetadataRepositories || element instanceof MetadataRepositoryElement) {
                    if (context.getViewType() != 3) {
                        if (context.getUseCategories()) return new ElementQueryDescriptor(queryable, categoryQuery, new Collector(), new CategoryElementWrapper(queryable, element));
                    }
                    AvailableIUWrapper wrapper = new AvailableIUWrapper(queryable, element, false, context.getShowAvailableChildren());
                    if (showLatest) {
                        topLevelQuery = QueryUtil.createLatestQuery(topLevelQuery);
                    }
                    if (targetProfile == null) return new ElementQueryDescriptor(queryable, topLevelQuery, new Collector(), wrapper);
                    wrapper.markInstalledIUs(targetProfile, hideInstalled);
                    return new ElementQueryDescriptor(queryable, topLevelQuery, new Collector(), wrapper);
                }
                if (!(element instanceof CategoryElement)) {
                    if (!(element instanceof IIUElement)) return null;
                    if (!((IIUElement)((Object)element)).shouldShowChildren()) return null;
                }
                boolean bl = drillDownTheChildren = element instanceof CategoryElement ? context.getShowAvailableChildren() : true;
                if (element instanceof CategoryElement) {
                    IExpression matchesRequirementsExpression = ExpressionUtil.parse((String)"$0.exists(r | this ~= r)");
                    memberOfCategoryQuery = QueryUtil.createMatchQuery((IExpression)matchesRequirementsExpression, (Object[])new Object[]{((CategoryElement)element).getRequirements()});
                } else {
                    memberOfCategoryQuery = QueryUtil.createIUCategoryMemberQuery((IInstallableUnit)((IIUElement)((Object)element)).getIU());
                }
                memberOfCategoryQuery = this.createEnvironmentFilterQuery(context, targetProfile, (IQuery<IInstallableUnit>)memberOfCategoryQuery);
                AvailableIUWrapper availableIUWrapper = new AvailableIUWrapper(queryable, element, true, drillDownTheChildren);
                if (targetProfile != null) {
                    availableIUWrapper.markInstalledIUs(targetProfile, hideInstalled);
                }
                if (element instanceof CategoryElement) {
                    if (!showLatest) return new ElementQueryDescriptor(queryable, memberOfCategoryQuery, new Collector(), availableIUWrapper);
                    memberOfCategoryQuery = QueryUtil.createLatestQuery((IQuery)memberOfCategoryQuery);
                    return new ElementQueryDescriptor(queryable, memberOfCategoryQuery, new Collector(), availableIUWrapper);
                }
                IQuery query = QueryUtil.createCompoundQuery((IQuery)topLevelQuery, (IQuery)new RequiredIUsQuery(((IIUElement)((Object)element)).getIU()), (boolean)true);
                if (!showLatest) return new ElementQueryDescriptor(queryable, query, new Collector(), availableIUWrapper);
                query = QueryUtil.createLatestQuery((IQuery)query);
                return new ElementQueryDescriptor(queryable, query, new Collector(), availableIUWrapper);
            }
            case 5: {
                IQuery iQuery;
                IProfile profile;
                IInstallableUnit[] toUpdate = null;
                if (element instanceof Updates) {
                    profile = ProvUI.getProfileRegistry(this.ui.getSession()).getProfile(((Updates)element).getProfileId());
                    toUpdate = ((Updates)element).getIUs();
                } else {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        Class<?> clazz2;
                        try {
                            clazz2 = Class.forName("org.eclipse.equinox.p2.engine.IProfile");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$0 = clazz2;
                    }
                    profile = (IProfile)ProvUI.getAdapter(element, clazz);
                }
                if (profile == null) {
                    return null;
                }
                if (toUpdate == null) {
                    IQueryResult queryResult = profile.query(policy.getVisibleInstalledIUQuery(), null);
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        Class<?> clazz3;
                        try {
                            clazz3 = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$1 = clazz3;
                    }
                    toUpdate = (IInstallableUnit[])queryResult.toArray((Class)clazz);
                }
                QueryableUpdates updateQueryable = new QueryableUpdates(this.ui, toUpdate);
                if (context.getShowLatestVersionsOnly()) {
                    iQuery = QueryUtil.createLatestIUQuery();
                    return new ElementQueryDescriptor(updateQueryable, iQuery, new Collector());
                }
                iQuery = QueryUtil.createIUAnyQuery();
                return new ElementQueryDescriptor(updateQueryable, iQuery, new Collector());
            }
            case 6: {
                IProfile profile;
                if (element instanceof IIUElement && context.getShowInstallChildren()) {
                    Collection<IRequirement> reqs = ((IIUElement)((Object)element)).getRequirements();
                    IExpression[] requirementExpressions = new IExpression[reqs.size()];
                    int i = 0;
                    Iterator<IRequirement> iterator = reqs.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            IExpressionFactory factory = ExpressionUtil.getFactory();
                            IQuery meetsAnyRequirementQuery = QueryUtil.createMatchQuery((IExpression)factory.or(requirementExpressions), (Object[])new Object[0]);
                            IQuery<IInstallableUnit> visibleAsAvailableQuery = policy.getVisibleAvailableIUQuery();
                            IQuery createCompoundQuery = QueryUtil.createCompoundQuery(visibleAsAvailableQuery, (IQuery)meetsAnyRequirementQuery, (boolean)true);
                            return new ElementQueryDescriptor(queryable, createCompoundQuery, new Collector(), new InstalledIUElementWrapper(queryable, element));
                        }
                        IRequirement req = iterator.next();
                        requirementExpressions[i++] = req.getMatches();
                    }
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz4;
                    try {
                        clazz4 = Class.forName("org.eclipse.equinox.p2.engine.IProfile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz4;
                }
                if ((profile = (IProfile)ProvUI.getAdapter(element, clazz)) != null) return new ElementQueryDescriptor((IQueryable<?>)profile, policy.getVisibleInstalledIUQuery(), (Collector<?>)new Collector(), new InstalledIUElementWrapper((IQueryable<?>)profile, element));
                return null;
            }
            case 1: {
                if (!(element instanceof MetadataRepositories)) return null;
                if (queryable != null) return new ElementQueryDescriptor(element.getQueryable(), (IQuery<?>)new RepositoryLocationQuery(), (Collector<?>)new Collector(), new MetadataRepositoryElementWrapper(null, (Object)element));
                queryable = new QueryableMetadataRepositoryManager(this.ui, ((MetadataRepositories)element).getIncludeDisabledRepositories()).locationsQueriable();
                element.setQueryable(queryable);
                return new ElementQueryDescriptor(element.getQueryable(), (IQuery<?>)new RepositoryLocationQuery(), (Collector<?>)new Collector(), new MetadataRepositoryElementWrapper(null, (Object)element));
            }
            case 3: {
                Class<?> clazz;
                queryable = new IQueryable<URI>(this.ui);
                Class<?> clazz5 = class$0;
                Class<?> clazz6 = clazz5;
                if (clazz5 != null) return new ElementQueryDescriptor(queryable, QueryUtil.createMatchQuery((Class)clazz6, (IExpression)ExpressionUtil.TRUE_EXPRESSION, (Object[])new Object[0]), new Collector(), new ProfileElementWrapper(null, (Object)element));
                try {
                    clazz = Class.forName("org.eclipse.equinox.p2.engine.IProfile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz6 = class$0 = clazz;
                return new ElementQueryDescriptor(queryable, QueryUtil.createMatchQuery((Class)clazz6, (IExpression)ExpressionUtil.TRUE_EXPRESSION, (Object[])new Object[0]), new Collector(), new ProfileElementWrapper(null, (Object)element));
            }
            case 7: {
                if (queryable instanceof IArtifactRepository) return new ElementQueryDescriptor(queryable, (IQuery<?>)ArtifactKeyQuery.ALL_KEYS, (Collector<?>)new Collector(), new ArtifactKeyWrapper((IArtifactRepository)queryable, (Object)element));
                return null;
            }
        }
        return null;
    }
}

