/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend;

import java.io.StringReader;
import java.util.List;
import java.util.Set;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.internal.xtend.xtend.ast.ExtensionFile;
import org.eclipse.internal.xtend.xtend.parser.ParseFacade;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.ExecutionContextImpl;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.expression.TypeSystemImpl;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendFacade {
    private ExecutionContext ctx;

    private XtendFacade(ExecutionContext ctx) {
        this.ctx = ctx;
    }

    public final XtendFacade cloneWithExtensions(String extensionCode) {
        return new XtendFacade(this.ctx.cloneWithResource(this.parse(extensionCode)));
    }

    public final void registerMetaModel(MetaModel mm) {
        if (!(this.ctx instanceof ExecutionContextImpl)) {
            throw new IllegalStateException("Couldn't register Metamodel - ExecutionContextImpl expected.");
        }
        ((ExecutionContextImpl)this.ctx).registerMetaModel(mm);
    }

    private ExtensionFile parse(String extFile) {
        return ParseFacade.file(new StringReader(extFile), "nofile");
    }

    public static final XtendFacade create(String ... extFile) {
        return XtendFacade.create(new ExecutionContextImpl(new TypeSystemImpl()), extFile);
    }

    public static final XtendFacade create(ExecutionContext ctx, final String ... extFile) {
        if (extFile.length > 0) {
            ctx = ctx.cloneWithResource(new Resource(){

                public String getFullyQualifiedName() {
                    return null;
                }

                public void setFullyQualifiedName(String fqn) {
                }

                public String[] getImportedNamespaces() {
                    return null;
                }

                public String[] getImportedExtensions() {
                    return extFile;
                }
            });
        }
        return new XtendFacade(ctx);
    }

    public Object call(String ext, Object ... params) {
        Extension extension;
        if (params == null) {
            params = new Object[1];
        }
        if ((extension = this.ctx.getExtension(ext, params)) == null) {
            throw new IllegalArgumentException("Couldn't find extension " + ext);
        }
        return extension.evaluate(params, this.ctx);
    }

    public Object call(String ext, List<?> params) {
        Object[] paramsArray = new Object[params.size()];
        Extension extension = this.ctx.getExtension(ext, paramsArray = params.toArray(paramsArray));
        if (extension == null) {
            throw new IllegalArgumentException("Couldn't find extension " + ext);
        }
        return extension.evaluate(paramsArray, this.ctx);
    }

    public boolean hasExtension(String ext, Object[] paramsArray) {
        Extension extension = this.ctx.getExtension(ext, paramsArray);
        return extension != null;
    }

    public boolean hasExtension(String ext, List<?> params) {
        Object[] paramsArray = new Object[params.size()];
        paramsArray = params.toArray(paramsArray);
        return this.hasExtension(ext, paramsArray);
    }

    public Type analyze(String string, Object[] objects, Set<AnalysationIssue> issues) {
        if (objects == null) {
            objects = new Object[]{};
        }
        Extension extension = this.ctx.getExtension(string, objects);
        Type[] params = new Type[objects.length];
        int i = 0;
        while (i < params.length) {
            params[i] = this.ctx.getType(objects[i]);
            ++i;
        }
        return this.ctx.getReturnType(extension, params, issues);
    }
}

