/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class QueuedBuildData {
    private Collection<IResourceDescription.Delta> deltas = Lists.newArrayList();
    private LinkedList<URI> uris = Lists.newLinkedList();
    private Map<String, LinkedList<URI>> projectNameToChangedResource = Maps.newHashMap();
    @Inject
    IStorage2UriMapper mapper;

    public synchronized void queueChanges(Collection<IResourceDescription.Delta> deltas) {
        if (deltas != null && !deltas.isEmpty()) {
            this.deltas.addAll(deltas);
        }
    }

    public synchronized void queueURIs(Collection<URI> uris) {
        if (uris != null && !uris.isEmpty()) {
            for (URI uri : uris) {
                this.queueURI(uri);
            }
        }
    }

    public void queueURI(URI uri) {
        if (uri.isPlatformResource()) {
            String projectName = uri.segment(1);
            if (".org.eclipse.jdt.core.external.folders".equals(projectName)) {
                this.uris.add(uri);
            } else {
                LinkedList list = this.projectNameToChangedResource.get(projectName);
                if (list == null) {
                    list = Lists.newLinkedList();
                    this.projectNameToChangedResource.put(projectName, list);
                }
                list.add(uri);
            }
        } else {
            this.uris.add(uri);
        }
    }

    public Collection<IResourceDescription.Delta> getAndRemovePendingDeltas() {
        Collection<IResourceDescription.Delta> result = this.deltas;
        this.deltas = Lists.newArrayList();
        return result;
    }

    public boolean isEmpty(String projectName) {
        return this.deltas.isEmpty() && this.getQueue(projectName).isEmpty();
    }

    public Queue<URI> getQueue(String projectName) {
        final LinkedList<URI> list = this.projectNameToChangedResource.get(projectName);
        if (list == null) {
            return this.uris;
        }
        return new AbstractQueue<URI>(){

            @Override
            public boolean offer(URI o) {
                return list.offer(o);
            }

            @Override
            public URI poll() {
                if (QueuedBuildData.this.uris.isEmpty()) {
                    return (URI)list.poll();
                }
                return (URI)QueuedBuildData.this.uris.poll();
            }

            @Override
            public URI peek() {
                if (QueuedBuildData.this.uris.isEmpty()) {
                    return (URI)list.peek();
                }
                return (URI)QueuedBuildData.this.uris.peek();
            }

            @Override
            public Iterator<URI> iterator() {
                return Iterators.concat(QueuedBuildData.this.uris.iterator(), list.iterator());
            }

            @Override
            public int size() {
                return QueuedBuildData.this.uris.size() + list.size();
            }
        };
    }

    public Iterable<URI> getAllRemainingURIs() {
        return Iterables.concat(this.uris, (Iterable)Iterables.concat(this.projectNameToChangedResource.values()));
    }
}

