/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;

public class DefaultResourceDescriptionDelta
implements IResourceDescription.Delta {
    private IResourceDescription _new;
    private IResourceDescription old;
    private Boolean hasChanges;

    public DefaultResourceDescriptionDelta(IResourceDescription old, IResourceDescription _new) {
        if (old == _new) {
            throw new AssertionError((Object)"'old!=_new' constraint violated");
        }
        if (_new != null && old != null && !old.getURI().equals((Object)_new.getURI())) {
            URI oldURI = old.getURI();
            URI newURI = _new.getURI();
            throw new AssertionError((Object)("'_new!=null && old!=null && !old.getURI().equals(_new.getURI())' constraint violated, old was " + oldURI + " new was: " + newURI));
        }
        this.old = old;
        this._new = _new;
    }

    public IResourceDescription getNew() {
        return this._new;
    }

    public IResourceDescription getOld() {
        return this.old;
    }

    public boolean haveEObjectDescriptionsChanged() {
        if (this.hasChanges == null) {
            this.hasChanges = this.internalHasChanges();
        }
        return this.hasChanges;
    }

    protected boolean internalHasChanges() {
        if (this._new == null || this.old == null) {
            return true;
        }
        ArrayList oldEObjects = Lists.newArrayList(this.old.getExportedObjects());
        ArrayList newEObjects = Lists.newArrayList(this._new.getExportedObjects());
        if (oldEObjects.size() != newEObjects.size()) {
            return true;
        }
        Iterator iterator1 = oldEObjects.iterator();
        Iterator iterator2 = newEObjects.iterator();
        while (iterator1.hasNext()) {
            if (this.equals((IEObjectDescription)iterator1.next(), (IEObjectDescription)iterator2.next())) continue;
            return true;
        }
        return false;
    }

    protected boolean equals(IEObjectDescription next, IEObjectDescription next2) {
        if (next == next2) {
            return true;
        }
        if (next.getEClass() != next2.getEClass()) {
            return false;
        }
        if (next.getName() != null && !next.getName().equals(next2.getName())) {
            return false;
        }
        if (!next.getEObjectURI().equals((Object)next2.getEObjectURI())) {
            return false;
        }
        if (!Arrays.equals(next.getUserDataKeys(), next2.getUserDataKeys())) {
            return false;
        }
        String[] stringArray = next.getUserDataKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String userData = next.getUserData(key);
            String userData2 = next2.getUserData(key);
            if (userData == null ? userData2 != null : !userData.equals(userData2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public URI getUri() {
        return this.old == null ? this._new.getURI() : this.old.getURI();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.getUri() + " old :" + (this.getOld() != null) + ",new :" + (this.getNew() != null);
    }
}

