/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.nodemodel.BidiIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.ClasspathUriResolutionException;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xtext.XtextMetamodelReferenceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextLinkingService
extends DefaultLinkingService {
    private static final Logger log = Logger.getLogger(XtextLinkingService.class);
    @Inject
    private IValueConverterService valueConverterService;
    private String fileExtension = "xtext";

    @Inject
    public void setFileExtension(@Named(value="file.extensions") String fileExtension) {
        this.fileExtension = fileExtension.split(",")[0];
    }

    @Override
    public List<EObject> getLinkedObjects(EObject context, EReference ref, INode node) throws IllegalNodeException {
        if (ref == XtextPackage.eINSTANCE.getGrammar_UsedGrammars()) {
            return this.getUsedGrammar((Grammar)context, node);
        }
        if (ref == XtextPackage.eINSTANCE.getTypeRef_Metamodel()) {
            return this.getLinkedMetaModel((TypeRef)context, ref, (ILeafNode)node);
        }
        if (ref == XtextPackage.eINSTANCE.getAbstractMetamodelDeclaration_EPackage() && context instanceof GeneratedMetamodel) {
            return this.createPackage((GeneratedMetamodel)context, (ILeafNode)node);
        }
        if (ref == XtextPackage.eINSTANCE.getAbstractMetamodelDeclaration_EPackage() && context instanceof ReferencedMetamodel) {
            return this.getPackage((ReferencedMetamodel)context, (ILeafNode)node);
        }
        return super.getLinkedObjects(context, ref, node);
    }

    private List<EObject> getUsedGrammar(Grammar grammar, INode node) {
        try {
            String grammarName = (String)this.valueConverterService.toValue("", "GrammarID", node);
            if (grammarName != null) {
                Resource resource2;
                ResourceSet resourceSet = grammar.eResource().getResourceSet();
                for (Resource resource2 : resourceSet.getResources()) {
                    Grammar otherGrammar;
                    EObject content;
                    if (resource2.getContents().isEmpty() || !((content = (EObject)resource2.getContents().get(0)) instanceof Grammar) || !grammarName.equals((otherGrammar = (Grammar)content).getName())) continue;
                    return Collections.singletonList(otherGrammar);
                }
                resource2 = resourceSet.getResource(URI.createURI((String)("classpath:/" + grammarName.replace('.', '/') + "." + this.fileExtension)), true);
                Grammar usedGrammar = (Grammar)resource2.getContents().get(0);
                if (grammarName.equals(usedGrammar.getName())) {
                    return Collections.singletonList(usedGrammar);
                }
            }
            return Collections.emptyList();
        }
        catch (ClasspathUriResolutionException e) {
            log.debug((Object)"Cannot load used grammar.", (Throwable)e);
            return Collections.emptyList();
        }
        catch (ValueConverterException e) {
            log.debug((Object)"Cannot load used grammar.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<EObject> getPackage(ReferencedMetamodel context, ILeafNode text) {
        String nsUri = this.getMetamodelNsURI(text);
        if (nsUri == null) {
            return Collections.emptyList();
        }
        Grammar grammar = GrammarUtil.getGrammar(context);
        HashSet<Grammar> visitedGrammars = new HashSet<Grammar>();
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            List<EObject> result = this.getPackage(nsUri, usedGrammar, visitedGrammars);
            if (result == null) continue;
            return result;
        }
        EPackage pack = this.loadEPackage(nsUri, context.eResource().getResourceSet());
        if (pack != null) {
            return Collections.singletonList(pack);
        }
        return Collections.emptyList();
    }

    private List<EObject> getPackage(String nsUri, Grammar grammar, Set<Grammar> visitedGrammars) {
        if (!visitedGrammars.add(grammar)) {
            return null;
        }
        for (AbstractMetamodelDeclaration declaration : grammar.getMetamodelDeclarations()) {
            EPackage pack = declaration.getEPackage();
            if (pack == null || !nsUri.equals(pack.getNsURI())) continue;
            return Collections.singletonList(pack);
        }
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            List<EObject> result = this.getPackage(nsUri, usedGrammar, visitedGrammars);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private String getMetamodelNsURI(ILeafNode text) {
        try {
            return (String)this.valueConverterService.toValue(text.getText(), this.getLinkingHelper().getRuleNameFrom(text.getGrammarElement()), text);
        }
        catch (ValueConverterException e) {
            log.debug((Object)("Exception on leaf '" + text.getText() + "'"), (Throwable)e);
            return null;
        }
    }

    private EPackage loadEPackage(String resourceOrNsURI, ResourceSet resourceSet) {
        if (EPackage.Registry.INSTANCE.containsKey((Object)resourceOrNsURI)) {
            return EPackage.Registry.INSTANCE.getEPackage(resourceOrNsURI);
        }
        URI uri = URI.createURI((String)resourceOrNsURI);
        try {
            if (uri.fragment() == null) {
                Resource resource = resourceSet.getResource(uri, true);
                EPackage result = (EPackage)resource.getContents().get(0);
                return result;
            }
            EPackage result = (EPackage)resourceSet.getEObject(uri, true);
            return result;
        }
        catch (RuntimeException ex) {
            if (uri.isPlatformResource()) {
                String platformString = uri.toPlatformString(true);
                URI platformPluginURI = URI.createPlatformPluginURI((String)platformString, (boolean)true);
                return this.loadEPackage(platformPluginURI.toString(), resourceSet);
            }
            log.trace((Object)("Cannot load package with URI '" + resourceOrNsURI + "'"), (Throwable)ex);
            return null;
        }
    }

    private List<EObject> createPackage(GeneratedMetamodel generatedMetamodel, ILeafNode text) {
        String nsURI = this.getMetamodelNsURI(text);
        URI uri = URI.createURI((String)nsURI);
        if (uri == null || this.isReferencedByUsedGrammar(generatedMetamodel, nsURI)) {
            return Collections.emptyList();
        }
        EPackage generatedEPackage = EcoreFactory.eINSTANCE.createEPackage();
        generatedEPackage.setName(generatedMetamodel.getName());
        generatedEPackage.setNsPrefix(generatedMetamodel.getName());
        generatedEPackage.setNsURI(nsURI);
        Resource generatedPackageResource = new EcoreResourceFactoryImpl().createResource(uri);
        generatedMetamodel.eResource().getResourceSet().getResources().add((Object)generatedPackageResource);
        generatedPackageResource.getContents().add((Object)generatedEPackage);
        return Collections.singletonList(generatedEPackage);
    }

    private boolean isReferencedByUsedGrammar(GeneratedMetamodel generatedMetamodel, String nsURI) {
        Grammar grammar = GrammarUtil.getGrammar(generatedMetamodel);
        if (grammar != null) {
            HashSet visitedGrammars = Sets.newHashSet((Object[])new Grammar[]{grammar});
            for (Grammar usedGrammar : grammar.getUsedGrammars()) {
                if (!this.isReferencedByUsedGrammar(usedGrammar, nsURI, visitedGrammars)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isReferencedByUsedGrammar(Grammar grammar, String nsURI, Set<Grammar> visitedGrammars) {
        if (!visitedGrammars.add(grammar)) {
            return false;
        }
        for (AbstractMetamodelDeclaration decl : grammar.getMetamodelDeclarations()) {
            EPackage pack = decl.getEPackage();
            if (pack == null || !nsURI.equals(pack.getNsURI())) continue;
            return true;
        }
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            if (!this.isReferencedByUsedGrammar(usedGrammar, nsURI, visitedGrammars)) continue;
            return true;
        }
        return false;
    }

    private List<EObject> getLinkedMetaModel(TypeRef context, EReference ref, ILeafNode text) throws IllegalNodeException {
        ICompositeNode parentNode = text.getParent();
        BidiIterator<INode> iterator = parentNode.getChildren().iterator();
        while (iterator.hasPrevious()) {
            INode child = iterator.previous();
            if (!(child instanceof ILeafNode)) continue;
            ILeafNode leaf = (ILeafNode)child;
            if (text == leaf) {
                return super.getLinkedObjects(context, ref, text);
            }
            if (leaf.getGrammarElement() instanceof Keyword || leaf.isHidden()) continue;
            IScope scope = this.getScope(context, ref);
            return XtextMetamodelReferenceHelper.findBestMetamodelForType(context, text.getText(), leaf.getText(), scope);
        }
        return Collections.emptyList();
    }
}

