/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import org.eclipse.draw3d.AbstractSurface;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Math3DCache;
import org.eclipse.draw3d.geometry.Matrix4f;
import org.eclipse.draw3d.geometry.Position3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.util.Draw3DCache;

public abstract class PositionBasedSurface
extends AbstractSurface {
    protected abstract Position3D getPosition3D();

    protected void calculateNormal(Vector3f io_normal) {
        io_normal.set(IVector3f.Z_AXIS_NEG);
        IMatrix4f rotation = this.getPosition3D().getAbsoluteRotationMatrix();
        Math3D.transform((IVector3f)io_normal, (IMatrix4f)rotation, (Vector3f)io_normal);
    }

    protected Vector3f getOrigin(Vector3f io_result) {
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        Position3D position3d = this.getPosition3D();
        IMatrix4f matrix = position3d.getRotationLocationMatrix();
        result.set(IVector3f.NULLVEC3f);
        result.transform(matrix);
        return result;
    }

    public Vector3f getSurfaceRotation(Vector3f o_result) {
        Vector3f vector3f;
        Vector3f result = o_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        Position3D absolute = Draw3DCache.getPosition3D();
        try {
            this.getPosition3D().getAbsolute(absolute);
            result.set(absolute.getRotation3D());
            vector3f = result;
        }
        catch (Throwable throwable) {
            Draw3DCache.returnPosition3D((Position3D[])new Position3D[]{absolute});
            throw throwable;
        }
        Draw3DCache.returnPosition3D((Position3D[])new Position3D[]{absolute});
        return vector3f;
    }

    protected Vector3f getXAxis(Vector3f io_result) {
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        result.set(IVector3f.X_AXIS);
        this.rotateVector(result);
        return result;
    }

    protected Vector3f getYAxis(Vector3f io_result) {
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        result.set(IVector3f.Y_AXIS);
        this.rotateVector(result);
        return result;
    }

    protected Vector3f getZAxis(Vector3f io_result) {
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        result.set(IVector3f.Z_AXIS);
        this.rotateVector(result);
        return result;
    }

    protected void rotateVector(Vector3f i_vector) {
        Matrix4f rot = Math3DCache.getMatrix4f();
        try {
            IVector3f angles = this.getPosition3D().getRotation3D();
            Math3D.rotate((IVector3f)angles, (IMatrix4f)IMatrix4f.IDENTITY, (Matrix4f)rot);
            i_vector.transform((IMatrix4f)rot);
        }
        catch (Throwable throwable) {
            Math3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{rot});
            throw throwable;
        }
        Math3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{rot});
    }
}

