/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common.converter;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(factory="org.eclipse.app4mc.amalthea.namespaceconverter.factory")
public class NamespaceConverter
extends AbstractConverter {
    BundleContext context;

    @Activate
    protected void activate(Map<String, Object> properties, BundleContext context) {
        super.activate(properties);
        this.context = context;
    }

    @Override
    public void convert(File targetFile, Map<File, Document> fileName2documentMap, List<ICache> caches) {
        Document document;
        ServiceReference serviceReference = null;
        SessionLogger logger = null;
        if (this.context != null) {
            serviceReference = this.context.getServiceReference(SessionLogger.class);
            logger = (SessionLogger)this.context.getService(serviceReference);
            logger.info("Migration from {0} to {1} : Executing Namespace converter for model file : {2}", new Object[]{this.getInputModelVersion(), this.getOutputModelVersion(), targetFile.getName()});
        }
        if ((document = fileName2documentMap.get(targetFile)) == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        ModelVersion inputVersion = ModelVersion.getModelVersion(this.getInputModelVersion());
        ModelVersion outputVersion = ModelVersion.getModelVersion(this.getOutputModelVersion());
        if (inputVersion != null && outputVersion != null) {
            HelperUtil.updateRootElement_NameSpaces(rootElement, inputVersion, outputVersion);
        } else if (logger != null) {
            logger.error("input model version {0} or output model version {1} are invalid!", new Object[]{this.getInputModelVersion(), this.getOutputModelVersion()});
        }
        if (this.context != null) {
            this.context.ungetService(serviceReference);
        }
    }
}

