/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters200.impl;

import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters200.utils.SchedulerCache;
import org.eclipse.app4mc.amalthea.converters200.utils.SchedulerConverterUtil;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=1.2.0", "output_model_version=2.0.0"}, service={IConverter.class})
public class SchedulerConverter
extends AbstractConverter {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String UNIT = "unit";
    private static final String EXTENDED = "extended: ";
    private static final String SCHEDULING_ALGORITHM = "schedulingAlgorithm";
    private static final String SCHEDULING_PARAMETERS = "schedulingParameters";
    private static final String PARAMETER_EXTENSIONS = "parameterExtensions";
    private static final String PRIORITY = "priority";
    private static final String MIN_BUDGET = "minBudget";
    private static final String MAX_BUDGET = "maxBudget";
    private static final String REPLENISHMENT2 = "replenishment";
    @Reference
    SessionLogger logger;
    private SchedulerCache myCache;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileDocumentMapping, List<ICache> caches) {
        this.logger.info("Migration from {0} to {1} : Executing Scheduler converter for model file : {2}", new Object[]{this.getInputModelVersion(), this.getOutputModelVersion(), targetFile.getName()});
        this.myCache = this.getFilteredCaches(caches, SchedulerCache.class).stream().findFirst().orElse(null);
        this.basicConvert(targetFile, fileDocumentMapping);
    }

    private void basicConvert(File file, Map<File, Document> map) {
        Document document = map.get(file);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.addSchedulerDefinitions(rootElement);
        this.convertSchedulingAlgorithms(rootElement);
        this.convertParameterValues(rootElement);
        this.myCache.setFirstFile(false);
    }

    private void addSchedulerDefinitions(Element rootElement) {
        if (this.myCache == null || rootElement == null) {
            return;
        }
        if (!this.myCache.isFirstFile()) {
            return;
        }
        Set<String> standardAlgorithmNames = this.myCache.getStandardAlgorithmCache();
        Set<Map.Entry<String, List<String>>> extendedAlgorithmEntries = this.myCache.getUserSpecificAlgorithmCache().entrySet();
        Set<String> standardParameterNames = this.myCache.getStandardParameterCache();
        Set<String> extendedParameterNames = this.myCache.getExtendedParameterCache();
        if (standardAlgorithmNames.isEmpty() && extendedAlgorithmEntries.isEmpty() && standardParameterNames.isEmpty() && extendedParameterNames.isEmpty()) {
            return;
        }
        Element osModel = rootElement.getChild("osModel");
        if (osModel == null) {
            osModel = new Element("osModel");
            rootElement.addContent((Content)osModel);
        }
        for (String string : this.sortedList(standardAlgorithmNames)) {
            String newName = SchedulerConverterUtil.getNewSchedulerName(string);
            SchedulerConverterUtil.addSchedulerDefinition(osModel, newName);
            standardParameterNames.addAll(SchedulerConverterUtil.getStandardParameterNames(newName));
        }
        for (Map.Entry entry : this.sortedEntryList(extendedAlgorithmEntries)) {
            String name = (String)entry.getKey();
            List<String> params = ((List)entry.getValue()).stream().map(s -> EXTENDED + s).collect(Collectors.toList());
            SchedulerConverterUtil.addSchedulerDefinition(osModel, name, null, params, null, null);
        }
        for (String string : this.sortedList(standardParameterNames)) {
            SchedulerConverterUtil.addParameterDefinition(osModel, string);
        }
        for (String string : this.sortedList(extendedParameterNames)) {
            SchedulerConverterUtil.addParameterDefinition(osModel, EXTENDED + string);
        }
    }

    private void convertSchedulingAlgorithms(Element rootElement) {
        if (this.myCache == null || rootElement == null) {
            return;
        }
        Namespace am = AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._120, (String)"am");
        Namespace xsi = AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi");
        List algorithmElements = HelperUtil.getXpathResult((Element)rootElement, (String)"./osModel/operatingSystems/taskSchedulers/schedulingAlgorithm|./osModel/operatingSystems/interruptControllers/schedulingAlgorithm", Element.class, (Namespace[])new Namespace[]{am, xsi});
        for (Element elem : algorithmElements) {
            Element parent = elem.getParentElement();
            String type = elem.getAttributeValue("type", xsi).substring(3);
            parent.removeChild(SCHEDULING_ALGORITHM);
            String definition = this.findSchedulerDefinitionName(elem, type);
            String link = String.valueOf(HelperUtil.encodeName((String)definition)) + "?type=SchedulerDefinition";
            for (Element paramExt : elem.getChildren(PARAMETER_EXTENSIONS)) {
                String key = paramExt.getAttributeValue(KEY);
                String value = paramExt.getAttributeValue(VALUE);
                this.addSchedulingParameter(parent, EXTENDED + key, "am:StringObject", value, null);
            }
            if (this.myCache.isFirstFile()) {
                parent.setAttribute("definition", link);
                continue;
            }
            Element definitionElement = new Element("definition");
            definitionElement.setAttribute("href", "amlt:/#" + link);
            parent.addContent((Content)definitionElement);
        }
    }

    private void convertParameterValues(Element rootElement) {
        if (this.myCache == null || rootElement == null) {
            return;
        }
        Namespace am = AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._120, (String)"am");
        Namespace xsi = AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi");
        List parameterElements = HelperUtil.getXpathResult((Element)rootElement, (String)"./osModel/operatingSystems/taskSchedulers/parentAssociation/schedulingParameters|./mappingModel/taskAllocation/schedulingParameters", Element.class, (Namespace[])new Namespace[]{am, xsi});
        for (Element elem : parameterElements) {
            Element replenishment;
            Element maxBudget;
            Element minBudget;
            Element parent = elem.getParentElement();
            parent.removeChild(SCHEDULING_PARAMETERS);
            String priorityValue = elem.getAttributeValue(PRIORITY);
            if (priorityValue != null && !priorityValue.equals("0")) {
                this.addIntegerSchedulingParameter(parent, PRIORITY, priorityValue);
            }
            if ((minBudget = elem.getChild(MIN_BUDGET)) != null) {
                this.addTimeSchedulingParameter(parent, MIN_BUDGET, minBudget);
            }
            if ((maxBudget = elem.getChild(MAX_BUDGET)) != null) {
                this.addTimeSchedulingParameter(parent, MAX_BUDGET, maxBudget);
            }
            if ((replenishment = elem.getChild(REPLENISHMENT2)) == null) continue;
            this.addTimeSchedulingParameter(parent, REPLENISHMENT2, replenishment);
        }
        List extendedParameterElements = HelperUtil.getXpathResult((Element)rootElement, (String)"./osModel/operatingSystems/taskSchedulers/parentAssociation/parameterExtensions|./mappingModel/taskAllocation/parameterExtensions", Element.class, (Namespace[])new Namespace[]{am, xsi});
        for (Element elem : extendedParameterElements) {
            Element parent = elem.getParentElement();
            String key = elem.getAttributeValue(KEY);
            String value = elem.getAttributeValue(VALUE);
            parent.removeChild(PARAMETER_EXTENSIONS);
            this.addSchedulingParameter(parent, EXTENDED + key, "am:StringObject", value, null);
        }
    }

    private String findSchedulerDefinitionName(Element algorithmElement, String type) {
        if (type.equals("UserSpecificSchedulingAlgorithm")) {
            List parameters = algorithmElement.getChildren(PARAMETER_EXTENSIONS).stream().map(param -> param.getAttributeValue(KEY)).collect(Collectors.toList());
            for (Map.Entry<String, List<String>> entry : this.myCache.getUserSpecificAlgorithmCache().entrySet()) {
                if (!entry.getValue().equals(parameters)) continue;
                return entry.getKey();
            }
            return null;
        }
        return SchedulerConverterUtil.getNewSchedulerName(type);
    }

    private <T> List<T> sortedList(Collection<T> collection) {
        return collection.stream().sorted().collect(Collectors.toList());
    }

    private List<Map.Entry<String, List<String>>> sortedEntryList(Collection<Map.Entry<String, List<String>>> entries) {
        return entries.stream().sorted(Comparator.comparing(Map.Entry::getKey)).collect(Collectors.toList());
    }

    private void addIntegerSchedulingParameter(Element parent, String definition, String value) {
        this.addSchedulingParameter(parent, definition, "am:IntegerObject", value, null);
    }

    private void addTimeSchedulingParameter(Element parent, String definition, Element timeElement) {
        this.addSchedulingParameter(parent, definition, "am:Time", timeElement.getAttributeValue(VALUE), timeElement.getAttributeValue(UNIT));
    }

    private void addSchedulingParameter(Element parent, String definition, String type, String value, String unit) {
        Element parameterElement = new Element(SCHEDULING_PARAMETERS);
        parent.addContent((Content)parameterElement);
        String keyLink = String.valueOf(HelperUtil.encodeName((String)definition)) + "?type=SchedulingParameterDefinition";
        if (this.myCache.isFirstFile()) {
            parameterElement.setAttribute(KEY, keyLink);
        } else {
            Element keyElement = new Element(KEY);
            keyElement.setAttribute("href", "amlt:/#" + keyLink);
            parameterElement.addContent((Content)keyElement);
        }
        Element valueElement = new Element(VALUE);
        valueElement.setAttribute("type", type, AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
        if (value != null) {
            valueElement.setAttribute(VALUE, value);
        }
        if (unit != null) {
            valueElement.setAttribute(UNIT, unit);
        }
        parameterElement.addContent((Content)valueElement);
    }
}

