/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters093.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters093.utils.HelperUtils_092_093;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.9.2", "output_model_version=0.9.3"}, service={IConverter.class})
public class StimulusConverter
extends AbstractConverter {
    @Reference
    SessionLogger logger;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> filename2documentMap, List<ICache> caches) {
        this.logger.info("Migration from 0.9.2 to 0.9.3 : Executing Stimulus converter for model file : {0}", new Object[]{targetFile.getName()});
        Document root = filename2documentMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateStimuli(rootElement);
    }

    private void updateStimuli(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./stimuliModel/stimuli");
        List stimuliElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._093, (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element stimuliElement : stimuliElements) {
            Element migratedElement;
            String stimuliType = stimuliElement.getAttributeValue("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            if (stimuliType == null) continue;
            if (stimuliType.equals("am:PeriodicStimulus")) {
                Element jitter_time_deviationElement = stimuliElement.getChild("jitter");
                if (jitter_time_deviationElement == null) continue;
                migratedElement = HelperUtils_092_093.migrateDeviationElementContainingTimeValue(jitter_time_deviationElement, "jitter", this.logger);
                int indexOf = stimuliElement.indexOf((Content)jitter_time_deviationElement);
                stimuliElement.removeContent((Content)jitter_time_deviationElement);
                if (migratedElement == null) continue;
                stimuliElement.addContent(indexOf, (Content)migratedElement);
                continue;
            }
            if (stimuliType.equals("am:RelativePeriodicStimulus")) {
                Element nextOccurrence_time_deviationElement = stimuliElement.getChild("nextOccurrence");
                if (nextOccurrence_time_deviationElement == null) continue;
                migratedElement = HelperUtils_092_093.migrateDeviationElementContainingTimeValue(nextOccurrence_time_deviationElement, "nextOccurrence", this.logger);
                int indexOf = stimuliElement.indexOf((Content)nextOccurrence_time_deviationElement);
                stimuliElement.removeContent((Content)nextOccurrence_time_deviationElement);
                if (migratedElement == null) continue;
                stimuliElement.addContent(indexOf, (Content)migratedElement);
                continue;
            }
            if (!stimuliType.equals("am:VariableRateStimulus")) continue;
            Element occurrencesPerStep_double_deviationElement = stimuliElement.getChild("occurrencesPerStep");
            if (occurrencesPerStep_double_deviationElement != null) {
                migratedElement = HelperUtils_092_093.migrateDeviationElementContainingDoubleValue(occurrencesPerStep_double_deviationElement, "occurrencesPerStep", this.logger);
                int indexOf = stimuliElement.indexOf((Content)occurrencesPerStep_double_deviationElement);
                stimuliElement.removeContent((Content)occurrencesPerStep_double_deviationElement);
                if (migratedElement != null) {
                    stimuliElement.addContent(indexOf, (Content)migratedElement);
                }
            }
            Element maxIncreasePerStepElement = stimuliElement.getChild("maxIncreasePerStep");
            Element maxDecreasePerStepElement = stimuliElement.getChild("maxDecreasePerStep");
            if (maxIncreasePerStepElement != null) {
                stimuliElement.setAttribute("maxIncreasePerStep", maxIncreasePerStepElement.getAttributeValue("value"));
                stimuliElement.removeContent((Content)maxIncreasePerStepElement);
            }
            if (maxDecreasePerStepElement == null) continue;
            stimuliElement.setAttribute("maxDecreasePerStep", maxDecreasePerStepElement.getAttributeValue("value"));
            stimuliElement.removeContent((Content)maxDecreasePerStepElement);
        }
    }
}

