/**
 ********************************************************************************
 * Copyright (c) 2019-2020 Robert Bosch GmbH and others.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 ********************************************************************************
 */
package org.eclipse.app4mc.amalthea.nature.decorators;

import java.util.Arrays;
import java.util.Optional;

import org.eclipse.app4mc.amalthea.nature.AmaltheaNoLoadNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class ProjectDecorator implements ILightweightLabelDecorator {

	private final Optional<ImageDescriptor> decoratorImage = ResourceLocator.imageDescriptorFromBundle(getClass(), "icons/sample_decorator.gif"); 
	
	@Override
	public void decorate(Object element, IDecoration decoration) {
		
		if (element instanceof IProject) {
			try {
				IProject project = (IProject) element;
				if (project.isOpen()) {
					IProjectDescription desc = project.getDescription();
					if (desc != null) {
						String[] prevNatures = desc.getNatureIds();
						if (Arrays.asList(prevNatures).contains(AmaltheaNoLoadNature.ID)) {
							decoration.addSuffix(" - Amalthea-no-load-activated");
							decoratorImage.ifPresent(d -> decoration.addOverlay(d, IDecoration.TOP_LEFT));
						}
					}
				}
				
			} catch (CoreException e) {
				Platform.getLog(getClass()).log(
						new Status(IStatus.ERROR, "org.eclipse.app4mc.amalthea.nature", "Error on AmaltheaNoLoadNature decoration", e));
			}
		}
	}

	@Override
	public void addListener(ILabelProviderListener listener) {
		// not implemented
	}

	@Override
	public void dispose() {
		// not implemented
	}

	@Override
	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	@Override
	public void removeListener(ILabelProviderListener listener) {
		// not implemented
	}
}
