/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.emf;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipFile;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.emf.AmaltheaResourceHandler;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class AmaltheaResource
extends XMIResourceImpl {
    private boolean computeZipOption = true;

    public AmaltheaResource() {
        this.addDefaults();
    }

    public AmaltheaResource(URI uri) {
        super(uri);
        this.addDefaults();
    }

    private void addDefaults() {
        this.getDefaultSaveOptions().put("ENCODING", "UTF-8");
        this.getDefaultLoadOptions().put("DEFER_ATTACHMENT", Boolean.TRUE);
        this.getDefaultLoadOptions().put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        this.getDefaultLoadOptions().put("USE_XML_NAME_TO_FEATURE_MAP", new HashMap());
        this.getDefaultLoadOptions().put("KEEP_DEFAULT_CONTENT", Boolean.TRUE);
        this.getDefaultSaveOptions().put("KEEP_DEFAULT_CONTENT", Boolean.TRUE);
        this.getDefaultLoadOptions().put("RESOURCE_HANDLER", new AmaltheaResourceHandler());
        this.getDefaultSaveOptions().put("RESOURCE_HANDLER", new AmaltheaResourceHandler());
    }

    public boolean useZip() {
        if (this.computeZipOption) {
            this.setUseZip(this.isZipFile(this.getURI()));
        }
        return super.useZip();
    }

    public void setUseZip(boolean useZip) {
        super.setUseZip(useZip);
        this.computeZipOption = false;
    }

    private boolean isZipFile(URI uri) {
        String fileString;
        boolean result = false;
        URI fileURI = this.convertToAbsoluteFileURI(uri);
        if (fileURI != null && (fileString = fileURI.toFileString()) != null) {
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try (ZipFile f = new ZipFile(fileString);){
                    result = true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private URI convertToAbsoluteFileURI(URI uri) {
        URI result = CommonPlugin.asLocalURI((URI)uri);
        if (result.isRelative()) {
            result = this.getURIConverter().normalize(uri);
            result = CommonPlugin.asLocalURI((URI)result);
        }
        return result;
    }

    protected boolean useUUIDs() {
        return false;
    }

    protected boolean useIDs() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetIDMaps() {
        AmaltheaResource amaltheaResource = this;
        synchronized (amaltheaResource) {
            this.idToEObjectMap = null;
            this.eObjectToIDMap = null;
        }
    }

    protected EObject getEObjectByID(String id) {
        EObject eObject;
        EObject eObject2;
        if (id == null) {
            return null;
        }
        if (this.idToEObjectMap != null && (eObject2 = (EObject)this.idToEObjectMap.get(id)) != null) {
            return eObject2;
        }
        Map map = this.getIntrinsicIDToEObjectMap();
        if (map != null && (eObject = (EObject)map.get(id)) != null) {
            return eObject;
        }
        return AmaltheaIndex.getEObjectByID((Notifier)this, id);
    }

    protected XMLHelper createXMLHelper() {
        return new XMIHelperImpl((XMLResource)this){

            protected URI getHREF(Resource otherResource, EObject obj) {
                String prefix = this.resource == otherResource ? "#" : "amlt:/#";
                return URI.createURI((String)(String.valueOf(prefix) + this.getIDREF(obj)), (boolean)true);
            }
        };
    }
}

