/**
 ********************************************************************************
 * Copyright (c) 2020-2022 Robert Bosch GmbH.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 *******************************************************************************/

package org.eclipse.app4mc.amalthea.visualization.hw;

import java.io.IOException;

import javax.annotation.PostConstruct;

import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.visualization.hw.templates.HWBlockGenerator;
import org.eclipse.app4mc.visualization.ui.registry.Visualization;
import org.eclipse.app4mc.visualization.util.svg.PlantUmlDiagram;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.component.annotations.Component;

@Component(property= {
		"name=HW Model Block Diagram",
		"description=Block Diagram Visualization for Hardware Models"
})
public class HWBlockDiagramVisualization implements Visualization {

	@PostConstruct
	public void createVisualization(
			HWModel hwModel,
			Composite parent,
			Shell shell) {

		PlantUmlDiagram diagram = new PlantUmlDiagram();

		Browser browser = new Browser(parent, SWT.NONE);

		// *** Execute thread to render diagram and update browser

		new Thread(() -> {
			// Build PlantUML diagram
			HWBlockGenerator.updateDiagram(diagram, hwModel.getStructures());

			String result;
			try {
				result = diagram.renderToSvg();
			} catch (IOException e) {
				result = prepareErrorMessage(e);
				Platform.getLog(HWBlockDiagramVisualization2.class).error(result, e);
			}

			if (result != null && !browser.isDisposed()) {
				final String browserContent = result;
				browser.getDisplay().asyncExec(() -> {
					if (!browser.isDisposed()) {
						browser.setText(browserContent);
					}
				});
			}

		}).start();
	}

	private String prepareErrorMessage(IOException e) {
		return "Error invoking PlantUML: \"" + e.getMessage()
				+ "\". Make sure you have configured the path to the dot executable properly in the PlantUML preferences.";
	}

}
