/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.javafx.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.util.SoftwareUtil;
import org.eclipse.app4mc.amalthea.visualizations.javafx.util.FontMetrics;

public class RunnablePainter {
    private static final double MIN_UNIT_HEIGHT = 20.0;
    private static final FontMetrics MIN_BOLD_FONT_METRICS = new FontMetrics(Font.font((String)Font.getDefault().getFamily(), (FontWeight)FontWeight.BOLD, (double)12.0));
    private static final FontMetrics MIN_FONT_METRICS = new FontMetrics(Font.font((String)Font.getDefault().getFamily(), (double)12.0));
    private final Runnable runnable;
    private List<LabelAccess> readItems;
    private List<LabelAccess> writeItems;
    private int itemMax = 0;
    private double scaleFactor = 1.0;
    private double maxScaleFactor = 0.0;
    private boolean autoscale = true;
    private Rectangle runnableRectangle;
    private HashMap<Label, Rectangle> readAccessRectangles = new HashMap();
    private HashMap<Label, Rectangle> writeAccessRectangles = new HashMap();
    private Color runnableStroke = Color.GREEN;
    private Color runnableHeaderFillColor = Color.LIGHTGREEN;
    private Color runnableBodyFillColor = null;
    private Color runnableHeaderFontFill = Color.BLACK;
    private Color labelFontFill = Color.GREEN;

    public RunnablePainter(Runnable runnable) {
        this(runnable, true);
    }

    public RunnablePainter(Runnable runnable, boolean autoscale) {
        this.runnable = runnable;
        this.autoscale = autoscale;
        this.readItems = SoftwareUtil.getReadLabelAccessList((Runnable)runnable, null);
        this.writeItems = SoftwareUtil.getWriteLabelAccessList((Runnable)runnable, null);
        this.itemMax = Math.max(this.readItems.size(), this.writeItems.size());
        if (this.itemMax == 0) {
            this.itemMax = 1;
        }
    }

    public double getPreferredMinimumHeight() {
        int units = this.itemMax + (this.itemMax - 1) + 2 + 2 + 2;
        return 20.0 * this.scaleFactor * (double)units;
    }

    public double getPreferredMinimumWidth() {
        double longestRead = 0.0;
        for (LabelAccess item : this.readItems) {
            String name = item.getData().getDisplayName() != null ? item.getData().getDisplayName() : item.getData().getName();
            longestRead = Math.max(longestRead, MIN_FONT_METRICS.computeStringWidth(name));
        }
        double longestWrite = 0.0;
        for (LabelAccess item : this.writeItems) {
            String name = item.getData().getDisplayName() != null ? item.getData().getDisplayName() : item.getData().getName();
            longestWrite = Math.max(longestWrite, MIN_FONT_METRICS.computeStringWidth(name));
        }
        double textWidth = MIN_BOLD_FONT_METRICS.computeStringWidth(this.runnable.getName());
        return (120.0 + longestRead + longestWrite + textWidth) * this.scaleFactor;
    }

    public void paint(GraphicsContext gc, Rectangle parentBounds) {
        int units = this.itemMax + (this.itemMax - 1) + 2 + 2 + 2;
        double unitHeight = 20.0 * this.scaleFactor;
        double minHeight = (double)units * unitHeight;
        if (this.autoscale && parentBounds.getHeight() > minHeight) {
            unitHeight = parentBounds.getHeight() / (double)units;
        }
        Font defaultFont = gc.getFont();
        double fontSize = 12.0 * (Double.valueOf(unitHeight) / 20.0);
        Font headlineFont = Font.font((String)defaultFont.getFamily(), (FontWeight)FontWeight.BOLD, (double)fontSize);
        Font labelAccessFont = Font.font((String)defaultFont.getFamily(), (double)fontSize);
        gc.setFont(headlineFont);
        FontMetrics headlineMetrics = new FontMetrics(headlineFont);
        double textWidth = headlineMetrics.computeStringWidth(this.runnable.getName());
        gc.setFont(labelAccessFont);
        FontMetrics labelAccessMetrics = new FontMetrics(gc.getFont());
        double longestRead = 0.0;
        for (LabelAccess item : this.readItems) {
            String name = item.getData().getDisplayName() != null ? item.getData().getDisplayName() : item.getData().getName();
            longestRead = Math.max(longestRead, labelAccessMetrics.computeStringWidth(name));
        }
        double longestWrite = 0.0;
        for (LabelAccess item : this.writeItems) {
            String name = item.getData().getDisplayName() != null ? item.getData().getDisplayName() : item.getData().getName();
            longestWrite = Math.max(longestWrite, labelAccessMetrics.computeStringWidth(name));
        }
        double runnableWidth = 2.0 * unitHeight + longestRead + longestWrite + 2.0 * unitHeight + textWidth + 2.0 * unitHeight;
        if (this.autoscale && runnableWidth > parentBounds.getWidth()) {
            double factor = parentBounds.getWidth() / runnableWidth;
            fontSize = 12.0 * (Double.valueOf(unitHeight *= factor) / 20.0);
            headlineFont = Font.font((String)defaultFont.getFamily(), (FontWeight)FontWeight.BOLD, (double)fontSize);
            labelAccessFont = Font.font((String)defaultFont.getFamily(), (double)fontSize);
            headlineMetrics = new FontMetrics(headlineFont);
            textWidth = headlineMetrics.computeStringWidth(this.runnable.getName());
            gc.setFont(labelAccessFont);
            labelAccessMetrics = new FontMetrics(gc.getFont());
            longestRead = 0.0;
            for (LabelAccess item : this.readItems) {
                String name = item.getData().getDisplayName() != null ? item.getData().getDisplayName() : item.getData().getName();
                longestRead = Math.max(longestRead, labelAccessMetrics.computeStringWidth(name));
            }
        }
        double rectX = parentBounds.getX() + 2.0 * unitHeight + longestRead;
        double runnableX = rectX + unitHeight;
        gc.setFont(headlineFont);
        gc.setStroke((Paint)this.runnableStroke);
        if (this.runnableBodyFillColor != null) {
            gc.setFill((Paint)this.runnableBodyFillColor);
            gc.fillRect(rectX, parentBounds.getY() + unitHeight, textWidth + 2.0 * unitHeight, (double)(units - 2) * unitHeight);
        }
        gc.strokeRect(rectX, parentBounds.getY() + unitHeight, textWidth + 2.0 * unitHeight, (double)(units - 2) * unitHeight);
        gc.setFill((Paint)this.runnableHeaderFillColor);
        headlineMetrics = new FontMetrics(headlineFont);
        this.runnableRectangle = new Rectangle(rectX, parentBounds.getY() + unitHeight, textWidth + 2.0 * unitHeight, 2.0 * unitHeight);
        gc.fillRect(rectX, parentBounds.getY() + unitHeight, textWidth + 2.0 * unitHeight, 2.0 * unitHeight);
        gc.setFill((Paint)this.runnableHeaderFontFill);
        gc.fillText(this.runnable.getName(), runnableX, parentBounds.getY() + unitHeight / 2.0 + 2.0 * unitHeight - (unitHeight - headlineMetrics.lineHeight) / 2.0 - headlineMetrics.descent);
        gc.setFont(labelAccessFont);
        gc.setStroke((Paint)this.runnableStroke);
        labelAccessMetrics = new FontMetrics(gc.getFont());
        double yStart = parentBounds.getY() + 4.0 * unitHeight;
        double readX = rectX - unitHeight / 2.0;
        for (LabelAccess item : this.readItems) {
            gc.setFill((Paint)Color.WHITE);
            gc.fillRoundRect(readX, yStart, unitHeight, unitHeight, 10.0, 10.0);
            gc.strokeRoundRect(readX, yStart, unitHeight, unitHeight, 10.0, 10.0);
            this.readAccessRectangles.put(item.getData(), new Rectangle(readX, yStart, unitHeight, unitHeight));
            gc.setFill((Paint)this.labelFontFill);
            String name = item.getData().getDisplayName() != null ? item.getData().getDisplayName() : item.getData().getName();
            gc.fillText(name, readX - labelAccessMetrics.computeStringWidth(name) - unitHeight / 2.0, yStart + unitHeight - (unitHeight - labelAccessMetrics.lineHeight) / 2.0 - labelAccessMetrics.descent);
            yStart += 2.0 * unitHeight;
        }
        yStart = parentBounds.getY() + 4.0 * unitHeight;
        double writeX = rectX + textWidth + 2.0 * unitHeight - unitHeight / 2.0;
        for (LabelAccess item : this.writeItems) {
            gc.setFill((Paint)Color.WHITE);
            gc.fillRoundRect(writeX, yStart, unitHeight, unitHeight, 10.0, 10.0);
            gc.strokeRoundRect(writeX, yStart, unitHeight, unitHeight, 10.0, 10.0);
            this.writeAccessRectangles.put(item.getData(), new Rectangle(writeX, yStart, unitHeight, unitHeight));
            gc.setFill((Paint)this.labelFontFill);
            String name = item.getData().getDisplayName() != null ? item.getData().getDisplayName() : item.getData().getName();
            gc.fillText(name, writeX + unitHeight + unitHeight / 2.0, yStart + unitHeight - (unitHeight - labelAccessMetrics.lineHeight) / 2.0 - labelAccessMetrics.descent);
            yStart += 2.0 * unitHeight;
        }
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public Rectangle getReadRectangle(Label label) {
        return this.readAccessRectangles.get(label);
    }

    public Map<Label, Rectangle> getReadRectangles() {
        return this.readAccessRectangles;
    }

    public Rectangle getWriteRectangle(Label label) {
        return this.writeAccessRectangles.get(label);
    }

    public Map<Label, Rectangle> getWriteRectangles() {
        return this.writeAccessRectangles;
    }

    public Rectangle getRunnableRectangle() {
        return this.runnableRectangle;
    }

    public void setRunnableHeaderFill(Color fill) {
        this.runnableHeaderFillColor = fill;
    }

    public void setRunnableBodyFill(Color fill) {
        this.runnableBodyFillColor = fill;
    }

    public void setRunnableStroke(Color stroke) {
        this.runnableStroke = stroke;
    }

    public void setRunnableHeaderFontFill(Color fill) {
        this.runnableHeaderFontFill = fill;
    }

    public void setLabelFontFill(Color fill) {
        this.labelFontFill = fill;
    }

    public void setRunnableColor(Color color) {
        this.runnableStroke = color;
        this.runnableHeaderFillColor = color;
        this.labelFontFill = color;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        if (scaleFactor <= this.maxScaleFactor && scaleFactor >= 0.1) {
            this.scaleFactor = scaleFactor;
        }
    }

    public double getMaxScaleFactor() {
        return this.maxScaleFactor;
    }

    public void setMaxScaleFactor(double maxScaleFactor) {
        this.maxScaleFactor = Math.floor(maxScaleFactor * 10.0) / 10.0;
        if (this.maxScaleFactor < 0.1) {
            this.maxScaleFactor = 0.1;
        }
        if (this.maxScaleFactor < this.scaleFactor) {
            this.scaleFactor = this.maxScaleFactor;
        }
    }

    public void zoomIn() {
        if (this.scaleFactor <= this.maxScaleFactor) {
            double newFactor = this.scaleFactor + 0.1;
            newFactor = (double)Math.round(newFactor * 10.0) / 10.0;
            this.scaleFactor = Math.min(this.maxScaleFactor, newFactor);
        }
    }

    public void zoomOut() {
        double newFactor = this.scaleFactor - 0.1;
        newFactor = (double)Math.round(newFactor * 10.0) / 10.0;
        this.scaleFactor = Math.max(newFactor, 0.1);
    }
}

