/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model;

import com.google.common.base.Preconditions;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.jdt.annotation.NonNull;

public class AmaltheaCrossReferenceAdapter
extends ECrossReferenceAdapter {
    private static final String ARG_NAME_MESSAGE = "Name argument is null, expected: String";
    private static final String ARG_PATTERN_MESSAGE = "Pattern argument is null, expected: Pattern";
    private static final String ARG_CLASS_MESSAGE = "Class argument is null, expected: Class<T extends INamed>";
    private static final String ARG_STREAM_MESSAGE = "Stream argument is null, expected: PrintStream";
    private final Map<String, Set<INamed>> nameIndex = new HashMap<String, Set<INamed>>();

    public @NonNull Set<@NonNull INamed> getElements(@NonNull String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)ARG_NAME_MESSAGE);
        return this.getElements(name, INamed.class);
    }

    public <T extends INamed> @NonNull Set<@NonNull T> getElements(@NonNull String name, @NonNull Class<T> targetClass) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)ARG_NAME_MESSAGE);
        Preconditions.checkArgument((targetClass != null ? 1 : 0) != 0, (Object)ARG_CLASS_MESSAGE);
        HashSet<INamed> result = new HashSet<INamed>();
        Set<INamed> values = this.nameIndex.get(name);
        if (values != null) {
            for (INamed namedObject : values) {
                if (!targetClass.isInstance(namedObject)) continue;
                result.add((INamed)targetClass.cast(namedObject));
            }
        }
        return result;
    }

    public @NonNull Set<@NonNull INamed> getElements(@NonNull Pattern namePattern) {
        Preconditions.checkArgument((namePattern != null ? 1 : 0) != 0, (Object)ARG_PATTERN_MESSAGE);
        return this.getElements(namePattern, INamed.class);
    }

    public <T extends INamed> @NonNull Set<@NonNull T> getElements(@NonNull Pattern namePattern, @NonNull Class<T> targetClass) {
        Preconditions.checkArgument((namePattern != null ? 1 : 0) != 0, (Object)ARG_PATTERN_MESSAGE);
        Preconditions.checkArgument((targetClass != null ? 1 : 0) != 0, (Object)ARG_CLASS_MESSAGE);
        HashSet<INamed> result = new HashSet<INamed>();
        for (Map.Entry<String, Set<INamed>> entry : this.nameIndex.entrySet()) {
            if (!namePattern.matcher(entry.getKey()).matches()) continue;
            for (INamed namedObject : entry.getValue()) {
                if (!targetClass.isInstance(namedObject)) continue;
                result.add((INamed)targetClass.cast(namedObject));
            }
        }
        return result;
    }

    public <T extends INamed> @NonNull Set<@NonNull T> getElements(@NonNull Class<T> targetClass) {
        Preconditions.checkArgument((targetClass != null ? 1 : 0) != 0, (Object)ARG_CLASS_MESSAGE);
        HashSet<INamed> result = new HashSet<INamed>();
        for (Map.Entry<String, Set<INamed>> entry : this.nameIndex.entrySet()) {
            for (INamed namedObject : entry.getValue()) {
                if (!targetClass.isInstance(namedObject)) continue;
                result.add((INamed)targetClass.cast(namedObject));
            }
        }
        return result;
    }

    public @NonNull List<@NonNull Set<@NonNull IReferable>> getObjectsWithConflictingNames() {
        @NonNull ArrayList<@NonNull Set<@NonNull IReferable>> result = new ArrayList<Set<IReferable>>();
        for (Set<INamed> objects : this.nameIndex.values()) {
            if (objects.size() < 2) continue;
            Map<Class, List<IReferable>> map1 = objects.stream().filter(IReferable.class::isInstance).map(IReferable.class::cast).collect(Collectors.groupingBy(Object::getClass));
            for (List<IReferable> objectsWithSameType : map1.values()) {
                if (objectsWithSameType.size() < 2) continue;
                Map<String, List<IReferable>> map2 = objectsWithSameType.stream().collect(Collectors.groupingBy(IReferable::getUniqueName));
                for (List<IReferable> objectsWithSameUniqueName : map2.values()) {
                    if (objectsWithSameUniqueName.size() < 2) continue;
                    result.add(new HashSet<IReferable>(objectsWithSameUniqueName));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected void selfAdapt(Notification notification) {
        Object notifier = notification.getNotifier();
        Object object = notifier;
        if (object instanceof INamed) {
            INamed iNamed = (INamed)object;
            INamed cfr_ignored_0 = (INamed)object;
            if (notification.getFeature() == AmaltheaPackage.eINSTANCE.getINamed_Name()) {
                void namedObj;
                int eventType = notification.getEventType();
                if (eventType == 2) {
                    String oldValue = notification.getOldStringValue();
                    this.removeFromNameIndex((INamed)namedObj, oldValue);
                    return;
                }
                if (eventType != 1) return;
                String oldValue = notification.getOldStringValue();
                this.removeFromNameIndex((INamed)namedObj, oldValue);
                String newValue = notification.getNewStringValue();
                this.addToNameIndex((INamed)namedObj, newValue);
                return;
            }
        }
        super.selfAdapt(notification);
    }

    /*
     * WARNING - void declaration
     */
    protected void setTarget(EObject target) {
        super.setTarget(target);
        EObject eObject = target;
        if (eObject instanceof INamed) {
            void namedObj;
            INamed iNamed = (INamed)eObject;
            INamed cfr_ignored_0 = (INamed)eObject;
            this.addToNameIndex((INamed)namedObj, namedObj.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void unsetTarget(EObject target) {
        super.unsetTarget(target);
        EObject eObject = target;
        if (eObject instanceof INamed) {
            void namedObj;
            INamed iNamed = (INamed)eObject;
            INamed cfr_ignored_0 = (INamed)eObject;
            this.removeFromNameIndex((INamed)namedObj, namedObj.getName());
        }
    }

    private void addToNameIndex(INamed eObject, String name) {
        if (name != null) {
            Set objSet = this.nameIndex.computeIfAbsent(name, k -> new HashSet());
            objSet.add(eObject);
        }
    }

    private void removeFromNameIndex(INamed eObject, String name) {
        Set<INamed> objSet;
        if (name != null && (objSet = this.nameIndex.get(name)) != null) {
            objSet.remove(eObject);
            if (objSet.isEmpty()) {
                this.nameIndex.remove(name);
            }
        }
    }

    protected void handleContainment(Notification notification) {
        switch (notification.getEventType()) {
            case 9: {
                this.handleResolve(notification);
                break;
            }
            case 2: {
                this.handleUnset(notification);
                break;
            }
            case 1: {
                this.handleSet(notification);
                break;
            }
            case 3: {
                this.handleAdd(notification);
                break;
            }
            case 5: {
                this.handleAddMany(notification);
                break;
            }
            case 4: {
                this.handleRemove(notification);
                break;
            }
            case 6: {
                this.handleRemoveMany(notification);
            }
        }
    }

    private void handleResolve(Notification notification) {
        Notifier oldValue = (Notifier)notification.getOldValue();
        if (oldValue.eAdapters().contains((Object)this)) {
            this.removeAdapter(oldValue);
            Notifier newValue = (Notifier)notification.getNewValue();
            this.addAdapter(newValue);
        }
    }

    private void handleUnset(Notification notification) {
        Object oldValue = notification.getOldValue();
        if (oldValue != Boolean.TRUE && oldValue != Boolean.FALSE) {
            if (oldValue != null) {
                this.removeAdapter((Notifier)oldValue);
            }
            this.handleAdd(notification);
        }
    }

    private void handleSet(Notification notification) {
        this.handleRemove(notification);
        this.handleAdd(notification);
    }

    private void handleAdd(Notification notification) {
        Notifier newValue = (Notifier)notification.getNewValue();
        if (newValue != null) {
            this.addAdapter(newValue);
        }
    }

    private void handleAddMany(Notification notification) {
        Collection newValues = (Collection)notification.getNewValue();
        for (Notifier newValue : newValues) {
            this.addAdapter(newValue);
        }
    }

    private void handleRemove(Notification notification) {
        Notifier oldValue = (Notifier)notification.getOldValue();
        if (oldValue != null) {
            this.removeAdapter(oldValue);
        }
    }

    private void handleRemoveMany(Notification notification) {
        Collection oldValues = (Collection)notification.getOldValue();
        for (Notifier oldContentValue : oldValues) {
            this.removeAdapter(oldContentValue);
        }
    }

    public void dumpInfo(@NonNull PrintStream stream) {
        Preconditions.checkArgument((stream != null ? 1 : 0) != 0, (Object)ARG_STREAM_MESSAGE);
        stream.println("Amalthea Cross Reference Adapter {");
        stream.println("  Id: " + ((Object)((Object)this)).getClass().getName() + '@' + Integer.toHexString(((Object)((Object)this)).hashCode()));
        stream.print("  Resources: ");
        Set resources = this.inverseCrossReferencer.keySet().stream().map(EObject::eResource).filter(Objects::nonNull).collect(Collectors.toSet());
        if (resources.isEmpty()) {
            stream.println("[]");
        } else {
            stream.println("[");
            for (Resource resource : resources) {
                stream.println("    " + resource.getURI());
            }
            stream.println("  ]");
        }
        stream.println("  Cross Reference Map size: " + this.inverseCrossReferencer.size());
        stream.println("  Name Index size: " + this.nameIndex.size());
        stream.println('}');
    }

    public void dumpCrossReferenceMap(@NonNull PrintStream stream) {
        Preconditions.checkArgument((stream != null ? 1 : 0) != 0, (Object)ARG_STREAM_MESSAGE);
        stream.println("Cross Reference Map (size: " + this.inverseCrossReferencer.size() + ") {");
        for (Map.Entry entry : this.inverseCrossReferencer.entrySet()) {
            EObject eObject = (EObject)entry.getKey();
            stream.print("  ");
            stream.print(this.description(eObject));
            stream.print(": ");
            Collection collection = (Collection)entry.getValue();
            if (collection.isEmpty()) {
                stream.println("[]");
                continue;
            }
            stream.println("[");
            Iterator j = collection.iterator();
            while (j.hasNext()) {
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)j.next();
                EObject object = setting.getEObject();
                EStructuralFeature feature = setting.getEStructuralFeature();
                stream.print("    ");
                stream.print(feature.getName());
                stream.print(" <- ");
                stream.print(this.description(object));
                if (!j.hasNext()) continue;
                stream.println(",");
            }
            stream.println(']');
        }
        stream.println('}');
    }

    public void dumpNameIndex(@NonNull PrintStream stream) {
        Preconditions.checkArgument((stream != null ? 1 : 0) != 0, (Object)ARG_STREAM_MESSAGE);
        stream.println("Name Index (size: " + this.nameIndex.size() + ") {");
        this.nameIndex.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> {
            stream.print("  \"" + (String)e.getKey() + "\": ");
            stream.println(((Set)e.getValue()).stream().map(obj -> obj.eClass().getName()).sorted().toList());
        });
        stream.println('}');
    }

    /*
     * WARNING - void declaration
     */
    private String description(EObject eObject) {
        EObject eObject2;
        StringBuilder result = new StringBuilder();
        result.append(eObject.eClass().getName());
        EObject eObject3 = eObject;
        if (eObject3 instanceof INamed) {
            void namedObj;
            INamed iNamed = (INamed)eObject3;
            INamed cfr_ignored_0 = (INamed)eObject3;
            result.append(" \"" + namedObj.getName() + "\"");
        }
        if ((eObject2 = eObject.eContainer()) instanceof INamed) {
            void cont;
            INamed iNamed = (INamed)eObject2;
            INamed cfr_ignored_1 = (INamed)eObject2;
            result.append(" (container: " + cont.eClass().getName() + " \"" + cont.getName() + "\")");
        }
        return result.toString();
    }
}

