/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.prefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import org.eclipse.birt.chart.internal.prefs.PreferenceKey;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.FontDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.util.SecurityUtil;

public final class DefaultsManager {
    private static final String sLocation = "charts.ini";
    private transient Preferences pr = null;
    private static transient DefaultsManager dm = null;
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/model.prefs");

    public static void main(String[] sa) throws Exception {
    }

    public static synchronized DefaultsManager instance() {
        if (dm == null) {
            dm = new DefaultsManager();
            if (!dm.exists()) {
                try {
                    dm.createSample();
                }
                catch (Exception ex) {
                    logger.log(ex);
                }
            } else {
                try {
                    dm.read();
                }
                catch (Exception ex) {
                    logger.log(ex);
                }
            }
        }
        return dm;
    }

    private DefaultsManager() {
    }

    private void createSample() throws IOException, BackingStoreException {
        DefaultsManager dm = DefaultsManager.instance();
        dm.samplePreferences();
        dm.write();
    }

    private void samplePreferences() {
        this.pr = DefaultsManager.create(null, null);
        Preferences prLabel = DefaultsManager.create(this.pr, PreferenceKey.N_LABEL);
        Preferences prLabelDatapoint = DefaultsManager.create(prLabel, PreferenceKey.N_DATAPOINT);
        FontDefinitionImpl fd = new FontDefinitionImpl("Arial", 12.0f);
        prLabelDatapoint.put("font", ((Object)fd).toString());
        ColorDefinition cdText = ColorDefinitionImpl.BLACK();
        prLabelDatapoint.put("textcolor", cdText.toString());
        ColorDefinition ifBackground = ColorDefinitionImpl.TRANSPARENT();
        prLabelDatapoint.put("fill", ifBackground.toString());
        LineAttributes laOutline = AttributeFactory.eINSTANCE.createLineAttributes();
        ((LineAttributesImpl)laOutline).set(ColorDefinitionImpl.BLACK(), LineStyle.DOTTED_LITERAL, 1);
        prLabelDatapoint.put("outline", laOutline.toString());
        Preferences prLabelAxis = DefaultsManager.create(prLabel, PreferenceKey.N_AXIS);
        fd = new FontDefinitionImpl("Arial", 12.0f);
        prLabelAxis.put("font", ((Object)fd).toString());
        cdText = ColorDefinitionImpl.BLACK();
        prLabelAxis.put("textcolor", cdText.toString());
        ifBackground = ColorDefinitionImpl.TRANSPARENT();
        prLabelAxis.put("fill", ifBackground.toString());
        laOutline = AttributeFactory.eINSTANCE.createLineAttributes();
        ((LineAttributesImpl)laOutline).set(ColorDefinitionImpl.BLACK(), LineStyle.SOLID_LITERAL, 1);
        prLabelAxis.put("outline", laOutline.toString());
        Preferences prLabelLegend = DefaultsManager.create(prLabel, PreferenceKey.N_LEGEND);
        fd = new FontDefinitionImpl("Arial", 12.0f);
        prLabelLegend.put("font", ((Object)fd).toString());
        cdText = ColorDefinitionImpl.BLACK();
        prLabelLegend.put("textcolor", cdText.toString());
        ifBackground = ColorDefinitionImpl.TRANSPARENT();
        prLabelLegend.put("fill", ifBackground.toString());
        laOutline = AttributeFactory.eINSTANCE.createLineAttributes();
        ((LineAttributesImpl)laOutline).set(ColorDefinitionImpl.BLACK(), LineStyle.SOLID_LITERAL, 1);
        prLabelLegend.put("outline", laOutline.toString());
        Preferences prTitle = DefaultsManager.create(this.pr, PreferenceKey.N_TITLE);
        fd = new FontDefinitionImpl("Arial", 12.0f);
        prTitle.put("font", ((Object)fd).toString());
        cdText = ColorDefinitionImpl.BLACK();
        prTitle.put("textcolor", cdText.toString());
        ifBackground = ColorDefinitionImpl.TRANSPARENT();
        prTitle.put("fill", ifBackground.toString());
        laOutline = AttributeFactory.eINSTANCE.createLineAttributes();
        ((LineAttributesImpl)laOutline).set(ColorDefinitionImpl.BLACK(), LineStyle.SOLID_LITERAL, 1);
        prTitle.put("outline", laOutline.toString());
        Preferences prTitleAxis = DefaultsManager.create(prTitle, PreferenceKey.N_AXIS);
        fd = new FontDefinitionImpl("Arial", 12.0f);
        prTitleAxis.put("font", ((Object)fd).toString());
        cdText = ColorDefinitionImpl.BLACK();
        prTitleAxis.put("textcolor", cdText.toString());
        ifBackground = ColorDefinitionImpl.TRANSPARENT();
        prTitleAxis.put("fill", ifBackground.toString());
        laOutline = AttributeFactory.eINSTANCE.createLineAttributes();
        ((LineAttributesImpl)laOutline).set(ColorDefinitionImpl.BLACK(), LineStyle.SOLID_LITERAL, 1);
        prTitleAxis.put("outline", laOutline.toString());
        Preferences prTitleSeries = DefaultsManager.create(prTitle, PreferenceKey.N_SERIES);
        fd = new FontDefinitionImpl("Arial", 12.0f);
        prTitleSeries.put("font", ((Object)fd).toString());
        cdText = ColorDefinitionImpl.BLACK();
        prTitleSeries.put("textcolor", cdText.toString());
        ifBackground = ColorDefinitionImpl.TRANSPARENT();
        prTitleSeries.put("fill", ifBackground.toString());
        laOutline = AttributeFactory.eINSTANCE.createLineAttributes();
        ((LineAttributesImpl)laOutline).set(ColorDefinitionImpl.BLACK(), LineStyle.SOLID_LITERAL, 1);
        prTitleSeries.put("outline", laOutline.toString());
    }

    private static Preferences create(Preferences pParent, PreferenceKey pk) {
        return pParent == null ? Preferences.userRoot() : pParent.node(pk.getKey());
    }

    public void write() throws IOException, BackingStoreException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileOutputStream fos = SecurityUtil.newFileOutputStream(sLocation);){
            this.pr.exportSubtree(fos);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void read() throws IOException, InvalidPreferencesFormatException {
        block3: {
            try {
                this.pr = AccessController.doPrivileged(new PrivilegedExceptionAction<Preferences>(){

                    @Override
                    public Preferences run() throws Exception {
                        Throwable throwable = null;
                        Object var2_3 = null;
                        try (FileInputStream fis = new FileInputStream(DefaultsManager.sLocation);){
                            Preferences.importPreferences(fis);
                            return Preferences.userRoot();
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (typedException instanceof IOException) {
                    throw (IOException)typedException;
                }
                if (!(typedException instanceof InvalidPreferencesFormatException)) break block3;
                throw (InvalidPreferencesFormatException)typedException;
            }
        }
    }

    private boolean exists() {
        final File f = new File(sLocation);
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (f.exists() && f.isFile()) {
                    return true;
                }
                return false;
            }
        });
    }
}

