/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.commands.actions;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.commands.IStepFiltersHandler;
import org.eclipse.debug.internal.core.StepFilterManager;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.DebugCommandAction;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class ToggleStepFiltersAction
extends DebugCommandAction
implements IEclipsePreferences.IPreferenceChangeListener {
    private boolean fInitialized = !DebugUITools.isUseStepFilters();

    @Override
    public ImageDescriptor getDisabledImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_DLCL_TOGGLE_STEP_FILTERS");
    }

    @Override
    public String getHelpContextId() {
        return "org.eclipse.debug.ui.step_with_filters_action_context";
    }

    @Override
    public ImageDescriptor getHoverImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_ELCL_TOGGLE_STEP_FILTERS");
    }

    @Override
    public String getId() {
        return "org.eclipse.debug.ui.actions.ToggleStepFilters";
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_ELCL_TOGGLE_STEP_FILTERS");
    }

    @Override
    public String getText() {
        return ActionMessages.ToggleStepFiltersAction_1;
    }

    @Override
    public String getToolTipText() {
        return ActionMessages.ToggleStepFiltersAction_0;
    }

    @Override
    protected boolean getInitialEnablement() {
        return true;
    }

    protected Class<IStepFiltersHandler> getCommandType() {
        return IStepFiltersHandler.class;
    }

    @Override
    public void run() {
        if (this.fInitialized) {
            DebugUITools.setUseStepFilters(!DebugUITools.isUseStepFilters());
        } else {
            this.fInitialized = true;
        }
    }

    public int getStyle() {
        return 2;
    }

    @Override
    public void debugContextChanged(DebugContextEvent event) {
        ISelection context = event.getContext();
        if (context.isEmpty()) {
            this.setEnabled(true);
        } else {
            super.debugContextChanged(event);
        }
    }

    @Override
    public void init(IWorkbenchPart part) {
        super.init(part);
        this.initState();
    }

    @Override
    public void init(IWorkbenchWindow window) {
        super.init(window);
        this.initState();
    }

    protected void initState() {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(DebugPlugin.getUniqueIdentifier());
        if (node != null) {
            node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(DebugPlugin.getUniqueIdentifier());
        if (node != null) {
            node.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals(StepFilterManager.PREF_USE_STEP_FILTERS)) {
            boolean checked = DebugUITools.isUseStepFilters();
            this.setChecked(checked);
            IAction action = this.getActionProxy();
            if (action != null) {
                action.setChecked(checked);
            }
        }
    }
}

