/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.TopologicalSort;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class ExtensionsSort
extends TopologicalSort<IExtension, Bundle> {
    @Override
    protected Bundle getId(IExtension extension) {
        IContributor contributor = extension.getContributor();
        return Activator.getDefault().getBundleForName(contributor.getName());
    }

    @Override
    protected Collection<Bundle> getRequirements(Bundle bundle) {
        return null;
    }

    private static void addDependents(Set<Bundle> dependents, BundleWiring providerWiring) {
        List requirerWires = providerWiring.getProvidedWires("osgi.wiring.bundle");
        if (requirerWires == null) {
            return;
        }
        for (BundleWire requireBundleWire : requirerWires) {
            Bundle requirer = requireBundleWire.getRequirer().getBundle();
            if (dependents.contains(requirer)) continue;
            dependents.add(requirer);
            String reExport = (String)requireBundleWire.getRequirement().getDirectives().get("visibility");
            if (!"reexport".equals(reExport)) continue;
            ExtensionsSort.addDependents(dependents, requireBundleWire.getRequirerWiring());
        }
    }

    @Override
    protected Collection<Bundle> getDependencies(Bundle bundle) {
        BundleWiring providerWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (!providerWiring.isInUse()) {
            return Collections.emptySet();
        }
        HashSet<Bundle> required = new HashSet<Bundle>();
        ExtensionsSort.addDependents(required, providerWiring);
        return Collections.unmodifiableSet(required);
    }
}

