/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.logging.Level;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.common.remote.TransmitableArray;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.ICallback;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.remote.BeanProxyValueSender;
import org.eclipse.jem.internal.proxy.remote.IREMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.IREMConnection;
import org.eclipse.jem.internal.proxy.remote.REMCallbackInputStream;
import org.eclipse.jem.internal.proxy.remote.REMCallbackRegistry;
import org.eclipse.jem.internal.proxy.remote.REMConnection;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanTypeProxyFactory;

class REMCallbackThread
extends Thread {
    final REMConnection fConnection;
    final REMCallbackRegistry fServer;
    final REMStandardBeanProxyFactory fFactory;
    final REMStandardBeanTypeProxyFactory fTypeFactory;
    final REMProxyFactoryRegistry registry;
    protected boolean shuttingDown;
    protected boolean inTransaction;
    static boolean LINUX_1_3 = "linux".equalsIgnoreCase(System.getProperty("os.name")) && System.getProperty("java.version", "").startsWith("1.3");

    public boolean inTransaction() {
        return this.inTransaction;
    }

    public void setIntransaction(boolean inTransaction) {
        this.inTransaction = inTransaction;
    }

    public REMCallbackThread(Socket socket, REMCallbackRegistry server, String name, REMProxyFactoryRegistry registry, boolean noTimeouts) {
        super(name);
        this.fConnection = new REMConnection(socket, true);
        this.registry = registry;
        this.fServer = server;
        this.fFactory = (REMStandardBeanProxyFactory)registry.getBeanProxyFactory();
        this.fTypeFactory = (REMStandardBeanTypeProxyFactory)registry.getBeanTypeProxyFactory();
    }

    public void close() {
        try {
            this.shuttingDown = true;
            if (this.fConnection.fSocket != null) {
                this.fConnection.fSocket.close();
            }
        }
        catch (Exception exception) {}
    }

    IREMConnection getConnection() {
        return this.fConnection;
    }

    @Override
    public void run() {
        boolean shutdown;
        block67: {
            DataOutputStream out;
            block69: {
                DataInputStream in = this.fConnection.in;
                out = this.fConnection.out;
                REMCallbackInputStream ins = null;
                shutdown = false;
                Commands.ValueObject valueObject = new Commands.ValueObject();
                BeanProxyValueSender valueSender = new BeanProxyValueSender(this.fFactory);
                try {
                    boolean doLoop = true;
                    block48: while (doLoop) {
                        byte cmd;
                        block66: {
                            cmd = 0;
                            try {
                                if (LINUX_1_3) {
                                    this.fConnection.fSocket.setSoTimeout(1000);
                                }
                                cmd = in.readByte();
                                if (!LINUX_1_3) break block66;
                                this.fConnection.fSocket.setSoTimeout(0);
                            }
                            catch (InterruptedIOException interruptedIOException) {
                                continue;
                            }
                        }
                        switch (cmd) {
                            case 4: {
                                doLoop = false;
                                break;
                            }
                            case 5: {
                                doLoop = false;
                                shutdown = true;
                                break;
                            }
                            case -1: {
                                int callID = in.readInt();
                                int msgID = in.readInt();
                                Object[] parm = null;
                                Object result = null;
                                ICallback cb = null;
                                try {
                                    this.fFactory.startTransaction();
                                    this.setIntransaction(true);
                                    boolean isProxies = true;
                                    try {
                                        Commands.readValue(in, valueObject);
                                        if (valueObject.type == 53) {
                                            valueSender.initialize(valueObject);
                                            Commands.readArray(in, valueObject.anInt, valueSender, valueObject, false);
                                            if (valueSender.getException() != null) {
                                                this.close();
                                            }
                                            parm = valueSender.getArray();
                                        } else {
                                            isProxies = false;
                                            parm = valueObject.getAsObject();
                                        }
                                    }
                                    finally {
                                        this.setIntransaction(false);
                                        this.fFactory.stopTransaction();
                                    }
                                    cb = this.fServer.getRegisteredCallback(callID);
                                    if (cb != null) {
                                        try {
                                            result = isProxies ? (parm.length == 1 && (parm[0] == null || parm[0] instanceof IBeanProxy) ? cb.calledBack(msgID, (IBeanProxy)parm[0]) : cb.calledBack(msgID, parm)) : cb.calledBack(msgID, (Object)parm);
                                            valueObject.set();
                                            if (result instanceof IREMBeanProxy) {
                                                ((IREMBeanProxy)result).renderBean(valueObject);
                                            } else if (result instanceof Object[]) {
                                                class Retriever
                                                implements Commands.ValueRetrieve {
                                                    int index = 0;
                                                    Object[] array;
                                                    Commands.ValueObject worker = new Commands.ValueObject();

                                                    public Retriever(Object[] anArray) {
                                                        this.array = anArray;
                                                    }

                                                    @Override
                                                    public Commands.ValueObject nextValue() {
                                                        Object retParm;
                                                        if ((retParm = this.array[this.index++]) != null) {
                                                            if (retParm instanceof IREMBeanProxy) {
                                                                ((IREMBeanProxy)retParm).renderBean(this.worker);
                                                            } else if (retParm instanceof TransmitableArray) {
                                                                this.worker.setArrayIDS(new Retriever(((TransmitableArray)retParm).array), ((TransmitableArray)retParm).array.length, ((TransmitableArray)retParm).componentTypeID);
                                                            } else {
                                                                IREMBeanProxy type = (IREMBeanProxy)((Object)REMCallbackThread.this.fTypeFactory.getBeanTypeProxy(retParm.getClass().getName()));
                                                                if (type == null) {
                                                                    throw new IllegalArgumentException();
                                                                }
                                                                int classID = type.getID();
                                                                this.worker.setAsObject(retParm, classID);
                                                            }
                                                        } else {
                                                            this.worker.set();
                                                        }
                                                        return this.worker;
                                                    }
                                                }
                                                valueObject.setArrayIDS(new Retriever((Object[])result), ((Object[])result).length, 23);
                                            }
                                            Commands.sendCallbackDoneCommand(out, valueObject, 0);
                                        }
                                        catch (RuntimeException e) {
                                            valueObject.set(String.valueOf(e.getClass().getName()) + ':' + e.getLocalizedMessage());
                                            Commands.sendCallbackDoneCommand(out, valueObject, 7);
                                            ProxyPlugin.getPlugin().getLogger().log((Throwable)e, Level.INFO);
                                        }
                                        continue block48;
                                    }
                                    valueObject.set();
                                    Commands.sendCallbackDoneCommand(out, valueObject, 8);
                                    continue block48;
                                }
                                finally {
                                    parm = null;
                                    result = null;
                                    cb = null;
                                    valueObject.set();
                                    valueSender.clear();
                                }
                            }
                            case -3: {
                                int callID = in.readInt();
                                int msgID = in.readInt();
                                ICallback cb = null;
                                try {
                                    cb = this.fServer.getRegisteredCallback(callID);
                                    if (cb != null) {
                                        valueObject.set();
                                        Commands.sendCallbackDoneCommand(out, valueObject, 0);
                                        ins = new REMCallbackInputStream(in, out);
                                        try {
                                            cb.calledBackStream(msgID, ins);
                                            continue block48;
                                        }
                                        finally {
                                            try {
                                                ((InputStream)ins).close();
                                            }
                                            catch (IOException e) {
                                                doLoop = false;
                                                ProxyPlugin.getPlugin().getLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "In REMCallbackThread", (Throwable)e));
                                            }
                                        }
                                    }
                                    valueObject.set();
                                    Commands.sendCallbackDoneCommand(out, valueObject, 8);
                                    continue block48;
                                }
                                finally {
                                    cb = null;
                                    ins = null;
                                    valueObject.set();
                                }
                            }
                            default: {
                                ProxyPlugin.getPlugin().getLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "REMCallback: Invalid cmd sent=" + cmd, null));
                                doLoop = false;
                            }
                        }
                    }
                }
                catch (EOFException eOFException) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception exception) {}
                    }
                    this.close();
                    break block67;
                }
                catch (Exception e) {
                    block68: {
                        try {
                            if (!this.shuttingDown) {
                                ProxyPlugin.getPlugin().getLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "In REMCallbackThread", (Throwable)e));
                            }
                            if (in == null) break block68;
                        }
                        catch (Throwable throwable) {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Exception exception) {}
                            }
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (Exception exception) {}
                            }
                            this.close();
                            throw throwable;
                        }
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception exception) {}
                    }
                    this.close();
                    break block67;
                }
                if (in == null) break block69;
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            this.close();
        }
        this.fServer.removeCallbackThread(this);
        if (shutdown) {
            this.fServer.requestShutdown();
        }
    }
}

