/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.annotations;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.ClassInheritanceHandler;
import org.eclipse.jetty.osgi.annotations.AnnotationParser;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationConfiguration
extends org.eclipse.jetty.annotations.AnnotationConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(org.eclipse.jetty.annotations.AnnotationConfiguration.class);

    public Class<? extends Configuration> replaces() {
        return org.eclipse.jetty.annotations.AnnotationConfiguration.class;
    }

    protected org.eclipse.jetty.annotations.AnnotationParser createAnnotationParser(int javaTargetVersion) {
        return new AnnotationParser(javaTargetVersion);
    }

    public Resource getJarFor(ServletContainerInitializer service) throws MalformedURLException, IOException {
        Resource resource = super.getJarFor(service);
        if (resource != null && !resource.toString().endsWith(".jar")) {
            return null;
        }
        return resource;
    }

    public void parseWebInfLib(WebAppContext context, org.eclipse.jetty.annotations.AnnotationParser parser) throws Exception {
        AnnotationParser oparser = (AnnotationParser)parser;
        if (this._webInfLibStats == null) {
            this._webInfLibStats = new CounterStatistic();
        }
        Bundle webbundle = (Bundle)context.getAttribute("osgi-bundle");
        Set fragAndRequiredBundles = (Set)context.getAttribute("org.eclipse.jetty.osgi.fragmentAndRequiredBundles");
        if (fragAndRequiredBundles != null) {
            for (Bundle bundle : fragAndRequiredBundles) {
                if (bundle.getState() == 1) continue;
                Resource bundleRes = oparser.indexBundle(bundle);
                if (!context.getMetaData().getWebInfResources(false).contains(bundleRes)) {
                    context.getMetaData().addWebInfResource(bundleRes);
                }
                if (bundle.getHeaders().get("Fragment-Host") == null) continue;
                this.parseFragmentBundle(context, oparser, webbundle, bundle);
                this._webInfLibStats.increment();
            }
        }
        oparser.indexBundle(webbundle);
        this.parseWebBundle(context, oparser, webbundle);
        this._webInfLibStats.increment();
        super.parseWebInfLib(context, parser);
        if (fragAndRequiredBundles != null) {
            for (Bundle requiredBundle : fragAndRequiredBundles) {
                if (requiredBundle.getState() == 1 || requiredBundle.getHeaders().get("Fragment-Host") != null) continue;
                this.parseRequiredBundle(context, oparser, webbundle, requiredBundle);
                this._webInfLibStats.increment();
            }
        }
    }

    protected void parseFragmentBundle(WebAppContext context, AnnotationParser parser, Bundle webbundle, Bundle fragmentBundle) throws Exception {
        this.parseBundle(context, parser, webbundle, fragmentBundle);
    }

    protected void parseWebBundle(WebAppContext context, AnnotationParser parser, Bundle webbundle) throws Exception {
        this.parseBundle(context, parser, webbundle, webbundle);
    }

    public void parseWebInfClasses(WebAppContext context, org.eclipse.jetty.annotations.AnnotationParser parser) throws Exception {
        Bundle webbundle = (Bundle)context.getAttribute("osgi-bundle");
        String bundleClasspath = (String)webbundle.getHeaders().get("Bundle-ClassPath");
        if (StringUtil.isBlank((String)bundleClasspath) || !bundleClasspath.contains("WEB-INF/classes")) {
            super.parseWebInfClasses(context, parser);
        }
    }

    protected void parseRequiredBundle(WebAppContext context, AnnotationParser parser, Bundle webbundle, Bundle requiredBundle) throws Exception {
        this.parseBundle(context, parser, webbundle, requiredBundle);
    }

    protected void parseBundle(WebAppContext context, AnnotationParser parser, Bundle webbundle, Bundle bundle) throws Exception {
        Resource bundleRes = parser.getResource(bundle);
        HashSet<ClassInheritanceHandler> handlers = new HashSet<ClassInheritanceHandler>();
        handlers.addAll(this._discoverableAnnotationHandlers);
        if (this._classInheritanceHandler != null) {
            handlers.add(this._classInheritanceHandler);
        }
        handlers.addAll(this._containerInitializerAnnotationHandlers);
        if (this._parserTasks != null) {
            BundleParserTask task = new BundleParserTask(parser, handlers, bundleRes);
            this._parserTasks.add(task);
            if (LOG.isDebugEnabled()) {
                task.setStatistic(new AnnotationConfiguration.TimeStatistic((org.eclipse.jetty.annotations.AnnotationConfiguration)this));
            }
        }
    }

    public class BundleParserTask
    extends AnnotationConfiguration.ParserTask {
        public BundleParserTask(AnnotationParser parser, Set<? extends AnnotationParser.Handler> handlers, Resource resource) {
            super((org.eclipse.jetty.annotations.AnnotationConfiguration)AnnotationConfiguration.this, (org.eclipse.jetty.annotations.AnnotationParser)parser, handlers, resource);
        }

        public Void call() throws Exception {
            if (this._parser != null) {
                AnnotationParser osgiAnnotationParser = (AnnotationParser)this._parser;
                Bundle bundle = osgiAnnotationParser.getBundle(this._resource);
                if (this._stat != null) {
                    this._stat.start();
                }
                osgiAnnotationParser.parse((Set<? extends AnnotationParser.Handler>)this._handlers, bundle);
                if (this._stat != null) {
                    this._stat.end();
                }
            }
            return null;
        }
    }
}

