/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.iproduct.IArgumentsInfo;
import org.eclipse.pde.internal.core.iproduct.IConfigurationFileInfo;
import org.eclipse.pde.internal.core.iproduct.IJREInfo;
import org.eclipse.pde.internal.core.iproduct.IPluginConfiguration;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.FeatureBlock;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class LaunchAction
extends Action {
    private static final String DEFAULT = "default";
    private IProduct fProduct;
    private String fMode;
    private IPath fPath;
    private Map<String, IPluginConfiguration> fPluginConfigurations;
    private static final Set<String> PROGRAM_ARGUMENTS = Set.of("-os", "-ws", "-arch", "-nl");

    public LaunchAction(IProduct product, IPath path, String mode) {
        this.fProduct = product;
        this.fMode = mode;
        this.fPath = path;
        this.fPluginConfigurations = Arrays.stream(this.fProduct.getPluginConfigurations()).collect(Collectors.toUnmodifiableMap(IPluginConfiguration::getId, c -> c));
    }

    public void run() {
        try {
            ILaunchConfiguration config = this.findLaunchConfiguration();
            if (config != null) {
                DebugUITools.launch((ILaunchConfiguration)config, (String)this.fMode);
            }
        }
        catch (CoreException e) {
            PDEPlugin.log(Status.error((String)PDEUIMessages.ProductEditor_launchFailed, (Throwable)e));
        }
    }

    public ILaunchConfiguration findLaunchConfiguration() throws CoreException {
        ILaunchConfiguration config;
        List<ILaunchConfiguration> configs = this.getLaunchConfigurations();
        if (configs.isEmpty()) {
            return this.createConfiguration();
        }
        ILaunchConfiguration iLaunchConfiguration = config = configs.size() == 1 ? configs.get(0) : this.chooseConfiguration(configs);
        if (config != null) {
            config = this.refreshConfiguration(config.getWorkingCopy());
        }
        return config;
    }

    private ILaunchConfiguration refreshConfiguration(ILaunchConfigurationWorkingCopy wc) throws CoreException {
        wc.setAttribute("product", this.fProduct.getProductId());
        wc.setAttribute("application", this.fProduct.getApplication());
        if (TargetPlatformHelper.usesNewApplicationModel()) {
            wc.setAttribute("pde.version", "3.3");
        } else if (TargetPlatformHelper.getTargetVersion() >= 3.2) {
            wc.setAttribute("pde.version", "3.2a");
        }
        String os = Platform.getOS();
        String arch = Platform.getOSArch();
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.getVMArguments(os, arch));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, this.getProgramArguments(os, arch));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, this.getJREContainer(os));
        HashSet wsplugins = new HashSet();
        HashSet<String> explugins = new HashSet<String>();
        Set<IPluginModelBase> models = LaunchAction.getModels(this.fProduct);
        for (IPluginModelBase model : models) {
            this.appendBundle(model.getUnderlyingResource() == null ? explugins : wsplugins, model);
        }
        wc.setAttribute("selected_workspace_bundles", wsplugins);
        wc.setAttribute("selected_target_bundles", explugins);
        if (this.fProduct.useFeatures()) {
            wc.setAttribute("useCustomFeatures", true);
            this.refreshFeatureLaunchPlugins(wc, models);
        } else {
            wc.removeAttribute("useCustomFeatures");
            wc.removeAttribute("selected_features");
            wc.removeAttribute("additional_plugins");
        }
        wc.setAttribute("automaticIncludeRequirements", this.fProduct.includeRequirementsAutomatically());
        String configIni = this.getTemplateConfigIni(os);
        wc.setAttribute("useDefaultConfig", configIni == null);
        if (configIni != null) {
            wc.setAttribute("templateConfig", configIni);
        }
        return wc.doSave();
    }

    private void refreshFeatureLaunchPlugins(ILaunchConfigurationWorkingCopy wc, Set<IPluginModelBase> allModels) {
        FeatureModelManager featureManager = PDECore.getDefault().getFeatureModelManager();
        Set selectedFeatures = Arrays.stream(this.fProduct.getFeatures()).map(f -> featureManager.findFeatureModel(f.getId(), f.getVersion())).filter(Objects::nonNull).map(m -> BundleLauncherHelper.formatFeatureEntry((String)m.getFeature().getId(), (String)DEFAULT)).collect(Collectors.toCollection(LinkedHashSet::new));
        Set additionalPlugins = allModels.stream().map(model -> this.getPluginConfiguration((IPluginModelBase)model).map(c -> BundleLauncherHelper.formatAdditionalPluginEntry((IPluginModelBase)model, (String)c.fResolution, (boolean)true, (String)c.fStartLevel, (String)c.fAutoStart))).flatMap(Optional::stream).collect(Collectors.toCollection(LinkedHashSet::new));
        wc.setAttribute("selected_features", selectedFeatures);
        wc.setAttribute("additional_plugins", additionalPlugins);
    }

    private void appendBundle(Set<String> plugins, IPluginModelBase model) {
        BundleLauncherHelper.AdditionalPluginData config = this.getPluginConfiguration(model).orElse(FeatureBlock.DEFAULT_PLUGIN_DATA);
        String entry = BundleLauncherHelper.formatBundleEntry((IPluginModelBase)model, (String)config.fStartLevel, (String)config.fAutoStart);
        plugins.add(entry);
    }

    private Optional<BundleLauncherHelper.AdditionalPluginData> getPluginConfiguration(IPluginModelBase model) {
        IPluginConfiguration config = this.fPluginConfigurations.get(model.getPluginBase().getId());
        if (config == null) {
            return Optional.empty();
        }
        String startLevel = config.getStartLevel() > 0 ? Integer.toString(config.getStartLevel()) : DEFAULT;
        String autoStart = Boolean.toString(config.isAutoStart());
        return Optional.of(new BundleLauncherHelper.AdditionalPluginData(DEFAULT, true, startLevel, autoStart));
    }

    private String getProgramArguments(String os, String arch) {
        IArgumentsInfo info = this.fProduct.getLauncherArguments();
        String userArgs = info != null ? CoreUtility.normalize((String)info.getCompleteProgramArguments(os, arch)) : "";
        return this.concatArgs(LaunchArgumentsHelper.getInitialProgramArguments(), userArgs);
    }

    private String getVMArguments(String os, String arch) {
        IArgumentsInfo info = this.fProduct.getLauncherArguments();
        String userArgs = info != null ? CoreUtility.normalize((String)info.getCompleteVMArguments(os, arch)) : "";
        return this.concatArgs(LaunchArgumentsHelper.getInitialVMArguments(), userArgs);
    }

    private String concatArgs(String initialArgs, String userArgs) {
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(DebugPlugin.splitArguments((String)initialArgs)));
        if (userArgs != null && userArgs.length() > 0) {
            List<String> userArgsList = Arrays.asList(DebugPlugin.splitArguments((String)userArgs));
            boolean previousHasSubArgument = false;
            for (String userArg : userArgsList) {
                boolean hasSubArgument = PROGRAM_ARGUMENTS.contains(userArg);
                if (!arguments.contains(userArg) || hasSubArgument || previousHasSubArgument) {
                    arguments.add(userArg);
                }
                previousHasSubArgument = hasSubArgument;
            }
        }
        try {
            return this.removeDuplicateArguments(arguments);
        }
        catch (Exception e) {
            PDEPlugin.log(e);
            return String.join((CharSequence)" ", arguments);
        }
    }

    private String removeDuplicateArguments(List<String> userArgsList) {
        String defaultStart = "${target.";
        for (String progArgument : PROGRAM_ARGUMENTS) {
            int index2;
            int index1 = userArgsList.indexOf(progArgument);
            if (index1 == (index2 = userArgsList.lastIndexOf(progArgument))) continue;
            String s1 = userArgsList.get(index1 + 1);
            String s2 = userArgsList.get(index2 + 1);
            if (s1.startsWith(defaultStart) && !s2.startsWith(defaultStart)) {
                userArgsList.remove(index1);
                userArgsList.remove(index1);
                continue;
            }
            if (!s2.startsWith(defaultStart) || s1.startsWith(defaultStart)) continue;
            userArgsList.remove(index2);
            userArgsList.remove(index2);
        }
        return String.join((CharSequence)" ", userArgsList);
    }

    private String getJREContainer(String os) {
        IPath jrePath;
        IJREInfo info = this.fProduct.getJREInfo();
        if (info != null && (jrePath = info.getJREContainerPath(os)) != null) {
            return jrePath.toPortableString();
        }
        return null;
    }

    public static Set<IPluginModelBase> getModels(IProduct product) {
        return product.useFeatures() ? LaunchAction.getModelsFromListedFeatures(product) : LaunchAction.getModelsFromListedPlugins(product);
    }

    private static Set<IPluginModelBase> getModelsFromListedPlugins(IProduct product) {
        return Arrays.stream(product.getPlugins()).map(IProductPlugin::getId).filter(Objects::nonNull).map(PluginRegistry::findModel).filter(Objects::nonNull).filter(TargetPlatformHelper::matchesCurrentEnvironment).collect(Collectors.toSet());
    }

    private static Set<IPluginModelBase> getModelsFromListedFeatures(IProduct product) {
        HashSet<IPluginModelBase> launchPlugins = new HashSet<IPluginModelBase>();
        for (IFeatureModel feature : LaunchAction.getUniqueFeatures(product)) {
            LaunchAction.addFeaturePlugins(feature.getFeature(), launchPlugins);
        }
        return launchPlugins;
    }

    private static Collection<IFeatureModel> getUniqueFeatures(IProduct product) {
        IProductFeature feature;
        ArrayDeque<IFeatureModel> pending = new ArrayDeque<IFeatureModel>();
        LinkedHashSet<IFeatureModel> features = new LinkedHashSet<IFeatureModel>();
        IProductFeature[] iProductFeatureArray = product.getFeatures();
        int n = iProductFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            feature = iProductFeatureArray[n2];
            LaunchAction.addFeature(feature.getId(), feature.getVersion(), pending, features);
            ++n2;
        }
        while (!pending.isEmpty()) {
            feature = (IFeatureModel)pending.remove();
            IFeatureChild[] iFeatureChildArray = feature.getFeature().getIncludedFeatures();
            int n3 = iFeatureChildArray.length;
            n = 0;
            while (n < n3) {
                IFeatureChild child = iFeatureChildArray[n];
                LaunchAction.addFeature(child.getId(), child.getVersion(), pending, features);
                ++n;
            }
        }
        return features;
    }

    private static void addFeature(String id, String version, Queue<IFeatureModel> pending, Set<IFeatureModel> features) {
        FeatureModelManager featureManager = PDECore.getDefault().getFeatureModelManager();
        IFeatureModel feature = featureManager.findFeatureModel(id, version);
        if (feature != null && features.add(feature)) {
            pending.add(feature);
        }
    }

    private static void addFeaturePlugins(IFeature feature, Set<IPluginModelBase> launchPlugins) {
        IFeaturePlugin[] iFeaturePluginArray = feature.getPlugins();
        int n = iFeaturePluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFeaturePlugin plugin = iFeaturePluginArray[n2];
            String id = plugin.getId();
            String version = plugin.getVersion();
            if (id != null && version != null) {
                IPluginModelBase model = PluginRegistry.findModel((String)id, (String)version, (int)1, null);
                if (model == null) {
                    model = PluginRegistry.findModel((String)id);
                }
                if (model != null && !launchPlugins.contains(model) && TargetPlatformHelper.matchesCurrentEnvironment((IPluginModelBase)model)) {
                    launchPlugins.add(model);
                }
            }
            ++n2;
        }
    }

    private String getTemplateConfigIni(String os) {
        IConfigurationFileInfo info = this.fProduct.getConfigurationFileInfo();
        if (info != null) {
            File file;
            String expandedPath;
            String path = info.getPath(os);
            if (path == null) {
                path = info.getPath(null);
            }
            if (path != null && (expandedPath = this.getExpandedPath(path)) != null && (file = new File(expandedPath)).isFile()) {
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    private String getExpandedPath(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        IResource resource = PDEPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
        if (resource != null) {
            IPath fullPath = resource.getLocation();
            return fullPath == null ? null : fullPath.toOSString();
        }
        return null;
    }

    private ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configs) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configs.toArray());
        dialog.setTitle(PDEUIMessages.RuntimeWorkbenchShortcut_title);
        dialog.setMessage(this.fMode.equals("debug") ? PDEUIMessages.RuntimeWorkbenchShortcut_select_debug : PDEUIMessages.RuntimeWorkbenchShortcut_select_run);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        return result == 0 ? (ILaunchConfiguration)dialog.getFirstResult() : null;
    }

    private ILaunchConfiguration createConfiguration() throws CoreException {
        ILaunchConfigurationType configType = this.getWorkbenchLaunchConfigType();
        String computedName = this.getComputedName(this.fPath.lastSegment());
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, computedName);
        wc.setAttribute("location", LaunchArgumentsHelper.getDefaultWorkspaceLocation((String)computedName));
        wc.setAttribute(DEFAULT, false);
        wc.setAttribute("clearws", false);
        wc.setAttribute("clearwslog", false);
        wc.setAttribute("append.args", true);
        wc.setAttribute("askclear", true);
        wc.setAttribute("useProduct", true);
        wc.setAttribute("automaticValidate", true);
        wc.setAttribute("automaticAdd", false);
        wc.setAttribute("productFile", this.fPath.toOSString());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
        wc.setAttribute("includeOptional", false);
        return this.refreshConfiguration(wc);
    }

    private String getComputedName(String prefix) {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.generateLaunchConfigurationName(prefix);
    }

    private List<ILaunchConfiguration> getLaunchConfigurations() throws CoreException {
        ArrayList<ILaunchConfiguration> result = new ArrayList<ILaunchConfiguration>();
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.pde.ui.RuntimeWorkbench");
        ILaunchConfiguration[] iLaunchConfigurationArray = manager.getLaunchConfigurations(type);
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path;
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            if (!DebugUITools.isPrivate((ILaunchConfiguration)config) && this.fPath.equals((Object)new Path(path = config.getAttribute("productFile", "")))) {
                result.add(config);
            }
            ++n2;
        }
        return result;
    }

    protected ILaunchConfigurationType getWorkbenchLaunchConfigType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType("org.eclipse.pde.ui.RuntimeWorkbench");
    }
}

