/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.format;

import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.json.core.cleanup.IJSONCleanupStrategy;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.internal.format.CompoundRegion;
import org.eclipse.wst.json.core.internal.format.FormatRegion;
import org.eclipse.wst.json.core.internal.format.JSONStructureFormatter;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class JSONObjectFormatter
extends JSONStructureFormatter {
    private static JSONObjectFormatter instance;

    JSONObjectFormatter() {
    }

    @Override
    protected void formatPost(IJSONNode node, StringBuilder source) {
        this.formatPost(node, new FormatRegion(node.getStartOffset(), node.getEndOffset() - node.getStartOffset()), source);
    }

    @Override
    protected void formatPost(IJSONNode node, IRegion region, StringBuilder source) {
        CompoundRegion r;
        IStructuredDocument document;
        CompoundRegion[] regions;
        IJSONCleanupStrategy stgy = this.getCleanupStrategy(node);
        if (region.getOffset() >= 0 && region.getLength() >= 0 && (regions = this.getRegionsWithoutWhiteSpaces(document = node.getOwnerDocument().getModel().getStructuredDocument(), region, stgy)).length > 0 && regions[regions.length - 1] != null && (r = regions[regions.length - 1]) != null && r.getType() == "JSON_OBJECT_CLOSE") {
            source.append(this.getLineDelimiter(node));
            source.append(this.getIndent(node));
            source.append(this.decoratedRegion(r, 0, stgy));
        }
    }

    @Override
    protected void formatPre(IJSONNode node, StringBuilder source) {
        this.formatPre(node, new FormatRegion(node.getStartOffset(), node.getEndOffset() - node.getStartOffset()), source);
    }

    @Override
    protected void formatPre(IJSONNode node, IRegion region, StringBuilder source) {
        IStructuredDocument document;
        CompoundRegion[] regions;
        IJSONCleanupStrategy stgy = this.getCleanupStrategy(node);
        if (region.getOffset() >= 0 && region.getLength() >= 0 && (regions = this.getRegionsWithoutWhiteSpaces(document = node.getOwnerDocument().getModel().getStructuredDocument(), region, stgy)).length > 0 && regions[0] != null && regions[0].getType() == "JSON_OBJECT_OPEN") {
            source.append(this.decoratedRegion(regions[0], 0, stgy));
        }
        source.append(this.getLineDelimiter(node));
        source.append(this.getIndent(node));
        source.append(this.getIndentString());
    }

    public static synchronized JSONObjectFormatter getInstance() {
        if (instance == null) {
            instance = new JSONObjectFormatter();
        }
        return instance;
    }
}

